"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk");
let organizationsClient;
/**
 * The onEvent handler is invoked whenever a resource lifecycle event for an Account occurs
 *
 * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#handling-lifecycle-events-onevent
 */
async function handler(event) {
    console.log(`Request of type ${event.RequestType} received`);
    if (!organizationsClient) {
        organizationsClient = new aws_sdk_1.Organizations({ region: "us-east-1" });
    }
    console.log("Payload: %j", event);
    const { Email, AccountName, RoleName, IamUserAccessToBilling } = event.ResourceProperties;
    if (event.RequestType == "Create") {
        const response = await organizationsClient
            // https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#createAccount-property
            .createAccount({
            Email: Email,
            AccountName: AccountName,
            RoleName: RoleName,
            IamUserAccessToBilling: IamUserAccessToBilling,
        })
            .promise();
        console.log("Creating account: %j", response);
        return {
            Data: { ...event.ResourceProperties, CreateAccountStatusId: response.CreateAccountStatus?.Id },
        };
    }
    return {
        ...event,
        Data: {
            ...event.ResourceProperties,
        },
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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