"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelegatedAdministrator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * Enables the specified member account to administer the Organizations features of the specified AWS service. It grants read-only access to AWS Organizations service data. The account still requires IAM permissions to access and administer the AWS service.
 *
 * You can run this action only for AWS services that support this feature. For a current list of services that support it, see the column Supports Delegated Administrator in the table at AWS Services that you can use with AWS Organizations in the [AWS Organizations User Guide](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html).
 *
 * @see https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-delegated-admin.html
 */
class DelegatedAdministrator extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { account, servicePrincipal } = props;
        new custom_resources_1.AwsCustomResource(this, "DelegatedAdministratorCustomResource", {
            resourceType: "Custom::Organizations_DelegatedAdministrator",
            onCreate: {
                service: "Organizations",
                action: "registerDelegatedAdministrator",
                region: "us-east-1",
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${account.accountId}:${servicePrincipal}`),
                parameters: {
                    AccountId: account.accountId,
                    ServicePrincipal: servicePrincipal,
                },
            },
            onDelete: {
                service: "Organizations",
                action: "registerDelegatedAdministrator",
                region: "us-east-1",
                parameters: {
                    AccountId: account.accountId,
                    ServicePrincipal: servicePrincipal,
                },
            },
            installLatestAwsSdk: false,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.DelegatedAdministrator = DelegatedAdministrator;
_a = JSII_RTTI_SYMBOL_1;
DelegatedAdministrator[_a] = { fqn: "@pepperize/cdk-organizations.DelegatedAdministrator", version: "0.7.227" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVsZWdhdGVkLWFkbWluaXN0cmF0b3IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZGVsZWdhdGVkLWFkbWluaXN0cmF0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxtRUFBOEc7QUFDOUcsMkNBQXVDO0FBY3ZDOzs7Ozs7R0FNRztBQUNILE1BQWEsc0JBQXVCLFNBQVEsc0JBQVM7SUFDbkQsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBa0M7UUFDakYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEVBQUUsT0FBTyxFQUFFLGdCQUFnQixFQUFFLEdBQUcsS0FBSyxDQUFDO1FBRTVDLElBQUksb0NBQWlCLENBQUMsSUFBSSxFQUFFLHNDQUFzQyxFQUFFO1lBQ2xFLFlBQVksRUFBRSw4Q0FBOEM7WUFDNUQsUUFBUSxFQUFFO2dCQUNSLE9BQU8sRUFBRSxlQUFlO2dCQUN4QixNQUFNLEVBQUUsZ0NBQWdDO2dCQUN4QyxNQUFNLEVBQUUsV0FBVztnQkFDbkIsa0JBQWtCLEVBQUUscUNBQWtCLENBQUMsRUFBRSxDQUFDLEdBQUcsT0FBTyxDQUFDLFNBQVMsSUFBSSxnQkFBZ0IsRUFBRSxDQUFDO2dCQUNyRixVQUFVLEVBQUU7b0JBQ1YsU0FBUyxFQUFFLE9BQU8sQ0FBQyxTQUFTO29CQUM1QixnQkFBZ0IsRUFBRSxnQkFBZ0I7aUJBQ25DO2FBQ0Y7WUFDRCxRQUFRLEVBQUU7Z0JBQ1IsT0FBTyxFQUFFLGVBQWU7Z0JBQ3hCLE1BQU0sRUFBRSxnQ0FBZ0M7Z0JBQ3hDLE1BQU0sRUFBRSxXQUFXO2dCQUNuQixVQUFVLEVBQUU7b0JBQ1YsU0FBUyxFQUFFLE9BQU8sQ0FBQyxTQUFTO29CQUM1QixnQkFBZ0IsRUFBRSxnQkFBZ0I7aUJBQ25DO2FBQ0Y7WUFDRCxtQkFBbUIsRUFBRSxLQUFLO1lBQzFCLE1BQU0sRUFBRSwwQ0FBdUIsQ0FBQyxZQUFZLENBQUM7Z0JBQzNDLFNBQVMsRUFBRSwwQ0FBdUIsQ0FBQyxZQUFZO2FBQ2hELENBQUM7U0FDSCxDQUFDLENBQUM7SUFDTCxDQUFDOztBQWhDSCx3REFpQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBd3NDdXN0b21SZXNvdXJjZSwgQXdzQ3VzdG9tUmVzb3VyY2VQb2xpY3ksIFBoeXNpY2FsUmVzb3VyY2VJZCB9IGZyb20gXCJhd3MtY2RrLWxpYi9jdXN0b20tcmVzb3VyY2VzXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgSUFjY291bnQgfSBmcm9tIFwiLi9hY2NvdW50XCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGVsZWdhdGVkQWRtaW5pc3RyYXRvclByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBtZW1iZXIgYWNjb3VudCBpbiB0aGUgb3JnYW5pemF0aW9uIHRvIHJlZ2lzdGVyIGFzIGEgZGVsZWdhdGVkIGFkbWluaXN0cmF0b3IuXG4gICAqL1xuICByZWFkb25seSBhY2NvdW50OiBJQWNjb3VudDtcbiAgLyoqXG4gICAqIFRoZSBzZXJ2aWNlIHByaW5jaXBhbCBvZiB0aGUgQVdTIHNlcnZpY2UgZm9yIHdoaWNoIHlvdSB3YW50IHRvIG1ha2UgdGhlIG1lbWJlciBhY2NvdW50IGEgZGVsZWdhdGVkIGFkbWluaXN0cmF0b3IuXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlUHJpbmNpcGFsOiBzdHJpbmc7XG59XG5cbi8qKlxuICogRW5hYmxlcyB0aGUgc3BlY2lmaWVkIG1lbWJlciBhY2NvdW50IHRvIGFkbWluaXN0ZXIgdGhlIE9yZ2FuaXphdGlvbnMgZmVhdHVyZXMgb2YgdGhlIHNwZWNpZmllZCBBV1Mgc2VydmljZS4gSXQgZ3JhbnRzIHJlYWQtb25seSBhY2Nlc3MgdG8gQVdTIE9yZ2FuaXphdGlvbnMgc2VydmljZSBkYXRhLiBUaGUgYWNjb3VudCBzdGlsbCByZXF1aXJlcyBJQU0gcGVybWlzc2lvbnMgdG8gYWNjZXNzIGFuZCBhZG1pbmlzdGVyIHRoZSBBV1Mgc2VydmljZS5cbiAqXG4gKiBZb3UgY2FuIHJ1biB0aGlzIGFjdGlvbiBvbmx5IGZvciBBV1Mgc2VydmljZXMgdGhhdCBzdXBwb3J0IHRoaXMgZmVhdHVyZS4gRm9yIGEgY3VycmVudCBsaXN0IG9mIHNlcnZpY2VzIHRoYXQgc3VwcG9ydCBpdCwgc2VlIHRoZSBjb2x1bW4gU3VwcG9ydHMgRGVsZWdhdGVkIEFkbWluaXN0cmF0b3IgaW4gdGhlIHRhYmxlIGF0IEFXUyBTZXJ2aWNlcyB0aGF0IHlvdSBjYW4gdXNlIHdpdGggQVdTIE9yZ2FuaXphdGlvbnMgaW4gdGhlIFtBV1MgT3JnYW5pemF0aW9ucyBVc2VyIEd1aWRlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vb3JnYW5pemF0aW9ucy9sYXRlc3QvdXNlcmd1aWRlL29yZ3NfaW50ZWdyYXRlX3NlcnZpY2VzX2xpc3QuaHRtbCkuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYWNjb3VudHMvbGF0ZXN0L3JlZmVyZW5jZS91c2luZy1vcmdzLWRlbGVnYXRlZC1hZG1pbi5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBEZWxlZ2F0ZWRBZG1pbmlzdHJhdG9yIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEZWxlZ2F0ZWRBZG1pbmlzdHJhdG9yUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgeyBhY2NvdW50LCBzZXJ2aWNlUHJpbmNpcGFsIH0gPSBwcm9wcztcblxuICAgIG5ldyBBd3NDdXN0b21SZXNvdXJjZSh0aGlzLCBcIkRlbGVnYXRlZEFkbWluaXN0cmF0b3JDdXN0b21SZXNvdXJjZVwiLCB7XG4gICAgICByZXNvdXJjZVR5cGU6IFwiQ3VzdG9tOjpPcmdhbml6YXRpb25zX0RlbGVnYXRlZEFkbWluaXN0cmF0b3JcIixcbiAgICAgIG9uQ3JlYXRlOiB7XG4gICAgICAgIHNlcnZpY2U6IFwiT3JnYW5pemF0aW9uc1wiLFxuICAgICAgICBhY3Rpb246IFwicmVnaXN0ZXJEZWxlZ2F0ZWRBZG1pbmlzdHJhdG9yXCIsIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NKYXZhU2NyaXB0U0RLL2xhdGVzdC9BV1MvT3JnYW5pemF0aW9ucy5odG1sI3JlZ2lzdGVyRGVsZWdhdGVkQWRtaW5pc3RyYXRvci1wcm9wZXJ0eVxuICAgICAgICByZWdpb246IFwidXMtZWFzdC0xXCIsXG4gICAgICAgIHBoeXNpY2FsUmVzb3VyY2VJZDogUGh5c2ljYWxSZXNvdXJjZUlkLm9mKGAke2FjY291bnQuYWNjb3VudElkfToke3NlcnZpY2VQcmluY2lwYWx9YCksXG4gICAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgICBBY2NvdW50SWQ6IGFjY291bnQuYWNjb3VudElkLFxuICAgICAgICAgIFNlcnZpY2VQcmluY2lwYWw6IHNlcnZpY2VQcmluY2lwYWwsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgb25EZWxldGU6IHtcbiAgICAgICAgc2VydmljZTogXCJPcmdhbml6YXRpb25zXCIsXG4gICAgICAgIGFjdGlvbjogXCJyZWdpc3RlckRlbGVnYXRlZEFkbWluaXN0cmF0b3JcIiwgLy8gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0phdmFTY3JpcHRTREsvbGF0ZXN0L0FXUy9Pcmdhbml6YXRpb25zLmh0bWwjZGVyZWdpc3RlckRlbGVnYXRlZEFkbWluaXN0cmF0b3ItcHJvcGVydHlcbiAgICAgICAgcmVnaW9uOiBcInVzLWVhc3QtMVwiLFxuICAgICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgICAgQWNjb3VudElkOiBhY2NvdW50LmFjY291bnRJZCxcbiAgICAgICAgICBTZXJ2aWNlUHJpbmNpcGFsOiBzZXJ2aWNlUHJpbmNpcGFsLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIGluc3RhbGxMYXRlc3RBd3NTZGs6IGZhbHNlLFxuICAgICAgcG9saWN5OiBBd3NDdXN0b21SZXNvdXJjZVBvbGljeS5mcm9tU2RrQ2FsbHMoe1xuICAgICAgICByZXNvdXJjZXM6IEF3c0N1c3RvbVJlc291cmNlUG9saWN5LkFOWV9SRVNPVVJDRSxcbiAgICAgIH0pLFxuICAgIH0pO1xuICB9XG59XG4iXX0=