import { Construct } from "constructs";
import { Root } from "./organization";
import { PolicyType } from "./policy";
export interface EnablePolicyTypeProps {
    readonly root: Root;
    readonly policyType: PolicyType;
}
/**
 * Enables and disables Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any organizational unit (OU), or account in that root.
 *
 * @see https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_enable-disable.html
 */
export declare class EnablePolicyType extends Construct {
    constructor(scope: Construct, id: string, props: EnablePolicyTypeProps);
}
