"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnablePolicyType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * Enables and disables Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any organizational unit (OU), or account in that root.
 *
 * @see https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_enable-disable.html
 */
class EnablePolicyType extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { root, policyType } = props;
        new custom_resources_1.AwsCustomResource(this, "EnablePolicyTypeCustomResource", {
            resourceType: "Custom::Organizations_EnablePolicyType",
            onCreate: {
                service: "Organizations",
                action: "enablePolicyType",
                region: "us-east-1",
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${root.rootId}:${policyType}`),
                parameters: {
                    RootId: root.rootId,
                    PolicyType: policyType,
                },
                ignoreErrorCodesMatching: "PolicyTypeAlreadyEnabledException",
            },
            onDelete: {
                service: "Organizations",
                action: "disablePolicyType",
                region: "us-east-1",
                parameters: {
                    RootId: root.rootId,
                    PolicyType: policyType,
                },
            },
            installLatestAwsSdk: false,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.EnablePolicyType = EnablePolicyType;
_a = JSII_RTTI_SYMBOL_1;
EnablePolicyType[_a] = { fqn: "@pepperize/cdk-organizations.EnablePolicyType", version: "0.7.227" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5hYmxlLXBvbGljeS10eXBlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2VuYWJsZS1wb2xpY3ktdHlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLG1FQUE4RztBQUM5RywyQ0FBdUM7QUFTdkM7Ozs7R0FJRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsc0JBQVM7SUFDN0MsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNEI7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEVBQUUsSUFBSSxFQUFFLFVBQVUsRUFBRSxHQUFHLEtBQUssQ0FBQztRQUVuQyxJQUFJLG9DQUFpQixDQUFDLElBQUksRUFBRSxnQ0FBZ0MsRUFBRTtZQUM1RCxZQUFZLEVBQUUsd0NBQXdDO1lBQ3RELFFBQVEsRUFBRTtnQkFDUixPQUFPLEVBQUUsZUFBZTtnQkFDeEIsTUFBTSxFQUFFLGtCQUFrQjtnQkFDMUIsTUFBTSxFQUFFLFdBQVc7Z0JBQ25CLGtCQUFrQixFQUFFLHFDQUFrQixDQUFDLEVBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxNQUFNLElBQUksVUFBVSxFQUFFLENBQUM7Z0JBQ3pFLFVBQVUsRUFBRTtvQkFDVixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07b0JBQ25CLFVBQVUsRUFBRSxVQUFVO2lCQUN2QjtnQkFDRCx3QkFBd0IsRUFBRSxtQ0FBbUM7YUFDOUQ7WUFDRCxRQUFRLEVBQUU7Z0JBQ1IsT0FBTyxFQUFFLGVBQWU7Z0JBQ3hCLE1BQU0sRUFBRSxtQkFBbUI7Z0JBQzNCLE1BQU0sRUFBRSxXQUFXO2dCQUNuQixVQUFVLEVBQUU7b0JBQ1YsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO29CQUNuQixVQUFVLEVBQUUsVUFBVTtpQkFDdkI7YUFDRjtZQUNELG1CQUFtQixFQUFFLEtBQUs7WUFDMUIsTUFBTSxFQUFFLDBDQUF1QixDQUFDLFlBQVksQ0FBQztnQkFDM0MsU0FBUyxFQUFFLDBDQUF1QixDQUFDLFlBQVk7YUFDaEQsQ0FBQztTQUNILENBQUMsQ0FBQztJQUNMLENBQUM7O0FBakNILDRDQWtDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEF3c0N1c3RvbVJlc291cmNlLCBBd3NDdXN0b21SZXNvdXJjZVBvbGljeSwgUGh5c2ljYWxSZXNvdXJjZUlkIH0gZnJvbSBcImF3cy1jZGstbGliL2N1c3RvbS1yZXNvdXJjZXNcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBSb290IH0gZnJvbSBcIi4vb3JnYW5pemF0aW9uXCI7XG5pbXBvcnQgeyBQb2xpY3lUeXBlIH0gZnJvbSBcIi4vcG9saWN5XCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRW5hYmxlUG9saWN5VHlwZVByb3BzIHtcbiAgcmVhZG9ubHkgcm9vdDogUm9vdDtcbiAgcmVhZG9ubHkgcG9saWN5VHlwZTogUG9saWN5VHlwZTtcbn1cblxuLyoqXG4gKiBFbmFibGVzIGFuZCBkaXNhYmxlcyBFbmFibGVzIGEgcG9saWN5IHR5cGUgaW4gYSByb290LiBBZnRlciB5b3UgZW5hYmxlIGEgcG9saWN5IHR5cGUgaW4gYSByb290LCB5b3UgY2FuIGF0dGFjaCBwb2xpY2llcyBvZiB0aGF0IHR5cGUgdG8gdGhlIHJvb3QsIGFueSBvcmdhbml6YXRpb25hbCB1bml0IChPVSksIG9yIGFjY291bnQgaW4gdGhhdCByb290LlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL29yZ2FuaXphdGlvbnMvbGF0ZXN0L3VzZXJndWlkZS9vcmdzX21hbmFnZV9wb2xpY2llc19lbmFibGUtZGlzYWJsZS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBFbmFibGVQb2xpY3lUeXBlIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFbmFibGVQb2xpY3lUeXBlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgeyByb290LCBwb2xpY3lUeXBlIH0gPSBwcm9wcztcblxuICAgIG5ldyBBd3NDdXN0b21SZXNvdXJjZSh0aGlzLCBcIkVuYWJsZVBvbGljeVR5cGVDdXN0b21SZXNvdXJjZVwiLCB7XG4gICAgICByZXNvdXJjZVR5cGU6IFwiQ3VzdG9tOjpPcmdhbml6YXRpb25zX0VuYWJsZVBvbGljeVR5cGVcIixcbiAgICAgIG9uQ3JlYXRlOiB7XG4gICAgICAgIHNlcnZpY2U6IFwiT3JnYW5pemF0aW9uc1wiLFxuICAgICAgICBhY3Rpb246IFwiZW5hYmxlUG9saWN5VHlwZVwiLCAvLyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTSmF2YVNjcmlwdFNESy9sYXRlc3QvQVdTL09yZ2FuaXphdGlvbnMuaHRtbCNlbmFibGVQb2xpY3lUeXBlLXByb3BlcnR5XG4gICAgICAgIHJlZ2lvbjogXCJ1cy1lYXN0LTFcIixcbiAgICAgICAgcGh5c2ljYWxSZXNvdXJjZUlkOiBQaHlzaWNhbFJlc291cmNlSWQub2YoYCR7cm9vdC5yb290SWR9OiR7cG9saWN5VHlwZX1gKSxcbiAgICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAgIFJvb3RJZDogcm9vdC5yb290SWQsXG4gICAgICAgICAgUG9saWN5VHlwZTogcG9saWN5VHlwZSxcbiAgICAgICAgfSxcbiAgICAgICAgaWdub3JlRXJyb3JDb2Rlc01hdGNoaW5nOiBcIlBvbGljeVR5cGVBbHJlYWR5RW5hYmxlZEV4Y2VwdGlvblwiLCAvLyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vb3JnYW5pemF0aW9ucy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FbmFibGVQb2xpY3lUeXBlLmh0bWwjQVBJX0VuYWJsZVBvbGljeVR5cGVfRXJyb3JzXG4gICAgICB9LFxuICAgICAgb25EZWxldGU6IHtcbiAgICAgICAgc2VydmljZTogXCJPcmdhbml6YXRpb25zXCIsXG4gICAgICAgIGFjdGlvbjogXCJkaXNhYmxlUG9saWN5VHlwZVwiLCAvLyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTSmF2YVNjcmlwdFNESy9sYXRlc3QvQVdTL09yZ2FuaXphdGlvbnMuaHRtbCNkaXNhYmxlUG9saWN5VHlwZS1wcm9wZXJ0eVxuICAgICAgICByZWdpb246IFwidXMtZWFzdC0xXCIsXG4gICAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgICBSb290SWQ6IHJvb3Qucm9vdElkLFxuICAgICAgICAgIFBvbGljeVR5cGU6IHBvbGljeVR5cGUsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgaW5zdGFsbExhdGVzdEF3c1NkazogZmFsc2UsXG4gICAgICBwb2xpY3k6IEF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TZGtDYWxscyh7XG4gICAgICAgIHJlc291cmNlczogQXdzQ3VzdG9tUmVzb3VyY2VQb2xpY3kuQU5ZX1JFU09VUkNFLFxuICAgICAgfSksXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==