"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrganizationalUnit = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const organizational_unit_provider_1 = require("./organizational-unit-provider/organizational-unit-provider");
const policy_attachment_1 = require("./policy-attachment");
const tag_resource_1 = require("./tag-resource");
const validators_1 = require("./validators");
class OrganizationalUnit extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.tags = new aws_cdk_lib_1.TagManager(aws_cdk_lib_1.TagType.KEY_VALUE, "Custom::Organizations_OrganizationalUnitProvider");
        this.scope = scope;
        const { organizationalUnitName, parent, importOnDuplicate, removalPolicy } = props;
        if (!validators_1.Validators.of().organizationalUnitName(organizationalUnitName)) {
            aws_cdk_lib_1.Annotations.of(this).addError("The organizational unit's name must be of type string and between 1 and 128 characters long.");
        }
        this.node.addDependency(parent);
        const organizationalUnitProvider = organizational_unit_provider_1.OrganizationalUnitProvider.getOrCreate(this);
        this.resource = new aws_cdk_lib_1.CustomResource(this, "OrganizationProvider", {
            serviceToken: organizationalUnitProvider.provider.serviceToken,
            resourceType: "Custom::Organizations_OrganizationalUnitProvider",
            properties: {
                Name: organizationalUnitName,
                ParentId: parent.identifier(),
                ImportOnDuplicate: String(importOnDuplicate ?? true),
                RemovalPolicy: removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.RETAIN,
            },
        });
        this.organizationalUnitId = this.resource.getAtt("Id").toString();
        this.organizationalUnitArn = this.resource.getAtt("Arn").toString();
        this.organizationalUnitName = this.resource.getAtt("Name").toString();
        const tagResource = new tag_resource_1.TagResource(this, "Tags", {
            resourceId: this.organizationalUnitId,
            tags: this.tags.renderedTags,
        });
        tagResource.node.addDependency(this.resource);
    }
    identifier() {
        return this.organizationalUnitId;
    }
    /**
     * Attach a policy. Before you can attach the policy, you must enable that policy type for use. You can use policies when you have all features enabled.
     *
     * @see https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html
     */
    attachPolicy(policy) {
        const policyAttachment = new policy_attachment_1.PolicyAttachment(this.scope, `PolicyAttachment-${aws_cdk_lib_1.Names.nodeUniqueId(this.node)}-${aws_cdk_lib_1.Names.nodeUniqueId(policy.node)}`, {
            target: this,
            policy: policy,
        });
        policyAttachment.node.addDependency(this.resource, policy);
    }
}
exports.OrganizationalUnit = OrganizationalUnit;
_a = JSII_RTTI_SYMBOL_1;
OrganizationalUnit[_a] = { fqn: "@pepperize/cdk-organizations.OrganizationalUnit", version: "0.7.227" };
//# sourceMappingURL=data:application/json;base64,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