"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Parent = exports.ParentBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class ParentBase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { childId } = props;
        const parent = new custom_resources_1.AwsCustomResource(this, "ListParentsCustomResource", {
            onCreate: {
                service: "Organizations",
                action: "listParents",
                region: "us-east-1",
                physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse("Parents.0.Id"),
                parameters: {
                    ChildId: childId,
                },
            },
            onUpdate: {
                service: "Organizations",
                action: "listParents",
                region: "us-east-1",
                physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse("Parents.0.Id"),
                parameters: {
                    ChildId: childId,
                },
            },
            onDelete: {
                service: "Organizations",
                action: "listParents",
                region: "us-east-1",
                parameters: {
                    ChildId: childId,
                },
            },
            installLatestAwsSdk: false,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
        this.parentId = parent.getResponseField("Parents.0.Id");
    }
    identifier() {
        return this.parentId;
    }
}
exports.ParentBase = ParentBase;
_a = JSII_RTTI_SYMBOL_1;
ParentBase[_a] = { fqn: "@pepperize/cdk-organizations.ParentBase", version: "0.7.227" };
class Parent extends ParentBase {
    constructor(scope, id, props) {
        const { child } = props;
        super(scope, id, { childId: child.identifier() });
        this.node.addDependency(child);
    }
    static fromChildId(scope, id, childId) {
        class Import extends ParentBase {
            constructor() {
                super(scope, id, { childId: childId });
            }
        }
        return new Import();
    }
}
exports.Parent = Parent;
_b = JSII_RTTI_SYMBOL_1;
Parent[_b] = { fqn: "@pepperize/cdk-organizations.Parent", version: "0.7.227" };
//# sourceMappingURL=data:application/json;base64,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