"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyAttachment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects accounts depends on the type of policy. Refer to the AWS Organizations User Guide for information about each policy type:
 */
class PolicyAttachment extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { target, policy } = props;
        new custom_resources_1.AwsCustomResource(this, "CustomResource", {
            resourceType: "Custom::Organizations_PolicyAttachment",
            onCreate: {
                service: "Organizations",
                action: "attachPolicy",
                region: "us-east-1",
                parameters: {
                    PolicyId: policy.policyId,
                    TargetId: target.identifier(),
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${policy.policyId}:${target.identifier()}`),
            },
            onDelete: {
                service: "Organizations",
                action: "detachPolicy",
                region: "us-east-1",
                parameters: {
                    PolicyId: policy.policyId,
                    TargetId: target.identifier(),
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${policy.policyId}:${target.identifier()}`),
            },
            installLatestAwsSdk: false,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.PolicyAttachment = PolicyAttachment;
_a = JSII_RTTI_SYMBOL_1;
PolicyAttachment[_a] = { fqn: "@pepperize/cdk-organizations.PolicyAttachment", version: "0.7.227" };
//# sourceMappingURL=data:application/json;base64,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