"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Validators = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class Validators {
    static of() {
        return new Validators();
    }
    accountId(id) {
        return /\d{12}/.test(id);
    }
    accountName(name) {
        return /[\s\S]{1,50}/.test(name);
    }
    email(email) {
        return /([^\s@]+@[^\s@]+\.[^\s@]+)/.test(email) && /(.*){6,64}/.test(email);
    }
    organizationalUnitName(name) {
        return /[\s\S]{1,128}/.test(name);
    }
    servicePrincipal(servicePrincipal) {
        return /[\w+=,.@-]{1,128}/.test(servicePrincipal);
    }
    policyContent(content) {
        return /[\s\S]{1,1000000}/.test(content);
    }
}
exports.Validators = Validators;
_a = JSII_RTTI_SYMBOL_1;
Validators[_a] = { fqn: "@pepperize/cdk-organizations.Validators", version: "0.7.227" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdG9ycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy92YWxpZGF0b3JzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsTUFBYSxVQUFVO0lBQ2QsTUFBTSxDQUFDLEVBQUU7UUFDZCxPQUFPLElBQUksVUFBVSxFQUFFLENBQUM7SUFDMUIsQ0FBQztJQUNNLFNBQVMsQ0FBQyxFQUFVO1FBQ3pCLE9BQU8sUUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUMzQixDQUFDO0lBQ00sV0FBVyxDQUFDLElBQVk7UUFDN0IsT0FBTyxjQUFjLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFDTSxLQUFLLENBQUMsS0FBYTtRQUN4QixPQUFPLDRCQUE0QixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxZQUFZLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzlFLENBQUM7SUFDTSxzQkFBc0IsQ0FBQyxJQUFZO1FBQ3hDLE9BQU8sZUFBZSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBQ00sZ0JBQWdCLENBQUMsZ0JBQXdCO1FBQzlDLE9BQU8sbUJBQW1CLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNNLGFBQWEsQ0FBQyxPQUFlO1FBQ2xDLE9BQU8sbUJBQW1CLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzNDLENBQUM7O0FBckJILGdDQXNCQyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBjbGFzcyBWYWxpZGF0b3JzIHtcbiAgcHVibGljIHN0YXRpYyBvZigpOiBWYWxpZGF0b3JzIHtcbiAgICByZXR1cm4gbmV3IFZhbGlkYXRvcnMoKTtcbiAgfVxuICBwdWJsaWMgYWNjb3VudElkKGlkOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICByZXR1cm4gL1xcZHsxMn0vLnRlc3QoaWQpO1xuICB9XG4gIHB1YmxpYyBhY2NvdW50TmFtZShuYW1lOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICByZXR1cm4gL1tcXHNcXFNdezEsNTB9Ly50ZXN0KG5hbWUpO1xuICB9XG4gIHB1YmxpYyBlbWFpbChlbWFpbDogc3RyaW5nKTogYm9vbGVhbiB7XG4gICAgcmV0dXJuIC8oW15cXHNAXStAW15cXHNAXStcXC5bXlxcc0BdKykvLnRlc3QoZW1haWwpICYmIC8oLiopezYsNjR9Ly50ZXN0KGVtYWlsKTtcbiAgfVxuICBwdWJsaWMgb3JnYW5pemF0aW9uYWxVbml0TmFtZShuYW1lOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICByZXR1cm4gL1tcXHNcXFNdezEsMTI4fS8udGVzdChuYW1lKTtcbiAgfVxuICBwdWJsaWMgc2VydmljZVByaW5jaXBhbChzZXJ2aWNlUHJpbmNpcGFsOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICByZXR1cm4gL1tcXHcrPSwuQC1dezEsMTI4fS8udGVzdChzZXJ2aWNlUHJpbmNpcGFsKTtcbiAgfVxuICBwdWJsaWMgcG9saWN5Q29udGVudChjb250ZW50OiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICByZXR1cm4gL1tcXHNcXFNdezEsMTAwMDAwMH0vLnRlc3QoY29udGVudCk7XG4gIH1cbn1cbiJdfQ==