# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AwsProxyCertificatesArgs',
    'AzureProxyCertificatesArgs',
    'GcpProxyCertificatesArgs',
    'RuleEcsContainerArgs',
    'RuleEcsDependArgs',
    'RuleEcsHttpArgs',
    'RuleRdsDatabaseArgs',
    'RuleRdsDependArgs',
    'RuleRdsTcpArgs',
    'RuleRdsTcpForwardRuleArgs',
    'RuleVmDependArgs',
    'RuleVmFilterArgs',
    'RuleVmFilterTagArgs',
    'RuleVmHttpArgs',
    'RuleVmHttpHealthArgs',
    'RuleVmHttpRoutingArgs',
    'RuleVmTcpArgs',
    'RuleVmTcpForwardRuleArgs',
    'RuleVmTcpRdpArgs',
    'RuleVmTcpSshArgs',
    'ScheduleRepeatArgs',
    'GetAwsProxyCertificatesArgs',
    'GetAzureProxyCertificatesArgs',
    'GetGcpProxyCertificatesArgs',
    'GetRuleEcsContainerArgs',
    'GetRuleEcsDependArgs',
    'GetRuleEcsHttpArgs',
    'GetRuleRdsDatabaseArgs',
    'GetRuleRdsDependArgs',
    'GetRuleRdsTcpArgs',
    'GetRuleRdsTcpForwardRuleArgs',
    'GetRuleVmDependArgs',
    'GetRuleVmFilterArgs',
    'GetRuleVmFilterTagArgs',
    'GetRuleVmHttpArgs',
    'GetRuleVmHttpHealthArgs',
    'GetRuleVmHttpRoutingArgs',
    'GetRuleVmTcpArgs',
    'GetRuleVmTcpForwardRuleArgs',
    'GetRuleVmTcpRdpArgs',
    'GetRuleVmTcpSshArgs',
]

@pulumi.input_type
class AwsProxyCertificatesArgs:
    def __init__(__self__, *,
                 cert_secret_id: pulumi.Input[str],
                 key_secret_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cert_secret_id: Certificate secret ID
        :param pulumi.Input[str] key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> pulumi.Input[str]:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @cert_secret_id.setter
    def cert_secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cert_secret_id", value)

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> pulumi.Input[str]:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")

    @key_secret_id.setter
    def key_secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_secret_id", value)


@pulumi.input_type
class AzureProxyCertificatesArgs:
    def __init__(__self__, *,
                 cert_secret_id: pulumi.Input[str],
                 key_secret_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cert_secret_id: ID of certificate secret uploaded to vault
        :param pulumi.Input[str] key_secret_id: ID of certificate key uploaded to vault
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> pulumi.Input[str]:
        """
        ID of certificate secret uploaded to vault
        """
        return pulumi.get(self, "cert_secret_id")

    @cert_secret_id.setter
    def cert_secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cert_secret_id", value)

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> pulumi.Input[str]:
        """
        ID of certificate key uploaded to vault
        """
        return pulumi.get(self, "key_secret_id")

    @key_secret_id.setter
    def key_secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_secret_id", value)


@pulumi.input_type
class GcpProxyCertificatesArgs:
    def __init__(__self__, *,
                 cert_secret_id: pulumi.Input[str],
                 key_secret_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cert_secret_id: Certificate secret ID
        :param pulumi.Input[str] key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> pulumi.Input[str]:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @cert_secret_id.setter
    def cert_secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cert_secret_id", value)

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> pulumi.Input[str]:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")

    @key_secret_id.setter
    def key_secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_secret_id", value)


@pulumi.input_type
class RuleEcsContainerArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[str],
                 region: pulumi.Input[str],
                 service: pulumi.Input[str],
                 task_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] cluster: Name of cluster in which service belong to
        :param pulumi.Input[str] region: Region of cluster
        :param pulumi.Input[str] service: Name of service to be onboarded
        :param pulumi.Input[int] task_count: Desired number of tasks on warming up a rule
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service", service)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[str]:
        """
        Name of cluster in which service belong to
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region of cluster
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        Name of service to be onboarded
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[pulumi.Input[int]]:
        """
        Desired number of tasks on warming up a rule
        """
        return pulumi.get(self, "task_count")

    @task_count.setter
    def task_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "task_count", value)


@pulumi.input_type
class RuleEcsDependArgs:
    def __init__(__self__, *,
                 rule_id: pulumi.Input[int],
                 delay_in_sec: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] rule_id: Rule id of the dependent rule
        :param pulumi.Input[int] delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[int]:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")

    @delay_in_sec.setter
    def delay_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_in_sec", value)


@pulumi.input_type
class RuleEcsHttpArgs:
    def __init__(__self__, *,
                 proxy_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] proxy_id: Id of the proxy
        """
        pulumi.set(__self__, "proxy_id", proxy_id)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> pulumi.Input[str]:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "proxy_id", value)


@pulumi.input_type
class RuleRdsDatabaseArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 region: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: ID of the database
        :param pulumi.Input[str] region: Region to which database belong to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        ID of the database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region to which database belong to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class RuleRdsDependArgs:
    def __init__(__self__, *,
                 rule_id: pulumi.Input[int],
                 delay_in_sec: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] rule_id: Rule id of the dependent rule
        :param pulumi.Input[int] delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[int]:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")

    @delay_in_sec.setter
    def delay_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_in_sec", value)


@pulumi.input_type
class RuleRdsTcpArgs:
    def __init__(__self__, *,
                 proxy_id: pulumi.Input[str],
                 forward_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpForwardRuleArgs']]]] = None):
        """
        :param pulumi.Input[str] proxy_id: Id of the Proxy
        :param pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpForwardRuleArgs']]] forward_rules: Additional tcp forwarding rules
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> pulumi.Input[str]:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "proxy_id", value)

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpForwardRuleArgs']]]]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @forward_rules.setter
    def forward_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRdsTcpForwardRuleArgs']]]]):
        pulumi.set(self, "forward_rules", value)


@pulumi.input_type
class RuleRdsTcpForwardRuleArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 connect_on: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: Port to listen on the vm
        :param pulumi.Input[int] connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[pulumi.Input[int]]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_on", value)


@pulumi.input_type
class RuleVmDependArgs:
    def __init__(__self__, *,
                 rule_id: pulumi.Input[int],
                 delay_in_sec: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] rule_id: Rule id of the dependent rule
        :param pulumi.Input[int] delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[int]:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")

    @delay_in_sec.setter
    def delay_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_in_sec", value)


@pulumi.input_type
class RuleVmFilterArgs:
    def __init__(__self__, *,
                 vm_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmFilterTagArgs']]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vm_ids: Ids of instances that needs to be managed using the AutoStopping rules
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: Regions of instances that needs to be managed using the AutoStopping rules
        :param pulumi.Input[Sequence[pulumi.Input['RuleVmFilterTagArgs']]] tags: Tags of instances that needs to be managed using the AutoStopping rules
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Zones of instances that needs to be managed using the AutoStopping rules
        """
        pulumi.set(__self__, "vm_ids", vm_ids)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="vmIds")
    def vm_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Ids of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "vm_ids")

    @vm_ids.setter
    def vm_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vm_ids", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Regions of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmFilterTagArgs']]]]:
        """
        Tags of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmFilterTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Zones of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class RuleVmFilterTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RuleVmHttpArgs:
    def __init__(__self__, *,
                 proxy_id: pulumi.Input[str],
                 healths: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmHttpHealthArgs']]]] = None,
                 routings: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmHttpRoutingArgs']]]] = None):
        """
        :param pulumi.Input[str] proxy_id: Id of the proxy
        :param pulumi.Input[Sequence[pulumi.Input['RuleVmHttpHealthArgs']]] healths: Health Check Details
        :param pulumi.Input[Sequence[pulumi.Input['RuleVmHttpRoutingArgs']]] routings: Routing configuration used to access the instances
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if routings is not None:
            pulumi.set(__self__, "routings", routings)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> pulumi.Input[str]:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "proxy_id", value)

    @property
    @pulumi.getter
    def healths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmHttpHealthArgs']]]]:
        """
        Health Check Details
        """
        return pulumi.get(self, "healths")

    @healths.setter
    def healths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmHttpHealthArgs']]]]):
        pulumi.set(self, "healths", value)

    @property
    @pulumi.getter
    def routings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmHttpRoutingArgs']]]]:
        """
        Routing configuration used to access the instances
        """
        return pulumi.get(self, "routings")

    @routings.setter
    def routings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmHttpRoutingArgs']]]]):
        pulumi.set(self, "routings", value)


@pulumi.input_type
class RuleVmHttpHealthArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None,
                 status_code_from: Optional[pulumi.Input[int]] = None,
                 status_code_to: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: Health check port on the VM
        :param pulumi.Input[str] protocol: Protocol can be http or https
        :param pulumi.Input[str] path: API path to use for health check
        :param pulumi.Input[int] status_code_from: Lower limit for acceptable status code
        :param pulumi.Input[int] status_code_to: Upper limit for acceptable status code
        :param pulumi.Input[int] timeout: Health check timeout
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code_from is not None:
            pulumi.set(__self__, "status_code_from", status_code_from)
        if status_code_to is not None:
            pulumi.set(__self__, "status_code_to", status_code_to)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Health check port on the VM
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Protocol can be http or https
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        API path to use for health check
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="statusCodeFrom")
    def status_code_from(self) -> Optional[pulumi.Input[int]]:
        """
        Lower limit for acceptable status code
        """
        return pulumi.get(self, "status_code_from")

    @status_code_from.setter
    def status_code_from(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status_code_from", value)

    @property
    @pulumi.getter(name="statusCodeTo")
    def status_code_to(self) -> Optional[pulumi.Input[int]]:
        """
        Upper limit for acceptable status code
        """
        return pulumi.get(self, "status_code_to")

    @status_code_to.setter
    def status_code_to(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status_code_to", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Health check timeout
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class RuleVmHttpRoutingArgs:
    def __init__(__self__, *,
                 source_protocol: pulumi.Input[str],
                 target_protocol: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[int]] = None,
                 target_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] source_protocol: Source protocol of the proxy can be http or https
        :param pulumi.Input[str] target_protocol: Target protocol of the instance can be http or https
        :param pulumi.Input[str] action: Organization Identifier for the Entity
        :param pulumi.Input[int] source_port: Port on the proxy
        :param pulumi.Input[int] target_port: Port on the VM
        """
        pulumi.set(__self__, "source_protocol", source_protocol)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @property
    @pulumi.getter(name="sourceProtocol")
    def source_protocol(self) -> pulumi.Input[str]:
        """
        Source protocol of the proxy can be http or https
        """
        return pulumi.get(self, "source_protocol")

    @source_protocol.setter
    def source_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_protocol", value)

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> pulumi.Input[str]:
        """
        Target protocol of the instance can be http or https
        """
        return pulumi.get(self, "target_protocol")

    @target_protocol.setter
    def target_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_protocol", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port on the proxy
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_port", value)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port on the VM
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_port", value)


@pulumi.input_type
class RuleVmTcpArgs:
    def __init__(__self__, *,
                 proxy_id: pulumi.Input[str],
                 forward_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpForwardRuleArgs']]]] = None,
                 rdps: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpRdpArgs']]]] = None,
                 sshes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpSshArgs']]]] = None):
        """
        :param pulumi.Input[str] proxy_id: Id of the Proxy
        :param pulumi.Input[Sequence[pulumi.Input['RuleVmTcpForwardRuleArgs']]] forward_rules: Additional tcp forwarding rules
        :param pulumi.Input[Sequence[pulumi.Input['RuleVmTcpRdpArgs']]] rdps: RDP configuration
        :param pulumi.Input[Sequence[pulumi.Input['RuleVmTcpSshArgs']]] sshes: SSH configuration
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)
        if rdps is not None:
            pulumi.set(__self__, "rdps", rdps)
        if sshes is not None:
            pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> pulumi.Input[str]:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "proxy_id", value)

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpForwardRuleArgs']]]]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @forward_rules.setter
    def forward_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpForwardRuleArgs']]]]):
        pulumi.set(self, "forward_rules", value)

    @property
    @pulumi.getter
    def rdps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpRdpArgs']]]]:
        """
        RDP configuration
        """
        return pulumi.get(self, "rdps")

    @rdps.setter
    def rdps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpRdpArgs']]]]):
        pulumi.set(self, "rdps", value)

    @property
    @pulumi.getter
    def sshes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpSshArgs']]]]:
        """
        SSH configuration
        """
        return pulumi.get(self, "sshes")

    @sshes.setter
    def sshes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleVmTcpSshArgs']]]]):
        pulumi.set(self, "sshes", value)


@pulumi.input_type
class RuleVmTcpForwardRuleArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 connect_on: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: Port to listen on the vm
        :param pulumi.Input[int] connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[pulumi.Input[int]]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_on", value)


@pulumi.input_type
class RuleVmTcpRdpArgs:
    def __init__(__self__, *,
                 connect_on: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] connect_on: Port to listen on the proxy
        :param pulumi.Input[int] port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[pulumi.Input[int]]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_on", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class RuleVmTcpSshArgs:
    def __init__(__self__, *,
                 connect_on: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] connect_on: Port to listen on the proxy
        :param pulumi.Input[int] port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[pulumi.Input[int]]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_on", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ScheduleRepeatArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[Sequence[pulumi.Input[str]]],
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] days: List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        :param pulumi.Input[str] end_time: Ending time of schedule action on the day. Defaults to 24:00Hrs unless specified. Accepted format is HH:MM. Eg : 20:00 for 8pm
        :param pulumi.Input[str] start_time: Starting time of schedule action on the day. Defaults to 00:00Hrs unless specified. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        pulumi.set(__self__, "days", days)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Ending time of schedule action on the day. Defaults to 24:00Hrs unless specified. Accepted format is HH:MM. Eg : 20:00 for 8pm
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Starting time of schedule action on the day. Defaults to 00:00Hrs unless specified. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class GetAwsProxyCertificatesArgs:
    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: Certificate secret ID
        :param str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @cert_secret_id.setter
    def cert_secret_id(self, value: str):
        pulumi.set(self, "cert_secret_id", value)

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")

    @key_secret_id.setter
    def key_secret_id(self, value: str):
        pulumi.set(self, "key_secret_id", value)


@pulumi.input_type
class GetAzureProxyCertificatesArgs:
    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: ID of certificate secret uploaded to vault
        :param str key_secret_id: ID of certificate key uploaded to vault
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        ID of certificate secret uploaded to vault
        """
        return pulumi.get(self, "cert_secret_id")

    @cert_secret_id.setter
    def cert_secret_id(self, value: str):
        pulumi.set(self, "cert_secret_id", value)

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        ID of certificate key uploaded to vault
        """
        return pulumi.get(self, "key_secret_id")

    @key_secret_id.setter
    def key_secret_id(self, value: str):
        pulumi.set(self, "key_secret_id", value)


@pulumi.input_type
class GetGcpProxyCertificatesArgs:
    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: Certificate secret ID
        :param str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @cert_secret_id.setter
    def cert_secret_id(self, value: str):
        pulumi.set(self, "cert_secret_id", value)

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")

    @key_secret_id.setter
    def key_secret_id(self, value: str):
        pulumi.set(self, "key_secret_id", value)


@pulumi.input_type
class GetRuleEcsContainerArgs:
    def __init__(__self__, *,
                 cluster: str,
                 region: str,
                 service: str,
                 task_count: Optional[int] = None):
        """
        :param str cluster: Name of cluster in which service belong to
        :param str region: Region of cluster
        :param str service: Name of service to be onboarded
        :param int task_count: Desired number of tasks on warming up a rule
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service", service)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        Name of cluster in which service belong to
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: str):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of cluster
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: str):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Name of service to be onboarded
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: str):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[int]:
        """
        Desired number of tasks on warming up a rule
        """
        return pulumi.get(self, "task_count")

    @task_count.setter
    def task_count(self, value: Optional[int]):
        pulumi.set(self, "task_count", value)


@pulumi.input_type
class GetRuleEcsDependArgs:
    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: int):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")

    @delay_in_sec.setter
    def delay_in_sec(self, value: Optional[int]):
        pulumi.set(self, "delay_in_sec", value)


@pulumi.input_type
class GetRuleEcsHttpArgs:
    def __init__(__self__, *,
                 proxy_id: str):
        """
        :param str proxy_id: Id of the proxy
        """
        pulumi.set(__self__, "proxy_id", proxy_id)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: str):
        pulumi.set(self, "proxy_id", value)


@pulumi.input_type
class GetRuleRdsDatabaseArgs:
    def __init__(__self__, *,
                 id: str,
                 region: str):
        """
        :param str id: ID of the database
        :param str region: Region to which database belong to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region to which database belong to
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: str):
        pulumi.set(self, "region", value)


@pulumi.input_type
class GetRuleRdsDependArgs:
    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: int):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")

    @delay_in_sec.setter
    def delay_in_sec(self, value: Optional[int]):
        pulumi.set(self, "delay_in_sec", value)


@pulumi.input_type
class GetRuleRdsTcpArgs:
    def __init__(__self__, *,
                 proxy_id: str,
                 forward_rules: Optional[Sequence['GetRuleRdsTcpForwardRuleArgs']] = None):
        """
        :param str proxy_id: Id of the Proxy
        :param Sequence['GetRuleRdsTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: str):
        pulumi.set(self, "proxy_id", value)

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['GetRuleRdsTcpForwardRuleArgs']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @forward_rules.setter
    def forward_rules(self, value: Optional[Sequence['GetRuleRdsTcpForwardRuleArgs']]):
        pulumi.set(self, "forward_rules", value)


@pulumi.input_type
class GetRuleRdsTcpForwardRuleArgs:
    def __init__(__self__, *,
                 port: int,
                 connect_on: Optional[int] = None):
        """
        :param int port: Port to listen on the vm
        :param int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: int):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[int]):
        pulumi.set(self, "connect_on", value)


@pulumi.input_type
class GetRuleVmDependArgs:
    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: int):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")

    @delay_in_sec.setter
    def delay_in_sec(self, value: Optional[int]):
        pulumi.set(self, "delay_in_sec", value)


@pulumi.input_type
class GetRuleVmFilterArgs:
    def __init__(__self__, *,
                 vm_ids: Sequence[str],
                 regions: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence['GetRuleVmFilterTagArgs']] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] vm_ids: Ids of instances that needs to be managed using the AutoStopping rules
        :param Sequence[str] regions: Regions of instances that needs to be managed using the AutoStopping rules
        :param Sequence['GetRuleVmFilterTagArgs'] tags: Tags of instances that needs to be managed using the AutoStopping rules
        :param Sequence[str] zones: Zones of instances that needs to be managed using the AutoStopping rules
        """
        pulumi.set(__self__, "vm_ids", vm_ids)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="vmIds")
    def vm_ids(self) -> Sequence[str]:
        """
        Ids of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "vm_ids")

    @vm_ids.setter
    def vm_ids(self, value: Sequence[str]):
        pulumi.set(self, "vm_ids", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        Regions of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['GetRuleVmFilterTagArgs']]:
        """
        Tags of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Sequence['GetRuleVmFilterTagArgs']]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        Zones of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class GetRuleVmFilterTagArgs:
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: str):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GetRuleVmHttpArgs:
    def __init__(__self__, *,
                 proxy_id: str,
                 healths: Optional[Sequence['GetRuleVmHttpHealthArgs']] = None,
                 routings: Optional[Sequence['GetRuleVmHttpRoutingArgs']] = None):
        """
        :param str proxy_id: Id of the proxy
        :param Sequence['GetRuleVmHttpHealthArgs'] healths: Health Check Details
        :param Sequence['GetRuleVmHttpRoutingArgs'] routings: Routing configuration used to access the instances
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if routings is not None:
            pulumi.set(__self__, "routings", routings)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: str):
        pulumi.set(self, "proxy_id", value)

    @property
    @pulumi.getter
    def healths(self) -> Optional[Sequence['GetRuleVmHttpHealthArgs']]:
        """
        Health Check Details
        """
        return pulumi.get(self, "healths")

    @healths.setter
    def healths(self, value: Optional[Sequence['GetRuleVmHttpHealthArgs']]):
        pulumi.set(self, "healths", value)

    @property
    @pulumi.getter
    def routings(self) -> Optional[Sequence['GetRuleVmHttpRoutingArgs']]:
        """
        Routing configuration used to access the instances
        """
        return pulumi.get(self, "routings")

    @routings.setter
    def routings(self, value: Optional[Sequence['GetRuleVmHttpRoutingArgs']]):
        pulumi.set(self, "routings", value)


@pulumi.input_type
class GetRuleVmHttpHealthArgs:
    def __init__(__self__, *,
                 port: int,
                 protocol: str,
                 path: Optional[str] = None,
                 status_code_from: Optional[int] = None,
                 status_code_to: Optional[int] = None,
                 timeout: Optional[int] = None):
        """
        :param int port: Health check port on the VM
        :param str protocol: Protocol can be http or https
        :param str path: API path to use for health check
        :param int status_code_from: Lower limit for acceptable status code
        :param int status_code_to: Upper limit for acceptable status code
        :param int timeout: Health check timeout
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code_from is not None:
            pulumi.set(__self__, "status_code_from", status_code_from)
        if status_code_to is not None:
            pulumi.set(__self__, "status_code_to", status_code_to)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Health check port on the VM
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: int):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol can be http or https
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: str):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        API path to use for health check
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="statusCodeFrom")
    def status_code_from(self) -> Optional[int]:
        """
        Lower limit for acceptable status code
        """
        return pulumi.get(self, "status_code_from")

    @status_code_from.setter
    def status_code_from(self, value: Optional[int]):
        pulumi.set(self, "status_code_from", value)

    @property
    @pulumi.getter(name="statusCodeTo")
    def status_code_to(self) -> Optional[int]:
        """
        Upper limit for acceptable status code
        """
        return pulumi.get(self, "status_code_to")

    @status_code_to.setter
    def status_code_to(self, value: Optional[int]):
        pulumi.set(self, "status_code_to", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Health check timeout
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[int]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class GetRuleVmHttpRoutingArgs:
    def __init__(__self__, *,
                 source_protocol: str,
                 target_protocol: str,
                 action: Optional[str] = None,
                 source_port: Optional[int] = None,
                 target_port: Optional[int] = None):
        """
        :param str source_protocol: Source protocol of the proxy can be http or https
        :param str target_protocol: Target protocol of the instance can be http or https
        :param str action: Organization Identifier for the Entity
        :param int source_port: Port on the proxy
        :param int target_port: Port on the VM
        """
        pulumi.set(__self__, "source_protocol", source_protocol)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @property
    @pulumi.getter(name="sourceProtocol")
    def source_protocol(self) -> str:
        """
        Source protocol of the proxy can be http or https
        """
        return pulumi.get(self, "source_protocol")

    @source_protocol.setter
    def source_protocol(self, value: str):
        pulumi.set(self, "source_protocol", value)

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        Target protocol of the instance can be http or https
        """
        return pulumi.get(self, "target_protocol")

    @target_protocol.setter
    def target_protocol(self, value: str):
        pulumi.set(self, "target_protocol", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[int]:
        """
        Port on the proxy
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[int]):
        pulumi.set(self, "source_port", value)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[int]:
        """
        Port on the VM
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: Optional[int]):
        pulumi.set(self, "target_port", value)


@pulumi.input_type
class GetRuleVmTcpArgs:
    def __init__(__self__, *,
                 proxy_id: str,
                 forward_rules: Optional[Sequence['GetRuleVmTcpForwardRuleArgs']] = None,
                 rdps: Optional[Sequence['GetRuleVmTcpRdpArgs']] = None,
                 sshes: Optional[Sequence['GetRuleVmTcpSshArgs']] = None):
        """
        :param str proxy_id: Id of the Proxy
        :param Sequence['GetRuleVmTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        :param Sequence['GetRuleVmTcpRdpArgs'] rdps: RDP configuration
        :param Sequence['GetRuleVmTcpSshArgs'] sshes: SSH configuration
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)
        if rdps is not None:
            pulumi.set(__self__, "rdps", rdps)
        if sshes is not None:
            pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: str):
        pulumi.set(self, "proxy_id", value)

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['GetRuleVmTcpForwardRuleArgs']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @forward_rules.setter
    def forward_rules(self, value: Optional[Sequence['GetRuleVmTcpForwardRuleArgs']]):
        pulumi.set(self, "forward_rules", value)

    @property
    @pulumi.getter
    def rdps(self) -> Optional[Sequence['GetRuleVmTcpRdpArgs']]:
        """
        RDP configuration
        """
        return pulumi.get(self, "rdps")

    @rdps.setter
    def rdps(self, value: Optional[Sequence['GetRuleVmTcpRdpArgs']]):
        pulumi.set(self, "rdps", value)

    @property
    @pulumi.getter
    def sshes(self) -> Optional[Sequence['GetRuleVmTcpSshArgs']]:
        """
        SSH configuration
        """
        return pulumi.get(self, "sshes")

    @sshes.setter
    def sshes(self, value: Optional[Sequence['GetRuleVmTcpSshArgs']]):
        pulumi.set(self, "sshes", value)


@pulumi.input_type
class GetRuleVmTcpForwardRuleArgs:
    def __init__(__self__, *,
                 port: int,
                 connect_on: Optional[int] = None):
        """
        :param int port: Port to listen on the vm
        :param int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: int):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[int]):
        pulumi.set(self, "connect_on", value)


@pulumi.input_type
class GetRuleVmTcpRdpArgs:
    def __init__(__self__, *,
                 connect_on: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param int connect_on: Port to listen on the proxy
        :param int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[int]):
        pulumi.set(self, "connect_on", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class GetRuleVmTcpSshArgs:
    def __init__(__self__, *,
                 connect_on: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param int connect_on: Port to listen on the proxy
        :param int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @connect_on.setter
    def connect_on(self, value: Optional[int]):
        pulumi.set(self, "connect_on", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[int]):
        pulumi.set(self, "port", value)


