# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AwsAlbArgs', 'AwsAlb']

@pulumi.input_type
class AwsAlbArgs:
    def __init__(__self__, *,
                 cloud_connector_id: pulumi.Input[str],
                 delete_cloud_resources_on_destroy: pulumi.Input[bool],
                 host_name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 vpc: pulumi.Input[str],
                 alb_arn: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route53_hosted_zone_id: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AwsAlb resource.
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        :param pulumi.Input[str] alb_arn: Arn of AWS ALB to be imported. Required only for importing existing ALB
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[str] route53_hosted_zone_id: Route 53 hosted zone id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        """
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        pulumi.set(__self__, "delete_cloud_resources_on_destroy", delete_cloud_resources_on_destroy)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc", vpc)
        if alb_arn is not None:
            pulumi.set(__self__, "alb_arn", alb_arn)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route53_hosted_zone_id is not None:
            pulumi.set(__self__, "route53_hosted_zone_id", route53_hosted_zone_id)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Input[str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @delete_cloud_resources_on_destroy.setter
    def delete_cloud_resources_on_destroy(self, value: pulumi.Input[bool]):
        pulumi.set(self, "delete_cloud_resources_on_destroy", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Input[str]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc", value)

    @property
    @pulumi.getter(name="albArn")
    def alb_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Arn of AWS ALB to be imported. Required only for importing existing ALB
        """
        return pulumi.get(self, "alb_arn")

    @alb_arn.setter
    def alb_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alb_arn", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="route53HostedZoneId")
    def route53_hosted_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        Route 53 hosted zone id
        """
        return pulumi.get(self, "route53_hosted_zone_id")

    @route53_hosted_zone_id.setter
    def route53_hosted_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route53_hosted_zone_id", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security Group to define the security rules that determine the inbound and outbound traffic
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)


@pulumi.input_type
class _AwsAlbState:
    def __init__(__self__, *,
                 alb_arn: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 cloud_connector_id: Optional[pulumi.Input[str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 route53_hosted_zone_id: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsAlb resources.
        :param pulumi.Input[str] alb_arn: Arn of AWS ALB to be imported. Required only for importing existing ALB
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] identifier: Unique identifier of the resource
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[str] route53_hosted_zone_id: Route 53 hosted zone id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        """
        if alb_arn is not None:
            pulumi.set(__self__, "alb_arn", alb_arn)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if cloud_connector_id is not None:
            pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if delete_cloud_resources_on_destroy is not None:
            pulumi.set(__self__, "delete_cloud_resources_on_destroy", delete_cloud_resources_on_destroy)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route53_hosted_zone_id is not None:
            pulumi.set(__self__, "route53_hosted_zone_id", route53_hosted_zone_id)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="albArn")
    def alb_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Arn of AWS ALB to be imported. Required only for importing existing ALB
        """
        return pulumi.get(self, "alb_arn")

    @alb_arn.setter
    def alb_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alb_arn", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @delete_cloud_resources_on_destroy.setter
    def delete_cloud_resources_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_cloud_resources_on_destroy", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="route53HostedZoneId")
    def route53_hosted_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        Route 53 hosted zone id
        """
        return pulumi.get(self, "route53_hosted_zone_id")

    @route53_hosted_zone_id.setter
    def route53_hosted_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route53_hosted_zone_id", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security Group to define the security rules that determine the inbound and outbound traffic
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[str]]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc", value)


class AwsAlb(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alb_arn: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 cloud_connector_id: Optional[pulumi.Input[str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 route53_hosted_zone_id: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for creating an AWS application load balancer

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.AwsAlb("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="region",
            vpc="vpc",
            security_groups=[
                "sg1",
                "sg2",
            ],
            route53_hosted_zone_id="/hostedzone/zone_id",
            delete_cloud_resources_on_destroy=True)
        harness_alb = harness.autostopping.AwsAlb("harness_alb",
            name="harness_alb",
            cloud_connector_id="cloud_connector_id",
            host_name="host.name",
            alb_arn="arn:aws:elasticloadbalancing:region:aws_account_id:loadbalancer/app/harness_alb/id",
            region="region",
            vpc="vpc",
            security_groups=["sg-0"],
            route53_hosted_zone_id="/hostedzone/zone_id",
            delete_cloud_resources_on_destroy=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alb_arn: Arn of AWS ALB to be imported. Required only for importing existing ALB
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[str] route53_hosted_zone_id: Route 53 hosted zone id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsAlbArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an AWS application load balancer

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.AwsAlb("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="region",
            vpc="vpc",
            security_groups=[
                "sg1",
                "sg2",
            ],
            route53_hosted_zone_id="/hostedzone/zone_id",
            delete_cloud_resources_on_destroy=True)
        harness_alb = harness.autostopping.AwsAlb("harness_alb",
            name="harness_alb",
            cloud_connector_id="cloud_connector_id",
            host_name="host.name",
            alb_arn="arn:aws:elasticloadbalancing:region:aws_account_id:loadbalancer/app/harness_alb/id",
            region="region",
            vpc="vpc",
            security_groups=["sg-0"],
            route53_hosted_zone_id="/hostedzone/zone_id",
            delete_cloud_resources_on_destroy=False)
        ```

        :param str resource_name: The name of the resource.
        :param AwsAlbArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsAlbArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alb_arn: Optional[pulumi.Input[str]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 cloud_connector_id: Optional[pulumi.Input[str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 route53_hosted_zone_id: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsAlbArgs.__new__(AwsAlbArgs)

            __props__.__dict__["alb_arn"] = alb_arn
            __props__.__dict__["certificate_id"] = certificate_id
            if cloud_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_connector_id'")
            __props__.__dict__["cloud_connector_id"] = cloud_connector_id
            if delete_cloud_resources_on_destroy is None and not opts.urn:
                raise TypeError("Missing required property 'delete_cloud_resources_on_destroy'")
            __props__.__dict__["delete_cloud_resources_on_destroy"] = delete_cloud_resources_on_destroy
            if host_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_name'")
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["name"] = name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["route53_hosted_zone_id"] = route53_hosted_zone_id
            __props__.__dict__["security_groups"] = security_groups
            if vpc is None and not opts.urn:
                raise TypeError("Missing required property 'vpc'")
            __props__.__dict__["vpc"] = vpc
            __props__.__dict__["identifier"] = None
        super(AwsAlb, __self__).__init__(
            'harness:autostopping/awsAlb:AwsAlb',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alb_arn: Optional[pulumi.Input[str]] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            cloud_connector_id: Optional[pulumi.Input[str]] = None,
            delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            route53_hosted_zone_id: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc: Optional[pulumi.Input[str]] = None) -> 'AwsAlb':
        """
        Get an existing AwsAlb resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alb_arn: Arn of AWS ALB to be imported. Required only for importing existing ALB
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] identifier: Unique identifier of the resource
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[str] route53_hosted_zone_id: Route 53 hosted zone id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsAlbState.__new__(_AwsAlbState)

        __props__.__dict__["alb_arn"] = alb_arn
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["cloud_connector_id"] = cloud_connector_id
        __props__.__dict__["delete_cloud_resources_on_destroy"] = delete_cloud_resources_on_destroy
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["route53_hosted_zone_id"] = route53_hosted_zone_id
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["vpc"] = vpc
        return AwsAlb(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="albArn")
    def alb_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Arn of AWS ALB to be imported. Required only for importing existing ALB
        """
        return pulumi.get(self, "alb_arn")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Output[str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[str]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="route53HostedZoneId")
    def route53_hosted_zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        Route 53 hosted zone id
        """
        return pulumi.get(self, "route53_hosted_zone_id")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Security Group to define the security rules that determine the inbound and outbound traffic
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[str]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "vpc")

