# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpProxyArgs', 'GcpProxy']

@pulumi.input_type
class GcpProxyArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[str],
                 cloud_connector_id: pulumi.Input[str],
                 delete_cloud_resources_on_destroy: pulumi.Input[bool],
                 host_name: pulumi.Input[str],
                 machine_type: pulumi.Input[str],
                 region: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc: pulumi.Input[str],
                 zone: pulumi.Input[str],
                 allocate_static_ip: Optional[pulumi.Input[bool]] = None,
                 certificates: Optional[pulumi.Input['GcpProxyCertificatesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a GcpProxy resource.
        :param pulumi.Input[str] api_key: Harness NG API key
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] machine_type: Machine instance type
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[str] subnet_id: VPC in which cloud resources are hosted
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        :param pulumi.Input[str] zone: Zone in which cloud resources are hosted
        :param pulumi.Input[bool] allocate_static_ip: Boolean value to indicate if proxy vm needs to have static IP
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        pulumi.set(__self__, "delete_cloud_resources_on_destroy", delete_cloud_resources_on_destroy)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc", vpc)
        pulumi.set(__self__, "zone", zone)
        if allocate_static_ip is not None:
            pulumi.set(__self__, "allocate_static_ip", allocate_static_ip)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[str]:
        """
        Harness NG API key
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Input[str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @delete_cloud_resources_on_destroy.setter
    def delete_cloud_resources_on_destroy(self, value: pulumi.Input[bool]):
        pulumi.set(self, "delete_cloud_resources_on_destroy", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[str]:
        """
        Machine instance type
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Input[str]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[str]:
        """
        Zone in which cloud resources are hosted
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter(name="allocateStaticIp")
    def allocate_static_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value to indicate if proxy vm needs to have static IP
        """
        return pulumi.get(self, "allocate_static_ip")

    @allocate_static_ip.setter
    def allocate_static_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocate_static_ip", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input['GcpProxyCertificatesArgs']]:
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input['GcpProxyCertificatesArgs']]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security Group to define the security rules that determine the inbound and outbound traffic
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)


@pulumi.input_type
class _GcpProxyState:
    def __init__(__self__, *,
                 allocate_static_ip: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input['GcpProxyCertificatesArgs']] = None,
                 cloud_connector_id: Optional[pulumi.Input[str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GcpProxy resources.
        :param pulumi.Input[bool] allocate_static_ip: Boolean value to indicate if proxy vm needs to have static IP
        :param pulumi.Input[str] api_key: Harness NG API key
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] identifier: Unique identifier of the resource
        :param pulumi.Input[str] machine_type: Machine instance type
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        :param pulumi.Input[str] subnet_id: VPC in which cloud resources are hosted
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        :param pulumi.Input[str] zone: Zone in which cloud resources are hosted
        """
        if allocate_static_ip is not None:
            pulumi.set(__self__, "allocate_static_ip", allocate_static_ip)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if cloud_connector_id is not None:
            pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if delete_cloud_resources_on_destroy is not None:
            pulumi.set(__self__, "delete_cloud_resources_on_destroy", delete_cloud_resources_on_destroy)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="allocateStaticIp")
    def allocate_static_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value to indicate if proxy vm needs to have static IP
        """
        return pulumi.get(self, "allocate_static_ip")

    @allocate_static_ip.setter
    def allocate_static_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allocate_static_ip", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        Harness NG API key
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input['GcpProxyCertificatesArgs']]:
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input['GcpProxyCertificatesArgs']]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @cloud_connector_id.setter
    def cloud_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_connector_id", value)

    @property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @delete_cloud_resources_on_destroy.setter
    def delete_cloud_resources_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_cloud_resources_on_destroy", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Machine instance type
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security Group to define the security rules that determine the inbound and outbound traffic
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[str]]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Zone in which cloud resources are hosted
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class GcpProxy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocate_static_ip: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Union['GcpProxyCertificatesArgs', 'GcpProxyCertificatesArgsDict']]] = None,
                 cloud_connector_id: Optional[pulumi.Input[str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for creating an GCP Autostopping proxy

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.GcpProxy("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="region",
            vpc="https://www.googleapis.com/compute/v1/projects/project_id/global/networks/netwok_id",
            zone="zone",
            security_groups=["http-server"],
            machine_type="e2-micro",
            subnet_id="https://www.googleapis.com/compute/v1/projects/project_id/regions/region/subnetworks/subnet_name",
            api_key="",
            allocate_static_ip=False,
            certificates={
                "key_secret_id": "projects/project_id/secrets/secret_id/versions/1",
                "cert_secret_id": "projects/project_id/secrets/secret_id/versions/1",
            },
            delete_cloud_resources_on_destroy=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allocate_static_ip: Boolean value to indicate if proxy vm needs to have static IP
        :param pulumi.Input[str] api_key: Harness NG API key
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] machine_type: Machine instance type
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        :param pulumi.Input[str] subnet_id: VPC in which cloud resources are hosted
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        :param pulumi.Input[str] zone: Zone in which cloud resources are hosted
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpProxyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an GCP Autostopping proxy

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.autostopping.GcpProxy("test",
            name="name",
            cloud_connector_id="cloud_connector_id",
            host_name="host_name",
            region="region",
            vpc="https://www.googleapis.com/compute/v1/projects/project_id/global/networks/netwok_id",
            zone="zone",
            security_groups=["http-server"],
            machine_type="e2-micro",
            subnet_id="https://www.googleapis.com/compute/v1/projects/project_id/regions/region/subnetworks/subnet_name",
            api_key="",
            allocate_static_ip=False,
            certificates={
                "key_secret_id": "projects/project_id/secrets/secret_id/versions/1",
                "cert_secret_id": "projects/project_id/secrets/secret_id/versions/1",
            },
            delete_cloud_resources_on_destroy=False)
        ```

        :param str resource_name: The name of the resource.
        :param GcpProxyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpProxyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocate_static_ip: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Union['GcpProxyCertificatesArgs', 'GcpProxyCertificatesArgsDict']]] = None,
                 cloud_connector_id: Optional[pulumi.Input[str]] = None,
                 delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpProxyArgs.__new__(GcpProxyArgs)

            __props__.__dict__["allocate_static_ip"] = allocate_static_ip
            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["certificates"] = certificates
            if cloud_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_connector_id'")
            __props__.__dict__["cloud_connector_id"] = cloud_connector_id
            if delete_cloud_resources_on_destroy is None and not opts.urn:
                raise TypeError("Missing required property 'delete_cloud_resources_on_destroy'")
            __props__.__dict__["delete_cloud_resources_on_destroy"] = delete_cloud_resources_on_destroy
            if host_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_name'")
            __props__.__dict__["host_name"] = host_name
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["name"] = name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["security_groups"] = security_groups
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if vpc is None and not opts.urn:
                raise TypeError("Missing required property 'vpc'")
            __props__.__dict__["vpc"] = vpc
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["identifier"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GcpProxy, __self__).__init__(
            'harness:autostopping/gcpProxy:GcpProxy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocate_static_ip: Optional[pulumi.Input[bool]] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            certificates: Optional[pulumi.Input[Union['GcpProxyCertificatesArgs', 'GcpProxyCertificatesArgsDict']]] = None,
            cloud_connector_id: Optional[pulumi.Input[str]] = None,
            delete_cloud_resources_on_destroy: Optional[pulumi.Input[bool]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            machine_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            vpc: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'GcpProxy':
        """
        Get an existing GcpProxy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allocate_static_ip: Boolean value to indicate if proxy vm needs to have static IP
        :param pulumi.Input[str] api_key: Harness NG API key
        :param pulumi.Input[str] cloud_connector_id: Id of the cloud connector
        :param pulumi.Input[str] host_name: Hostname for the proxy
        :param pulumi.Input[str] identifier: Unique identifier of the resource
        :param pulumi.Input[str] machine_type: Machine instance type
        :param pulumi.Input[str] name: Name of the proxy
        :param pulumi.Input[str] region: Region in which cloud resources are hosted
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Security Group to define the security rules that determine the inbound and outbound traffic
        :param pulumi.Input[str] subnet_id: VPC in which cloud resources are hosted
        :param pulumi.Input[str] vpc: VPC in which cloud resources are hosted
        :param pulumi.Input[str] zone: Zone in which cloud resources are hosted
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpProxyState.__new__(_GcpProxyState)

        __props__.__dict__["allocate_static_ip"] = allocate_static_ip
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["cloud_connector_id"] = cloud_connector_id
        __props__.__dict__["delete_cloud_resources_on_destroy"] = delete_cloud_resources_on_destroy
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["vpc"] = vpc
        __props__.__dict__["zone"] = zone
        return GcpProxy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocateStaticIp")
    def allocate_static_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value to indicate if proxy vm needs to have static IP
        """
        return pulumi.get(self, "allocate_static_ip")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        Harness NG API key
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional['outputs.GcpProxyCertificates']]:
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> pulumi.Output[str]:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @property
    @pulumi.getter(name="deleteCloudResourcesOnDestroy")
    def delete_cloud_resources_on_destroy(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "delete_cloud_resources_on_destroy")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[str]:
        """
        Hostname for the proxy
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        Machine instance type
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the proxy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region in which cloud resources are hosted
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Security Group to define the security rules that determine the inbound and outbound traffic
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[str]:
        """
        VPC in which cloud resources are hosted
        """
        return pulumi.get(self, "vpc")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        Zone in which cloud resources are hosted
        """
        return pulumi.get(self, "zone")

