# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRuleEcsResult',
    'AwaitableGetRuleEcsResult',
    'get_rule_ecs',
    'get_rule_ecs_output',
]

@pulumi.output_type
class GetRuleEcsResult:
    """
    A collection of values returned by getRuleEcs.
    """
    def __init__(__self__, cloud_connector_id=None, container=None, custom_domains=None, depends=None, https=None, id=None, identifier=None, idle_time_mins=None, name=None):
        if cloud_connector_id and not isinstance(cloud_connector_id, str):
            raise TypeError("Expected argument 'cloud_connector_id' to be a str")
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if container and not isinstance(container, dict):
            raise TypeError("Expected argument 'container' to be a dict")
        pulumi.set(__self__, "container", container)
        if custom_domains and not isinstance(custom_domains, list):
            raise TypeError("Expected argument 'custom_domains' to be a list")
        pulumi.set(__self__, "custom_domains", custom_domains)
        if depends and not isinstance(depends, list):
            raise TypeError("Expected argument 'depends' to be a list")
        pulumi.set(__self__, "depends", depends)
        if https and not isinstance(https, list):
            raise TypeError("Expected argument 'https' to be a list")
        pulumi.set(__self__, "https", https)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, float):
            raise TypeError("Expected argument 'identifier' to be a float")
        pulumi.set(__self__, "identifier", identifier)
        if idle_time_mins and not isinstance(idle_time_mins, int):
            raise TypeError("Expected argument 'idle_time_mins' to be a int")
        pulumi.set(__self__, "idle_time_mins", idle_time_mins)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> str:
        """
        Id of the cloud connector
        """
        return pulumi.get(self, "cloud_connector_id")

    @property
    @pulumi.getter
    def container(self) -> Optional['outputs.GetRuleEcsContainerResult']:
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[Sequence[str]]:
        """
        Custom URLs used to access the instances
        """
        return pulumi.get(self, "custom_domains")

    @property
    @pulumi.getter
    def depends(self) -> Optional[Sequence['outputs.GetRuleEcsDependResult']]:
        """
        Dependent rules
        """
        return pulumi.get(self, "depends")

    @property
    @pulumi.getter
    def https(self) -> Optional[Sequence['outputs.GetRuleEcsHttpResult']]:
        """
        Http routing configuration
        """
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> float:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="idleTimeMins")
    def idle_time_mins(self) -> Optional[int]:
        """
        Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
        """
        return pulumi.get(self, "idle_time_mins")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")


class AwaitableGetRuleEcsResult(GetRuleEcsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleEcsResult(
            cloud_connector_id=self.cloud_connector_id,
            container=self.container,
            custom_domains=self.custom_domains,
            depends=self.depends,
            https=self.https,
            id=self.id,
            identifier=self.identifier,
            idle_time_mins=self.idle_time_mins,
            name=self.name)


def get_rule_ecs(cloud_connector_id: Optional[str] = None,
                 container: Optional[Union['GetRuleEcsContainerArgs', 'GetRuleEcsContainerArgsDict']] = None,
                 custom_domains: Optional[Sequence[str]] = None,
                 depends: Optional[Sequence[Union['GetRuleEcsDependArgs', 'GetRuleEcsDependArgsDict']]] = None,
                 https: Optional[Sequence[Union['GetRuleEcsHttpArgs', 'GetRuleEcsHttpArgsDict']]] = None,
                 idle_time_mins: Optional[int] = None,
                 name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleEcsResult:
    """
    Data source for retrieving a Harness Variable.


    :param str cloud_connector_id: Id of the cloud connector
    :param Sequence[str] custom_domains: Custom URLs used to access the instances
    :param Sequence[Union['GetRuleEcsDependArgs', 'GetRuleEcsDependArgsDict']] depends: Dependent rules
    :param Sequence[Union['GetRuleEcsHttpArgs', 'GetRuleEcsHttpArgsDict']] https: Http routing configuration
    :param int idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
    :param str name: Name of the rule
    """
    __args__ = dict()
    __args__['cloudConnectorId'] = cloud_connector_id
    __args__['container'] = container
    __args__['customDomains'] = custom_domains
    __args__['depends'] = depends
    __args__['https'] = https
    __args__['idleTimeMins'] = idle_time_mins
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:autostopping/getRuleEcs:getRuleEcs', __args__, opts=opts, typ=GetRuleEcsResult).value

    return AwaitableGetRuleEcsResult(
        cloud_connector_id=pulumi.get(__ret__, 'cloud_connector_id'),
        container=pulumi.get(__ret__, 'container'),
        custom_domains=pulumi.get(__ret__, 'custom_domains'),
        depends=pulumi.get(__ret__, 'depends'),
        https=pulumi.get(__ret__, 'https'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        idle_time_mins=pulumi.get(__ret__, 'idle_time_mins'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_rule_ecs)
def get_rule_ecs_output(cloud_connector_id: Optional[pulumi.Input[str]] = None,
                        container: Optional[pulumi.Input[Optional[Union['GetRuleEcsContainerArgs', 'GetRuleEcsContainerArgsDict']]]] = None,
                        custom_domains: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        depends: Optional[pulumi.Input[Optional[Sequence[Union['GetRuleEcsDependArgs', 'GetRuleEcsDependArgsDict']]]]] = None,
                        https: Optional[pulumi.Input[Optional[Sequence[Union['GetRuleEcsHttpArgs', 'GetRuleEcsHttpArgsDict']]]]] = None,
                        idle_time_mins: Optional[pulumi.Input[Optional[int]]] = None,
                        name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRuleEcsResult]:
    """
    Data source for retrieving a Harness Variable.


    :param str cloud_connector_id: Id of the cloud connector
    :param Sequence[str] custom_domains: Custom URLs used to access the instances
    :param Sequence[Union['GetRuleEcsDependArgs', 'GetRuleEcsDependArgsDict']] depends: Dependent rules
    :param Sequence[Union['GetRuleEcsHttpArgs', 'GetRuleEcsHttpArgsDict']] https: Http routing configuration
    :param int idle_time_mins: Idle time in minutes. This is the time that the AutoStopping rule waits before stopping the idle instances.
    :param str name: Name of the rule
    """
    ...
