# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AwsProxyCertificates',
    'AzureProxyCertificates',
    'GcpProxyCertificates',
    'RuleEcsContainer',
    'RuleEcsDepend',
    'RuleEcsHttp',
    'RuleRdsDatabase',
    'RuleRdsDepend',
    'RuleRdsTcp',
    'RuleRdsTcpForwardRule',
    'RuleVmDepend',
    'RuleVmFilter',
    'RuleVmFilterTag',
    'RuleVmHttp',
    'RuleVmHttpHealth',
    'RuleVmHttpRouting',
    'RuleVmTcp',
    'RuleVmTcpForwardRule',
    'RuleVmTcpRdp',
    'RuleVmTcpSsh',
    'ScheduleRepeat',
    'GetAwsProxyCertificatesResult',
    'GetAzureProxyCertificatesResult',
    'GetGcpProxyCertificatesResult',
    'GetRuleEcsContainerResult',
    'GetRuleEcsDependResult',
    'GetRuleEcsHttpResult',
    'GetRuleRdsDatabaseResult',
    'GetRuleRdsDependResult',
    'GetRuleRdsTcpResult',
    'GetRuleRdsTcpForwardRuleResult',
    'GetRuleVmDependResult',
    'GetRuleVmFilterResult',
    'GetRuleVmFilterTagResult',
    'GetRuleVmHttpResult',
    'GetRuleVmHttpHealthResult',
    'GetRuleVmHttpRoutingResult',
    'GetRuleVmTcpResult',
    'GetRuleVmTcpForwardRuleResult',
    'GetRuleVmTcpRdpResult',
    'GetRuleVmTcpSshResult',
    'GetScheduleRepeatResult',
]

@pulumi.output_type
class AwsProxyCertificates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSecretId":
            suggest = "cert_secret_id"
        elif key == "keySecretId":
            suggest = "key_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsProxyCertificates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsProxyCertificates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsProxyCertificates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: Certificate secret ID
        :param str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class AzureProxyCertificates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSecretId":
            suggest = "cert_secret_id"
        elif key == "keySecretId":
            suggest = "key_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureProxyCertificates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureProxyCertificates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureProxyCertificates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: ID of certificate secret uploaded to vault
        :param str key_secret_id: ID of certificate key uploaded to vault
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        ID of certificate secret uploaded to vault
        """
        return pulumi.get(self, "cert_secret_id")

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        ID of certificate key uploaded to vault
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GcpProxyCertificates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSecretId":
            suggest = "cert_secret_id"
        elif key == "keySecretId":
            suggest = "key_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpProxyCertificates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpProxyCertificates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpProxyCertificates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: Certificate secret ID
        :param str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class RuleEcsContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: str,
                 region: str,
                 service: str,
                 task_count: Optional[int] = None):
        """
        :param str cluster: Name of cluster in which service belong to
        :param str region: Region of cluster
        :param str service: Name of service to be onboarded
        :param int task_count: Desired number of tasks on warming up a rule
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service", service)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        Name of cluster in which service belong to
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of cluster
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Name of service to be onboarded
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[int]:
        """
        Desired number of tasks on warming up a rule
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class RuleEcsDepend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "delayInSec":
            suggest = "delay_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsDepend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsDepend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsDepend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class RuleEcsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: str):
        """
        :param str proxy_id: Id of the proxy
        """
        pulumi.set(__self__, "proxy_id", proxy_id)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")


@pulumi.output_type
class RuleRdsDatabase(dict):
    def __init__(__self__, *,
                 id: str,
                 region: str):
        """
        :param str id: ID of the database
        :param str region: Region to which database belong to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the database
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region to which database belong to
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RuleRdsDepend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "delayInSec":
            suggest = "delay_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRdsDepend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRdsDepend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRdsDepend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class RuleRdsTcp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"
        elif key == "forwardRules":
            suggest = "forward_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRdsTcp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRdsTcp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRdsTcp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: str,
                 forward_rules: Optional[Sequence['outputs.RuleRdsTcpForwardRule']] = None):
        """
        :param str proxy_id: Id of the Proxy
        :param Sequence['RuleRdsTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.RuleRdsTcpForwardRule']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")


@pulumi.output_type
class RuleRdsTcpForwardRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRdsTcpForwardRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRdsTcpForwardRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRdsTcpForwardRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 connect_on: Optional[int] = None):
        """
        :param int port: Port to listen on the vm
        :param int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class RuleVmDepend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "delayInSec":
            suggest = "delay_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmDepend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmDepend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmDepend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class RuleVmFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmIds":
            suggest = "vm_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_ids: Sequence[str],
                 regions: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence['outputs.RuleVmFilterTag']] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] vm_ids: Ids of instances that needs to be managed using the AutoStopping rules
        :param Sequence[str] regions: Regions of instances that needs to be managed using the AutoStopping rules
        :param Sequence['RuleVmFilterTagArgs'] tags: Tags of instances that needs to be managed using the AutoStopping rules
        :param Sequence[str] zones: Zones of instances that needs to be managed using the AutoStopping rules
        """
        pulumi.set(__self__, "vm_ids", vm_ids)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="vmIds")
    def vm_ids(self) -> Sequence[str]:
        """
        Ids of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "vm_ids")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        Regions of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.RuleVmFilterTag']]:
        """
        Tags of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        Zones of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class RuleVmFilterTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleVmHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: str,
                 healths: Optional[Sequence['outputs.RuleVmHttpHealth']] = None,
                 routings: Optional[Sequence['outputs.RuleVmHttpRouting']] = None):
        """
        :param str proxy_id: Id of the proxy
        :param Sequence['RuleVmHttpHealthArgs'] healths: Health Check Details
        :param Sequence['RuleVmHttpRoutingArgs'] routings: Routing configuration used to access the instances
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if routings is not None:
            pulumi.set(__self__, "routings", routings)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter
    def healths(self) -> Optional[Sequence['outputs.RuleVmHttpHealth']]:
        """
        Health Check Details
        """
        return pulumi.get(self, "healths")

    @property
    @pulumi.getter
    def routings(self) -> Optional[Sequence['outputs.RuleVmHttpRouting']]:
        """
        Routing configuration used to access the instances
        """
        return pulumi.get(self, "routings")


@pulumi.output_type
class RuleVmHttpHealth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodeFrom":
            suggest = "status_code_from"
        elif key == "statusCodeTo":
            suggest = "status_code_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmHttpHealth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmHttpHealth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmHttpHealth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 protocol: str,
                 path: Optional[str] = None,
                 status_code_from: Optional[int] = None,
                 status_code_to: Optional[int] = None,
                 timeout: Optional[int] = None):
        """
        :param int port: Health check port on the VM
        :param str protocol: Protocol can be http or https
        :param str path: API path to use for health check
        :param int status_code_from: Lower limit for acceptable status code
        :param int status_code_to: Upper limit for acceptable status code
        :param int timeout: Health check timeout
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code_from is not None:
            pulumi.set(__self__, "status_code_from", status_code_from)
        if status_code_to is not None:
            pulumi.set(__self__, "status_code_to", status_code_to)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Health check port on the VM
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol can be http or https
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        API path to use for health check
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="statusCodeFrom")
    def status_code_from(self) -> Optional[int]:
        """
        Lower limit for acceptable status code
        """
        return pulumi.get(self, "status_code_from")

    @property
    @pulumi.getter(name="statusCodeTo")
    def status_code_to(self) -> Optional[int]:
        """
        Upper limit for acceptable status code
        """
        return pulumi.get(self, "status_code_to")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Health check timeout
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class RuleVmHttpRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceProtocol":
            suggest = "source_protocol"
        elif key == "targetProtocol":
            suggest = "target_protocol"
        elif key == "sourcePort":
            suggest = "source_port"
        elif key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmHttpRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmHttpRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmHttpRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_protocol: str,
                 target_protocol: str,
                 action: Optional[str] = None,
                 source_port: Optional[int] = None,
                 target_port: Optional[int] = None):
        """
        :param str source_protocol: Source protocol of the proxy can be http or https
        :param str target_protocol: Target protocol of the instance can be http or https
        :param str action: Organization Identifier for the Entity
        :param int source_port: Port on the proxy
        :param int target_port: Port on the VM
        """
        pulumi.set(__self__, "source_protocol", source_protocol)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @property
    @pulumi.getter(name="sourceProtocol")
    def source_protocol(self) -> str:
        """
        Source protocol of the proxy can be http or https
        """
        return pulumi.get(self, "source_protocol")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        Target protocol of the instance can be http or https
        """
        return pulumi.get(self, "target_protocol")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[int]:
        """
        Port on the proxy
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[int]:
        """
        Port on the VM
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class RuleVmTcp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyId":
            suggest = "proxy_id"
        elif key == "forwardRules":
            suggest = "forward_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_id: str,
                 forward_rules: Optional[Sequence['outputs.RuleVmTcpForwardRule']] = None,
                 rdps: Optional[Sequence['outputs.RuleVmTcpRdp']] = None,
                 sshes: Optional[Sequence['outputs.RuleVmTcpSsh']] = None):
        """
        :param str proxy_id: Id of the Proxy
        :param Sequence['RuleVmTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        :param Sequence['RuleVmTcpRdpArgs'] rdps: RDP configuration
        :param Sequence['RuleVmTcpSshArgs'] sshes: SSH configuration
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)
        if rdps is not None:
            pulumi.set(__self__, "rdps", rdps)
        if sshes is not None:
            pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.RuleVmTcpForwardRule']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @property
    @pulumi.getter
    def rdps(self) -> Optional[Sequence['outputs.RuleVmTcpRdp']]:
        """
        RDP configuration
        """
        return pulumi.get(self, "rdps")

    @property
    @pulumi.getter
    def sshes(self) -> Optional[Sequence['outputs.RuleVmTcpSsh']]:
        """
        SSH configuration
        """
        return pulumi.get(self, "sshes")


@pulumi.output_type
class RuleVmTcpForwardRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcpForwardRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcpForwardRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcpForwardRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 connect_on: Optional[int] = None):
        """
        :param int port: Port to listen on the vm
        :param int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class RuleVmTcpRdp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcpRdp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcpRdp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcpRdp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_on: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param int connect_on: Port to listen on the proxy
        :param int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RuleVmTcpSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectOn":
            suggest = "connect_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleVmTcpSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleVmTcpSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleVmTcpSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_on: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param int connect_on: Port to listen on the proxy
        :param int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ScheduleRepeat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleRepeat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleRepeat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleRepeat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Sequence[str],
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        :param Sequence[str] days: List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        :param str end_time: Ending time of schedule action on the day. Defaults to 24:00Hrs unless specified. Accepted format is HH:MM. Eg : 20:00 for 8pm
        :param str start_time: Starting time of schedule action on the day. Defaults to 00:00Hrs unless specified. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        pulumi.set(__self__, "days", days)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def days(self) -> Sequence[str]:
        """
        List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Ending time of schedule action on the day. Defaults to 24:00Hrs unless specified. Accepted format is HH:MM. Eg : 20:00 for 8pm
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Starting time of schedule action on the day. Defaults to 00:00Hrs unless specified. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetAwsProxyCertificatesResult(dict):
    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: Certificate secret ID
        :param str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GetAzureProxyCertificatesResult(dict):
    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: ID of certificate secret uploaded to vault
        :param str key_secret_id: ID of certificate key uploaded to vault
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        ID of certificate secret uploaded to vault
        """
        return pulumi.get(self, "cert_secret_id")

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        ID of certificate key uploaded to vault
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GetGcpProxyCertificatesResult(dict):
    def __init__(__self__, *,
                 cert_secret_id: str,
                 key_secret_id: str):
        """
        :param str cert_secret_id: Certificate secret ID
        :param str key_secret_id: Private key secret ID
        """
        pulumi.set(__self__, "cert_secret_id", cert_secret_id)
        pulumi.set(__self__, "key_secret_id", key_secret_id)

    @property
    @pulumi.getter(name="certSecretId")
    def cert_secret_id(self) -> str:
        """
        Certificate secret ID
        """
        return pulumi.get(self, "cert_secret_id")

    @property
    @pulumi.getter(name="keySecretId")
    def key_secret_id(self) -> str:
        """
        Private key secret ID
        """
        return pulumi.get(self, "key_secret_id")


@pulumi.output_type
class GetRuleEcsContainerResult(dict):
    def __init__(__self__, *,
                 cluster: str,
                 region: str,
                 service: str,
                 task_count: Optional[int] = None):
        """
        :param str cluster: Name of cluster in which service belong to
        :param str region: Region of cluster
        :param str service: Name of service to be onboarded
        :param int task_count: Desired number of tasks on warming up a rule
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service", service)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        Name of cluster in which service belong to
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region of cluster
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Name of service to be onboarded
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[int]:
        """
        Desired number of tasks on warming up a rule
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class GetRuleEcsDependResult(dict):
    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class GetRuleEcsHttpResult(dict):
    def __init__(__self__, *,
                 proxy_id: str):
        """
        :param str proxy_id: Id of the proxy
        """
        pulumi.set(__self__, "proxy_id", proxy_id)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")


@pulumi.output_type
class GetRuleRdsDatabaseResult(dict):
    def __init__(__self__, *,
                 id: str,
                 region: str):
        """
        :param str id: ID of the database
        :param str region: Region to which database belong to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the database
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region to which database belong to
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetRuleRdsDependResult(dict):
    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class GetRuleRdsTcpResult(dict):
    def __init__(__self__, *,
                 proxy_id: str,
                 forward_rules: Optional[Sequence['outputs.GetRuleRdsTcpForwardRuleResult']] = None):
        """
        :param str proxy_id: Id of the Proxy
        :param Sequence['GetRuleRdsTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.GetRuleRdsTcpForwardRuleResult']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")


@pulumi.output_type
class GetRuleRdsTcpForwardRuleResult(dict):
    def __init__(__self__, *,
                 port: int,
                 connect_on: Optional[int] = None):
        """
        :param int port: Port to listen on the vm
        :param int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class GetRuleVmDependResult(dict):
    def __init__(__self__, *,
                 rule_id: int,
                 delay_in_sec: Optional[int] = None):
        """
        :param int rule_id: Rule id of the dependent rule
        :param int delay_in_sec: Number of seconds the rule should wait after warming up the dependent rule
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if delay_in_sec is not None:
            pulumi.set(__self__, "delay_in_sec", delay_in_sec)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> int:
        """
        Rule id of the dependent rule
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="delayInSec")
    def delay_in_sec(self) -> Optional[int]:
        """
        Number of seconds the rule should wait after warming up the dependent rule
        """
        return pulumi.get(self, "delay_in_sec")


@pulumi.output_type
class GetRuleVmFilterResult(dict):
    def __init__(__self__, *,
                 vm_ids: Sequence[str],
                 regions: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence['outputs.GetRuleVmFilterTagResult']] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] vm_ids: Ids of instances that needs to be managed using the AutoStopping rules
        :param Sequence[str] regions: Regions of instances that needs to be managed using the AutoStopping rules
        :param Sequence['GetRuleVmFilterTagArgs'] tags: Tags of instances that needs to be managed using the AutoStopping rules
        :param Sequence[str] zones: Zones of instances that needs to be managed using the AutoStopping rules
        """
        pulumi.set(__self__, "vm_ids", vm_ids)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="vmIds")
    def vm_ids(self) -> Sequence[str]:
        """
        Ids of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "vm_ids")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        Regions of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.GetRuleVmFilterTagResult']]:
        """
        Tags of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        Zones of instances that needs to be managed using the AutoStopping rules
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetRuleVmFilterTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRuleVmHttpResult(dict):
    def __init__(__self__, *,
                 proxy_id: str,
                 healths: Optional[Sequence['outputs.GetRuleVmHttpHealthResult']] = None,
                 routings: Optional[Sequence['outputs.GetRuleVmHttpRoutingResult']] = None):
        """
        :param str proxy_id: Id of the proxy
        :param Sequence['GetRuleVmHttpHealthArgs'] healths: Health Check Details
        :param Sequence['GetRuleVmHttpRoutingArgs'] routings: Routing configuration used to access the instances
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if healths is not None:
            pulumi.set(__self__, "healths", healths)
        if routings is not None:
            pulumi.set(__self__, "routings", routings)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the proxy
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter
    def healths(self) -> Optional[Sequence['outputs.GetRuleVmHttpHealthResult']]:
        """
        Health Check Details
        """
        return pulumi.get(self, "healths")

    @property
    @pulumi.getter
    def routings(self) -> Optional[Sequence['outputs.GetRuleVmHttpRoutingResult']]:
        """
        Routing configuration used to access the instances
        """
        return pulumi.get(self, "routings")


@pulumi.output_type
class GetRuleVmHttpHealthResult(dict):
    def __init__(__self__, *,
                 port: int,
                 protocol: str,
                 path: Optional[str] = None,
                 status_code_from: Optional[int] = None,
                 status_code_to: Optional[int] = None,
                 timeout: Optional[int] = None):
        """
        :param int port: Health check port on the VM
        :param str protocol: Protocol can be http or https
        :param str path: API path to use for health check
        :param int status_code_from: Lower limit for acceptable status code
        :param int status_code_to: Upper limit for acceptable status code
        :param int timeout: Health check timeout
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_code_from is not None:
            pulumi.set(__self__, "status_code_from", status_code_from)
        if status_code_to is not None:
            pulumi.set(__self__, "status_code_to", status_code_to)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Health check port on the VM
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol can be http or https
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        API path to use for health check
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="statusCodeFrom")
    def status_code_from(self) -> Optional[int]:
        """
        Lower limit for acceptable status code
        """
        return pulumi.get(self, "status_code_from")

    @property
    @pulumi.getter(name="statusCodeTo")
    def status_code_to(self) -> Optional[int]:
        """
        Upper limit for acceptable status code
        """
        return pulumi.get(self, "status_code_to")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Health check timeout
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetRuleVmHttpRoutingResult(dict):
    def __init__(__self__, *,
                 source_protocol: str,
                 target_protocol: str,
                 action: Optional[str] = None,
                 source_port: Optional[int] = None,
                 target_port: Optional[int] = None):
        """
        :param str source_protocol: Source protocol of the proxy can be http or https
        :param str target_protocol: Target protocol of the instance can be http or https
        :param str action: Organization Identifier for the Entity
        :param int source_port: Port on the proxy
        :param int target_port: Port on the VM
        """
        pulumi.set(__self__, "source_protocol", source_protocol)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @property
    @pulumi.getter(name="sourceProtocol")
    def source_protocol(self) -> str:
        """
        Source protocol of the proxy can be http or https
        """
        return pulumi.get(self, "source_protocol")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        Target protocol of the instance can be http or https
        """
        return pulumi.get(self, "target_protocol")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Organization Identifier for the Entity
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[int]:
        """
        Port on the proxy
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[int]:
        """
        Port on the VM
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class GetRuleVmTcpResult(dict):
    def __init__(__self__, *,
                 proxy_id: str,
                 forward_rules: Optional[Sequence['outputs.GetRuleVmTcpForwardRuleResult']] = None,
                 rdps: Optional[Sequence['outputs.GetRuleVmTcpRdpResult']] = None,
                 sshes: Optional[Sequence['outputs.GetRuleVmTcpSshResult']] = None):
        """
        :param str proxy_id: Id of the Proxy
        :param Sequence['GetRuleVmTcpForwardRuleArgs'] forward_rules: Additional tcp forwarding rules
        :param Sequence['GetRuleVmTcpRdpArgs'] rdps: RDP configuration
        :param Sequence['GetRuleVmTcpSshArgs'] sshes: SSH configuration
        """
        pulumi.set(__self__, "proxy_id", proxy_id)
        if forward_rules is not None:
            pulumi.set(__self__, "forward_rules", forward_rules)
        if rdps is not None:
            pulumi.set(__self__, "rdps", rdps)
        if sshes is not None:
            pulumi.set(__self__, "sshes", sshes)

    @property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> str:
        """
        Id of the Proxy
        """
        return pulumi.get(self, "proxy_id")

    @property
    @pulumi.getter(name="forwardRules")
    def forward_rules(self) -> Optional[Sequence['outputs.GetRuleVmTcpForwardRuleResult']]:
        """
        Additional tcp forwarding rules
        """
        return pulumi.get(self, "forward_rules")

    @property
    @pulumi.getter
    def rdps(self) -> Optional[Sequence['outputs.GetRuleVmTcpRdpResult']]:
        """
        RDP configuration
        """
        return pulumi.get(self, "rdps")

    @property
    @pulumi.getter
    def sshes(self) -> Optional[Sequence['outputs.GetRuleVmTcpSshResult']]:
        """
        SSH configuration
        """
        return pulumi.get(self, "sshes")


@pulumi.output_type
class GetRuleVmTcpForwardRuleResult(dict):
    def __init__(__self__, *,
                 port: int,
                 connect_on: Optional[int] = None):
        """
        :param int port: Port to listen on the vm
        :param int connect_on: Port to listen on the proxy
        """
        pulumi.set(__self__, "port", port)
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")


@pulumi.output_type
class GetRuleVmTcpRdpResult(dict):
    def __init__(__self__, *,
                 connect_on: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param int connect_on: Port to listen on the proxy
        :param int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRuleVmTcpSshResult(dict):
    def __init__(__self__, *,
                 connect_on: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param int connect_on: Port to listen on the proxy
        :param int port: Port to listen on the vm
        """
        if connect_on is not None:
            pulumi.set(__self__, "connect_on", connect_on)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="connectOn")
    def connect_on(self) -> Optional[int]:
        """
        Port to listen on the proxy
        """
        return pulumi.get(self, "connect_on")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port to listen on the vm
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetScheduleRepeatResult(dict):
    def __init__(__self__, *,
                 days: Sequence[str],
                 end_time: str,
                 start_time: str):
        """
        :param Sequence[str] days: List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        :param str end_time: Ending time of schedule action on the day. Accepted format is HH:MM. Eg : 20:00 for 8pm
        :param str start_time: Starting time of schedule action on the day. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def days(self) -> Sequence[str]:
        """
        List of days on which schedule need to be active. Valid values are SUN, MON, TUE, WED, THU, FRI and SAT.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Ending time of schedule action on the day. Accepted format is HH:MM. Eg : 20:00 for 8pm
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Starting time of schedule action on the day. Accepted format is HH:MM. Eg : 13:15 for 01:15pm
        """
        return pulumi.get(self, "start_time")


