# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AzureArgs', 'Azure']

@pulumi.input_type
class AzureArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 key: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 environment_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Azure resource.
        :param pulumi.Input[str] client_id: The client id for the Azure application
        :param pulumi.Input[str] key: The Name of the Harness secret containing the key for the Azure application
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure application
        :param pulumi.Input[str] environment_type: The type of environment. Valid options are [AZURE AZURE*US*GOVERNMENT]
        :param pulumi.Input[str] name: The name of the cloud provider.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if environment_type is not None:
            pulumi.set(__self__, "environment_type", environment_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        The client id for the Azure application
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The Name of the Harness secret containing the key for the Azure application
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The tenant id for the Azure application
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of environment. Valid options are [AZURE AZURE*US*GOVERNMENT]
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AzureState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 environment_type: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Azure resources.
        :param pulumi.Input[str] client_id: The client id for the Azure application
        :param pulumi.Input[str] environment_type: The type of environment. Valid options are [AZURE AZURE*US*GOVERNMENT]
        :param pulumi.Input[str] key: The Name of the Harness secret containing the key for the Azure application
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure application
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if environment_type is not None:
            pulumi.set(__self__, "environment_type", environment_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id for the Azure application
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of environment. Valid options are [AZURE AZURE*US*GOVERNMENT]
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the Harness secret containing the key for the Azure application
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant id for the Azure application
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class Azure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 environment_type: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for creating an Azure cloud provider. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        default = harness.get_secret_manager(default=True)
        azure_key = harness.EncryptedText("azure_key",
            name="azure_key",
            value="<AZURE_KEY>",
            secret_manager_id=default.id)
        azure = harness.cloudprovider.Azure("azure",
            name="azure",
            client_id="<AZURE_CLIENT_ID>",
            tenant_id="<AZURE_TENANT_ID>",
            key=azure_key.name)
        ```

        ## Import

        Import using the Harness azure cloud provider id.

        ```sh
        $ pulumi import harness:cloudprovider/azure:Azure example <provider_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The client id for the Azure application
        :param pulumi.Input[str] environment_type: The type of environment. Valid options are [AZURE AZURE*US*GOVERNMENT]
        :param pulumi.Input[str] key: The Name of the Harness secret containing the key for the Azure application
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure application
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an Azure cloud provider. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        default = harness.get_secret_manager(default=True)
        azure_key = harness.EncryptedText("azure_key",
            name="azure_key",
            value="<AZURE_KEY>",
            secret_manager_id=default.id)
        azure = harness.cloudprovider.Azure("azure",
            name="azure",
            client_id="<AZURE_CLIENT_ID>",
            tenant_id="<AZURE_TENANT_ID>",
            key=azure_key.name)
        ```

        ## Import

        Import using the Harness azure cloud provider id.

        ```sh
        $ pulumi import harness:cloudprovider/azure:Azure example <provider_id>
        ```

        :param str resource_name: The name of the resource.
        :param AzureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 environment_type: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureArgs.__new__(AzureArgs)

            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["environment_type"] = environment_type
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(Azure, __self__).__init__(
            'harness:cloudprovider/azure:Azure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            environment_type: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'Azure':
        """
        Get an existing Azure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The client id for the Azure application
        :param pulumi.Input[str] environment_type: The type of environment. Valid options are [AZURE AZURE*US*GOVERNMENT]
        :param pulumi.Input[str] key: The Name of the Harness secret containing the key for the Azure application
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[str] tenant_id: The tenant id for the Azure application
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureState.__new__(_AzureState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["environment_type"] = environment_type
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        return Azure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        The client id for the Azure application
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of environment. Valid options are [AZURE AZURE*US*GOVERNMENT]
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The Name of the Harness secret containing the key for the Azure application
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The tenant id for the Azure application
        """
        return pulumi.get(self, "tenant_id")

