# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesArgs', 'Kubernetes']

@pulumi.input_type
class KubernetesArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['KubernetesAuthenticationArgs'],
                 name: Optional[pulumi.Input[str]] = None,
                 skip_validation: Optional[pulumi.Input[bool]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]]] = None):
        """
        The set of arguments for constructing a Kubernetes resource.
        :param pulumi.Input['KubernetesAuthenticationArgs'] authentication: Authentication configuration for the Kubernetes cluster
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[bool] skip_validation: Skip validation of Kubernetes configuration.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        """
        pulumi.set(__self__, "authentication", authentication)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_validation is not None:
            pulumi.set(__self__, "skip_validation", skip_validation)
        if usage_scopes is not None:
            pulumi.set(__self__, "usage_scopes", usage_scopes)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['KubernetesAuthenticationArgs']:
        """
        Authentication configuration for the Kubernetes cluster
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['KubernetesAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip validation of Kubernetes configuration.
        """
        return pulumi.get(self, "skip_validation")

    @skip_validation.setter
    def skip_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_validation", value)

    @property
    @pulumi.getter(name="usageScopes")
    def usage_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]]]:
        """
        This block is used for scoping the resource to a specific set of applications or environments.
        """
        return pulumi.get(self, "usage_scopes")

    @usage_scopes.setter
    def usage_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]]]):
        pulumi.set(self, "usage_scopes", value)


@pulumi.input_type
class _KubernetesState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['KubernetesAuthenticationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_validation: Optional[pulumi.Input[bool]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]]] = None):
        """
        Input properties used for looking up and filtering Kubernetes resources.
        :param pulumi.Input['KubernetesAuthenticationArgs'] authentication: Authentication configuration for the Kubernetes cluster
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[bool] skip_validation: Skip validation of Kubernetes configuration.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_validation is not None:
            pulumi.set(__self__, "skip_validation", skip_validation)
        if usage_scopes is not None:
            pulumi.set(__self__, "usage_scopes", usage_scopes)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['KubernetesAuthenticationArgs']]:
        """
        Authentication configuration for the Kubernetes cluster
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['KubernetesAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip validation of Kubernetes configuration.
        """
        return pulumi.get(self, "skip_validation")

    @skip_validation.setter
    def skip_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_validation", value)

    @property
    @pulumi.getter(name="usageScopes")
    def usage_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]]]:
        """
        This block is used for scoping the resource to a specific set of applications or environments.
        """
        return pulumi.get(self, "usage_scopes")

    @usage_scopes.setter
    def usage_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesUsageScopeArgs']]]]):
        pulumi.set(self, "usage_scopes", value)


class Kubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['KubernetesAuthenticationArgs', 'KubernetesAuthenticationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_validation: Optional[pulumi.Input[bool]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesUsageScopeArgs', 'KubernetesUsageScopeArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for creating a Kubernetes cloud provider. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Import

        Import using the Harness kubernetes cloud provider id.

        ```sh
        $ pulumi import harness:cloudprovider/kubernetes:Kubernetes example <provider_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesAuthenticationArgs', 'KubernetesAuthenticationArgsDict']] authentication: Authentication configuration for the Kubernetes cluster
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[bool] skip_validation: Skip validation of Kubernetes configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesUsageScopeArgs', 'KubernetesUsageScopeArgsDict']]]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Kubernetes cloud provider. This resource uses the config-as-code API's. When updating the `name` or `path` of this resource you should typically also set the `create_before_destroy = true` lifecycle setting.

        ## Import

        Import using the Harness kubernetes cloud provider id.

        ```sh
        $ pulumi import harness:cloudprovider/kubernetes:Kubernetes example <provider_id>
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['KubernetesAuthenticationArgs', 'KubernetesAuthenticationArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_validation: Optional[pulumi.Input[bool]] = None,
                 usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesUsageScopeArgs', 'KubernetesUsageScopeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesArgs.__new__(KubernetesArgs)

            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["name"] = name
            __props__.__dict__["skip_validation"] = skip_validation
            __props__.__dict__["usage_scopes"] = usage_scopes
        super(Kubernetes, __self__).__init__(
            'harness:cloudprovider/kubernetes:Kubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[Union['KubernetesAuthenticationArgs', 'KubernetesAuthenticationArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            skip_validation: Optional[pulumi.Input[bool]] = None,
            usage_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesUsageScopeArgs', 'KubernetesUsageScopeArgsDict']]]]] = None) -> 'Kubernetes':
        """
        Get an existing Kubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesAuthenticationArgs', 'KubernetesAuthenticationArgsDict']] authentication: Authentication configuration for the Kubernetes cluster
        :param pulumi.Input[str] name: The name of the cloud provider.
        :param pulumi.Input[bool] skip_validation: Skip validation of Kubernetes configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesUsageScopeArgs', 'KubernetesUsageScopeArgsDict']]]] usage_scopes: This block is used for scoping the resource to a specific set of applications or environments.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesState.__new__(_KubernetesState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["name"] = name
        __props__.__dict__["skip_validation"] = skip_validation
        __props__.__dict__["usage_scopes"] = usage_scopes
        return Kubernetes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.KubernetesAuthentication']:
        """
        Authentication configuration for the Kubernetes cluster
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cloud provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> pulumi.Output[Optional[bool]]:
        """
        Skip validation of Kubernetes configuration.
        """
        return pulumi.get(self, "skip_validation")

    @property
    @pulumi.getter(name="usageScopes")
    def usage_scopes(self) -> pulumi.Output[Optional[Sequence['outputs.KubernetesUsageScope']]]:
        """
        This block is used for scoping the resource to a specific set of applications or environments.
        """
        return pulumi.get(self, "usage_scopes")

