# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureCloudProviderConnectorArgs', 'AzureCloudProviderConnector']

@pulumi.input_type
class AzureCloudProviderConnectorArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input['AzureCloudProviderConnectorCredentialsArgs'],
                 identifier: pulumi.Input[str],
                 azure_environment_type: Optional[pulumi.Input[str]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AzureCloudProviderConnector resource.
        :param pulumi.Input['AzureCloudProviderConnectorCredentialsArgs'] credentials: Contains Azure connector credentials.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] azure_environment_type: Specifies the Azure Environment type, which is AZURE by default. Can either be AZURE or AZURE*US*GOVERNMENT
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "identifier", identifier)
        if azure_environment_type is not None:
            pulumi.set(__self__, "azure_environment_type", azure_environment_type)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input['AzureCloudProviderConnectorCredentialsArgs']:
        """
        Contains Azure connector credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input['AzureCloudProviderConnectorCredentialsArgs']):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="azureEnvironmentType")
    def azure_environment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Azure Environment type, which is AZURE by default. Can either be AZURE or AZURE*US*GOVERNMENT
        """
        return pulumi.get(self, "azure_environment_type")

    @azure_environment_type.setter
    def azure_environment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_environment_type", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this flag for force deletion of connector
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AzureCloudProviderConnectorState:
    def __init__(__self__, *,
                 azure_environment_type: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['AzureCloudProviderConnectorCredentialsArgs']] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AzureCloudProviderConnector resources.
        :param pulumi.Input[str] azure_environment_type: Specifies the Azure Environment type, which is AZURE by default. Can either be AZURE or AZURE*US*GOVERNMENT
        :param pulumi.Input['AzureCloudProviderConnectorCredentialsArgs'] credentials: Contains Azure connector credentials.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        if azure_environment_type is not None:
            pulumi.set(__self__, "azure_environment_type", azure_environment_type)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="azureEnvironmentType")
    def azure_environment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Azure Environment type, which is AZURE by default. Can either be AZURE or AZURE*US*GOVERNMENT
        """
        return pulumi.get(self, "azure_environment_type")

    @azure_environment_type.setter
    def azure_environment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_environment_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['AzureCloudProviderConnectorCredentialsArgs']]:
        """
        Contains Azure connector credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['AzureCloudProviderConnectorCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this flag for force deletion of connector
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class AzureCloudProviderConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_environment_type: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[Union['AzureCloudProviderConnectorCredentialsArgs', 'AzureCloudProviderConnectorCredentialsArgsDict']]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for creating an Azure Cloud Provider in Harness.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        manual_config_secret = harness.platform.AzureCloudProviderConnector("manual_config_secret",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "ManualConfig",
                "azure_manual_details": {
                    "application_id": "application_id",
                    "tenant_id": "tenant_id",
                    "auth": {
                        "type": "Secret",
                        "azure_client_secret_key": {
                            "secret_ref": f"account.{test['id']}",
                        },
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        manual_config_certificate = harness.platform.AzureCloudProviderConnector("manual_config_certificate",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "ManualConfig",
                "azure_manual_details": {
                    "application_id": "application_id",
                    "tenant_id": "tenant_id",
                    "auth": {
                        "type": "Certificate",
                        "azure_client_key_cert": {
                            "certificate_ref": f"account.{test['id']}",
                        },
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        inherit_from_delegate_user_assigned_managed_identity = harness.platform.AzureCloudProviderConnector("inherit_from_delegate_user_assigned_managed_identity",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "InheritFromDelegate",
                "azure_inherit_from_delegate_details": {
                    "auth": {
                        "azure_msi_auth_ua": {
                            "client_id": "client_id",
                        },
                        "type": "UserAssignedManagedIdentity",
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        inherit_from_delegate_system_assigned_managed_identity = harness.platform.AzureCloudProviderConnector("inherit_from_delegate_system_assigned_managed_identity",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "InheritFromDelegate",
                "azure_inherit_from_delegate_details": {
                    "auth": {
                        "type": "SystemAssignedManagedIdentity",
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        ```

        ## Import

        Import account level azure cloud provider connector

        ```sh
        $ pulumi import harness:platform/azureCloudProviderConnector:AzureCloudProviderConnector example <connector_id>
        ```

        Import org level azure cloud provider connector

        ```sh
        $ pulumi import harness:platform/azureCloudProviderConnector:AzureCloudProviderConnector example <ord_id>/<connector_id>
        ```

        Import project level azure cloud provider connector

        ```sh
        $ pulumi import harness:platform/azureCloudProviderConnector:AzureCloudProviderConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_environment_type: Specifies the Azure Environment type, which is AZURE by default. Can either be AZURE or AZURE*US*GOVERNMENT
        :param pulumi.Input[Union['AzureCloudProviderConnectorCredentialsArgs', 'AzureCloudProviderConnectorCredentialsArgsDict']] credentials: Contains Azure connector credentials.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureCloudProviderConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an Azure Cloud Provider in Harness.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        manual_config_secret = harness.platform.AzureCloudProviderConnector("manual_config_secret",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "ManualConfig",
                "azure_manual_details": {
                    "application_id": "application_id",
                    "tenant_id": "tenant_id",
                    "auth": {
                        "type": "Secret",
                        "azure_client_secret_key": {
                            "secret_ref": f"account.{test['id']}",
                        },
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        manual_config_certificate = harness.platform.AzureCloudProviderConnector("manual_config_certificate",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "ManualConfig",
                "azure_manual_details": {
                    "application_id": "application_id",
                    "tenant_id": "tenant_id",
                    "auth": {
                        "type": "Certificate",
                        "azure_client_key_cert": {
                            "certificate_ref": f"account.{test['id']}",
                        },
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        inherit_from_delegate_user_assigned_managed_identity = harness.platform.AzureCloudProviderConnector("inherit_from_delegate_user_assigned_managed_identity",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "InheritFromDelegate",
                "azure_inherit_from_delegate_details": {
                    "auth": {
                        "azure_msi_auth_ua": {
                            "client_id": "client_id",
                        },
                        "type": "UserAssignedManagedIdentity",
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        inherit_from_delegate_system_assigned_managed_identity = harness.platform.AzureCloudProviderConnector("inherit_from_delegate_system_assigned_managed_identity",
            identifier="identifier",
            name="name",
            description="example",
            tags=["foo:bar"],
            credentials={
                "type": "InheritFromDelegate",
                "azure_inherit_from_delegate_details": {
                    "auth": {
                        "type": "SystemAssignedManagedIdentity",
                    },
                },
            },
            azure_environment_type="AZURE",
            delegate_selectors=["harness-delegate"])
        ```

        ## Import

        Import account level azure cloud provider connector

        ```sh
        $ pulumi import harness:platform/azureCloudProviderConnector:AzureCloudProviderConnector example <connector_id>
        ```

        Import org level azure cloud provider connector

        ```sh
        $ pulumi import harness:platform/azureCloudProviderConnector:AzureCloudProviderConnector example <ord_id>/<connector_id>
        ```

        Import project level azure cloud provider connector

        ```sh
        $ pulumi import harness:platform/azureCloudProviderConnector:AzureCloudProviderConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param AzureCloudProviderConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureCloudProviderConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_environment_type: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[Union['AzureCloudProviderConnectorCredentialsArgs', 'AzureCloudProviderConnectorCredentialsArgsDict']]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureCloudProviderConnectorArgs.__new__(AzureCloudProviderConnectorArgs)

            __props__.__dict__["azure_environment_type"] = azure_environment_type
            if credentials is None and not opts.urn:
                raise TypeError("Missing required property 'credentials'")
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            __props__.__dict__["execute_on_delegate"] = execute_on_delegate
            __props__.__dict__["force_delete"] = force_delete
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
        super(AzureCloudProviderConnector, __self__).__init__(
            'harness:platform/azureCloudProviderConnector:AzureCloudProviderConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_environment_type: Optional[pulumi.Input[str]] = None,
            credentials: Optional[pulumi.Input[Union['AzureCloudProviderConnectorCredentialsArgs', 'AzureCloudProviderConnectorCredentialsArgsDict']]] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            execute_on_delegate: Optional[pulumi.Input[bool]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AzureCloudProviderConnector':
        """
        Get an existing AzureCloudProviderConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azure_environment_type: Specifies the Azure Environment type, which is AZURE by default. Can either be AZURE or AZURE*US*GOVERNMENT
        :param pulumi.Input[Union['AzureCloudProviderConnectorCredentialsArgs', 'AzureCloudProviderConnectorCredentialsArgsDict']] credentials: Contains Azure connector credentials.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureCloudProviderConnectorState.__new__(_AzureCloudProviderConnectorState)

        __props__.__dict__["azure_environment_type"] = azure_environment_type
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_on_delegate"] = execute_on_delegate
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        return AzureCloudProviderConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureEnvironmentType")
    def azure_environment_type(self) -> pulumi.Output[str]:
        """
        Specifies the Azure Environment type, which is AZURE by default. Can either be AZURE or AZURE*US*GOVERNMENT
        """
        return pulumi.get(self, "azure_environment_type")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.AzureCloudProviderConnectorCredentials']:
        """
        Contains Azure connector credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> pulumi.Output[Optional[bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[bool]:
        """
        Enable this flag for force deletion of connector
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

