# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorCustomSecretManagerArgs', 'ConnectorCustomSecretManager']

@pulumi.input_type
class ConnectorCustomSecretManagerArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 template_ref: pulumi.Input[str],
                 version_label: pulumi.Input[str],
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_delegate: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_host: Optional[pulumi.Input[str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 working_directory: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConnectorCustomSecretManager resource.
        :param pulumi.Input[str] identifier: : Unique identifier of the resource.
        :param pulumi.Input[str] template_ref: : Reference to the template used for managing secrets.
        :param pulumi.Input[str] version_label: : Version identifier of the secrets management template.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: : A brief description of what the resource does or is used for.
        :param pulumi.Input[str] name: : Name of the resource.
        :param pulumi.Input[bool] on_delegate: : Specifies whether the secrets manager runs on a Harness delegate.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] ssh_secret_ref: : Reference to the Harness secret containing SSH credentials for the target host. Required if `on_delegate` is set to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: : Tags to associate with the resource.
        :param pulumi.Input[str] target_host: : Host address where secrets will be managed. Required if `on_delegate` is set to false.
        :param pulumi.Input[int] timeout: : Timeout in seconds for secrets management operations.
        :param pulumi.Input[str] type: : Type of the custom secrets manager, typically set to `CustomSecretManager`.
        :param pulumi.Input[str] working_directory: : Directory path on the target host where secrets management tasks are performed. Required if `on_delegate` is set to false.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "template_ref", template_ref)
        pulumi.set(__self__, "version_label", version_label)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_delegate is not None:
            pulumi.set(__self__, "on_delegate", on_delegate)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if ssh_secret_ref is not None:
            pulumi.set(__self__, "ssh_secret_ref", ssh_secret_ref)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_host is not None:
            pulumi.set(__self__, "target_host", target_host)
        if template_inputs is not None:
            pulumi.set(__self__, "template_inputs", template_inputs)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        : Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="templateRef")
    def template_ref(self) -> pulumi.Input[str]:
        """
        : Reference to the template used for managing secrets.
        """
        return pulumi.get(self, "template_ref")

    @template_ref.setter
    def template_ref(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_ref", value)

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> pulumi.Input[str]:
        """
        : Version identifier of the secrets management template.
        """
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "version_label", value)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        : A brief description of what the resource does or is used for.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        : Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onDelegate")
    def on_delegate(self) -> Optional[pulumi.Input[bool]]:
        """
        : Specifies whether the secrets manager runs on a Harness delegate.
        """
        return pulumi.get(self, "on_delegate")

    @on_delegate.setter
    def on_delegate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_delegate", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sshSecretRef")
    def ssh_secret_ref(self) -> Optional[pulumi.Input[str]]:
        """
        : Reference to the Harness secret containing SSH credentials for the target host. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "ssh_secret_ref")

    @ssh_secret_ref.setter
    def ssh_secret_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_secret_ref", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        : Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetHost")
    def target_host(self) -> Optional[pulumi.Input[str]]:
        """
        : Host address where secrets will be managed. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "target_host")

    @target_host.setter
    def target_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_host", value)

    @property
    @pulumi.getter(name="templateInputs")
    def template_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]:
        return pulumi.get(self, "template_inputs")

    @template_inputs.setter
    def template_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]):
        pulumi.set(self, "template_inputs", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        : Timeout in seconds for secrets management operations.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        : Type of the custom secrets manager, typically set to `CustomSecretManager`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[str]]:
        """
        : Directory path on the target host where secrets management tasks are performed. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class _ConnectorCustomSecretManagerState:
    def __init__(__self__, *,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_delegate: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_host: Optional[pulumi.Input[str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]] = None,
                 template_ref: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version_label: Optional[pulumi.Input[str]] = None,
                 working_directory: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConnectorCustomSecretManager resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: : A brief description of what the resource does or is used for.
        :param pulumi.Input[str] identifier: : Unique identifier of the resource.
        :param pulumi.Input[str] name: : Name of the resource.
        :param pulumi.Input[bool] on_delegate: : Specifies whether the secrets manager runs on a Harness delegate.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] ssh_secret_ref: : Reference to the Harness secret containing SSH credentials for the target host. Required if `on_delegate` is set to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: : Tags to associate with the resource.
        :param pulumi.Input[str] target_host: : Host address where secrets will be managed. Required if `on_delegate` is set to false.
        :param pulumi.Input[str] template_ref: : Reference to the template used for managing secrets.
        :param pulumi.Input[int] timeout: : Timeout in seconds for secrets management operations.
        :param pulumi.Input[str] type: : Type of the custom secrets manager, typically set to `CustomSecretManager`.
        :param pulumi.Input[str] version_label: : Version identifier of the secrets management template.
        :param pulumi.Input[str] working_directory: : Directory path on the target host where secrets management tasks are performed. Required if `on_delegate` is set to false.
        """
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_delegate is not None:
            pulumi.set(__self__, "on_delegate", on_delegate)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if ssh_secret_ref is not None:
            pulumi.set(__self__, "ssh_secret_ref", ssh_secret_ref)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_host is not None:
            pulumi.set(__self__, "target_host", target_host)
        if template_inputs is not None:
            pulumi.set(__self__, "template_inputs", template_inputs)
        if template_ref is not None:
            pulumi.set(__self__, "template_ref", template_ref)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version_label is not None:
            pulumi.set(__self__, "version_label", version_label)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        : A brief description of what the resource does or is used for.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        : Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        : Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onDelegate")
    def on_delegate(self) -> Optional[pulumi.Input[bool]]:
        """
        : Specifies whether the secrets manager runs on a Harness delegate.
        """
        return pulumi.get(self, "on_delegate")

    @on_delegate.setter
    def on_delegate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_delegate", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sshSecretRef")
    def ssh_secret_ref(self) -> Optional[pulumi.Input[str]]:
        """
        : Reference to the Harness secret containing SSH credentials for the target host. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "ssh_secret_ref")

    @ssh_secret_ref.setter
    def ssh_secret_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_secret_ref", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        : Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetHost")
    def target_host(self) -> Optional[pulumi.Input[str]]:
        """
        : Host address where secrets will be managed. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "target_host")

    @target_host.setter
    def target_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_host", value)

    @property
    @pulumi.getter(name="templateInputs")
    def template_inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]:
        return pulumi.get(self, "template_inputs")

    @template_inputs.setter
    def template_inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomSecretManagerTemplateInputArgs']]]]):
        pulumi.set(self, "template_inputs", value)

    @property
    @pulumi.getter(name="templateRef")
    def template_ref(self) -> Optional[pulumi.Input[str]]:
        """
        : Reference to the template used for managing secrets.
        """
        return pulumi.get(self, "template_ref")

    @template_ref.setter
    def template_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_ref", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        : Timeout in seconds for secrets management operations.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        : Type of the custom secrets manager, typically set to `CustomSecretManager`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[pulumi.Input[str]]:
        """
        : Version identifier of the secrets management template.
        """
        return pulumi.get(self, "version_label")

    @version_label.setter
    def version_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_label", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[str]]:
        """
        : Directory path on the target host where secrets management tasks are performed. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_directory", value)


class ConnectorCustomSecretManager(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_delegate: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_host: Optional[pulumi.Input[str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomSecretManagerTemplateInputArgs', 'ConnectorCustomSecretManagerTemplateInputArgsDict']]]]] = None,
                 template_ref: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version_label: Optional[pulumi.Input[str]] = None,
                 working_directory: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Import account level custom secret manager connector

        ```sh
        $ pulumi import harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager example <connector_id>
        ```

        Import org level custom secret manager connector

        ```sh
        $ pulumi import harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager example <ord_id>/<connector_id>
        ```

        Import project level custom secret manager connector

        ```sh
        $ pulumi import harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: : A brief description of what the resource does or is used for.
        :param pulumi.Input[str] identifier: : Unique identifier of the resource.
        :param pulumi.Input[str] name: : Name of the resource.
        :param pulumi.Input[bool] on_delegate: : Specifies whether the secrets manager runs on a Harness delegate.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] ssh_secret_ref: : Reference to the Harness secret containing SSH credentials for the target host. Required if `on_delegate` is set to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: : Tags to associate with the resource.
        :param pulumi.Input[str] target_host: : Host address where secrets will be managed. Required if `on_delegate` is set to false.
        :param pulumi.Input[str] template_ref: : Reference to the template used for managing secrets.
        :param pulumi.Input[int] timeout: : Timeout in seconds for secrets management operations.
        :param pulumi.Input[str] type: : Type of the custom secrets manager, typically set to `CustomSecretManager`.
        :param pulumi.Input[str] version_label: : Version identifier of the secrets management template.
        :param pulumi.Input[str] working_directory: : Directory path on the target host where secrets management tasks are performed. Required if `on_delegate` is set to false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorCustomSecretManagerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Import account level custom secret manager connector

        ```sh
        $ pulumi import harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager example <connector_id>
        ```

        Import org level custom secret manager connector

        ```sh
        $ pulumi import harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager example <ord_id>/<connector_id>
        ```

        Import project level custom secret manager connector

        ```sh
        $ pulumi import harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorCustomSecretManagerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorCustomSecretManagerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_delegate: Optional[pulumi.Input[bool]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ssh_secret_ref: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_host: Optional[pulumi.Input[str]] = None,
                 template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomSecretManagerTemplateInputArgs', 'ConnectorCustomSecretManagerTemplateInputArgsDict']]]]] = None,
                 template_ref: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version_label: Optional[pulumi.Input[str]] = None,
                 working_directory: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorCustomSecretManagerArgs.__new__(ConnectorCustomSecretManagerArgs)

            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["on_delegate"] = on_delegate
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["ssh_secret_ref"] = ssh_secret_ref
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_host"] = target_host
            __props__.__dict__["template_inputs"] = template_inputs
            if template_ref is None and not opts.urn:
                raise TypeError("Missing required property 'template_ref'")
            __props__.__dict__["template_ref"] = template_ref
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["type"] = type
            if version_label is None and not opts.urn:
                raise TypeError("Missing required property 'version_label'")
            __props__.__dict__["version_label"] = version_label
            __props__.__dict__["working_directory"] = working_directory
        super(ConnectorCustomSecretManager, __self__).__init__(
            'harness:platform/connectorCustomSecretManager:ConnectorCustomSecretManager',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            on_delegate: Optional[pulumi.Input[bool]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            ssh_secret_ref: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            target_host: Optional[pulumi.Input[str]] = None,
            template_inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomSecretManagerTemplateInputArgs', 'ConnectorCustomSecretManagerTemplateInputArgsDict']]]]] = None,
            template_ref: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            version_label: Optional[pulumi.Input[str]] = None,
            working_directory: Optional[pulumi.Input[str]] = None) -> 'ConnectorCustomSecretManager':
        """
        Get an existing ConnectorCustomSecretManager resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[str] description: : A brief description of what the resource does or is used for.
        :param pulumi.Input[str] identifier: : Unique identifier of the resource.
        :param pulumi.Input[str] name: : Name of the resource.
        :param pulumi.Input[bool] on_delegate: : Specifies whether the secrets manager runs on a Harness delegate.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] ssh_secret_ref: : Reference to the Harness secret containing SSH credentials for the target host. Required if `on_delegate` is set to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: : Tags to associate with the resource.
        :param pulumi.Input[str] target_host: : Host address where secrets will be managed. Required if `on_delegate` is set to false.
        :param pulumi.Input[str] template_ref: : Reference to the template used for managing secrets.
        :param pulumi.Input[int] timeout: : Timeout in seconds for secrets management operations.
        :param pulumi.Input[str] type: : Type of the custom secrets manager, typically set to `CustomSecretManager`.
        :param pulumi.Input[str] version_label: : Version identifier of the secrets management template.
        :param pulumi.Input[str] working_directory: : Directory path on the target host where secrets management tasks are performed. Required if `on_delegate` is set to false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorCustomSecretManagerState.__new__(_ConnectorCustomSecretManagerState)

        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["on_delegate"] = on_delegate
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["ssh_secret_ref"] = ssh_secret_ref
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_host"] = target_host
        __props__.__dict__["template_inputs"] = template_inputs
        __props__.__dict__["template_ref"] = template_ref
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        __props__.__dict__["version_label"] = version_label
        __props__.__dict__["working_directory"] = working_directory
        return ConnectorCustomSecretManager(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        : A brief description of what the resource does or is used for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        : Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        : Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onDelegate")
    def on_delegate(self) -> pulumi.Output[Optional[bool]]:
        """
        : Specifies whether the secrets manager runs on a Harness delegate.
        """
        return pulumi.get(self, "on_delegate")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="sshSecretRef")
    def ssh_secret_ref(self) -> pulumi.Output[Optional[str]]:
        """
        : Reference to the Harness secret containing SSH credentials for the target host. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "ssh_secret_ref")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        : Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetHost")
    def target_host(self) -> pulumi.Output[Optional[str]]:
        """
        : Host address where secrets will be managed. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "target_host")

    @property
    @pulumi.getter(name="templateInputs")
    def template_inputs(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectorCustomSecretManagerTemplateInput']]]:
        return pulumi.get(self, "template_inputs")

    @property
    @pulumi.getter(name="templateRef")
    def template_ref(self) -> pulumi.Output[str]:
        """
        : Reference to the template used for managing secrets.
        """
        return pulumi.get(self, "template_ref")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        : Timeout in seconds for secrets management operations.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        : Type of the custom secrets manager, typically set to `CustomSecretManager`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> pulumi.Output[str]:
        """
        : Version identifier of the secrets management template.
        """
        return pulumi.get(self, "version_label")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> pulumi.Output[Optional[str]]:
        """
        : Directory path on the target host where secrets management tasks are performed. Required if `on_delegate` is set to false.
        """
        return pulumi.get(self, "working_directory")

