# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpCloudCostConnectorArgs', 'GcpCloudCostConnector']

@pulumi.input_type
class GcpCloudCostConnectorArgs:
    def __init__(__self__, *,
                 features_enableds: pulumi.Input[Sequence[pulumi.Input[str]]],
                 gcp_project_id: pulumi.Input[str],
                 identifier: pulumi.Input[str],
                 service_account_email: pulumi.Input[str],
                 billing_export_spec: Optional[pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a GcpCloudCostConnector resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features_enableds: Indicates which features to enable among Billing, Optimization, Visibility and Governance.
        :param pulumi.Input[str] gcp_project_id: GCP Project Id.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] service_account_email: Email corresponding to the Service Account.
        :param pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs'] billing_export_spec: Returns billing details.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "features_enableds", features_enableds)
        pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "service_account_email", service_account_email)
        if billing_export_spec is not None:
            pulumi.set(__self__, "billing_export_spec", billing_export_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="featuresEnableds")
    def features_enableds(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Indicates which features to enable among Billing, Optimization, Visibility and Governance.
        """
        return pulumi.get(self, "features_enableds")

    @features_enableds.setter
    def features_enableds(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "features_enableds", value)

    @property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> pulumi.Input[str]:
        """
        GCP Project Id.
        """
        return pulumi.get(self, "gcp_project_id")

    @gcp_project_id.setter
    def gcp_project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "gcp_project_id", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Input[str]:
        """
        Email corresponding to the Service Account.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="billingExportSpec")
    def billing_export_spec(self) -> Optional[pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs']]:
        """
        Returns billing details.
        """
        return pulumi.get(self, "billing_export_spec")

    @billing_export_spec.setter
    def billing_export_spec(self, value: Optional[pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs']]):
        pulumi.set(self, "billing_export_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GcpCloudCostConnectorState:
    def __init__(__self__, *,
                 billing_export_spec: Optional[pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 features_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gcp_project_id: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering GcpCloudCostConnector resources.
        :param pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs'] billing_export_spec: Returns billing details.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features_enableds: Indicates which features to enable among Billing, Optimization, Visibility and Governance.
        :param pulumi.Input[str] gcp_project_id: GCP Project Id.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] service_account_email: Email corresponding to the Service Account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        if billing_export_spec is not None:
            pulumi.set(__self__, "billing_export_spec", billing_export_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if features_enableds is not None:
            pulumi.set(__self__, "features_enableds", features_enableds)
        if gcp_project_id is not None:
            pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="billingExportSpec")
    def billing_export_spec(self) -> Optional[pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs']]:
        """
        Returns billing details.
        """
        return pulumi.get(self, "billing_export_spec")

    @billing_export_spec.setter
    def billing_export_spec(self, value: Optional[pulumi.Input['GcpCloudCostConnectorBillingExportSpecArgs']]):
        pulumi.set(self, "billing_export_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featuresEnableds")
    def features_enableds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates which features to enable among Billing, Optimization, Visibility and Governance.
        """
        return pulumi.get(self, "features_enableds")

    @features_enableds.setter
    def features_enableds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "features_enableds", value)

    @property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        GCP Project Id.
        """
        return pulumi.get(self, "gcp_project_id")

    @gcp_project_id.setter
    def gcp_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcp_project_id", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email corresponding to the Service Account.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class GcpCloudCostConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_export_spec: Optional[pulumi.Input[Union['GcpCloudCostConnectorBillingExportSpecArgs', 'GcpCloudCostConnectorBillingExportSpecArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 features_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gcp_project_id: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for creating a GCP Cloud Cost connector in Harness.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.platform.GcpCloudCostConnector("test",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            features_enableds=[
                "BILLING",
                "VISIBILITY",
                "OPTIMIZATION",
            ],
            gcp_project_id="gcp_project_id",
            service_account_email="service_account_email",
            billing_export_spec={
                "data_set_id": "data_set_id",
                "table_id": "table_id",
            })
        ```

        ## Import

        Import account level gcp cloud cost connector

        ```sh
        $ pulumi import harness:platform/gcpCloudCostConnector:GcpCloudCostConnector example <connector_id>
        ```

        Import org level gcp cloud cost connector

        ```sh
        $ pulumi import harness:platform/gcpCloudCostConnector:GcpCloudCostConnector example <ord_id>/<connector_id>
        ```

        Import project level gcp cloud cost connector

        ```sh
        $ pulumi import harness:platform/gcpCloudCostConnector:GcpCloudCostConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GcpCloudCostConnectorBillingExportSpecArgs', 'GcpCloudCostConnectorBillingExportSpecArgsDict']] billing_export_spec: Returns billing details.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features_enableds: Indicates which features to enable among Billing, Optimization, Visibility and Governance.
        :param pulumi.Input[str] gcp_project_id: GCP Project Id.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] service_account_email: Email corresponding to the Service Account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpCloudCostConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a GCP Cloud Cost connector in Harness.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.platform.GcpCloudCostConnector("test",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            features_enableds=[
                "BILLING",
                "VISIBILITY",
                "OPTIMIZATION",
            ],
            gcp_project_id="gcp_project_id",
            service_account_email="service_account_email",
            billing_export_spec={
                "data_set_id": "data_set_id",
                "table_id": "table_id",
            })
        ```

        ## Import

        Import account level gcp cloud cost connector

        ```sh
        $ pulumi import harness:platform/gcpCloudCostConnector:GcpCloudCostConnector example <connector_id>
        ```

        Import org level gcp cloud cost connector

        ```sh
        $ pulumi import harness:platform/gcpCloudCostConnector:GcpCloudCostConnector example <ord_id>/<connector_id>
        ```

        Import project level gcp cloud cost connector

        ```sh
        $ pulumi import harness:platform/gcpCloudCostConnector:GcpCloudCostConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param GcpCloudCostConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpCloudCostConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_export_spec: Optional[pulumi.Input[Union['GcpCloudCostConnectorBillingExportSpecArgs', 'GcpCloudCostConnectorBillingExportSpecArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 features_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gcp_project_id: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpCloudCostConnectorArgs.__new__(GcpCloudCostConnectorArgs)

            __props__.__dict__["billing_export_spec"] = billing_export_spec
            __props__.__dict__["description"] = description
            if features_enableds is None and not opts.urn:
                raise TypeError("Missing required property 'features_enableds'")
            __props__.__dict__["features_enableds"] = features_enableds
            if gcp_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_project_id'")
            __props__.__dict__["gcp_project_id"] = gcp_project_id
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            if service_account_email is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_email'")
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["tags"] = tags
        super(GcpCloudCostConnector, __self__).__init__(
            'harness:platform/gcpCloudCostConnector:GcpCloudCostConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            billing_export_spec: Optional[pulumi.Input[Union['GcpCloudCostConnectorBillingExportSpecArgs', 'GcpCloudCostConnectorBillingExportSpecArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            features_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            gcp_project_id: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            service_account_email: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'GcpCloudCostConnector':
        """
        Get an existing GcpCloudCostConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GcpCloudCostConnectorBillingExportSpecArgs', 'GcpCloudCostConnectorBillingExportSpecArgsDict']] billing_export_spec: Returns billing details.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features_enableds: Indicates which features to enable among Billing, Optimization, Visibility and Governance.
        :param pulumi.Input[str] gcp_project_id: GCP Project Id.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] service_account_email: Email corresponding to the Service Account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpCloudCostConnectorState.__new__(_GcpCloudCostConnectorState)

        __props__.__dict__["billing_export_spec"] = billing_export_spec
        __props__.__dict__["description"] = description
        __props__.__dict__["features_enableds"] = features_enableds
        __props__.__dict__["gcp_project_id"] = gcp_project_id
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["tags"] = tags
        return GcpCloudCostConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="billingExportSpec")
    def billing_export_spec(self) -> pulumi.Output[Optional['outputs.GcpCloudCostConnectorBillingExportSpec']]:
        """
        Returns billing details.
        """
        return pulumi.get(self, "billing_export_spec")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featuresEnableds")
    def features_enableds(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates which features to enable among Billing, Optimization, Visibility and Governance.
        """
        return pulumi.get(self, "features_enableds")

    @property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> pulumi.Output[str]:
        """
        GCP Project Id.
        """
        return pulumi.get(self, "gcp_project_id")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[str]:
        """
        Email corresponding to the Service Account.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

