# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetApiKeyResult',
    'AwaitableGetApiKeyResult',
    'get_api_key',
    'get_api_key_output',
]

@pulumi.output_type
class GetApiKeyResult:
    """
    A collection of values returned by getApiKey.
    """
    def __init__(__self__, account_id=None, apikey_type=None, default_time_to_expire_token=None, description=None, id=None, identifier=None, name=None, org_id=None, parent_id=None, project_id=None, tags=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if apikey_type and not isinstance(apikey_type, str):
            raise TypeError("Expected argument 'apikey_type' to be a str")
        pulumi.set(__self__, "apikey_type", apikey_type)
        if default_time_to_expire_token and not isinstance(default_time_to_expire_token, int):
            raise TypeError("Expected argument 'default_time_to_expire_token' to be a int")
        pulumi.set(__self__, "default_time_to_expire_token", default_time_to_expire_token)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Account Identifier for the Entity
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="apikeyType")
    def apikey_type(self) -> str:
        """
        Type of the API Key
        """
        return pulumi.get(self, "apikey_type")

    @property
    @pulumi.getter(name="defaultTimeToExpireToken")
    def default_time_to_expire_token(self) -> Optional[int]:
        """
        Default expiration time of the Token within API Key
        """
        return pulumi.get(self, "default_time_to_expire_token")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> str:
        """
        Parent Entity Identifier of the API Key
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetApiKeyResult(GetApiKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeyResult(
            account_id=self.account_id,
            apikey_type=self.apikey_type,
            default_time_to_expire_token=self.default_time_to_expire_token,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            name=self.name,
            org_id=self.org_id,
            parent_id=self.parent_id,
            project_id=self.project_id,
            tags=self.tags)


def get_api_key(account_id: Optional[str] = None,
                apikey_type: Optional[str] = None,
                default_time_to_expire_token: Optional[int] = None,
                identifier: Optional[str] = None,
                name: Optional[str] = None,
                org_id: Optional[str] = None,
                parent_id: Optional[str] = None,
                project_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeyResult:
    """
    Data source for retrieving a Harness ApiKey.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_api_key(identifier="test_apikey",
        name="test_apikey",
        parent_id="parent_id",
        apikey_type="USER",
        account_id="account_id",
        org_id="org_id",
        project_id="project_id")
    ```


    :param str account_id: Account Identifier for the Entity
    :param str apikey_type: Type of the API Key
    :param int default_time_to_expire_token: Default expiration time of the Token within API Key
    :param str identifier: Unique identifier of the resource.
    :param str name: Name of the resource.
    :param str org_id: Unique identifier of the organization.
    :param str parent_id: Parent Entity Identifier of the API Key
    :param str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['apikeyType'] = apikey_type
    __args__['defaultTimeToExpireToken'] = default_time_to_expire_token
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['parentId'] = parent_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getApiKey:getApiKey', __args__, opts=opts, typ=GetApiKeyResult).value

    return AwaitableGetApiKeyResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        apikey_type=pulumi.get(__ret__, 'apikey_type'),
        default_time_to_expire_token=pulumi.get(__ret__, 'default_time_to_expire_token'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_api_key)
def get_api_key_output(account_id: Optional[pulumi.Input[str]] = None,
                       apikey_type: Optional[pulumi.Input[str]] = None,
                       default_time_to_expire_token: Optional[pulumi.Input[Optional[int]]] = None,
                       identifier: Optional[pulumi.Input[str]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       org_id: Optional[pulumi.Input[Optional[str]]] = None,
                       parent_id: Optional[pulumi.Input[str]] = None,
                       project_id: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApiKeyResult]:
    """
    Data source for retrieving a Harness ApiKey.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_api_key(identifier="test_apikey",
        name="test_apikey",
        parent_id="parent_id",
        apikey_type="USER",
        account_id="account_id",
        org_id="org_id",
        project_id="project_id")
    ```


    :param str account_id: Account Identifier for the Entity
    :param str apikey_type: Type of the API Key
    :param int default_time_to_expire_token: Default expiration time of the Token within API Key
    :param str identifier: Unique identifier of the resource.
    :param str name: Name of the resource.
    :param str org_id: Unique identifier of the organization.
    :param str parent_id: Parent Entity Identifier of the API Key
    :param str project_id: Unique identifier of the project.
    """
    ...
