# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetEnvironmentGroupResult',
    'AwaitableGetEnvironmentGroupResult',
    'get_environment_group',
    'get_environment_group_output',
]

@pulumi.output_type
class GetEnvironmentGroupResult:
    """
    A collection of values returned by getEnvironmentGroup.
    """
    def __init__(__self__, color=None, id=None, identifier=None, org_id=None, project_id=None, yaml=None):
        if color and not isinstance(color, str):
            raise TypeError("Expected argument 'color' to be a str")
        pulumi.set(__self__, "color", color)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if yaml and not isinstance(yaml, str):
            raise TypeError("Expected argument 'yaml' to be a str")
        pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def color(self) -> str:
        """
        Color of the environment group.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        identifier of the environment group.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        org_id of the environment group.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        project_id of the environment group.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def yaml(self) -> str:
        """
        Input Set YAML
        """
        return pulumi.get(self, "yaml")


class AwaitableGetEnvironmentGroupResult(GetEnvironmentGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentGroupResult(
            color=self.color,
            id=self.id,
            identifier=self.identifier,
            org_id=self.org_id,
            project_id=self.project_id,
            yaml=self.yaml)


def get_environment_group(color: Optional[str] = None,
                          identifier: Optional[str] = None,
                          org_id: Optional[str] = None,
                          project_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentGroupResult:
    """
    Data source for retrieving a Harness environment group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_environment_group(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param str color: Color of the environment group.
    :param str identifier: identifier of the environment group.
    :param str org_id: org_id of the environment group.
    :param str project_id: project_id of the environment group.
    """
    __args__ = dict()
    __args__['color'] = color
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getEnvironmentGroup:getEnvironmentGroup', __args__, opts=opts, typ=GetEnvironmentGroupResult).value

    return AwaitableGetEnvironmentGroupResult(
        color=pulumi.get(__ret__, 'color'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        yaml=pulumi.get(__ret__, 'yaml'))


@_utilities.lift_output_func(get_environment_group)
def get_environment_group_output(color: Optional[pulumi.Input[Optional[str]]] = None,
                                 identifier: Optional[pulumi.Input[str]] = None,
                                 org_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 project_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentGroupResult]:
    """
    Data source for retrieving a Harness environment group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_environment_group(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param str color: Color of the environment group.
    :param str identifier: identifier of the environment group.
    :param str org_id: org_id of the environment group.
    :param str project_id: project_id of the environment group.
    """
    ...
