# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFileStoreFileResult',
    'AwaitableGetFileStoreFileResult',
    'get_file_store_file',
    'get_file_store_file_output',
]

@pulumi.output_type
class GetFileStoreFileResult:
    """
    A collection of values returned by getFileStoreFile.
    """
    def __init__(__self__, content=None, created_bies=None, description=None, file_content_path=None, file_usage=None, id=None, identifier=None, last_modified_at=None, last_modified_bies=None, mime_type=None, name=None, org_id=None, parent_identifier=None, path=None, project_id=None, tags=None):
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if created_bies and not isinstance(created_bies, list):
            raise TypeError("Expected argument 'created_bies' to be a list")
        pulumi.set(__self__, "created_bies", created_bies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if file_content_path and not isinstance(file_content_path, str):
            raise TypeError("Expected argument 'file_content_path' to be a str")
        pulumi.set(__self__, "file_content_path", file_content_path)
        if file_usage and not isinstance(file_usage, str):
            raise TypeError("Expected argument 'file_usage' to be a str")
        pulumi.set(__self__, "file_usage", file_usage)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if last_modified_at and not isinstance(last_modified_at, int):
            raise TypeError("Expected argument 'last_modified_at' to be a int")
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_bies and not isinstance(last_modified_bies, list):
            raise TypeError("Expected argument 'last_modified_bies' to be a list")
        pulumi.set(__self__, "last_modified_bies", last_modified_bies)
        if mime_type and not isinstance(mime_type, str):
            raise TypeError("Expected argument 'mime_type' to be a str")
        pulumi.set(__self__, "mime_type", mime_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if parent_identifier and not isinstance(parent_identifier, str):
            raise TypeError("Expected argument 'parent_identifier' to be a str")
        pulumi.set(__self__, "parent_identifier", parent_identifier)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        File content stored on Harness File Store
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Sequence['outputs.GetFileStoreFileCreatedByResult']:
        """
        Created by
        """
        return pulumi.get(self, "created_bies")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileContentPath")
    def file_content_path(self) -> str:
        """
        File content path to be upladed on Harness File Store
        """
        return pulumi.get(self, "file_content_path")

    @property
    @pulumi.getter(name="fileUsage")
    def file_usage(self) -> str:
        """
        File usage. Valid options are ManifestFile, Config, Script
        """
        return pulumi.get(self, "file_usage")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> int:
        """
        Last modified at
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBies")
    def last_modified_bies(self) -> Sequence['outputs.GetFileStoreFileLastModifiedByResult']:
        """
        Last modified by
        """
        return pulumi.get(self, "last_modified_bies")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        File mime type
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="parentIdentifier")
    def parent_identifier(self) -> str:
        """
        File parent identifier on Harness File Store
        """
        return pulumi.get(self, "parent_identifier")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Harness File Store file path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetFileStoreFileResult(GetFileStoreFileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileStoreFileResult(
            content=self.content,
            created_bies=self.created_bies,
            description=self.description,
            file_content_path=self.file_content_path,
            file_usage=self.file_usage,
            id=self.id,
            identifier=self.identifier,
            last_modified_at=self.last_modified_at,
            last_modified_bies=self.last_modified_bies,
            mime_type=self.mime_type,
            name=self.name,
            org_id=self.org_id,
            parent_identifier=self.parent_identifier,
            path=self.path,
            project_id=self.project_id,
            tags=self.tags)


def get_file_store_file(identifier: Optional[str] = None,
                        name: Optional[str] = None,
                        org_id: Optional[str] = None,
                        project_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileStoreFileResult:
    """
    Data source for retrieving files.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_file_store_file(identifier="identifier")
    ```


    :param str identifier: Unique identifier of the resource.
    :param str name: Name of the resource.
    :param str org_id: Unique identifier of the organization.
    :param str project_id: Unique identifier of the project.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getFileStoreFile:getFileStoreFile', __args__, opts=opts, typ=GetFileStoreFileResult).value

    return AwaitableGetFileStoreFileResult(
        content=pulumi.get(__ret__, 'content'),
        created_bies=pulumi.get(__ret__, 'created_bies'),
        description=pulumi.get(__ret__, 'description'),
        file_content_path=pulumi.get(__ret__, 'file_content_path'),
        file_usage=pulumi.get(__ret__, 'file_usage'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        last_modified_at=pulumi.get(__ret__, 'last_modified_at'),
        last_modified_bies=pulumi.get(__ret__, 'last_modified_bies'),
        mime_type=pulumi.get(__ret__, 'mime_type'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        parent_identifier=pulumi.get(__ret__, 'parent_identifier'),
        path=pulumi.get(__ret__, 'path'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_file_store_file)
def get_file_store_file_output(identifier: Optional[pulumi.Input[str]] = None,
                               name: Optional[pulumi.Input[Optional[str]]] = None,
                               org_id: Optional[pulumi.Input[Optional[str]]] = None,
                               project_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFileStoreFileResult]:
    """
    Data source for retrieving files.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_file_store_file(identifier="identifier")
    ```


    :param str identifier: Unique identifier of the resource.
    :param str name: Name of the resource.
    :param str org_id: Unique identifier of the organization.
    :param str project_id: Unique identifier of the project.
    """
    ...
