# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGitopsAgentResult',
    'AwaitableGetGitopsAgentResult',
    'get_gitops_agent',
    'get_gitops_agent_output',
]

@pulumi.output_type
class GetGitopsAgentResult:
    """
    A collection of values returned by getGitopsAgent.
    """
    def __init__(__self__, account_id=None, agent_token=None, description=None, id=None, identifier=None, metadatas=None, name=None, operator=None, org_id=None, project_id=None, tags=None, type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if agent_token and not isinstance(agent_token, str):
            raise TypeError("Expected argument 'agent_token' to be a str")
        pulumi.set(__self__, "agent_token", agent_token)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operator and not isinstance(operator, str):
            raise TypeError("Expected argument 'operator' to be a str")
        pulumi.set(__self__, "operator", operator)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Account identifier of the GitOps agent.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="agentToken")
    def agent_token(self) -> str:
        """
        Agent token to be used for authentication of the agent with Harness.
        """
        return pulumi.get(self, "agent_token")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the GitOps agent.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        Identifier of the GitOps agent.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetGitopsAgentMetadataResult']:
        """
        Metadata of the agent.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the GitOps agent.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The Operator to use for the Harness GitOps agent. Enum: "ARGO" "FLAMINGO"
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        Organization identifier of the GitOps agent.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Project identifier of the GitOps agent.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags for the GitOps agents. These can be used to search or filter the GitOps agents.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Default: "AGENT*TYPE*UNSET"
        Enum: "AGENT*TYPE*UNSET" "CONNECTED*ARGO*PROVIDER" "MANAGED*ARGO*PROVIDER"
        """
        return pulumi.get(self, "type")


class AwaitableGetGitopsAgentResult(GetGitopsAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitopsAgentResult(
            account_id=self.account_id,
            agent_token=self.agent_token,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            metadatas=self.metadatas,
            name=self.name,
            operator=self.operator,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags,
            type=self.type)


def get_gitops_agent(account_id: Optional[str] = None,
                     identifier: Optional[str] = None,
                     org_id: Optional[str] = None,
                     project_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitopsAgentResult:
    """
    Datasource for fetching a Harness GitOps Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gitops_agent(identifier="identifier",
        account_id="account_id",
        project_id="project_id",
        org_id="org_id")
    ```


    :param str account_id: Account identifier of the GitOps agent.
    :param str identifier: Identifier of the GitOps agent.
    :param str org_id: Organization identifier of the GitOps agent.
    :param str project_id: Project identifier of the GitOps agent.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getGitopsAgent:getGitopsAgent', __args__, opts=opts, typ=GetGitopsAgentResult).value

    return AwaitableGetGitopsAgentResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        agent_token=pulumi.get(__ret__, 'agent_token'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        operator=pulumi.get(__ret__, 'operator'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_gitops_agent)
def get_gitops_agent_output(account_id: Optional[pulumi.Input[str]] = None,
                            identifier: Optional[pulumi.Input[str]] = None,
                            org_id: Optional[pulumi.Input[Optional[str]]] = None,
                            project_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGitopsAgentResult]:
    """
    Datasource for fetching a Harness GitOps Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gitops_agent(identifier="identifier",
        account_id="account_id",
        project_id="project_id",
        org_id="org_id")
    ```


    :param str account_id: Account identifier of the GitOps agent.
    :param str identifier: Identifier of the GitOps agent.
    :param str org_id: Organization identifier of the GitOps agent.
    :param str project_id: Project identifier of the GitOps agent.
    """
    ...
