# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGitopsRepositoryResult',
    'AwaitableGetGitopsRepositoryResult',
    'get_gitops_repository',
    'get_gitops_repository_output',
]

@pulumi.output_type
class GetGitopsRepositoryResult:
    """
    A collection of values returned by getGitopsRepository.
    """
    def __init__(__self__, account_id=None, agent_id=None, enable_oci=None, id=None, identifier=None, org_id=None, project_id=None, repos=None, update_masks=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if enable_oci and not isinstance(enable_oci, bool):
            raise TypeError("Expected argument 'enable_oci' to be a bool")
        pulumi.set(__self__, "enable_oci", enable_oci)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if repos and not isinstance(repos, list):
            raise TypeError("Expected argument 'repos' to be a list")
        pulumi.set(__self__, "repos", repos)
        if update_masks and not isinstance(update_masks, list):
            raise TypeError("Expected argument 'update_masks' to be a list")
        pulumi.set(__self__, "update_masks", update_masks)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Account identifier of the GitOps repository.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        Agent identifier of the GitOps repository.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="enableOci")
    def enable_oci(self) -> bool:
        """
        Indicates if helm-oci support must be enabled for this repo.
        """
        return pulumi.get(self, "enable_oci")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        Identifier of the GitOps repository.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        Organization identifier of the GitOps repository.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Project identifier of the GitOps repository.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def repos(self) -> Sequence['outputs.GetGitopsRepositoryRepoResult']:
        """
        Repo details holding application configurations.
        """
        return pulumi.get(self, "repos")

    @property
    @pulumi.getter(name="updateMasks")
    def update_masks(self) -> Sequence['outputs.GetGitopsRepositoryUpdateMaskResult']:
        """
        Update mask of the repository.
        """
        return pulumi.get(self, "update_masks")


class AwaitableGetGitopsRepositoryResult(GetGitopsRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitopsRepositoryResult(
            account_id=self.account_id,
            agent_id=self.agent_id,
            enable_oci=self.enable_oci,
            id=self.id,
            identifier=self.identifier,
            org_id=self.org_id,
            project_id=self.project_id,
            repos=self.repos,
            update_masks=self.update_masks)


def get_gitops_repository(account_id: Optional[str] = None,
                          agent_id: Optional[str] = None,
                          enable_oci: Optional[bool] = None,
                          identifier: Optional[str] = None,
                          org_id: Optional[str] = None,
                          project_id: Optional[str] = None,
                          update_masks: Optional[Sequence[Union['GetGitopsRepositoryUpdateMaskArgs', 'GetGitopsRepositoryUpdateMaskArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitopsRepositoryResult:
    """
    Data source for fetching a Harness GitOps Repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gitops_repository(identifier="identifier",
        account_id="account_id",
        project_id="project_id",
        org_id="org_id",
        agent_id="agent_id")
    ```


    :param str account_id: Account identifier of the GitOps repository.
    :param str agent_id: Agent identifier of the GitOps repository.
    :param bool enable_oci: Indicates if helm-oci support must be enabled for this repo.
    :param str identifier: Identifier of the GitOps repository.
    :param str org_id: Organization identifier of the GitOps repository.
    :param str project_id: Project identifier of the GitOps repository.
    :param Sequence[Union['GetGitopsRepositoryUpdateMaskArgs', 'GetGitopsRepositoryUpdateMaskArgsDict']] update_masks: Update mask of the repository.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['agentId'] = agent_id
    __args__['enableOci'] = enable_oci
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    __args__['updateMasks'] = update_masks
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getGitopsRepository:getGitopsRepository', __args__, opts=opts, typ=GetGitopsRepositoryResult).value

    return AwaitableGetGitopsRepositoryResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        agent_id=pulumi.get(__ret__, 'agent_id'),
        enable_oci=pulumi.get(__ret__, 'enable_oci'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        repos=pulumi.get(__ret__, 'repos'),
        update_masks=pulumi.get(__ret__, 'update_masks'))


@_utilities.lift_output_func(get_gitops_repository)
def get_gitops_repository_output(account_id: Optional[pulumi.Input[str]] = None,
                                 agent_id: Optional[pulumi.Input[str]] = None,
                                 enable_oci: Optional[pulumi.Input[Optional[bool]]] = None,
                                 identifier: Optional[pulumi.Input[str]] = None,
                                 org_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 project_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 update_masks: Optional[pulumi.Input[Optional[Sequence[Union['GetGitopsRepositoryUpdateMaskArgs', 'GetGitopsRepositoryUpdateMaskArgsDict']]]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGitopsRepositoryResult]:
    """
    Data source for fetching a Harness GitOps Repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_gitops_repository(identifier="identifier",
        account_id="account_id",
        project_id="project_id",
        org_id="org_id",
        agent_id="agent_id")
    ```


    :param str account_id: Account identifier of the GitOps repository.
    :param str agent_id: Agent identifier of the GitOps repository.
    :param bool enable_oci: Indicates if helm-oci support must be enabled for this repo.
    :param str identifier: Identifier of the GitOps repository.
    :param str org_id: Organization identifier of the GitOps repository.
    :param str project_id: Project identifier of the GitOps repository.
    :param Sequence[Union['GetGitopsRepositoryUpdateMaskArgs', 'GetGitopsRepositoryUpdateMaskArgsDict']] update_masks: Update mask of the repository.
    """
    ...
