# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetProjectListResult',
    'AwaitableGetProjectListResult',
    'get_project_list',
    'get_project_list_output',
]

@pulumi.output_type
class GetProjectListResult:
    """
    A collection of values returned by getProjectList.
    """
    def __init__(__self__, description=None, id=None, identifier=None, limit=None, name=None, org_id=None, page=None, projects=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if projects and not isinstance(projects, list):
            raise TypeError("Expected argument 'projects' to be a list")
        pulumi.set(__self__, "projects", projects)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        """
        Optional pagination parameter indicating the maximum number of entities to retrieve per page.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> str:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def page(self) -> Optional[int]:
        """
        Optional pagination parameter indicating the page number when retrieving entities.
        """
        return pulumi.get(self, "page")

    @property
    @pulumi.getter
    def projects(self) -> Sequence['outputs.GetProjectListProjectResult']:
        """
        Containing list of all projects with details identifier and name.
        """
        return pulumi.get(self, "projects")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        return pulumi.get(self, "tags")


class AwaitableGetProjectListResult(GetProjectListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectListResult(
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            limit=self.limit,
            name=self.name,
            org_id=self.org_id,
            page=self.page,
            projects=self.projects,
            tags=self.tags)


def get_project_list(identifier: Optional[str] = None,
                     limit: Optional[int] = None,
                     name: Optional[str] = None,
                     org_id: Optional[str] = None,
                     page: Optional[int] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectListResult:
    """
    Data source for retrieving Harness project list.

    ## Example Usage

    ### Org Level Project List

    ### Without the Pagination

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_project_list(org_id="org_id")
    ```

    ### With Pagination Logic

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_project_list(org_id="org_id",
        page=1,
        limit=4)
    ```


    :param int limit: Optional pagination parameter indicating the maximum number of entities to retrieve per page.
    :param str org_id: Unique identifier of the organization.
    :param int page: Optional pagination parameter indicating the page number when retrieving entities.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['limit'] = limit
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['page'] = page
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getProjectList:getProjectList', __args__, opts=opts, typ=GetProjectListResult).value

    return AwaitableGetProjectListResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        limit=pulumi.get(__ret__, 'limit'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        page=pulumi.get(__ret__, 'page'),
        projects=pulumi.get(__ret__, 'projects'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_project_list)
def get_project_list_output(identifier: Optional[pulumi.Input[Optional[str]]] = None,
                            limit: Optional[pulumi.Input[Optional[int]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            org_id: Optional[pulumi.Input[str]] = None,
                            page: Optional[pulumi.Input[Optional[int]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectListResult]:
    """
    Data source for retrieving Harness project list.

    ## Example Usage

    ### Org Level Project List

    ### Without the Pagination

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_project_list(org_id="org_id")
    ```

    ### With Pagination Logic

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_project_list(org_id="org_id",
        page=1,
        limit=4)
    ```


    :param int limit: Optional pagination parameter indicating the maximum number of entities to retrieve per page.
    :param str org_id: Unique identifier of the organization.
    :param int page: Optional pagination parameter indicating the page number when retrieving entities.
    """
    ...
