# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRoleAssignmentsResult',
    'AwaitableGetRoleAssignmentsResult',
    'get_role_assignments',
    'get_role_assignments_output',
]

@pulumi.output_type
class GetRoleAssignmentsResult:
    """
    A collection of values returned by getRoleAssignments.
    """
    def __init__(__self__, disabled=None, id=None, identifier=None, managed=None, org_id=None, principals=None, project_id=None, resource_group_identifier=None, role_identifier=None):
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if managed and not isinstance(managed, bool):
            raise TypeError("Expected argument 'managed' to be a bool")
        pulumi.set(__self__, "managed", managed)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if principals and not isinstance(principals, list):
            raise TypeError("Expected argument 'principals' to be a list")
        pulumi.set(__self__, "principals", principals)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if resource_group_identifier and not isinstance(resource_group_identifier, str):
            raise TypeError("Expected argument 'resource_group_identifier' to be a str")
        pulumi.set(__self__, "resource_group_identifier", resource_group_identifier)
        if role_identifier and not isinstance(role_identifier, str):
            raise TypeError("Expected argument 'role_identifier' to be a str")
        pulumi.set(__self__, "role_identifier", role_identifier)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        The `disabled` attribute in the role assignment resource controls the status of the role assignment. Setting `disabled` to `false` activates the role and its permissions, enabling the assigned entity to perform allowed actions. Conversely, setting `disabled` to `true` deactivates the role, revoking the entity's permissions and action capabilities. Default value should be `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        Identifier for role assignment.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def managed(self) -> bool:
        """
        Specifies whether the role assignment is managed by Harness. Setting managed to `true` means that Harness will manage the lifecycle of the role assignment, including its creation, updates, and deletion. Conversely, setting it to `false` indicates that the role assignment is not managed by Harness, and thus Harness will not perform actions on it. Default value should be `false`.
        """
        return pulumi.get(self, "managed")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[str]:
        """
        Org identifier.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def principals(self) -> Sequence['outputs.GetRoleAssignmentsPrincipalResult']:
        """
        Principal.
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Project Identifier
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="resourceGroupIdentifier")
    def resource_group_identifier(self) -> str:
        """
        Resource group identifier.
        """
        return pulumi.get(self, "resource_group_identifier")

    @property
    @pulumi.getter(name="roleIdentifier")
    def role_identifier(self) -> str:
        """
        Role identifier.
        """
        return pulumi.get(self, "role_identifier")


class AwaitableGetRoleAssignmentsResult(GetRoleAssignmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleAssignmentsResult(
            disabled=self.disabled,
            id=self.id,
            identifier=self.identifier,
            managed=self.managed,
            org_id=self.org_id,
            principals=self.principals,
            project_id=self.project_id,
            resource_group_identifier=self.resource_group_identifier,
            role_identifier=self.role_identifier)


def get_role_assignments(identifier: Optional[str] = None,
                         org_id: Optional[str] = None,
                         project_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleAssignmentsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_role_assignments(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param str identifier: Identifier for role assignment.
    :param str org_id: Org identifier.
    :param str project_id: Project Identifier
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getRoleAssignments:getRoleAssignments', __args__, opts=opts, typ=GetRoleAssignmentsResult).value

    return AwaitableGetRoleAssignmentsResult(
        disabled=pulumi.get(__ret__, 'disabled'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        managed=pulumi.get(__ret__, 'managed'),
        org_id=pulumi.get(__ret__, 'org_id'),
        principals=pulumi.get(__ret__, 'principals'),
        project_id=pulumi.get(__ret__, 'project_id'),
        resource_group_identifier=pulumi.get(__ret__, 'resource_group_identifier'),
        role_identifier=pulumi.get(__ret__, 'role_identifier'))


@_utilities.lift_output_func(get_role_assignments)
def get_role_assignments_output(identifier: Optional[pulumi.Input[str]] = None,
                                org_id: Optional[pulumi.Input[Optional[str]]] = None,
                                project_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRoleAssignmentsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.platform.get_role_assignments(identifier="identifier",
        org_id="org_id",
        project_id="project_id")
    ```


    :param str identifier: Identifier for role assignment.
    :param str org_id: Org identifier.
    :param str project_id: Project Identifier
    """
    ...
