# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IacmDefaultPipelineArgs', 'IacmDefaultPipeline']

@pulumi.input_type
class IacmDefaultPipelineArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[str],
                 org_id: pulumi.Input[str],
                 pipeline: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 provisioner_type: pulumi.Input[str]):
        """
        The set of arguments for constructing a IacmDefaultPipeline resource.
        :param pulumi.Input[str] operation: The operation associated with this default.
        :param pulumi.Input[str] org_id: Organization identifier of the organization the default pipelines resides in.
        :param pulumi.Input[str] pipeline: The pipeline associated with this default.
        :param pulumi.Input[str] project_id: Project identifier of the project the default pipelines resides in.
        :param pulumi.Input[str] provisioner_type: The provisioner associated with this default.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "pipeline", pipeline)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provisioner_type", provisioner_type)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[str]:
        """
        The operation associated with this default.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[str]:
        """
        Organization identifier of the organization the default pipelines resides in.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Input[str]:
        """
        The pipeline associated with this default.
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: pulumi.Input[str]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Project identifier of the project the default pipelines resides in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Input[str]:
        """
        The provisioner associated with this default.
        """
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provisioner_type", value)


@pulumi.input_type
class _IacmDefaultPipelineState:
    def __init__(__self__, *,
                 operation: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provisioner_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IacmDefaultPipeline resources.
        :param pulumi.Input[str] operation: The operation associated with this default.
        :param pulumi.Input[str] org_id: Organization identifier of the organization the default pipelines resides in.
        :param pulumi.Input[str] pipeline: The pipeline associated with this default.
        :param pulumi.Input[str] project_id: Project identifier of the project the default pipelines resides in.
        :param pulumi.Input[str] provisioner_type: The provisioner associated with this default.
        """
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provisioner_type is not None:
            pulumi.set(__self__, "provisioner_type", provisioner_type)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        The operation associated with this default.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Organization identifier of the organization the default pipelines resides in.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[pulumi.Input[str]]:
        """
        The pipeline associated with this default.
        """
        return pulumi.get(self, "pipeline")

    @pipeline.setter
    def pipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Project identifier of the project the default pipelines resides in.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> Optional[pulumi.Input[str]]:
        """
        The provisioner associated with this default.
        """
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioner_type", value)


class IacmDefaultPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provisioner_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing IAC default pipelines

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] operation: The operation associated with this default.
        :param pulumi.Input[str] org_id: Organization identifier of the organization the default pipelines resides in.
        :param pulumi.Input[str] pipeline: The pipeline associated with this default.
        :param pulumi.Input[str] project_id: Project identifier of the project the default pipelines resides in.
        :param pulumi.Input[str] provisioner_type: The provisioner associated with this default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IacmDefaultPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing IAC default pipelines

        :param str resource_name: The name of the resource.
        :param IacmDefaultPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IacmDefaultPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 pipeline: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provisioner_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IacmDefaultPipelineArgs.__new__(IacmDefaultPipelineArgs)

            if operation is None and not opts.urn:
                raise TypeError("Missing required property 'operation'")
            __props__.__dict__["operation"] = operation
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if pipeline is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline'")
            __props__.__dict__["pipeline"] = pipeline
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if provisioner_type is None and not opts.urn:
                raise TypeError("Missing required property 'provisioner_type'")
            __props__.__dict__["provisioner_type"] = provisioner_type
        super(IacmDefaultPipeline, __self__).__init__(
            'harness:platform/iacmDefaultPipeline:IacmDefaultPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            operation: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            pipeline: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            provisioner_type: Optional[pulumi.Input[str]] = None) -> 'IacmDefaultPipeline':
        """
        Get an existing IacmDefaultPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] operation: The operation associated with this default.
        :param pulumi.Input[str] org_id: Organization identifier of the organization the default pipelines resides in.
        :param pulumi.Input[str] pipeline: The pipeline associated with this default.
        :param pulumi.Input[str] project_id: Project identifier of the project the default pipelines resides in.
        :param pulumi.Input[str] provisioner_type: The provisioner associated with this default.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IacmDefaultPipelineState.__new__(_IacmDefaultPipelineState)

        __props__.__dict__["operation"] = operation
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["pipeline"] = pipeline
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provisioner_type"] = provisioner_type
        return IacmDefaultPipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[str]:
        """
        The operation associated with this default.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[str]:
        """
        Organization identifier of the organization the default pipelines resides in.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter
    def pipeline(self) -> pulumi.Output[str]:
        """
        The pipeline associated with this default.
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Project identifier of the project the default pipelines resides in.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Output[str]:
        """
        The provisioner associated with this default.
        """
        return pulumi.get(self, "provisioner_type")

