# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredServiceArgs', 'MonitoredService']

@pulumi.input_type
class MonitoredServiceArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 org_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 request: Optional[pulumi.Input['MonitoredServiceRequestArgs']] = None):
        """
        The set of arguments for constructing a MonitoredService resource.
        :param pulumi.Input[str] identifier: Identifier of the monitored service.
        :param pulumi.Input[str] org_id: Identifier of the organization in which the monitored service is configured.
        :param pulumi.Input[str] project_id: Identifier of the project in which the monitored service is configured.
        :param pulumi.Input['MonitoredServiceRequestArgs'] request: Request for creating or updating a monitored service.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if request is not None:
            pulumi.set(__self__, "request", request)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        Identifier of the monitored service.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[str]:
        """
        Identifier of the organization in which the monitored service is configured.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Identifier of the project in which the monitored service is configured.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['MonitoredServiceRequestArgs']]:
        """
        Request for creating or updating a monitored service.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['MonitoredServiceRequestArgs']]):
        pulumi.set(self, "request", value)


@pulumi.input_type
class _MonitoredServiceState:
    def __init__(__self__, *,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 request: Optional[pulumi.Input['MonitoredServiceRequestArgs']] = None):
        """
        Input properties used for looking up and filtering MonitoredService resources.
        :param pulumi.Input[str] identifier: Identifier of the monitored service.
        :param pulumi.Input[str] org_id: Identifier of the organization in which the monitored service is configured.
        :param pulumi.Input[str] project_id: Identifier of the project in which the monitored service is configured.
        :param pulumi.Input['MonitoredServiceRequestArgs'] request: Request for creating or updating a monitored service.
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if request is not None:
            pulumi.set(__self__, "request", request)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the monitored service.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the organization in which the monitored service is configured.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the project in which the monitored service is configured.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['MonitoredServiceRequestArgs']]:
        """
        Request for creating or updating a monitored service.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['MonitoredServiceRequestArgs']]):
        pulumi.set(self, "request", value)


class MonitoredService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 request: Optional[pulumi.Input[Union['MonitoredServiceRequestArgs', 'MonitoredServiceRequestArgsDict']]] = None,
                 __props__=None):
        """
        Resource for creating a monitored service.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_harness as harness

        #Sample template for Elastic Search Log Health Source
        example = harness.platform.MonitoredService("example",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "name",
                    "identifier": "identifier",
                    "type": "ElasticSearch",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "error_4xx",
                                "identifier": "error_4xx_id",
                                "query": "Bad Request",
                                "index": "index",
                                "group_name": "Logs_Group",
                                "query_params": {
                                    "index": "index",
                                    "service_instance_field": "serviceInstanceIdentifier",
                                    "time_stamp_identifier": "timeStampIdentifier",
                                    "time_stamp_format": "timeStampFormat",
                                    "message_identifier": "messageIdentifier",
                                },
                            },
                            {
                                "name": "error_5xx",
                                "identifier": "error_5xx_id",
                                "query": "Internal Server Error",
                                "index": "index2",
                                "groupName": "Logs_Group",
                                "queryParams": {
                                    "index": "index",
                                    "serviceInstanceField": "serviceInstanceIdentifier",
                                    "timeStampIdentifier": "timeStampIdentifier",
                                    "timeStampFormat": "timeStampFormat",
                                    "messageIdentifier": "messageIdentifier",
                                },
                            },
                        ],
                    }),
                }],
                "change_sources": [
                    {
                        "name": "BAC",
                        "identifier": "BAC",
                        "type": "PagerDuty",
                        "enabled": True,
                        "spec": json.dumps({
                            "connector_ref": "account.pd",
                            "pager_duty_service_id": "P0N21OB",
                        }),
                        "category": "Alert",
                    },
                    {
                        "name": "FH",
                        "identifier": "FH",
                        "type": "CustomIncident",
                        "enabled": True,
                        "spec": json.dumps({
                            "name": "FH",
                            "webhook_url": "https://harness.io/cv/api/account/sampleAcc/org/sampleOrg/project/sampleProj/webhook/custom-change?monitoredServiceIdentifier=checkout_prod&changeSourceIdentifier=FH",
                            "webhook_curl_command": "curl -X POST -H 'content-type: application/json' -H 'X-Api-Key: sample_api_key' --url 'https://harness.io/cv/api/account/sampleAcc/org/sampleOrg/project/sampleProj/webhook/custom-change?monitoredServiceIdentifier=checkout_prod&changeSourceIdentifier=FH' -d '{ \\"eventIdentifier\\": \\"<string>\\" (optional), \\"user\\": \\"user@harness.io\\", \\"startTime\\": timeInMs, \\"endTime\\": timeInMs, \\"eventDetail\\": { \\"description\\": \\"<String>\\", \\"changeEventDetailsLink\\": \\"urlString\\" (optional), \\"externalLinkToEntity\\": \\"urlString\\" (optional), \\"name\\": \\"changeEventName\\" } }'",
                            "type": "Alert",
                        }),
                        "category": "Alert",
                    },
                    {
                        "name": "customff",
                        "identifier": "customff",
                        "type": "CustomFF",
                        "enabled": True,
                        "category": "FeatureFlag",
                        "spec": json.dumps({
                            "type": "FeatureFlag",
                        }),
                    },
                    {
                        "name": "customdeploy",
                        "identifier": "customdeploy",
                        "type": "CustomDeploy",
                        "enabled": True,
                        "category": "Deployment",
                        "spec": json.dumps({
                            "type": "Deployment",
                        }),
                    },
                    {
                        "name": "customincident",
                        "identifier": "customincident",
                        "type": "CustomIncident",
                        "enabled": True,
                        "category": "Alert",
                        "spec": json.dumps({
                            "type": "Alert",
                            "authorization_token": "abc",
                        }),
                    },
                ],
                "notification_rule_refs": [
                    {
                        "notification_rule_ref": "notification_rule_ref",
                        "enabled": True,
                    },
                    {
                        "notification_rule_ref": "notification_rule_ref1",
                        "enabled": False,
                    },
                ],
            })
        #Sample template for Sumologic Metrics Health Source
        example1 = harness.platform.MonitoredService("example1",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "sumologicmetrics",
                    "identifier": "sumo_metric_identifier",
                    "type": "SumologicMetrics",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "metric_cpu",
                                "identifier": "metric_cpu",
                                "query": "metric=cpu",
                                "group_name": "g1",
                                "query_params": {
                                    "service_instance_field": "_sourcehost",
                                },
                                "risk_profile": {
                                    "risk_category": "Performance_Other",
                                    "threshold_types": ["ACT_WHEN_HIGHER"],
                                },
                                "live_monitoring_enabled": "true",
                                "continuous_verification_enabled": "true",
                                "sli_enabled": "false",
                                "metric_thresholds": [
                                    {
                                        "type": "IgnoreThreshold",
                                        "spec": {
                                            "action": "Ignore",
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greater_than": 100,
                                            },
                                        },
                                        "metric_type": "Custom",
                                        "metric_name": "metric_cpu",
                                    },
                                    {
                                        "type": "FailImmediately",
                                        "spec": {
                                            "action": "FailAfterOccurrence",
                                            "spec": {
                                                "count": 2,
                                            },
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metricType": "Custom",
                                        "metricName": "metric_cpu",
                                    },
                                ],
                            },
                            {
                                "name": "name2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "metric=memory",
                                "queryParams": {
                                    "serviceInstanceField": "_sourcehost",
                                },
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "liveMonitoringEnabled": "false",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Sumologic Log Health Source
        example2 = harness.platform.MonitoredService("example2",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "sumologic",
                    "identifier": "sumo_metric_identifier",
                    "type": "SumologicLogs",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "log1",
                                "identifier": "log1",
                                "query": "*",
                                "group_name": "Logs Group",
                                "query_params": {
                                    "service_instance_field": "_sourcehost",
                                },
                            },
                            {
                                "name": "log2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "error",
                                "queryParams": {
                                    "serviceInstanceField": "_sourcehost",
                                },
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Splunk Signal FX Health Source
        example3 = harness.platform.MonitoredService("example3",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "signalfxmetrics",
                    "identifier": "signalfxmetrics",
                    "type": "SplunkSignalFXMetrics",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "metric_infra_cpu",
                                "identifier": "metric_infra_cpu",
                                "query": "***",
                                "group_name": "g",
                                "risk_profile": {
                                    "risk_category": "Errors",
                                    "threshold_types": [
                                        "ACT_WHEN_HIGHER",
                                        "ACT_WHEN_LOWER",
                                    ],
                                },
                                "live_monitoring_enabled": "true",
                                "continuous_verification_enabled": "true",
                                "sli_enabled": "false",
                            },
                            {
                                "name": "name2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "*",
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "liveMonitoringEnabled": "true",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                                "metricThresholds": [
                                    {
                                        "type": "IgnoreThreshold",
                                        "spec": {
                                            "action": "Ignore",
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metrictype": "Custom",
                                        "metricName": "identifier2",
                                    },
                                    {
                                        "type": "FailImmediately",
                                        "spec": {
                                            "action": "FailAfterOccurrence",
                                            "spec": {
                                                "count": 2,
                                            },
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metricType": "Custom",
                                        "metricName": "identifier2",
                                    },
                                ],
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Grafana Loki Log Health Source
        example4 = harness.platform.MonitoredService("example4",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "Test",
                    "identifier": "Test",
                    "type": "GrafanaLokiLogs",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "Demo",
                                "identifier": "Demo",
                                "query": "{job=~\\".+\\"}",
                                "group_name": "Log_Group",
                                "query_params": {
                                    "service_instance_field": "job",
                                },
                            },
                            {
                                "name": "log2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "error",
                                "queryParams": {
                                    "serviceInstanceField": "_sourcehost",
                                },
                                "liveMonitoringEnabled": "false",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Azure Metrics Health Source
        example5 = harness.platform.MonitoredService("example5",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "azure metrics verify step",
                    "identifier": "azure_metrics_verify_step",
                    "type": "AzureMetrics",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "metric",
                                "identifier": "metric",
                                "query": "default",
                                "group_name": "g1",
                                "query_params": {
                                    "service_instance_field": "host",
                                    "index": "/subscriptions/12d2db62-5aa9-471d-84bb-faa489b3e319/resourceGroups/srm-test/providers/Microsoft.ContainerService/managedClusters/srm-test",
                                    "health_source_metric_name": "cpuUsagePercentage",
                                    "health_source_metric_namespace": "insights.container/nodes",
                                    "aggregation_type": "average",
                                },
                                "risk_profile": {
                                    "risk_category": "Performance_Other",
                                    "threshold_types": ["ACT_WHEN_HIGHER"],
                                },
                                "live_monitoring_enabled": "true",
                                "continuous_verification_enabled": "true",
                                "sli_enabled": "false",
                                "metric_thresholds": [
                                    {
                                        "type": "IgnoreThreshold",
                                        "spec": {
                                            "action": "Ignore",
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greater_than": 100,
                                            },
                                        },
                                        "metrictype": "Custom",
                                        "metric_name": "metric",
                                    },
                                    {
                                        "type": "FailImmediately",
                                        "spec": {
                                            "action": "FailAfterOccurrence",
                                            "spec": {
                                                "count": 2,
                                            },
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metricType": "Custom",
                                        "metricName": "metric",
                                    },
                                ],
                            },
                            {
                                "name": "name2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "queryParams": {
                                    "serviceInstanceField": "host",
                                    "index": "/subscriptions/12d2db62-5aa9-471d-84bb-faa489b3e319/resourceGroups/srm-test/providers/Microsoft.ContainerService/managedClusters/srm-test",
                                    "healthSourceMetricName": "cpuUsagePercentage",
                                    "healthSourceMetricNamespace": "insights.container/nodes",
                                    "aggregationType": "average",
                                },
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "liveMonitoringEnabled": "false",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Azure Log Health Source
        example6 = harness.platform.MonitoredService("example6",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "Demo azure",
                    "identifier": "Demo_azure",
                    "type": "AzureLogs",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [{
                            "name": "name2",
                            "identifier": "identifier2",
                            "group_name": "g2",
                            "query": "*",
                            "query_params": {
                                "service_instance_field": "Name",
                                "time_stamp_identifier": "StartedTime",
                                "message_identifier": "Image",
                                "index": "/subscriptions/12d2db62-5aa9-471d-84bb-faa489b3e319/resourceGroups/srm-test/providers/Microsoft.ContainerService/managedClusters/srm-test",
                            },
                            "live_monitoring_enabled": "false",
                            "continuous_verification_enabled": "false",
                        }],
                    }),
                }],
            })
        #Sample template for Prometheus Metrics Health Source
        example7 = harness.platform.MonitoredService("example7",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "prometheus metrics verify step",
                    "identifier": "prometheus_metrics",
                    "type": "Prometheus",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "metric_definitions": [{
                            "identifier": "Prometheus_Metric",
                            "metric_name": "Prometheus Metric",
                            "risk_profile": {
                                "risk_category": "Performance_Other",
                                "threshold_types": ["ACT_WHEN_HIGHER"],
                            },
                            "analysis": {
                                "live_monitoring": {
                                    "enabled": True,
                                },
                                "deployment_verification": {
                                    "enabled": True,
                                    "service_instance_field_name": "pod_name",
                                },
                            },
                            "query": "count(up{group=\\"cv\\",group=\\"cv\\"})",
                            "group_name": "met",
                            "is_manual_query": True,
                        }],
                        "metric_packs": [{
                            "identifier": "Custom",
                            "metric_thresholds": [
                                {
                                    "type": "IgnoreThreshold",
                                    "spec": {
                                        "action": "Ignore",
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greater_than": 100,
                                        },
                                    },
                                    "metrictype": "Custom",
                                    "metric_name": "Prometheus Metric",
                                },
                                {
                                    "type": "FailImmediately",
                                    "spec": {
                                        "action": "FailAfterOccurrence",
                                        "spec": {
                                            "count": 2,
                                        },
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greaterThan": 100,
                                        },
                                    },
                                    "metricType": "Custom",
                                    "metricName": "Prometheus Metric",
                                },
                            ],
                        }],
                    }),
                }],
            })
        #Sample template for Datadog Metrics Health Source
        example8 = harness.platform.MonitoredService("example8",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "ddm",
                    "identifier": "ddm",
                    "type": "DatadogMetrics",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "feature": "Datadog Cloud Metrics",
                        "metric_definitions": [
                            {
                                "metric_name": "metric",
                                "metric_path": "M1",
                                "identifier": "metric",
                                "query": \"\"\"avg:kubernetes.cpu.limits{*}.rollup(avg, 60);
        avg:kubernetes.cpu.limits{*}.rollup(avg, 30);
        (a+b)/10\"\"\",
                                "is_manual_query": True,
                                "is_custom_created_metric": True,
                                "risk_profile": {
                                    "risk_category": "Performance_Other",
                                    "threshold_types": ["ACT_WHEN_HIGHER"],
                                },
                                "analysis": {
                                    "live_monitoring": {
                                        "enabled": True,
                                    },
                                    "deployment_verification": {
                                        "enabled": True,
                                        "service_instance_field_name": "pod",
                                    },
                                },
                            },
                            {
                                "metricName": "dashboard_metric_cpu",
                                "identifier": "metric_cpu",
                                "query": \"\"\"avg:kubernetes.cpu.limits{*}.rollup(avg, 60);
        avg:kubernetes.cpu.limits{*}.rollup(avg, 30);
        (a+b)/10\"\"\",
                                "isManualQuery": False,
                                "dashboardName": "dashboard",
                                "metricPath": "M1",
                                "groupingQuery": "avg:kubernetes.cpu.limits{*} by {host}.rollup(avg, 60)",
                                "metric": "kubernetes.cpu.limits",
                                "aggregation": "avg",
                                "isCustomCreatedMetric": True,
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "analysis": {
                                    "liveMonitoring": {
                                        "enabled": True,
                                    },
                                    "deploymentVerification": {
                                        "enabled": True,
                                        "serviceInstanceFieldName": "pod",
                                    },
                                },
                            },
                        ],
                        "metric_packs": [{
                            "identifier": "Custom",
                            "metric_thresholds": [
                                {
                                    "type": "IgnoreThreshold",
                                    "spec": {
                                        "action": "Ignore",
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greater_than": 100,
                                        },
                                    },
                                    "metrictype": "Custom",
                                    "metric_name": "metric",
                                },
                                {
                                    "type": "FailImmediately",
                                    "spec": {
                                        "action": "FailAfterOccurrence",
                                        "spec": {
                                            "count": 2,
                                        },
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greaterThan": 100,
                                        },
                                    },
                                    "metricType": "Custom",
                                    "metricName": "metric",
                                },
                            ],
                        }],
                    }),
                }],
            })
        #Sample template for New Relic Metrics Health Source
        example9 = harness.platform.MonitoredService("example9",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "name",
                    "identifier": "identifier",
                    "type": "NewRelic",
                    "spec": json.dumps({
                        "connector_ref": "account.Newrelicautomation_do_not_delete",
                        "feature": "apm",
                        "application_id": "107019083",
                        "application_name": "My Application",
                        "metric_data": {
                            "performance": True,
                        },
                        "metric_packs": [{
                            "identifier": "Performance",
                        }],
                        "new_relic_metric_definitions": [{
                            "identifier": "New_Relic_Metric",
                            "metric_name": "New Relic Metric",
                            "risk_profile": {
                                "risk_category": "Performance_Other",
                                "threshold_types": ["ACT_WHEN_HIGHER"],
                            },
                            "analysis": {
                                "deployment_verification": {
                                    "enabled": True,
                                },
                            },
                            "group_name": "group1",
                            "nrql": "SELECT count(apm.service.instance.count) FROM Metric WHERE appName LIKE 'My Application' TIMESERIES",
                            "response_mapping": {
                                "metric_value_json_path": "$.['timeSeries'].[*].['results'].[*].['count']",
                                "timestamp_json_path": "$.['timeSeries'].[*].['beginTimeSeconds']",
                            },
                        }],
                        "metric_packs": [{
                            "identifier": "Custom",
                            "metric_thresholds": [
                                {
                                    "type": "IgnoreThreshold",
                                    "spec": {
                                        "action": "Ignore",
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greater_than": 100,
                                        },
                                    },
                                    "metric_type": "Custom",
                                    "metric_name": "New Relic Metric",
                                },
                                {
                                    "type": "FailImmediately",
                                    "spec": {
                                        "action": "FailAfterOccurrence",
                                        "spec": {
                                            "count": 2,
                                        },
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greaterThan": 100,
                                        },
                                    },
                                    "metricType": "Custom",
                                    "metricName": "New Relic Metric",
                                },
                            ],
                        }],
                    }),
                }],
            })
        ```

        ## Import

        Import account level monitored_service

        ```sh
        $ pulumi import harness:platform/monitoredService:MonitoredService example <monitored_service_id>
        ```

        Import organization level monitored_service

        ```sh
        $ pulumi import harness:platform/monitoredService:MonitoredService example <org_id>/<monitored_service_id>
        ```

        Import project level monitored_service

        ```sh
        $ pulumi import harness:platform/monitoredService:MonitoredService example <org_id>/<project_id>/<monitored_service_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] identifier: Identifier of the monitored service.
        :param pulumi.Input[str] org_id: Identifier of the organization in which the monitored service is configured.
        :param pulumi.Input[str] project_id: Identifier of the project in which the monitored service is configured.
        :param pulumi.Input[Union['MonitoredServiceRequestArgs', 'MonitoredServiceRequestArgsDict']] request: Request for creating or updating a monitored service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a monitored service.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_harness as harness

        #Sample template for Elastic Search Log Health Source
        example = harness.platform.MonitoredService("example",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "name",
                    "identifier": "identifier",
                    "type": "ElasticSearch",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "error_4xx",
                                "identifier": "error_4xx_id",
                                "query": "Bad Request",
                                "index": "index",
                                "group_name": "Logs_Group",
                                "query_params": {
                                    "index": "index",
                                    "service_instance_field": "serviceInstanceIdentifier",
                                    "time_stamp_identifier": "timeStampIdentifier",
                                    "time_stamp_format": "timeStampFormat",
                                    "message_identifier": "messageIdentifier",
                                },
                            },
                            {
                                "name": "error_5xx",
                                "identifier": "error_5xx_id",
                                "query": "Internal Server Error",
                                "index": "index2",
                                "groupName": "Logs_Group",
                                "queryParams": {
                                    "index": "index",
                                    "serviceInstanceField": "serviceInstanceIdentifier",
                                    "timeStampIdentifier": "timeStampIdentifier",
                                    "timeStampFormat": "timeStampFormat",
                                    "messageIdentifier": "messageIdentifier",
                                },
                            },
                        ],
                    }),
                }],
                "change_sources": [
                    {
                        "name": "BAC",
                        "identifier": "BAC",
                        "type": "PagerDuty",
                        "enabled": True,
                        "spec": json.dumps({
                            "connector_ref": "account.pd",
                            "pager_duty_service_id": "P0N21OB",
                        }),
                        "category": "Alert",
                    },
                    {
                        "name": "FH",
                        "identifier": "FH",
                        "type": "CustomIncident",
                        "enabled": True,
                        "spec": json.dumps({
                            "name": "FH",
                            "webhook_url": "https://harness.io/cv/api/account/sampleAcc/org/sampleOrg/project/sampleProj/webhook/custom-change?monitoredServiceIdentifier=checkout_prod&changeSourceIdentifier=FH",
                            "webhook_curl_command": "curl -X POST -H 'content-type: application/json' -H 'X-Api-Key: sample_api_key' --url 'https://harness.io/cv/api/account/sampleAcc/org/sampleOrg/project/sampleProj/webhook/custom-change?monitoredServiceIdentifier=checkout_prod&changeSourceIdentifier=FH' -d '{ \\"eventIdentifier\\": \\"<string>\\" (optional), \\"user\\": \\"user@harness.io\\", \\"startTime\\": timeInMs, \\"endTime\\": timeInMs, \\"eventDetail\\": { \\"description\\": \\"<String>\\", \\"changeEventDetailsLink\\": \\"urlString\\" (optional), \\"externalLinkToEntity\\": \\"urlString\\" (optional), \\"name\\": \\"changeEventName\\" } }'",
                            "type": "Alert",
                        }),
                        "category": "Alert",
                    },
                    {
                        "name": "customff",
                        "identifier": "customff",
                        "type": "CustomFF",
                        "enabled": True,
                        "category": "FeatureFlag",
                        "spec": json.dumps({
                            "type": "FeatureFlag",
                        }),
                    },
                    {
                        "name": "customdeploy",
                        "identifier": "customdeploy",
                        "type": "CustomDeploy",
                        "enabled": True,
                        "category": "Deployment",
                        "spec": json.dumps({
                            "type": "Deployment",
                        }),
                    },
                    {
                        "name": "customincident",
                        "identifier": "customincident",
                        "type": "CustomIncident",
                        "enabled": True,
                        "category": "Alert",
                        "spec": json.dumps({
                            "type": "Alert",
                            "authorization_token": "abc",
                        }),
                    },
                ],
                "notification_rule_refs": [
                    {
                        "notification_rule_ref": "notification_rule_ref",
                        "enabled": True,
                    },
                    {
                        "notification_rule_ref": "notification_rule_ref1",
                        "enabled": False,
                    },
                ],
            })
        #Sample template for Sumologic Metrics Health Source
        example1 = harness.platform.MonitoredService("example1",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "sumologicmetrics",
                    "identifier": "sumo_metric_identifier",
                    "type": "SumologicMetrics",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "metric_cpu",
                                "identifier": "metric_cpu",
                                "query": "metric=cpu",
                                "group_name": "g1",
                                "query_params": {
                                    "service_instance_field": "_sourcehost",
                                },
                                "risk_profile": {
                                    "risk_category": "Performance_Other",
                                    "threshold_types": ["ACT_WHEN_HIGHER"],
                                },
                                "live_monitoring_enabled": "true",
                                "continuous_verification_enabled": "true",
                                "sli_enabled": "false",
                                "metric_thresholds": [
                                    {
                                        "type": "IgnoreThreshold",
                                        "spec": {
                                            "action": "Ignore",
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greater_than": 100,
                                            },
                                        },
                                        "metric_type": "Custom",
                                        "metric_name": "metric_cpu",
                                    },
                                    {
                                        "type": "FailImmediately",
                                        "spec": {
                                            "action": "FailAfterOccurrence",
                                            "spec": {
                                                "count": 2,
                                            },
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metricType": "Custom",
                                        "metricName": "metric_cpu",
                                    },
                                ],
                            },
                            {
                                "name": "name2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "metric=memory",
                                "queryParams": {
                                    "serviceInstanceField": "_sourcehost",
                                },
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "liveMonitoringEnabled": "false",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Sumologic Log Health Source
        example2 = harness.platform.MonitoredService("example2",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "sumologic",
                    "identifier": "sumo_metric_identifier",
                    "type": "SumologicLogs",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "log1",
                                "identifier": "log1",
                                "query": "*",
                                "group_name": "Logs Group",
                                "query_params": {
                                    "service_instance_field": "_sourcehost",
                                },
                            },
                            {
                                "name": "log2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "error",
                                "queryParams": {
                                    "serviceInstanceField": "_sourcehost",
                                },
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Splunk Signal FX Health Source
        example3 = harness.platform.MonitoredService("example3",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "signalfxmetrics",
                    "identifier": "signalfxmetrics",
                    "type": "SplunkSignalFXMetrics",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "metric_infra_cpu",
                                "identifier": "metric_infra_cpu",
                                "query": "***",
                                "group_name": "g",
                                "risk_profile": {
                                    "risk_category": "Errors",
                                    "threshold_types": [
                                        "ACT_WHEN_HIGHER",
                                        "ACT_WHEN_LOWER",
                                    ],
                                },
                                "live_monitoring_enabled": "true",
                                "continuous_verification_enabled": "true",
                                "sli_enabled": "false",
                            },
                            {
                                "name": "name2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "*",
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "liveMonitoringEnabled": "true",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                                "metricThresholds": [
                                    {
                                        "type": "IgnoreThreshold",
                                        "spec": {
                                            "action": "Ignore",
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metrictype": "Custom",
                                        "metricName": "identifier2",
                                    },
                                    {
                                        "type": "FailImmediately",
                                        "spec": {
                                            "action": "FailAfterOccurrence",
                                            "spec": {
                                                "count": 2,
                                            },
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metricType": "Custom",
                                        "metricName": "identifier2",
                                    },
                                ],
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Grafana Loki Log Health Source
        example4 = harness.platform.MonitoredService("example4",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "Test",
                    "identifier": "Test",
                    "type": "GrafanaLokiLogs",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "Demo",
                                "identifier": "Demo",
                                "query": "{job=~\\".+\\"}",
                                "group_name": "Log_Group",
                                "query_params": {
                                    "service_instance_field": "job",
                                },
                            },
                            {
                                "name": "log2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "query": "error",
                                "queryParams": {
                                    "serviceInstanceField": "_sourcehost",
                                },
                                "liveMonitoringEnabled": "false",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Azure Metrics Health Source
        example5 = harness.platform.MonitoredService("example5",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "azure metrics verify step",
                    "identifier": "azure_metrics_verify_step",
                    "type": "AzureMetrics",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [
                            {
                                "name": "metric",
                                "identifier": "metric",
                                "query": "default",
                                "group_name": "g1",
                                "query_params": {
                                    "service_instance_field": "host",
                                    "index": "/subscriptions/12d2db62-5aa9-471d-84bb-faa489b3e319/resourceGroups/srm-test/providers/Microsoft.ContainerService/managedClusters/srm-test",
                                    "health_source_metric_name": "cpuUsagePercentage",
                                    "health_source_metric_namespace": "insights.container/nodes",
                                    "aggregation_type": "average",
                                },
                                "risk_profile": {
                                    "risk_category": "Performance_Other",
                                    "threshold_types": ["ACT_WHEN_HIGHER"],
                                },
                                "live_monitoring_enabled": "true",
                                "continuous_verification_enabled": "true",
                                "sli_enabled": "false",
                                "metric_thresholds": [
                                    {
                                        "type": "IgnoreThreshold",
                                        "spec": {
                                            "action": "Ignore",
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greater_than": 100,
                                            },
                                        },
                                        "metrictype": "Custom",
                                        "metric_name": "metric",
                                    },
                                    {
                                        "type": "FailImmediately",
                                        "spec": {
                                            "action": "FailAfterOccurrence",
                                            "spec": {
                                                "count": 2,
                                            },
                                        },
                                        "criteria": {
                                            "type": "Absolute",
                                            "spec": {
                                                "greaterThan": 100,
                                            },
                                        },
                                        "metricType": "Custom",
                                        "metricName": "metric",
                                    },
                                ],
                            },
                            {
                                "name": "name2",
                                "identifier": "identifier2",
                                "groupName": "g2",
                                "queryParams": {
                                    "serviceInstanceField": "host",
                                    "index": "/subscriptions/12d2db62-5aa9-471d-84bb-faa489b3e319/resourceGroups/srm-test/providers/Microsoft.ContainerService/managedClusters/srm-test",
                                    "healthSourceMetricName": "cpuUsagePercentage",
                                    "healthSourceMetricNamespace": "insights.container/nodes",
                                    "aggregationType": "average",
                                },
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "liveMonitoringEnabled": "false",
                                "continuousVerificationEnabled": "false",
                                "sliEnabled": "false",
                            },
                        ],
                    }),
                }],
            })
        #Sample template for Azure Log Health Source
        example6 = harness.platform.MonitoredService("example6",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "Demo azure",
                    "identifier": "Demo_azure",
                    "type": "AzureLogs",
                    "version": "v2",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "query_definitions": [{
                            "name": "name2",
                            "identifier": "identifier2",
                            "group_name": "g2",
                            "query": "*",
                            "query_params": {
                                "service_instance_field": "Name",
                                "time_stamp_identifier": "StartedTime",
                                "message_identifier": "Image",
                                "index": "/subscriptions/12d2db62-5aa9-471d-84bb-faa489b3e319/resourceGroups/srm-test/providers/Microsoft.ContainerService/managedClusters/srm-test",
                            },
                            "live_monitoring_enabled": "false",
                            "continuous_verification_enabled": "false",
                        }],
                    }),
                }],
            })
        #Sample template for Prometheus Metrics Health Source
        example7 = harness.platform.MonitoredService("example7",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "prometheus metrics verify step",
                    "identifier": "prometheus_metrics",
                    "type": "Prometheus",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "metric_definitions": [{
                            "identifier": "Prometheus_Metric",
                            "metric_name": "Prometheus Metric",
                            "risk_profile": {
                                "risk_category": "Performance_Other",
                                "threshold_types": ["ACT_WHEN_HIGHER"],
                            },
                            "analysis": {
                                "live_monitoring": {
                                    "enabled": True,
                                },
                                "deployment_verification": {
                                    "enabled": True,
                                    "service_instance_field_name": "pod_name",
                                },
                            },
                            "query": "count(up{group=\\"cv\\",group=\\"cv\\"})",
                            "group_name": "met",
                            "is_manual_query": True,
                        }],
                        "metric_packs": [{
                            "identifier": "Custom",
                            "metric_thresholds": [
                                {
                                    "type": "IgnoreThreshold",
                                    "spec": {
                                        "action": "Ignore",
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greater_than": 100,
                                        },
                                    },
                                    "metrictype": "Custom",
                                    "metric_name": "Prometheus Metric",
                                },
                                {
                                    "type": "FailImmediately",
                                    "spec": {
                                        "action": "FailAfterOccurrence",
                                        "spec": {
                                            "count": 2,
                                        },
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greaterThan": 100,
                                        },
                                    },
                                    "metricType": "Custom",
                                    "metricName": "Prometheus Metric",
                                },
                            ],
                        }],
                    }),
                }],
            })
        #Sample template for Datadog Metrics Health Source
        example8 = harness.platform.MonitoredService("example8",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "ddm",
                    "identifier": "ddm",
                    "type": "DatadogMetrics",
                    "spec": json.dumps({
                        "connector_ref": "connectorRef",
                        "feature": "Datadog Cloud Metrics",
                        "metric_definitions": [
                            {
                                "metric_name": "metric",
                                "metric_path": "M1",
                                "identifier": "metric",
                                "query": \"\"\"avg:kubernetes.cpu.limits{*}.rollup(avg, 60);
        avg:kubernetes.cpu.limits{*}.rollup(avg, 30);
        (a+b)/10\"\"\",
                                "is_manual_query": True,
                                "is_custom_created_metric": True,
                                "risk_profile": {
                                    "risk_category": "Performance_Other",
                                    "threshold_types": ["ACT_WHEN_HIGHER"],
                                },
                                "analysis": {
                                    "live_monitoring": {
                                        "enabled": True,
                                    },
                                    "deployment_verification": {
                                        "enabled": True,
                                        "service_instance_field_name": "pod",
                                    },
                                },
                            },
                            {
                                "metricName": "dashboard_metric_cpu",
                                "identifier": "metric_cpu",
                                "query": \"\"\"avg:kubernetes.cpu.limits{*}.rollup(avg, 60);
        avg:kubernetes.cpu.limits{*}.rollup(avg, 30);
        (a+b)/10\"\"\",
                                "isManualQuery": False,
                                "dashboardName": "dashboard",
                                "metricPath": "M1",
                                "groupingQuery": "avg:kubernetes.cpu.limits{*} by {host}.rollup(avg, 60)",
                                "metric": "kubernetes.cpu.limits",
                                "aggregation": "avg",
                                "isCustomCreatedMetric": True,
                                "riskProfile": {
                                    "riskCategory": "Performance_Other",
                                    "thresholdTypes": ["ACT_WHEN_HIGHER"],
                                },
                                "analysis": {
                                    "liveMonitoring": {
                                        "enabled": True,
                                    },
                                    "deploymentVerification": {
                                        "enabled": True,
                                        "serviceInstanceFieldName": "pod",
                                    },
                                },
                            },
                        ],
                        "metric_packs": [{
                            "identifier": "Custom",
                            "metric_thresholds": [
                                {
                                    "type": "IgnoreThreshold",
                                    "spec": {
                                        "action": "Ignore",
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greater_than": 100,
                                        },
                                    },
                                    "metrictype": "Custom",
                                    "metric_name": "metric",
                                },
                                {
                                    "type": "FailImmediately",
                                    "spec": {
                                        "action": "FailAfterOccurrence",
                                        "spec": {
                                            "count": 2,
                                        },
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greaterThan": 100,
                                        },
                                    },
                                    "metricType": "Custom",
                                    "metricName": "metric",
                                },
                            ],
                        }],
                    }),
                }],
            })
        #Sample template for New Relic Metrics Health Source
        example9 = harness.platform.MonitoredService("example9",
            org_id="org_id",
            project_id="project_id",
            identifier="identifier",
            request={
                "name": "name",
                "type": "Application",
                "description": "description",
                "service_ref": "service_ref",
                "environment_ref": "environment_ref",
                "tags": [
                    "foo:bar",
                    "bar:foo",
                ],
                "health_sources": [{
                    "name": "name",
                    "identifier": "identifier",
                    "type": "NewRelic",
                    "spec": json.dumps({
                        "connector_ref": "account.Newrelicautomation_do_not_delete",
                        "feature": "apm",
                        "application_id": "107019083",
                        "application_name": "My Application",
                        "metric_data": {
                            "performance": True,
                        },
                        "metric_packs": [{
                            "identifier": "Performance",
                        }],
                        "new_relic_metric_definitions": [{
                            "identifier": "New_Relic_Metric",
                            "metric_name": "New Relic Metric",
                            "risk_profile": {
                                "risk_category": "Performance_Other",
                                "threshold_types": ["ACT_WHEN_HIGHER"],
                            },
                            "analysis": {
                                "deployment_verification": {
                                    "enabled": True,
                                },
                            },
                            "group_name": "group1",
                            "nrql": "SELECT count(apm.service.instance.count) FROM Metric WHERE appName LIKE 'My Application' TIMESERIES",
                            "response_mapping": {
                                "metric_value_json_path": "$.['timeSeries'].[*].['results'].[*].['count']",
                                "timestamp_json_path": "$.['timeSeries'].[*].['beginTimeSeconds']",
                            },
                        }],
                        "metric_packs": [{
                            "identifier": "Custom",
                            "metric_thresholds": [
                                {
                                    "type": "IgnoreThreshold",
                                    "spec": {
                                        "action": "Ignore",
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greater_than": 100,
                                        },
                                    },
                                    "metric_type": "Custom",
                                    "metric_name": "New Relic Metric",
                                },
                                {
                                    "type": "FailImmediately",
                                    "spec": {
                                        "action": "FailAfterOccurrence",
                                        "spec": {
                                            "count": 2,
                                        },
                                    },
                                    "criteria": {
                                        "type": "Absolute",
                                        "spec": {
                                            "greaterThan": 100,
                                        },
                                    },
                                    "metricType": "Custom",
                                    "metricName": "New Relic Metric",
                                },
                            ],
                        }],
                    }),
                }],
            })
        ```

        ## Import

        Import account level monitored_service

        ```sh
        $ pulumi import harness:platform/monitoredService:MonitoredService example <monitored_service_id>
        ```

        Import organization level monitored_service

        ```sh
        $ pulumi import harness:platform/monitoredService:MonitoredService example <org_id>/<monitored_service_id>
        ```

        Import project level monitored_service

        ```sh
        $ pulumi import harness:platform/monitoredService:MonitoredService example <org_id>/<project_id>/<monitored_service_id>
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 request: Optional[pulumi.Input[Union['MonitoredServiceRequestArgs', 'MonitoredServiceRequestArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredServiceArgs.__new__(MonitoredServiceArgs)

            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["request"] = request
        super(MonitoredService, __self__).__init__(
            'harness:platform/monitoredService:MonitoredService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            request: Optional[pulumi.Input[Union['MonitoredServiceRequestArgs', 'MonitoredServiceRequestArgsDict']]] = None) -> 'MonitoredService':
        """
        Get an existing MonitoredService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] identifier: Identifier of the monitored service.
        :param pulumi.Input[str] org_id: Identifier of the organization in which the monitored service is configured.
        :param pulumi.Input[str] project_id: Identifier of the project in which the monitored service is configured.
        :param pulumi.Input[Union['MonitoredServiceRequestArgs', 'MonitoredServiceRequestArgsDict']] request: Request for creating or updating a monitored service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredServiceState.__new__(_MonitoredServiceState)

        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["request"] = request
        return MonitoredService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Identifier of the monitored service.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[str]:
        """
        Identifier of the organization in which the monitored service is configured.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Identifier of the project in which the monitored service is configured.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def request(self) -> pulumi.Output[Optional['outputs.MonitoredServiceRequest']]:
        """
        Request for creating or updating a monitored service.
        """
        return pulumi.get(self, "request")

