# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 fetch_resolved_yaml: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[str]] = None,
                 git_details: Optional[pulumi.Input['ServiceGitDetailsArgs']] = None,
                 import_from_git: Optional[pulumi.Input[bool]] = None,
                 is_force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yaml: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] fetch_resolved_yaml: to fetch resoled service yaml
        :param pulumi.Input[str] force_delete: Enable this flag for force deletion of service
        :param pulumi.Input['ServiceGitDetailsArgs'] git_details: Contains parameters related to Git Experience for remote entities
        :param pulumi.Input[bool] import_from_git: import service from git
        :param pulumi.Input[bool] is_force_import: force import service from remote even if same file path already exist
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[str] yaml: Service YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression:
               org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}.
               For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as
               connectorRef: org.connectorId.
        """
        pulumi.set(__self__, "identifier", identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fetch_resolved_yaml is not None:
            pulumi.set(__self__, "fetch_resolved_yaml", fetch_resolved_yaml)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if is_force_import is not None:
            pulumi.set(__self__, "is_force_import", is_force_import)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fetchResolvedYaml")
    def fetch_resolved_yaml(self) -> Optional[pulumi.Input[bool]]:
        """
        to fetch resoled service yaml
        """
        return pulumi.get(self, "fetch_resolved_yaml")

    @fetch_resolved_yaml.setter
    def fetch_resolved_yaml(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fetch_resolved_yaml", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[str]]:
        """
        Enable this flag for force deletion of service
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['ServiceGitDetailsArgs']]:
        """
        Contains parameters related to Git Experience for remote entities
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['ServiceGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[bool]]:
        """
        import service from git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_from_git", value)

    @property
    @pulumi.getter(name="isForceImport")
    def is_force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        force import service from remote even if same file path already exist
        """
        return pulumi.get(self, "is_force_import")

    @is_force_import.setter
    def is_force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_import", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[str]]:
        """
        Service YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression:
        org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}.
        For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as
        connectorRef: org.connectorId.
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "yaml", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 fetch_resolved_yaml: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[str]] = None,
                 git_details: Optional[pulumi.Input['ServiceGitDetailsArgs']] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 import_from_git: Optional[pulumi.Input[bool]] = None,
                 is_force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yaml: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] fetch_resolved_yaml: to fetch resoled service yaml
        :param pulumi.Input[str] force_delete: Enable this flag for force deletion of service
        :param pulumi.Input['ServiceGitDetailsArgs'] git_details: Contains parameters related to Git Experience for remote entities
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[bool] import_from_git: import service from git
        :param pulumi.Input[bool] is_force_import: force import service from remote even if same file path already exist
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[str] yaml: Service YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression:
               org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}.
               For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as
               connectorRef: org.connectorId.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fetch_resolved_yaml is not None:
            pulumi.set(__self__, "fetch_resolved_yaml", fetch_resolved_yaml)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if git_details is not None:
            pulumi.set(__self__, "git_details", git_details)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if import_from_git is not None:
            pulumi.set(__self__, "import_from_git", import_from_git)
        if is_force_import is not None:
            pulumi.set(__self__, "is_force_import", is_force_import)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if yaml is not None:
            pulumi.set(__self__, "yaml", yaml)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fetchResolvedYaml")
    def fetch_resolved_yaml(self) -> Optional[pulumi.Input[bool]]:
        """
        to fetch resoled service yaml
        """
        return pulumi.get(self, "fetch_resolved_yaml")

    @fetch_resolved_yaml.setter
    def fetch_resolved_yaml(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fetch_resolved_yaml", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[str]]:
        """
        Enable this flag for force deletion of service
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> Optional[pulumi.Input['ServiceGitDetailsArgs']]:
        """
        Contains parameters related to Git Experience for remote entities
        """
        return pulumi.get(self, "git_details")

    @git_details.setter
    def git_details(self, value: Optional[pulumi.Input['ServiceGitDetailsArgs']]):
        pulumi.set(self, "git_details", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> Optional[pulumi.Input[bool]]:
        """
        import service from git
        """
        return pulumi.get(self, "import_from_git")

    @import_from_git.setter
    def import_from_git(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_from_git", value)

    @property
    @pulumi.getter(name="isForceImport")
    def is_force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        force import service from remote even if same file path already exist
        """
        return pulumi.get(self, "is_force_import")

    @is_force_import.setter
    def is_force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_import", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def yaml(self) -> Optional[pulumi.Input[str]]:
        """
        Service YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression:
        org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}.
        For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as
        connectorRef: org.connectorId.
        """
        return pulumi.get(self, "yaml")

    @yaml.setter
    def yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "yaml", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fetch_resolved_yaml: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[str]] = None,
                 git_details: Optional[pulumi.Input[Union['ServiceGitDetailsArgs', 'ServiceGitDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 import_from_git: Optional[pulumi.Input[bool]] = None,
                 is_force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yaml: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for creating a Harness service.

        ## Example to create Service at different levels (Org, Project, Account)

        ### Account Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Org Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Project Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            project_id="project_id",
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Creating Remote Service
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            project_id="project_id",
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
            },
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Importing Service From Git
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            import_from_git=True,
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
            })
        ```

        ## Import

        Import account level service

        ```sh
        $ pulumi import harness:platform/service:Service example <service_id>
        ```

        Import org level service

        ```sh
        $ pulumi import harness:platform/service:Service example <org_id>/<service_id>
        ```

        Import project level service

        ```sh
        $ pulumi import harness:platform/service:Service example <org_id>/<project_id>/<service_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] fetch_resolved_yaml: to fetch resoled service yaml
        :param pulumi.Input[str] force_delete: Enable this flag for force deletion of service
        :param pulumi.Input[Union['ServiceGitDetailsArgs', 'ServiceGitDetailsArgsDict']] git_details: Contains parameters related to Git Experience for remote entities
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[bool] import_from_git: import service from git
        :param pulumi.Input[bool] is_force_import: force import service from remote even if same file path already exist
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[str] yaml: Service YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression:
               org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}.
               For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as
               connectorRef: org.connectorId.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness service.

        ## Example to create Service at different levels (Org, Project, Account)

        ### Account Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Org Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Project Level
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            project_id="project_id",
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Creating Remote Service
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            description="test",
            org_id="org_id",
            project_id="project_id",
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
            },
            yaml=\"\"\"service:
          name: name
          identifier: identifier
          serviceDefinition:
            spec:
              manifests:
                - manifest:
                    identifier: manifest1
                    type: K8sManifest
                    spec:
                      store:
                        type: Github
                        spec:
                          connectorRef: <+input>
                          gitFetchType: Branch
                          paths:
                            - files1
                          repoName: <+input>
                          branch: master
                      skipResourceVersioning: false
              configFiles:
                - configFile:
                    identifier: configFile1
                    spec:
                      store:
                        type: Harness
                        spec:
                          files:
                            - <+org.description>
              variables:
                - name: var1
                  type: String
                  value: val1
                - name: var2
                  type: String
                  value: val2
            type: Kubernetes
          gitOpsEnabled: false
        \"\"\")
        ```

        ### Importing Service From Git
        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Service("example",
            identifier="identifier",
            name="name",
            import_from_git=True,
            git_details={
                "store_type": "REMOTE",
                "connector_ref": "connector_ref",
                "repo_name": "repo_name",
                "file_path": "file_path",
                "branch": "branch",
            })
        ```

        ## Import

        Import account level service

        ```sh
        $ pulumi import harness:platform/service:Service example <service_id>
        ```

        Import org level service

        ```sh
        $ pulumi import harness:platform/service:Service example <org_id>/<service_id>
        ```

        Import project level service

        ```sh
        $ pulumi import harness:platform/service:Service example <org_id>/<project_id>/<service_id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fetch_resolved_yaml: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[str]] = None,
                 git_details: Optional[pulumi.Input[Union['ServiceGitDetailsArgs', 'ServiceGitDetailsArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 import_from_git: Optional[pulumi.Input[bool]] = None,
                 is_force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yaml: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["fetch_resolved_yaml"] = fetch_resolved_yaml
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["git_details"] = git_details
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["import_from_git"] = import_from_git
            __props__.__dict__["is_force_import"] = is_force_import
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["yaml"] = yaml
        super(Service, __self__).__init__(
            'harness:platform/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            fetch_resolved_yaml: Optional[pulumi.Input[bool]] = None,
            force_delete: Optional[pulumi.Input[str]] = None,
            git_details: Optional[pulumi.Input[Union['ServiceGitDetailsArgs', 'ServiceGitDetailsArgsDict']]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            import_from_git: Optional[pulumi.Input[bool]] = None,
            is_force_import: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            yaml: Optional[pulumi.Input[str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[bool] fetch_resolved_yaml: to fetch resoled service yaml
        :param pulumi.Input[str] force_delete: Enable this flag for force deletion of service
        :param pulumi.Input[Union['ServiceGitDetailsArgs', 'ServiceGitDetailsArgsDict']] git_details: Contains parameters related to Git Experience for remote entities
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[bool] import_from_git: import service from git
        :param pulumi.Input[bool] is_force_import: force import service from remote even if same file path already exist
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[str] yaml: Service YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression:
               org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}.
               For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as
               connectorRef: org.connectorId.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["fetch_resolved_yaml"] = fetch_resolved_yaml
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["git_details"] = git_details
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["import_from_git"] = import_from_git
        __props__.__dict__["is_force_import"] = is_force_import
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["yaml"] = yaml
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fetchResolvedYaml")
    def fetch_resolved_yaml(self) -> pulumi.Output[bool]:
        """
        to fetch resoled service yaml
        """
        return pulumi.get(self, "fetch_resolved_yaml")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[str]:
        """
        Enable this flag for force deletion of service
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="gitDetails")
    def git_details(self) -> pulumi.Output['outputs.ServiceGitDetails']:
        """
        Contains parameters related to Git Experience for remote entities
        """
        return pulumi.get(self, "git_details")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="importFromGit")
    def import_from_git(self) -> pulumi.Output[bool]:
        """
        import service from git
        """
        return pulumi.get(self, "import_from_git")

    @property
    @pulumi.getter(name="isForceImport")
    def is_force_import(self) -> pulumi.Output[bool]:
        """
        force import service from remote even if same file path already exist
        """
        return pulumi.get(self, "is_force_import")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def yaml(self) -> pulumi.Output[str]:
        """
        Service YAML. In YAML, to reference an entity at the organization scope, prefix 'org' to the expression:
        org.{identifier}. To reference an entity at the account scope, prefix 'account` to the expression: account.{identifier}.
        For eg, to reference a connector with identifier 'connectorId' at the organization scope in a stage mention it as
        connectorRef: org.connectorId.
        """
        return pulumi.get(self, "yaml")

