# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 cost_estimation_enabled: pulumi.Input[bool],
                 identifier: pulumi.Input[str],
                 org_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 provider_connector: pulumi.Input[str],
                 provisioner_type: pulumi.Input[str],
                 provisioner_version: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 repository_connector: pulumi.Input[str],
                 repository_path: pulumi.Input[str],
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repository_branch: Optional[pulumi.Input[str]] = None,
                 repository_commit: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[str] repository_commit: Repository commit is commit or tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "cost_estimation_enabled", cost_estimation_enabled)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_connector", provider_connector)
        pulumi.set(__self__, "provisioner_type", provisioner_type)
        pulumi.set(__self__, "provisioner_version", provisioner_version)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "repository_connector", repository_connector)
        pulumi.set(__self__, "repository_path", repository_path)
        if default_pipelines is not None:
            pulumi.set(__self__, "default_pipelines", default_pipelines)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository_branch is not None:
            pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit is not None:
            pulumi.set(__self__, "repository_commit", repository_commit)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terraform_variable_files is not None:
            pulumi.set(__self__, "terraform_variable_files", terraform_variable_files)
        if terraform_variables is not None:
            pulumi.set(__self__, "terraform_variables", terraform_variables)

    @property
    @pulumi.getter(name="costEstimationEnabled")
    def cost_estimation_enabled(self) -> pulumi.Input[bool]:
        """
        Cost estimation enabled determines if cost estimation operations are performed.
        """
        return pulumi.get(self, "cost_estimation_enabled")

    @cost_estimation_enabled.setter
    def cost_estimation_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "cost_estimation_enabled", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> pulumi.Input[str]:
        """
        Provider connector is the reference to the connector for the infrastructure provider
        """
        return pulumi.get(self, "provider_connector")

    @provider_connector.setter
    def provider_connector(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_connector", value)

    @property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provisioner_type", value)

    @property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> pulumi.Input[str]:
        return pulumi.get(self, "provisioner_version")

    @provisioner_version.setter
    def provisioner_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "provisioner_version", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        Repository is the name of the repository to fetch the code from.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> pulumi.Input[str]:
        """
        Repository connector is the reference to the connector used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @repository_connector.setter
    def repository_connector(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_connector", value)

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> pulumi.Input[str]:
        """
        Repository path is the path in which the code resides.
        """
        return pulumi.get(self, "repository_path")

    @repository_path.setter
    def repository_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_path", value)

    @property
    @pulumi.getter(name="defaultPipelines")
    def default_pipelines(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Default pipelines associated with this workspace
        """
        return pulumi.get(self, "default_pipelines")

    @default_pipelines.setter
    def default_pipelines(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "default_pipelines", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]:
        """
        Environment variables configured on the workspace
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit is set.
        """
        return pulumi.get(self, "repository_branch")

    @repository_branch.setter
    def repository_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_branch", value)

    @property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> Optional[pulumi.Input[str]]:
        """
        Repository commit is commit or tag to fetch the code from. This cannot be set if repository branch is set.
        """
        return pulumi.get(self, "repository_commit")

    @repository_commit.setter
    def repository_commit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_commit", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]:
        return pulumi.get(self, "terraform_variable_files")

    @terraform_variable_files.setter
    def terraform_variable_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]):
        pulumi.set(self, "terraform_variable_files", value)

    @property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]:
        return pulumi.get(self, "terraform_variables")

    @terraform_variables.setter
    def terraform_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]):
        pulumi.set(self, "terraform_variables", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 cost_estimation_enabled: Optional[pulumi.Input[bool]] = None,
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_connector: Optional[pulumi.Input[str]] = None,
                 provisioner_type: Optional[pulumi.Input[str]] = None,
                 provisioner_version: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 repository_branch: Optional[pulumi.Input[str]] = None,
                 repository_commit: Optional[pulumi.Input[str]] = None,
                 repository_connector: Optional[pulumi.Input[str]] = None,
                 repository_path: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input[bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[str] repository_commit: Repository commit is commit or tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        if cost_estimation_enabled is not None:
            pulumi.set(__self__, "cost_estimation_enabled", cost_estimation_enabled)
        if default_pipelines is not None:
            pulumi.set(__self__, "default_pipelines", default_pipelines)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provider_connector is not None:
            pulumi.set(__self__, "provider_connector", provider_connector)
        if provisioner_type is not None:
            pulumi.set(__self__, "provisioner_type", provisioner_type)
        if provisioner_version is not None:
            pulumi.set(__self__, "provisioner_version", provisioner_version)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if repository_branch is not None:
            pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit is not None:
            pulumi.set(__self__, "repository_commit", repository_commit)
        if repository_connector is not None:
            pulumi.set(__self__, "repository_connector", repository_connector)
        if repository_path is not None:
            pulumi.set(__self__, "repository_path", repository_path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terraform_variable_files is not None:
            pulumi.set(__self__, "terraform_variable_files", terraform_variable_files)
        if terraform_variables is not None:
            pulumi.set(__self__, "terraform_variables", terraform_variables)

    @property
    @pulumi.getter(name="costEstimationEnabled")
    def cost_estimation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Cost estimation enabled determines if cost estimation operations are performed.
        """
        return pulumi.get(self, "cost_estimation_enabled")

    @cost_estimation_enabled.setter
    def cost_estimation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cost_estimation_enabled", value)

    @property
    @pulumi.getter(name="defaultPipelines")
    def default_pipelines(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Default pipelines associated with this workspace
        """
        return pulumi.get(self, "default_pipelines")

    @default_pipelines.setter
    def default_pipelines(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "default_pipelines", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]:
        """
        Environment variables configured on the workspace
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> Optional[pulumi.Input[str]]:
        """
        Provider connector is the reference to the connector for the infrastructure provider
        """
        return pulumi.get(self, "provider_connector")

    @provider_connector.setter
    def provider_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_connector", value)

    @property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioner_type", value)

    @property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "provisioner_version")

    @provisioner_version.setter
    def provisioner_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioner_version", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        Repository is the name of the repository to fetch the code from.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit is set.
        """
        return pulumi.get(self, "repository_branch")

    @repository_branch.setter
    def repository_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_branch", value)

    @property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> Optional[pulumi.Input[str]]:
        """
        Repository commit is commit or tag to fetch the code from. This cannot be set if repository branch is set.
        """
        return pulumi.get(self, "repository_commit")

    @repository_commit.setter
    def repository_commit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_commit", value)

    @property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> Optional[pulumi.Input[str]]:
        """
        Repository connector is the reference to the connector used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @repository_connector.setter
    def repository_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_connector", value)

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> Optional[pulumi.Input[str]]:
        """
        Repository path is the path in which the code resides.
        """
        return pulumi.get(self, "repository_path")

    @repository_path.setter
    def repository_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_path", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]:
        return pulumi.get(self, "terraform_variable_files")

    @terraform_variable_files.setter
    def terraform_variable_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableFileArgs']]]]):
        pulumi.set(self, "terraform_variable_files", value)

    @property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]:
        return pulumi.get(self, "terraform_variables")

    @terraform_variables.setter
    def terraform_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTerraformVariableArgs']]]]):
        pulumi.set(self, "terraform_variables", value)


class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cost_estimation_enabled: Optional[pulumi.Input[bool]] = None,
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_connector: Optional[pulumi.Input[str]] = None,
                 provisioner_type: Optional[pulumi.Input[str]] = None,
                 provisioner_version: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 repository_branch: Optional[pulumi.Input[str]] = None,
                 repository_commit: Optional[pulumi.Input[str]] = None,
                 repository_connector: Optional[pulumi.Input[str]] = None,
                 repository_path: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableFileArgs', 'WorkspaceTerraformVariableFileArgsDict']]]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableArgs', 'WorkspaceTerraformVariableArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for managing Workspaces

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Workspace("example",
            name="example",
            identifier="example",
            org_id=test_harness_platform_organization["id"],
            project_id=test_harness_platform_project["id"],
            provisioner_type="terraform",
            provisioner_version="1.5.6",
            repository="https://github.com/org/repo",
            repository_branch="main",
            repository_path="tf/aws/basic",
            cost_estimation_enabled=True,
            provider_connector=test["id"],
            repository_connector=test["id"],
            terraform_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            environment_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            terraform_variable_files=[
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "main",
                    "repository_path": "tf/gcp/basic",
                    "repository_connector": test["id"],
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_commit": "349d90bb9c90f4a3482981c259080de31609e6f6",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": test["id"],
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import harness:platform/workspace:Workspace example <org_id>/<project_id>/<slo_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[str] repository_commit: Repository commit is commit or tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing Workspaces

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.Workspace("example",
            name="example",
            identifier="example",
            org_id=test_harness_platform_organization["id"],
            project_id=test_harness_platform_project["id"],
            provisioner_type="terraform",
            provisioner_version="1.5.6",
            repository="https://github.com/org/repo",
            repository_branch="main",
            repository_path="tf/aws/basic",
            cost_estimation_enabled=True,
            provider_connector=test["id"],
            repository_connector=test["id"],
            terraform_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            environment_variables=[
                {
                    "key": "key1",
                    "value": "val1",
                    "value_type": "string",
                },
                {
                    "key": "key2",
                    "value": "val2",
                    "value_type": "string",
                },
            ],
            terraform_variable_files=[
                {
                    "repository": "https://github.com/org/repo",
                    "repository_branch": "main",
                    "repository_path": "tf/gcp/basic",
                    "repository_connector": test["id"],
                },
                {
                    "repository": "https://github.com/org/repo",
                    "repository_commit": "349d90bb9c90f4a3482981c259080de31609e6f6",
                    "repository_path": "tf/aws/basic",
                    "repository_connector": test["id"],
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import harness:platform/workspace:Workspace example <org_id>/<project_id>/<slo_id>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cost_estimation_enabled: Optional[pulumi.Input[bool]] = None,
                 default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 provider_connector: Optional[pulumi.Input[str]] = None,
                 provisioner_type: Optional[pulumi.Input[str]] = None,
                 provisioner_version: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 repository_branch: Optional[pulumi.Input[str]] = None,
                 repository_commit: Optional[pulumi.Input[str]] = None,
                 repository_connector: Optional[pulumi.Input[str]] = None,
                 repository_path: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableFileArgs', 'WorkspaceTerraformVariableFileArgsDict']]]]] = None,
                 terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableArgs', 'WorkspaceTerraformVariableArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            if cost_estimation_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'cost_estimation_enabled'")
            __props__.__dict__["cost_estimation_enabled"] = cost_estimation_enabled
            __props__.__dict__["default_pipelines"] = default_pipelines
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if provider_connector is None and not opts.urn:
                raise TypeError("Missing required property 'provider_connector'")
            __props__.__dict__["provider_connector"] = provider_connector
            if provisioner_type is None and not opts.urn:
                raise TypeError("Missing required property 'provisioner_type'")
            __props__.__dict__["provisioner_type"] = provisioner_type
            if provisioner_version is None and not opts.urn:
                raise TypeError("Missing required property 'provisioner_version'")
            __props__.__dict__["provisioner_version"] = provisioner_version
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            __props__.__dict__["repository_branch"] = repository_branch
            __props__.__dict__["repository_commit"] = repository_commit
            if repository_connector is None and not opts.urn:
                raise TypeError("Missing required property 'repository_connector'")
            __props__.__dict__["repository_connector"] = repository_connector
            if repository_path is None and not opts.urn:
                raise TypeError("Missing required property 'repository_path'")
            __props__.__dict__["repository_path"] = repository_path
            __props__.__dict__["tags"] = tags
            __props__.__dict__["terraform_variable_files"] = terraform_variable_files
            __props__.__dict__["terraform_variables"] = terraform_variables
        super(Workspace, __self__).__init__(
            'harness:platform/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cost_estimation_enabled: Optional[pulumi.Input[bool]] = None,
            default_pipelines: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            provider_connector: Optional[pulumi.Input[str]] = None,
            provisioner_type: Optional[pulumi.Input[str]] = None,
            provisioner_version: Optional[pulumi.Input[str]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            repository_branch: Optional[pulumi.Input[str]] = None,
            repository_commit: Optional[pulumi.Input[str]] = None,
            repository_connector: Optional[pulumi.Input[str]] = None,
            repository_path: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            terraform_variable_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableFileArgs', 'WorkspaceTerraformVariableFileArgsDict']]]]] = None,
            terraform_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTerraformVariableArgs', 'WorkspaceTerraformVariableArgsDict']]]]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] cost_estimation_enabled: Cost estimation enabled determines if cost estimation operations are performed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] default_pipelines: Default pipelines associated with this workspace
        :param pulumi.Input[str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceEnvironmentVariableArgs', 'WorkspaceEnvironmentVariableArgsDict']]]] environment_variables: Environment variables configured on the workspace
        :param pulumi.Input[str] identifier: Unique identifier of the resource.
        :param pulumi.Input[str] name: Name of the resource.
        :param pulumi.Input[str] org_id: Unique identifier of the organization.
        :param pulumi.Input[str] project_id: Unique identifier of the project.
        :param pulumi.Input[str] provider_connector: Provider connector is the reference to the connector for the infrastructure provider
        :param pulumi.Input[str] repository: Repository is the name of the repository to fetch the code from.
        :param pulumi.Input[str] repository_branch: Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[str] repository_commit: Repository commit is commit or tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[str] repository_connector: Repository connector is the reference to the connector used to fetch the code.
        :param pulumi.Input[str] repository_path: Repository path is the path in which the code resides.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["cost_estimation_enabled"] = cost_estimation_enabled
        __props__.__dict__["default_pipelines"] = default_pipelines
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provider_connector"] = provider_connector
        __props__.__dict__["provisioner_type"] = provisioner_type
        __props__.__dict__["provisioner_version"] = provisioner_version
        __props__.__dict__["repository"] = repository
        __props__.__dict__["repository_branch"] = repository_branch
        __props__.__dict__["repository_commit"] = repository_commit
        __props__.__dict__["repository_connector"] = repository_connector
        __props__.__dict__["repository_path"] = repository_path
        __props__.__dict__["tags"] = tags
        __props__.__dict__["terraform_variable_files"] = terraform_variable_files
        __props__.__dict__["terraform_variables"] = terraform_variables
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="costEstimationEnabled")
    def cost_estimation_enabled(self) -> pulumi.Output[bool]:
        """
        Cost estimation enabled determines if cost estimation operations are performed.
        """
        return pulumi.get(self, "cost_estimation_enabled")

    @property
    @pulumi.getter(name="defaultPipelines")
    def default_pipelines(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Default pipelines associated with this workspace
        """
        return pulumi.get(self, "default_pipelines")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceEnvironmentVariable']]]:
        """
        Environment variables configured on the workspace
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> pulumi.Output[str]:
        """
        Provider connector is the reference to the connector for the infrastructure provider
        """
        return pulumi.get(self, "provider_connector")

    @property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "provisioner_type")

    @property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "provisioner_version")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        Repository is the name of the repository to fetch the code from.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> pulumi.Output[Optional[str]]:
        """
        Repository branch is the name of the branch to fetch the code from. This cannot be set if repository commit is set.
        """
        return pulumi.get(self, "repository_branch")

    @property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> pulumi.Output[Optional[str]]:
        """
        Repository commit is commit or tag to fetch the code from. This cannot be set if repository branch is set.
        """
        return pulumi.get(self, "repository_commit")

    @property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> pulumi.Output[str]:
        """
        Repository connector is the reference to the connector used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> pulumi.Output[str]:
        """
        Repository path is the path in which the code resides.
        """
        return pulumi.get(self, "repository_path")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terraformVariableFiles")
    def terraform_variable_files(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceTerraformVariableFile']]]:
        return pulumi.get(self, "terraform_variable_files")

    @property
    @pulumi.getter(name="terraformVariables")
    def terraform_variables(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceTerraformVariable']]]:
        return pulumi.get(self, "terraform_variables")

