# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'DevicePortOverrideArgs',
    'DevicePortOverrideArgsDict',
    'RadiusProfileAcctServerArgs',
    'RadiusProfileAcctServerArgsDict',
    'RadiusProfileAuthServerArgs',
    'RadiusProfileAuthServerArgsDict',
    'WlanScheduleArgs',
    'WlanScheduleArgsDict',
]

MYPY = False

if not MYPY:
    class DevicePortOverrideArgsDict(TypedDict):
        number: pulumi.Input[_builtins.int]
        """
        Switch port number.
        """
        aggregate_num_ports: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of ports in the aggregate.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Human-readable name of the port.
        """
        op_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Operating mode of the port, valid values are `switch`, `mirror`, and `aggregate`. Defaults to `switch`.
        """
        port_profile_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the Port Profile used on this port.
        """
elif False:
    DevicePortOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevicePortOverrideArgs:
    def __init__(__self__, *,
                 number: pulumi.Input[_builtins.int],
                 aggregate_num_ports: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 op_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 port_profile_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] number: Switch port number.
        :param pulumi.Input[_builtins.int] aggregate_num_ports: Number of ports in the aggregate.
        :param pulumi.Input[_builtins.str] name: Human-readable name of the port.
        :param pulumi.Input[_builtins.str] op_mode: Operating mode of the port, valid values are `switch`, `mirror`, and `aggregate`. Defaults to `switch`.
        :param pulumi.Input[_builtins.str] port_profile_id: ID of the Port Profile used on this port.
        """
        pulumi.set(__self__, "number", number)
        if aggregate_num_ports is not None:
            pulumi.set(__self__, "aggregate_num_ports", aggregate_num_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if op_mode is not None:
            pulumi.set(__self__, "op_mode", op_mode)
        if port_profile_id is not None:
            pulumi.set(__self__, "port_profile_id", port_profile_id)

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Input[_builtins.int]:
        """
        Switch port number.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter(name="aggregateNumPorts")
    def aggregate_num_ports(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of ports in the aggregate.
        """
        return pulumi.get(self, "aggregate_num_ports")

    @aggregate_num_ports.setter
    def aggregate_num_ports(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "aggregate_num_ports", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name of the port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="opMode")
    def op_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating mode of the port, valid values are `switch`, `mirror`, and `aggregate`. Defaults to `switch`.
        """
        return pulumi.get(self, "op_mode")

    @op_mode.setter
    def op_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "op_mode", value)

    @_builtins.property
    @pulumi.getter(name="portProfileId")
    def port_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Port Profile used on this port.
        """
        return pulumi.get(self, "port_profile_id")

    @port_profile_id.setter
    def port_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_profile_id", value)


if not MYPY:
    class RadiusProfileAcctServerArgsDict(TypedDict):
        ip: pulumi.Input[_builtins.str]
        """
        IP address of accounting service server.
        """
        xsecret: pulumi.Input[_builtins.str]
        """
        RADIUS secret.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Port of accounting service. Defaults to `1813`.
        """
elif False:
    RadiusProfileAcctServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RadiusProfileAcctServerArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[_builtins.str],
                 xsecret: pulumi.Input[_builtins.str],
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] ip: IP address of accounting service server.
        :param pulumi.Input[_builtins.str] xsecret: RADIUS secret.
        :param pulumi.Input[_builtins.int] port: Port of accounting service. Defaults to `1813`.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "xsecret", xsecret)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        IP address of accounting service server.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def xsecret(self) -> pulumi.Input[_builtins.str]:
        """
        RADIUS secret.
        """
        return pulumi.get(self, "xsecret")

    @xsecret.setter
    def xsecret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "xsecret", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port of accounting service. Defaults to `1813`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class RadiusProfileAuthServerArgsDict(TypedDict):
        ip: pulumi.Input[_builtins.str]
        """
        IP address of authentication service server.
        """
        xsecret: pulumi.Input[_builtins.str]
        """
        RADIUS secret.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Port of authentication service. Defaults to `1812`.
        """
elif False:
    RadiusProfileAuthServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RadiusProfileAuthServerArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[_builtins.str],
                 xsecret: pulumi.Input[_builtins.str],
                 port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] ip: IP address of authentication service server.
        :param pulumi.Input[_builtins.str] xsecret: RADIUS secret.
        :param pulumi.Input[_builtins.int] port: Port of authentication service. Defaults to `1812`.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "xsecret", xsecret)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        IP address of authentication service server.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def xsecret(self) -> pulumi.Input[_builtins.str]:
        """
        RADIUS secret.
        """
        return pulumi.get(self, "xsecret")

    @xsecret.setter
    def xsecret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "xsecret", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port of authentication service. Defaults to `1812`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class WlanScheduleArgsDict(TypedDict):
        day_of_week: pulumi.Input[_builtins.str]
        """
        Day of week for the block. Valid values are `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`.
        """
        duration: pulumi.Input[_builtins.int]
        """
        Length of the block in minutes.
        """
        start_hour: pulumi.Input[_builtins.int]
        """
        Start hour for the block (0-23).
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the block.
        """
        start_minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        Start minute for the block (0-59). Defaults to `0`.
        """
elif False:
    WlanScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WlanScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[_builtins.str],
                 duration: pulumi.Input[_builtins.int],
                 start_hour: pulumi.Input[_builtins.int],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_minute: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] day_of_week: Day of week for the block. Valid values are `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`.
        :param pulumi.Input[_builtins.int] duration: Length of the block in minutes.
        :param pulumi.Input[_builtins.int] start_hour: Start hour for the block (0-23).
        :param pulumi.Input[_builtins.str] name: Name of the block.
        :param pulumi.Input[_builtins.int] start_minute: Start minute for the block (0-59). Defaults to `0`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_hour", start_hour)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[_builtins.str]:
        """
        Day of week for the block. Valid values are `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Input[_builtins.int]:
        """
        Length of the block in minutes.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> pulumi.Input[_builtins.int]:
        """
        Start hour for the block (0-23).
        """
        return pulumi.get(self, "start_hour")

    @start_hour.setter
    def start_hour(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "start_hour", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the block.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Start minute for the block (0-59). Defaults to `0`.
        """
        return pulumi.get(self, "start_minute")

    @start_minute.setter
    def start_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_minute", value)


