# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DynamicDNSArgs', 'DynamicDNS']

@pulumi.input_type
class DynamicDNSArgs:
    def __init__(__self__, *,
                 host_name: pulumi.Input[_builtins.str],
                 service: pulumi.Input[_builtins.str],
                 interface: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DynamicDNS resource.
        :param pulumi.Input[_builtins.str] host_name: The host name to update in the dynamic DNS service.
        :param pulumi.Input[_builtins.str] service: The Dynamic DNS service provider, various values are supported (for example `dyndns`, etc.).
        :param pulumi.Input[_builtins.str] interface: The interface for the dynamic DNS. Can be `wan` or `wan2`. Defaults to `wan`.
        :param pulumi.Input[_builtins.str] login: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] password: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] server: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the dynamic DNS with.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "service", service)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if site is not None:
            pulumi.set(__self__, "site", site)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[_builtins.str]:
        """
        The host name to update in the dynamic DNS service.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        The Dynamic DNS service provider, various values are supported (for example `dyndns`, etc.).
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interface for the dynamic DNS. Can be `wan` or `wan2`. Defaults to `wan`.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the dynamic DNS with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)


@pulumi.input_type
class _DynamicDNSState:
    def __init__(__self__, *,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interface: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DynamicDNS resources.
        :param pulumi.Input[_builtins.str] host_name: The host name to update in the dynamic DNS service.
        :param pulumi.Input[_builtins.str] interface: The interface for the dynamic DNS. Can be `wan` or `wan2`. Defaults to `wan`.
        :param pulumi.Input[_builtins.str] login: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] password: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] server: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] service: The Dynamic DNS service provider, various values are supported (for example `dyndns`, etc.).
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the dynamic DNS with.
        """
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if site is not None:
            pulumi.set(__self__, "site", site)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name to update in the dynamic DNS service.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The interface for the dynamic DNS. Can be `wan` or `wan2`. Defaults to `wan`.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Dynamic DNS service provider, various values are supported (for example `dyndns`, etc.).
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the dynamic DNS with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)


@pulumi.type_token("unifi:index/dynamicDNS:DynamicDNS")
class DynamicDNS(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interface: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `DynamicDNS` manages dynamic DNS settings for different providers.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        test = unifi.DynamicDNS("test",
            service="dyndns",
            host_name="my-network.example.com",
            server="domains.google.com",
            login=dns_login,
            password=dns_password)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] host_name: The host name to update in the dynamic DNS service.
        :param pulumi.Input[_builtins.str] interface: The interface for the dynamic DNS. Can be `wan` or `wan2`. Defaults to `wan`.
        :param pulumi.Input[_builtins.str] login: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] password: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] server: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] service: The Dynamic DNS service provider, various values are supported (for example `dyndns`, etc.).
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the dynamic DNS with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DynamicDNSArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `DynamicDNS` manages dynamic DNS settings for different providers.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        test = unifi.DynamicDNS("test",
            service="dyndns",
            host_name="my-network.example.com",
            server="domains.google.com",
            login=dns_login,
            password=dns_password)
        ```

        :param str resource_name: The name of the resource.
        :param DynamicDNSArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DynamicDNSArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 interface: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DynamicDNSArgs.__new__(DynamicDNSArgs)

            if host_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_name'")
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["interface"] = interface
            __props__.__dict__["login"] = login
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["server"] = server
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["site"] = site
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DynamicDNS, __self__).__init__(
            'unifi:index/dynamicDNS:DynamicDNS',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            interface: Optional[pulumi.Input[_builtins.str]] = None,
            login: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            server: Optional[pulumi.Input[_builtins.str]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            site: Optional[pulumi.Input[_builtins.str]] = None) -> 'DynamicDNS':
        """
        Get an existing DynamicDNS resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] host_name: The host name to update in the dynamic DNS service.
        :param pulumi.Input[_builtins.str] interface: The interface for the dynamic DNS. Can be `wan` or `wan2`. Defaults to `wan`.
        :param pulumi.Input[_builtins.str] login: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] password: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] server: The server for the dynamic DNS service.
        :param pulumi.Input[_builtins.str] service: The Dynamic DNS service provider, various values are supported (for example `dyndns`, etc.).
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the dynamic DNS with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DynamicDNSState.__new__(_DynamicDNSState)

        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["interface"] = interface
        __props__.__dict__["login"] = login
        __props__.__dict__["password"] = password
        __props__.__dict__["server"] = server
        __props__.__dict__["service"] = service
        __props__.__dict__["site"] = site
        return DynamicDNS(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[_builtins.str]:
        """
        The host name to update in the dynamic DNS service.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The interface for the dynamic DNS. Can be `wan` or `wan2`. Defaults to `wan`.
        """
        return pulumi.get(self, "interface")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def server(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The server for the dynamic DNS service.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        The Dynamic DNS service provider, various values are supported (for example `dyndns`, etc.).
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def site(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the site to associate the dynamic DNS with.
        """
        return pulumi.get(self, "site")

