# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, id=None, name=None, network_id=None, password=None, site=None, tunnel_medium_type=None, tunnel_type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if site and not isinstance(site, str):
            raise TypeError("Expected argument 'site' to be a str")
        pulumi.set(__self__, "site", site)
        if tunnel_medium_type and not isinstance(tunnel_medium_type, int):
            raise TypeError("Expected argument 'tunnel_medium_type' to be a int")
        pulumi.set(__self__, "tunnel_medium_type", tunnel_medium_type)
        if tunnel_type and not isinstance(tunnel_type, int):
            raise TypeError("Expected argument 'tunnel_type' to be a int")
        pulumi.set(__self__, "tunnel_type", tunnel_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this account.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the account to look up
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        ID of the network for this account
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password of the account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def site(self) -> _builtins.str:
        """
        The name of the site the account is associated with.
        """
        return pulumi.get(self, "site")

    @_builtins.property
    @pulumi.getter(name="tunnelMediumType")
    def tunnel_medium_type(self) -> _builtins.int:
        """
        See RFC2868 section 3.2
        """
        return pulumi.get(self, "tunnel_medium_type")

    @_builtins.property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> _builtins.int:
        """
        See RFC2868 section 3.1
        """
        return pulumi.get(self, "tunnel_type")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            id=self.id,
            name=self.name,
            network_id=self.network_id,
            password=self.password,
            site=self.site,
            tunnel_medium_type=self.tunnel_medium_type,
            tunnel_type=self.tunnel_type)


def get_account(name: Optional[_builtins.str] = None,
                site: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    `Account` data source can be used to retrieve RADIUS user accounts


    :param _builtins.str name: The name of the account to look up
    :param _builtins.str site: The name of the site the account is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['site'] = site
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('unifi:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        password=pulumi.get(__ret__, 'password'),
        site=pulumi.get(__ret__, 'site'),
        tunnel_medium_type=pulumi.get(__ret__, 'tunnel_medium_type'),
        tunnel_type=pulumi.get(__ret__, 'tunnel_type'))
def get_account_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       site: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    `Account` data source can be used to retrieve RADIUS user accounts


    :param _builtins.str name: The name of the account to look up
    :param _builtins.str site: The name of the site the account is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['site'] = site
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('unifi:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        password=pulumi.get(__response__, 'password'),
        site=pulumi.get(__response__, 'site'),
        tunnel_medium_type=pulumi.get(__response__, 'tunnel_medium_type'),
        tunnel_type=pulumi.get(__response__, 'tunnel_type')))
