# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    """
    A collection of values returned by getNetwork.
    """
    def __init__(__self__, dhcp_dns=None, dhcp_enabled=None, dhcp_lease=None, dhcp_start=None, dhcp_stop=None, dhcp_v6_dns=None, dhcp_v6_dns_auto=None, dhcp_v6_enabled=None, dhcp_v6_lease=None, dhcp_v6_start=None, dhcp_v6_stop=None, dhcpd_boot_enabled=None, dhcpd_boot_filename=None, dhcpd_boot_server=None, domain_name=None, id=None, igmp_snooping=None, ipv6_interface_type=None, ipv6_pd_interface=None, ipv6_pd_prefixid=None, ipv6_pd_start=None, ipv6_pd_stop=None, ipv6_ra_enable=None, ipv6_ra_preferred_lifetime=None, ipv6_ra_priority=None, ipv6_ra_valid_lifetime=None, ipv6_static_subnet=None, multicast_dns=None, name=None, network_group=None, purpose=None, site=None, subnet=None, vlan_id=None, wan_dhcp_v6_pd_size=None, wan_dns=None, wan_egress_qos=None, wan_gateway=None, wan_gateway_v6=None, wan_ip=None, wan_ipv6=None, wan_netmask=None, wan_networkgroup=None, wan_prefixlen=None, wan_type=None, wan_type_v6=None, wan_username=None, x_wan_password=None):
        if dhcp_dns and not isinstance(dhcp_dns, list):
            raise TypeError("Expected argument 'dhcp_dns' to be a list")
        pulumi.set(__self__, "dhcp_dns", dhcp_dns)
        if dhcp_enabled and not isinstance(dhcp_enabled, bool):
            raise TypeError("Expected argument 'dhcp_enabled' to be a bool")
        pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)
        if dhcp_lease and not isinstance(dhcp_lease, int):
            raise TypeError("Expected argument 'dhcp_lease' to be a int")
        pulumi.set(__self__, "dhcp_lease", dhcp_lease)
        if dhcp_start and not isinstance(dhcp_start, str):
            raise TypeError("Expected argument 'dhcp_start' to be a str")
        pulumi.set(__self__, "dhcp_start", dhcp_start)
        if dhcp_stop and not isinstance(dhcp_stop, str):
            raise TypeError("Expected argument 'dhcp_stop' to be a str")
        pulumi.set(__self__, "dhcp_stop", dhcp_stop)
        if dhcp_v6_dns and not isinstance(dhcp_v6_dns, list):
            raise TypeError("Expected argument 'dhcp_v6_dns' to be a list")
        pulumi.set(__self__, "dhcp_v6_dns", dhcp_v6_dns)
        if dhcp_v6_dns_auto and not isinstance(dhcp_v6_dns_auto, bool):
            raise TypeError("Expected argument 'dhcp_v6_dns_auto' to be a bool")
        pulumi.set(__self__, "dhcp_v6_dns_auto", dhcp_v6_dns_auto)
        if dhcp_v6_enabled and not isinstance(dhcp_v6_enabled, bool):
            raise TypeError("Expected argument 'dhcp_v6_enabled' to be a bool")
        pulumi.set(__self__, "dhcp_v6_enabled", dhcp_v6_enabled)
        if dhcp_v6_lease and not isinstance(dhcp_v6_lease, int):
            raise TypeError("Expected argument 'dhcp_v6_lease' to be a int")
        pulumi.set(__self__, "dhcp_v6_lease", dhcp_v6_lease)
        if dhcp_v6_start and not isinstance(dhcp_v6_start, str):
            raise TypeError("Expected argument 'dhcp_v6_start' to be a str")
        pulumi.set(__self__, "dhcp_v6_start", dhcp_v6_start)
        if dhcp_v6_stop and not isinstance(dhcp_v6_stop, str):
            raise TypeError("Expected argument 'dhcp_v6_stop' to be a str")
        pulumi.set(__self__, "dhcp_v6_stop", dhcp_v6_stop)
        if dhcpd_boot_enabled and not isinstance(dhcpd_boot_enabled, bool):
            raise TypeError("Expected argument 'dhcpd_boot_enabled' to be a bool")
        pulumi.set(__self__, "dhcpd_boot_enabled", dhcpd_boot_enabled)
        if dhcpd_boot_filename and not isinstance(dhcpd_boot_filename, str):
            raise TypeError("Expected argument 'dhcpd_boot_filename' to be a str")
        pulumi.set(__self__, "dhcpd_boot_filename", dhcpd_boot_filename)
        if dhcpd_boot_server and not isinstance(dhcpd_boot_server, str):
            raise TypeError("Expected argument 'dhcpd_boot_server' to be a str")
        pulumi.set(__self__, "dhcpd_boot_server", dhcpd_boot_server)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if igmp_snooping and not isinstance(igmp_snooping, bool):
            raise TypeError("Expected argument 'igmp_snooping' to be a bool")
        pulumi.set(__self__, "igmp_snooping", igmp_snooping)
        if ipv6_interface_type and not isinstance(ipv6_interface_type, str):
            raise TypeError("Expected argument 'ipv6_interface_type' to be a str")
        pulumi.set(__self__, "ipv6_interface_type", ipv6_interface_type)
        if ipv6_pd_interface and not isinstance(ipv6_pd_interface, str):
            raise TypeError("Expected argument 'ipv6_pd_interface' to be a str")
        pulumi.set(__self__, "ipv6_pd_interface", ipv6_pd_interface)
        if ipv6_pd_prefixid and not isinstance(ipv6_pd_prefixid, str):
            raise TypeError("Expected argument 'ipv6_pd_prefixid' to be a str")
        pulumi.set(__self__, "ipv6_pd_prefixid", ipv6_pd_prefixid)
        if ipv6_pd_start and not isinstance(ipv6_pd_start, str):
            raise TypeError("Expected argument 'ipv6_pd_start' to be a str")
        pulumi.set(__self__, "ipv6_pd_start", ipv6_pd_start)
        if ipv6_pd_stop and not isinstance(ipv6_pd_stop, str):
            raise TypeError("Expected argument 'ipv6_pd_stop' to be a str")
        pulumi.set(__self__, "ipv6_pd_stop", ipv6_pd_stop)
        if ipv6_ra_enable and not isinstance(ipv6_ra_enable, bool):
            raise TypeError("Expected argument 'ipv6_ra_enable' to be a bool")
        pulumi.set(__self__, "ipv6_ra_enable", ipv6_ra_enable)
        if ipv6_ra_preferred_lifetime and not isinstance(ipv6_ra_preferred_lifetime, int):
            raise TypeError("Expected argument 'ipv6_ra_preferred_lifetime' to be a int")
        pulumi.set(__self__, "ipv6_ra_preferred_lifetime", ipv6_ra_preferred_lifetime)
        if ipv6_ra_priority and not isinstance(ipv6_ra_priority, str):
            raise TypeError("Expected argument 'ipv6_ra_priority' to be a str")
        pulumi.set(__self__, "ipv6_ra_priority", ipv6_ra_priority)
        if ipv6_ra_valid_lifetime and not isinstance(ipv6_ra_valid_lifetime, int):
            raise TypeError("Expected argument 'ipv6_ra_valid_lifetime' to be a int")
        pulumi.set(__self__, "ipv6_ra_valid_lifetime", ipv6_ra_valid_lifetime)
        if ipv6_static_subnet and not isinstance(ipv6_static_subnet, str):
            raise TypeError("Expected argument 'ipv6_static_subnet' to be a str")
        pulumi.set(__self__, "ipv6_static_subnet", ipv6_static_subnet)
        if multicast_dns and not isinstance(multicast_dns, bool):
            raise TypeError("Expected argument 'multicast_dns' to be a bool")
        pulumi.set(__self__, "multicast_dns", multicast_dns)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_group and not isinstance(network_group, str):
            raise TypeError("Expected argument 'network_group' to be a str")
        pulumi.set(__self__, "network_group", network_group)
        if purpose and not isinstance(purpose, str):
            raise TypeError("Expected argument 'purpose' to be a str")
        pulumi.set(__self__, "purpose", purpose)
        if site and not isinstance(site, str):
            raise TypeError("Expected argument 'site' to be a str")
        pulumi.set(__self__, "site", site)
        if subnet and not isinstance(subnet, str):
            raise TypeError("Expected argument 'subnet' to be a str")
        pulumi.set(__self__, "subnet", subnet)
        if vlan_id and not isinstance(vlan_id, int):
            raise TypeError("Expected argument 'vlan_id' to be a int")
        pulumi.set(__self__, "vlan_id", vlan_id)
        if wan_dhcp_v6_pd_size and not isinstance(wan_dhcp_v6_pd_size, int):
            raise TypeError("Expected argument 'wan_dhcp_v6_pd_size' to be a int")
        pulumi.set(__self__, "wan_dhcp_v6_pd_size", wan_dhcp_v6_pd_size)
        if wan_dns and not isinstance(wan_dns, list):
            raise TypeError("Expected argument 'wan_dns' to be a list")
        pulumi.set(__self__, "wan_dns", wan_dns)
        if wan_egress_qos and not isinstance(wan_egress_qos, int):
            raise TypeError("Expected argument 'wan_egress_qos' to be a int")
        pulumi.set(__self__, "wan_egress_qos", wan_egress_qos)
        if wan_gateway and not isinstance(wan_gateway, str):
            raise TypeError("Expected argument 'wan_gateway' to be a str")
        pulumi.set(__self__, "wan_gateway", wan_gateway)
        if wan_gateway_v6 and not isinstance(wan_gateway_v6, str):
            raise TypeError("Expected argument 'wan_gateway_v6' to be a str")
        pulumi.set(__self__, "wan_gateway_v6", wan_gateway_v6)
        if wan_ip and not isinstance(wan_ip, str):
            raise TypeError("Expected argument 'wan_ip' to be a str")
        pulumi.set(__self__, "wan_ip", wan_ip)
        if wan_ipv6 and not isinstance(wan_ipv6, str):
            raise TypeError("Expected argument 'wan_ipv6' to be a str")
        pulumi.set(__self__, "wan_ipv6", wan_ipv6)
        if wan_netmask and not isinstance(wan_netmask, str):
            raise TypeError("Expected argument 'wan_netmask' to be a str")
        pulumi.set(__self__, "wan_netmask", wan_netmask)
        if wan_networkgroup and not isinstance(wan_networkgroup, str):
            raise TypeError("Expected argument 'wan_networkgroup' to be a str")
        pulumi.set(__self__, "wan_networkgroup", wan_networkgroup)
        if wan_prefixlen and not isinstance(wan_prefixlen, int):
            raise TypeError("Expected argument 'wan_prefixlen' to be a int")
        pulumi.set(__self__, "wan_prefixlen", wan_prefixlen)
        if wan_type and not isinstance(wan_type, str):
            raise TypeError("Expected argument 'wan_type' to be a str")
        pulumi.set(__self__, "wan_type", wan_type)
        if wan_type_v6 and not isinstance(wan_type_v6, str):
            raise TypeError("Expected argument 'wan_type_v6' to be a str")
        pulumi.set(__self__, "wan_type_v6", wan_type_v6)
        if wan_username and not isinstance(wan_username, str):
            raise TypeError("Expected argument 'wan_username' to be a str")
        pulumi.set(__self__, "wan_username", wan_username)
        if x_wan_password and not isinstance(x_wan_password, str):
            raise TypeError("Expected argument 'x_wan_password' to be a str")
        pulumi.set(__self__, "x_wan_password", x_wan_password)

    @_builtins.property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> Sequence[_builtins.str]:
        """
        IPv4 addresses for the DNS server to be returned from the DHCP server.
        """
        return pulumi.get(self, "dhcp_dns")

    @_builtins.property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> _builtins.bool:
        """
        whether DHCP is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_enabled")

    @_builtins.property
    @pulumi.getter(name="dhcpLease")
    def dhcp_lease(self) -> _builtins.int:
        """
        lease time for DHCP addresses.
        """
        return pulumi.get(self, "dhcp_lease")

    @_builtins.property
    @pulumi.getter(name="dhcpStart")
    def dhcp_start(self) -> _builtins.str:
        """
        The IPv4 address where the DHCP range of addresses starts.
        """
        return pulumi.get(self, "dhcp_start")

    @_builtins.property
    @pulumi.getter(name="dhcpStop")
    def dhcp_stop(self) -> _builtins.str:
        """
        The IPv4 address where the DHCP range of addresses stops.
        """
        return pulumi.get(self, "dhcp_stop")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Dns")
    def dhcp_v6_dns(self) -> Sequence[_builtins.str]:
        """
        Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        """
        return pulumi.get(self, "dhcp_v6_dns")

    @_builtins.property
    @pulumi.getter(name="dhcpV6DnsAuto")
    def dhcp_v6_dns_auto(self) -> _builtins.bool:
        """
        Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise
        """
        return pulumi.get(self, "dhcp_v6_dns_auto")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Enabled")
    def dhcp_v6_enabled(self) -> _builtins.bool:
        """
        Enable stateful DHCPv6 for static configuration.
        """
        return pulumi.get(self, "dhcp_v6_enabled")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Lease")
    def dhcp_v6_lease(self) -> _builtins.int:
        """
        Specifies the lease time for DHCPv6 addresses.
        """
        return pulumi.get(self, "dhcp_v6_lease")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Start")
    def dhcp_v6_start(self) -> _builtins.str:
        """
        Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_start")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Stop")
    def dhcp_v6_stop(self) -> _builtins.str:
        """
        End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_stop")

    @_builtins.property
    @pulumi.getter(name="dhcpdBootEnabled")
    def dhcpd_boot_enabled(self) -> _builtins.bool:
        """
        Toggles on the DHCP boot options. will be set to true if you have dhcpd*boot*filename, and dhcpd*boot*server set.
        """
        return pulumi.get(self, "dhcpd_boot_enabled")

    @_builtins.property
    @pulumi.getter(name="dhcpdBootFilename")
    def dhcpd_boot_filename(self) -> _builtins.str:
        """
        the file to PXE boot from on the dhcpd*boot*server.
        """
        return pulumi.get(self, "dhcpd_boot_filename")

    @_builtins.property
    @pulumi.getter(name="dhcpdBootServer")
    def dhcpd_boot_server(self) -> _builtins.str:
        """
        IPv4 address of a TFTP server to network boot from.
        """
        return pulumi.get(self, "dhcpd_boot_server")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The domain name of this network.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="igmpSnooping")
    def igmp_snooping(self) -> _builtins.bool:
        """
        Specifies whether IGMP snooping is enabled or not.
        """
        return pulumi.get(self, "igmp_snooping")

    @_builtins.property
    @pulumi.getter(name="ipv6InterfaceType")
    def ipv6_interface_type(self) -> _builtins.str:
        """
        Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`.
        """
        return pulumi.get(self, "ipv6_interface_type")

    @_builtins.property
    @pulumi.getter(name="ipv6PdInterface")
    def ipv6_pd_interface(self) -> _builtins.str:
        """
        Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        """
        return pulumi.get(self, "ipv6_pd_interface")

    @_builtins.property
    @pulumi.getter(name="ipv6PdPrefixid")
    def ipv6_pd_prefixid(self) -> _builtins.str:
        """
        Specifies the IPv6 Prefix ID.
        """
        return pulumi.get(self, "ipv6_pd_prefixid")

    @_builtins.property
    @pulumi.getter(name="ipv6PdStart")
    def ipv6_pd_start(self) -> _builtins.str:
        """
        Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_start")

    @_builtins.property
    @pulumi.getter(name="ipv6PdStop")
    def ipv6_pd_stop(self) -> _builtins.str:
        """
        End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_stop")

    @_builtins.property
    @pulumi.getter(name="ipv6RaEnable")
    def ipv6_ra_enable(self) -> _builtins.bool:
        """
        Specifies whether to enable router advertisements or not.
        """
        return pulumi.get(self, "ipv6_ra_enable")

    @_builtins.property
    @pulumi.getter(name="ipv6RaPreferredLifetime")
    def ipv6_ra_preferred_lifetime(self) -> _builtins.int:
        """
        Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime`
        """
        return pulumi.get(self, "ipv6_ra_preferred_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipv6RaPriority")
    def ipv6_ra_priority(self) -> _builtins.str:
        """
        IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        """
        return pulumi.get(self, "ipv6_ra_priority")

    @_builtins.property
    @pulumi.getter(name="ipv6RaValidLifetime")
    def ipv6_ra_valid_lifetime(self) -> _builtins.int:
        """
        Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`.
        """
        return pulumi.get(self, "ipv6_ra_valid_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipv6StaticSubnet")
    def ipv6_static_subnet(self) -> _builtins.str:
        """
        Specifies the static IPv6 subnet (when ipv6*interface*type is 'static').
        """
        return pulumi.get(self, "ipv6_static_subnet")

    @_builtins.property
    @pulumi.getter(name="multicastDns")
    def multicast_dns(self) -> _builtins.bool:
        """
        Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        """
        return pulumi.get(self, "multicast_dns")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkGroup")
    def network_group(self) -> _builtins.str:
        """
        The group of the network.
        """
        return pulumi.get(self, "network_group")

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> _builtins.str:
        """
        The purpose of the network. One of `corporate`, `guest`, `wan`, or `vlan-only`.
        """
        return pulumi.get(self, "purpose")

    @_builtins.property
    @pulumi.getter
    def site(self) -> _builtins.str:
        """
        The name of the site to associate the network with.
        """
        return pulumi.get(self, "site")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> _builtins.str:
        """
        The subnet of the network (CIDR address).
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> _builtins.int:
        """
        The VLAN ID of the network.
        """
        return pulumi.get(self, "vlan_id")

    @_builtins.property
    @pulumi.getter(name="wanDhcpV6PdSize")
    def wan_dhcp_v6_pd_size(self) -> _builtins.int:
        """
        Specifies the IPv6 prefix size to request from ISP. Must be a number between 48 and 64.
        """
        return pulumi.get(self, "wan_dhcp_v6_pd_size")

    @_builtins.property
    @pulumi.getter(name="wanDns")
    def wan_dns(self) -> Sequence[_builtins.str]:
        """
        DNS servers IPs of the WAN.
        """
        return pulumi.get(self, "wan_dns")

    @_builtins.property
    @pulumi.getter(name="wanEgressQos")
    def wan_egress_qos(self) -> _builtins.int:
        """
        Specifies the WAN egress quality of service.
        """
        return pulumi.get(self, "wan_egress_qos")

    @_builtins.property
    @pulumi.getter(name="wanGateway")
    def wan_gateway(self) -> _builtins.str:
        """
        The IPv4 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway")

    @_builtins.property
    @pulumi.getter(name="wanGatewayV6")
    def wan_gateway_v6(self) -> _builtins.str:
        """
        The IPv6 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway_v6")

    @_builtins.property
    @pulumi.getter(name="wanIp")
    def wan_ip(self) -> _builtins.str:
        """
        The IPv4 address of the WAN.
        """
        return pulumi.get(self, "wan_ip")

    @_builtins.property
    @pulumi.getter(name="wanIpv6")
    def wan_ipv6(self) -> _builtins.str:
        """
        The IPv6 address of the WAN.
        """
        return pulumi.get(self, "wan_ipv6")

    @_builtins.property
    @pulumi.getter(name="wanNetmask")
    def wan_netmask(self) -> _builtins.str:
        """
        The IPv4 netmask of the WAN.
        """
        return pulumi.get(self, "wan_netmask")

    @_builtins.property
    @pulumi.getter(name="wanNetworkgroup")
    def wan_networkgroup(self) -> _builtins.str:
        """
        Specifies the WAN network group. One of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        """
        return pulumi.get(self, "wan_networkgroup")

    @_builtins.property
    @pulumi.getter(name="wanPrefixlen")
    def wan_prefixlen(self) -> _builtins.int:
        """
        The IPv6 prefix length of the WAN. Must be between 1 and 128.
        """
        return pulumi.get(self, "wan_prefixlen")

    @_builtins.property
    @pulumi.getter(name="wanType")
    def wan_type(self) -> _builtins.str:
        """
        Specifies the IPV4 WAN connection type. One of either `disabled`, `static`, `dhcp`, or `pppoe`.
        """
        return pulumi.get(self, "wan_type")

    @_builtins.property
    @pulumi.getter(name="wanTypeV6")
    def wan_type_v6(self) -> _builtins.str:
        """
        Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        """
        return pulumi.get(self, "wan_type_v6")

    @_builtins.property
    @pulumi.getter(name="wanUsername")
    def wan_username(self) -> _builtins.str:
        """
        Specifies the IPV4 WAN username.
        """
        return pulumi.get(self, "wan_username")

    @_builtins.property
    @pulumi.getter(name="xWanPassword")
    def x_wan_password(self) -> _builtins.str:
        """
        Specifies the IPV4 WAN password.
        """
        return pulumi.get(self, "x_wan_password")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            dhcp_dns=self.dhcp_dns,
            dhcp_enabled=self.dhcp_enabled,
            dhcp_lease=self.dhcp_lease,
            dhcp_start=self.dhcp_start,
            dhcp_stop=self.dhcp_stop,
            dhcp_v6_dns=self.dhcp_v6_dns,
            dhcp_v6_dns_auto=self.dhcp_v6_dns_auto,
            dhcp_v6_enabled=self.dhcp_v6_enabled,
            dhcp_v6_lease=self.dhcp_v6_lease,
            dhcp_v6_start=self.dhcp_v6_start,
            dhcp_v6_stop=self.dhcp_v6_stop,
            dhcpd_boot_enabled=self.dhcpd_boot_enabled,
            dhcpd_boot_filename=self.dhcpd_boot_filename,
            dhcpd_boot_server=self.dhcpd_boot_server,
            domain_name=self.domain_name,
            id=self.id,
            igmp_snooping=self.igmp_snooping,
            ipv6_interface_type=self.ipv6_interface_type,
            ipv6_pd_interface=self.ipv6_pd_interface,
            ipv6_pd_prefixid=self.ipv6_pd_prefixid,
            ipv6_pd_start=self.ipv6_pd_start,
            ipv6_pd_stop=self.ipv6_pd_stop,
            ipv6_ra_enable=self.ipv6_ra_enable,
            ipv6_ra_preferred_lifetime=self.ipv6_ra_preferred_lifetime,
            ipv6_ra_priority=self.ipv6_ra_priority,
            ipv6_ra_valid_lifetime=self.ipv6_ra_valid_lifetime,
            ipv6_static_subnet=self.ipv6_static_subnet,
            multicast_dns=self.multicast_dns,
            name=self.name,
            network_group=self.network_group,
            purpose=self.purpose,
            site=self.site,
            subnet=self.subnet,
            vlan_id=self.vlan_id,
            wan_dhcp_v6_pd_size=self.wan_dhcp_v6_pd_size,
            wan_dns=self.wan_dns,
            wan_egress_qos=self.wan_egress_qos,
            wan_gateway=self.wan_gateway,
            wan_gateway_v6=self.wan_gateway_v6,
            wan_ip=self.wan_ip,
            wan_ipv6=self.wan_ipv6,
            wan_netmask=self.wan_netmask,
            wan_networkgroup=self.wan_networkgroup,
            wan_prefixlen=self.wan_prefixlen,
            wan_type=self.wan_type,
            wan_type_v6=self.wan_type_v6,
            wan_username=self.wan_username,
            x_wan_password=self.x_wan_password)


def get_network(id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                site: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    `Network` data source can be used to retrieve settings for a network by name or ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    #retrieve network data by unifi network name
    lan_network = unifi.get_network(name="Default")
    #retrieve network data from user record
    my_device = unifi.iam.get_user(mac="01:23:45:67:89:ab")
    my_network = unifi.get_network(id=my_device.network_id)
    ```


    :param _builtins.str id: The ID of the network.
    :param _builtins.str name: The name of the network.
    :param _builtins.str site: The name of the site to associate the network with.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['site'] = site
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('unifi:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        dhcp_dns=pulumi.get(__ret__, 'dhcp_dns'),
        dhcp_enabled=pulumi.get(__ret__, 'dhcp_enabled'),
        dhcp_lease=pulumi.get(__ret__, 'dhcp_lease'),
        dhcp_start=pulumi.get(__ret__, 'dhcp_start'),
        dhcp_stop=pulumi.get(__ret__, 'dhcp_stop'),
        dhcp_v6_dns=pulumi.get(__ret__, 'dhcp_v6_dns'),
        dhcp_v6_dns_auto=pulumi.get(__ret__, 'dhcp_v6_dns_auto'),
        dhcp_v6_enabled=pulumi.get(__ret__, 'dhcp_v6_enabled'),
        dhcp_v6_lease=pulumi.get(__ret__, 'dhcp_v6_lease'),
        dhcp_v6_start=pulumi.get(__ret__, 'dhcp_v6_start'),
        dhcp_v6_stop=pulumi.get(__ret__, 'dhcp_v6_stop'),
        dhcpd_boot_enabled=pulumi.get(__ret__, 'dhcpd_boot_enabled'),
        dhcpd_boot_filename=pulumi.get(__ret__, 'dhcpd_boot_filename'),
        dhcpd_boot_server=pulumi.get(__ret__, 'dhcpd_boot_server'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        id=pulumi.get(__ret__, 'id'),
        igmp_snooping=pulumi.get(__ret__, 'igmp_snooping'),
        ipv6_interface_type=pulumi.get(__ret__, 'ipv6_interface_type'),
        ipv6_pd_interface=pulumi.get(__ret__, 'ipv6_pd_interface'),
        ipv6_pd_prefixid=pulumi.get(__ret__, 'ipv6_pd_prefixid'),
        ipv6_pd_start=pulumi.get(__ret__, 'ipv6_pd_start'),
        ipv6_pd_stop=pulumi.get(__ret__, 'ipv6_pd_stop'),
        ipv6_ra_enable=pulumi.get(__ret__, 'ipv6_ra_enable'),
        ipv6_ra_preferred_lifetime=pulumi.get(__ret__, 'ipv6_ra_preferred_lifetime'),
        ipv6_ra_priority=pulumi.get(__ret__, 'ipv6_ra_priority'),
        ipv6_ra_valid_lifetime=pulumi.get(__ret__, 'ipv6_ra_valid_lifetime'),
        ipv6_static_subnet=pulumi.get(__ret__, 'ipv6_static_subnet'),
        multicast_dns=pulumi.get(__ret__, 'multicast_dns'),
        name=pulumi.get(__ret__, 'name'),
        network_group=pulumi.get(__ret__, 'network_group'),
        purpose=pulumi.get(__ret__, 'purpose'),
        site=pulumi.get(__ret__, 'site'),
        subnet=pulumi.get(__ret__, 'subnet'),
        vlan_id=pulumi.get(__ret__, 'vlan_id'),
        wan_dhcp_v6_pd_size=pulumi.get(__ret__, 'wan_dhcp_v6_pd_size'),
        wan_dns=pulumi.get(__ret__, 'wan_dns'),
        wan_egress_qos=pulumi.get(__ret__, 'wan_egress_qos'),
        wan_gateway=pulumi.get(__ret__, 'wan_gateway'),
        wan_gateway_v6=pulumi.get(__ret__, 'wan_gateway_v6'),
        wan_ip=pulumi.get(__ret__, 'wan_ip'),
        wan_ipv6=pulumi.get(__ret__, 'wan_ipv6'),
        wan_netmask=pulumi.get(__ret__, 'wan_netmask'),
        wan_networkgroup=pulumi.get(__ret__, 'wan_networkgroup'),
        wan_prefixlen=pulumi.get(__ret__, 'wan_prefixlen'),
        wan_type=pulumi.get(__ret__, 'wan_type'),
        wan_type_v6=pulumi.get(__ret__, 'wan_type_v6'),
        wan_username=pulumi.get(__ret__, 'wan_username'),
        x_wan_password=pulumi.get(__ret__, 'x_wan_password'))
def get_network_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       site: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkResult]:
    """
    `Network` data source can be used to retrieve settings for a network by name or ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    #retrieve network data by unifi network name
    lan_network = unifi.get_network(name="Default")
    #retrieve network data from user record
    my_device = unifi.iam.get_user(mac="01:23:45:67:89:ab")
    my_network = unifi.get_network(id=my_device.network_id)
    ```


    :param _builtins.str id: The ID of the network.
    :param _builtins.str name: The name of the network.
    :param _builtins.str site: The name of the site to associate the network with.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['site'] = site
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('unifi:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        dhcp_dns=pulumi.get(__response__, 'dhcp_dns'),
        dhcp_enabled=pulumi.get(__response__, 'dhcp_enabled'),
        dhcp_lease=pulumi.get(__response__, 'dhcp_lease'),
        dhcp_start=pulumi.get(__response__, 'dhcp_start'),
        dhcp_stop=pulumi.get(__response__, 'dhcp_stop'),
        dhcp_v6_dns=pulumi.get(__response__, 'dhcp_v6_dns'),
        dhcp_v6_dns_auto=pulumi.get(__response__, 'dhcp_v6_dns_auto'),
        dhcp_v6_enabled=pulumi.get(__response__, 'dhcp_v6_enabled'),
        dhcp_v6_lease=pulumi.get(__response__, 'dhcp_v6_lease'),
        dhcp_v6_start=pulumi.get(__response__, 'dhcp_v6_start'),
        dhcp_v6_stop=pulumi.get(__response__, 'dhcp_v6_stop'),
        dhcpd_boot_enabled=pulumi.get(__response__, 'dhcpd_boot_enabled'),
        dhcpd_boot_filename=pulumi.get(__response__, 'dhcpd_boot_filename'),
        dhcpd_boot_server=pulumi.get(__response__, 'dhcpd_boot_server'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        id=pulumi.get(__response__, 'id'),
        igmp_snooping=pulumi.get(__response__, 'igmp_snooping'),
        ipv6_interface_type=pulumi.get(__response__, 'ipv6_interface_type'),
        ipv6_pd_interface=pulumi.get(__response__, 'ipv6_pd_interface'),
        ipv6_pd_prefixid=pulumi.get(__response__, 'ipv6_pd_prefixid'),
        ipv6_pd_start=pulumi.get(__response__, 'ipv6_pd_start'),
        ipv6_pd_stop=pulumi.get(__response__, 'ipv6_pd_stop'),
        ipv6_ra_enable=pulumi.get(__response__, 'ipv6_ra_enable'),
        ipv6_ra_preferred_lifetime=pulumi.get(__response__, 'ipv6_ra_preferred_lifetime'),
        ipv6_ra_priority=pulumi.get(__response__, 'ipv6_ra_priority'),
        ipv6_ra_valid_lifetime=pulumi.get(__response__, 'ipv6_ra_valid_lifetime'),
        ipv6_static_subnet=pulumi.get(__response__, 'ipv6_static_subnet'),
        multicast_dns=pulumi.get(__response__, 'multicast_dns'),
        name=pulumi.get(__response__, 'name'),
        network_group=pulumi.get(__response__, 'network_group'),
        purpose=pulumi.get(__response__, 'purpose'),
        site=pulumi.get(__response__, 'site'),
        subnet=pulumi.get(__response__, 'subnet'),
        vlan_id=pulumi.get(__response__, 'vlan_id'),
        wan_dhcp_v6_pd_size=pulumi.get(__response__, 'wan_dhcp_v6_pd_size'),
        wan_dns=pulumi.get(__response__, 'wan_dns'),
        wan_egress_qos=pulumi.get(__response__, 'wan_egress_qos'),
        wan_gateway=pulumi.get(__response__, 'wan_gateway'),
        wan_gateway_v6=pulumi.get(__response__, 'wan_gateway_v6'),
        wan_ip=pulumi.get(__response__, 'wan_ip'),
        wan_ipv6=pulumi.get(__response__, 'wan_ipv6'),
        wan_netmask=pulumi.get(__response__, 'wan_netmask'),
        wan_networkgroup=pulumi.get(__response__, 'wan_networkgroup'),
        wan_prefixlen=pulumi.get(__response__, 'wan_prefixlen'),
        wan_type=pulumi.get(__response__, 'wan_type'),
        wan_type_v6=pulumi.get(__response__, 'wan_type_v6'),
        wan_username=pulumi.get(__response__, 'wan_username'),
        x_wan_password=pulumi.get(__response__, 'x_wan_password')))
