# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, blocked=None, dev_id_override=None, fixed_ip=None, hostname=None, id=None, ip=None, local_dns_record=None, mac=None, name=None, network_id=None, note=None, site=None, user_group_id=None):
        if blocked and not isinstance(blocked, bool):
            raise TypeError("Expected argument 'blocked' to be a bool")
        pulumi.set(__self__, "blocked", blocked)
        if dev_id_override and not isinstance(dev_id_override, int):
            raise TypeError("Expected argument 'dev_id_override' to be a int")
        pulumi.set(__self__, "dev_id_override", dev_id_override)
        if fixed_ip and not isinstance(fixed_ip, str):
            raise TypeError("Expected argument 'fixed_ip' to be a str")
        pulumi.set(__self__, "fixed_ip", fixed_ip)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if local_dns_record and not isinstance(local_dns_record, str):
            raise TypeError("Expected argument 'local_dns_record' to be a str")
        pulumi.set(__self__, "local_dns_record", local_dns_record)
        if mac and not isinstance(mac, str):
            raise TypeError("Expected argument 'mac' to be a str")
        pulumi.set(__self__, "mac", mac)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if note and not isinstance(note, str):
            raise TypeError("Expected argument 'note' to be a str")
        pulumi.set(__self__, "note", note)
        if site and not isinstance(site, str):
            raise TypeError("Expected argument 'site' to be a str")
        pulumi.set(__self__, "site", site)
        if user_group_id and not isinstance(user_group_id, str):
            raise TypeError("Expected argument 'user_group_id' to be a str")
        pulumi.set(__self__, "user_group_id", user_group_id)

    @_builtins.property
    @pulumi.getter
    def blocked(self) -> _builtins.bool:
        """
        Specifies whether this user should be blocked from the network.
        """
        return pulumi.get(self, "blocked")

    @_builtins.property
    @pulumi.getter(name="devIdOverride")
    def dev_id_override(self) -> _builtins.int:
        """
        Override the device fingerprint.
        """
        return pulumi.get(self, "dev_id_override")

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> _builtins.str:
        """
        fixed IPv4 address set for this user.
        """
        return pulumi.get(self, "fixed_ip")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of the user.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the user.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP address of the user.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="localDnsRecord")
    def local_dns_record(self) -> _builtins.str:
        """
        The local DNS record for this user.
        """
        return pulumi.get(self, "local_dns_record")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> _builtins.str:
        """
        The MAC address of the user.
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The network ID for this user.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def note(self) -> _builtins.str:
        """
        A note with additional information for the user.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def site(self) -> _builtins.str:
        """
        The name of the site the user is associated with.
        """
        return pulumi.get(self, "site")

    @_builtins.property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> _builtins.str:
        """
        The user group ID for the user.
        """
        return pulumi.get(self, "user_group_id")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            blocked=self.blocked,
            dev_id_override=self.dev_id_override,
            fixed_ip=self.fixed_ip,
            hostname=self.hostname,
            id=self.id,
            ip=self.ip,
            local_dns_record=self.local_dns_record,
            mac=self.mac,
            name=self.name,
            network_id=self.network_id,
            note=self.note,
            site=self.site,
            user_group_id=self.user_group_id)


def get_user(mac: Optional[_builtins.str] = None,
             site: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    `iam.User` retrieves properties of a user (or "client" in the UI) of the network by MAC address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    client = unifi.iam.get_user(mac="01:23:45:67:89:ab")
    ```


    :param _builtins.str mac: The MAC address of the user.
    :param _builtins.str site: The name of the site the user is associated with.
    """
    __args__ = dict()
    __args__['mac'] = mac
    __args__['site'] = site
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('unifi:iam/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        blocked=pulumi.get(__ret__, 'blocked'),
        dev_id_override=pulumi.get(__ret__, 'dev_id_override'),
        fixed_ip=pulumi.get(__ret__, 'fixed_ip'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        local_dns_record=pulumi.get(__ret__, 'local_dns_record'),
        mac=pulumi.get(__ret__, 'mac'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        note=pulumi.get(__ret__, 'note'),
        site=pulumi.get(__ret__, 'site'),
        user_group_id=pulumi.get(__ret__, 'user_group_id'))
def get_user_output(mac: Optional[pulumi.Input[_builtins.str]] = None,
                    site: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    `iam.User` retrieves properties of a user (or "client" in the UI) of the network by MAC address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_unifi as unifi

    client = unifi.iam.get_user(mac="01:23:45:67:89:ab")
    ```


    :param _builtins.str mac: The MAC address of the user.
    :param _builtins.str site: The name of the site the user is associated with.
    """
    __args__ = dict()
    __args__['mac'] = mac
    __args__['site'] = site
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('unifi:iam/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        blocked=pulumi.get(__response__, 'blocked'),
        dev_id_override=pulumi.get(__response__, 'dev_id_override'),
        fixed_ip=pulumi.get(__response__, 'fixed_ip'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        local_dns_record=pulumi.get(__response__, 'local_dns_record'),
        mac=pulumi.get(__response__, 'mac'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        note=pulumi.get(__response__, 'note'),
        site=pulumi.get(__response__, 'site'),
        user_group_id=pulumi.get(__response__, 'user_group_id')))
