# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 purpose: pulumi.Input[_builtins.str],
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_v6_dns_auto: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_v6_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 igmp_snooping: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 intra_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_start: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_ra_preferred_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_ra_priority: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dhcp_v6_pd_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_gateway_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_prefixlen: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_type: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_type_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_username: Optional[pulumi.Input[_builtins.str]] = None,
                 x_wan_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[_builtins.bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[_builtins.int] dhcp_lease: Specifies the lease time for DHCP addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[_builtins.str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[_builtins.str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_v6_dns: Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_dns_auto: Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_enabled: Enable stateful DHCPv6 for static configuration.
        :param pulumi.Input[_builtins.int] dhcp_v6_lease: Specifies the lease time for DHCPv6 addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] dhcp_v6_start: Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.str] dhcp_v6_stop: End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[_builtins.str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[_builtins.str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of this network.
        :param pulumi.Input[_builtins.bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[_builtins.bool] internet_access_enabled: Specifies whether this network should be allowed to access the internet or not. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] intra_network_access_enabled: Specifies whether this network should be allowed to access other local networks or not. Defaults to `true`.
        :param pulumi.Input[_builtins.str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        :param pulumi.Input[_builtins.str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[_builtins.str] ipv6_pd_start: Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.str] ipv6_pd_stop: End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[_builtins.int] ipv6_ra_preferred_lifetime: Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime` Defaults to `14400`.
        :param pulumi.Input[_builtins.str] ipv6_ra_priority: IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        :param pulumi.Input[_builtins.int] ipv6_ra_valid_lifetime: Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] ipv6_static_subnet: Specifies the static IPv6 subnet when `ipv6_interface_type` is 'static'.
        :param pulumi.Input[_builtins.bool] multicast_dns: Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[_builtins.str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the network with.
        :param pulumi.Input[_builtins.str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[_builtins.int] wan_dhcp_v6_pd_size: Specifies the IPv6 prefix size to request from ISP. Must be between 48 and 64.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[_builtins.int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[_builtins.str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_gateway_v6: The IPv6 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_ipv6: The IPv6 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[_builtins.str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[_builtins.int] wan_prefixlen: The IPv6 prefix length of the WAN. Must be between 1 and 128.
        :param pulumi.Input[_builtins.str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[_builtins.str] wan_type_v6: Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        :param pulumi.Input[_builtins.str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[_builtins.str] x_wan_password: Specifies the IPV4 WAN password.
        """
        pulumi.set(__self__, "purpose", purpose)
        if dhcp_dns is not None:
            pulumi.set(__self__, "dhcp_dns", dhcp_dns)
        if dhcp_enabled is not None:
            pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)
        if dhcp_lease is not None:
            pulumi.set(__self__, "dhcp_lease", dhcp_lease)
        if dhcp_relay_enabled is not None:
            pulumi.set(__self__, "dhcp_relay_enabled", dhcp_relay_enabled)
        if dhcp_start is not None:
            pulumi.set(__self__, "dhcp_start", dhcp_start)
        if dhcp_stop is not None:
            pulumi.set(__self__, "dhcp_stop", dhcp_stop)
        if dhcp_v6_dns is not None:
            pulumi.set(__self__, "dhcp_v6_dns", dhcp_v6_dns)
        if dhcp_v6_dns_auto is not None:
            pulumi.set(__self__, "dhcp_v6_dns_auto", dhcp_v6_dns_auto)
        if dhcp_v6_enabled is not None:
            pulumi.set(__self__, "dhcp_v6_enabled", dhcp_v6_enabled)
        if dhcp_v6_lease is not None:
            pulumi.set(__self__, "dhcp_v6_lease", dhcp_v6_lease)
        if dhcp_v6_start is not None:
            pulumi.set(__self__, "dhcp_v6_start", dhcp_v6_start)
        if dhcp_v6_stop is not None:
            pulumi.set(__self__, "dhcp_v6_stop", dhcp_v6_stop)
        if dhcpd_boot_enabled is not None:
            pulumi.set(__self__, "dhcpd_boot_enabled", dhcpd_boot_enabled)
        if dhcpd_boot_filename is not None:
            pulumi.set(__self__, "dhcpd_boot_filename", dhcpd_boot_filename)
        if dhcpd_boot_server is not None:
            pulumi.set(__self__, "dhcpd_boot_server", dhcpd_boot_server)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if igmp_snooping is not None:
            pulumi.set(__self__, "igmp_snooping", igmp_snooping)
        if internet_access_enabled is not None:
            pulumi.set(__self__, "internet_access_enabled", internet_access_enabled)
        if intra_network_access_enabled is not None:
            pulumi.set(__self__, "intra_network_access_enabled", intra_network_access_enabled)
        if ipv6_interface_type is not None:
            pulumi.set(__self__, "ipv6_interface_type", ipv6_interface_type)
        if ipv6_pd_interface is not None:
            pulumi.set(__self__, "ipv6_pd_interface", ipv6_pd_interface)
        if ipv6_pd_prefixid is not None:
            pulumi.set(__self__, "ipv6_pd_prefixid", ipv6_pd_prefixid)
        if ipv6_pd_start is not None:
            pulumi.set(__self__, "ipv6_pd_start", ipv6_pd_start)
        if ipv6_pd_stop is not None:
            pulumi.set(__self__, "ipv6_pd_stop", ipv6_pd_stop)
        if ipv6_ra_enable is not None:
            pulumi.set(__self__, "ipv6_ra_enable", ipv6_ra_enable)
        if ipv6_ra_preferred_lifetime is not None:
            pulumi.set(__self__, "ipv6_ra_preferred_lifetime", ipv6_ra_preferred_lifetime)
        if ipv6_ra_priority is not None:
            pulumi.set(__self__, "ipv6_ra_priority", ipv6_ra_priority)
        if ipv6_ra_valid_lifetime is not None:
            pulumi.set(__self__, "ipv6_ra_valid_lifetime", ipv6_ra_valid_lifetime)
        if ipv6_static_subnet is not None:
            pulumi.set(__self__, "ipv6_static_subnet", ipv6_static_subnet)
        if multicast_dns is not None:
            pulumi.set(__self__, "multicast_dns", multicast_dns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_group is not None:
            pulumi.set(__self__, "network_group", network_group)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wan_dhcp_v6_pd_size is not None:
            pulumi.set(__self__, "wan_dhcp_v6_pd_size", wan_dhcp_v6_pd_size)
        if wan_dns is not None:
            pulumi.set(__self__, "wan_dns", wan_dns)
        if wan_egress_qos is not None:
            pulumi.set(__self__, "wan_egress_qos", wan_egress_qos)
        if wan_gateway is not None:
            pulumi.set(__self__, "wan_gateway", wan_gateway)
        if wan_gateway_v6 is not None:
            pulumi.set(__self__, "wan_gateway_v6", wan_gateway_v6)
        if wan_ip is not None:
            pulumi.set(__self__, "wan_ip", wan_ip)
        if wan_ipv6 is not None:
            pulumi.set(__self__, "wan_ipv6", wan_ipv6)
        if wan_netmask is not None:
            pulumi.set(__self__, "wan_netmask", wan_netmask)
        if wan_networkgroup is not None:
            pulumi.set(__self__, "wan_networkgroup", wan_networkgroup)
        if wan_prefixlen is not None:
            pulumi.set(__self__, "wan_prefixlen", wan_prefixlen)
        if wan_type is not None:
            pulumi.set(__self__, "wan_type", wan_type)
        if wan_type_v6 is not None:
            pulumi.set(__self__, "wan_type_v6", wan_type_v6)
        if wan_username is not None:
            pulumi.set(__self__, "wan_username", wan_username)
        if x_wan_password is not None:
            pulumi.set(__self__, "x_wan_password", x_wan_password)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> pulumi.Input[_builtins.str]:
        """
        The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        """
        return pulumi.get(self, "dhcp_dns")

    @dhcp_dns.setter
    def dhcp_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_dns", value)

    @_builtins.property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether DHCP is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_enabled")

    @dhcp_enabled.setter
    def dhcp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpLease")
    def dhcp_lease(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the lease time for DHCP addresses in seconds. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_lease")

    @dhcp_lease.setter
    def dhcp_lease(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dhcp_lease", value)

    @_builtins.property
    @pulumi.getter(name="dhcpRelayEnabled")
    def dhcp_relay_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether DHCP relay is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_relay_enabled")

    @dhcp_relay_enabled.setter
    def dhcp_relay_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_relay_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpStart")
    def dhcp_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address where the DHCP range of addresses starts.
        """
        return pulumi.get(self, "dhcp_start")

    @dhcp_start.setter
    def dhcp_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_start", value)

    @_builtins.property
    @pulumi.getter(name="dhcpStop")
    def dhcp_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address where the DHCP range of addresses stops.
        """
        return pulumi.get(self, "dhcp_stop")

    @dhcp_stop.setter
    def dhcp_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_stop", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Dns")
    def dhcp_v6_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        """
        return pulumi.get(self, "dhcp_v6_dns")

    @dhcp_v6_dns.setter
    def dhcp_v6_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_v6_dns", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6DnsAuto")
    def dhcp_v6_dns_auto(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise Defaults to `true`.
        """
        return pulumi.get(self, "dhcp_v6_dns_auto")

    @dhcp_v6_dns_auto.setter
    def dhcp_v6_dns_auto(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_v6_dns_auto", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Enabled")
    def dhcp_v6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable stateful DHCPv6 for static configuration.
        """
        return pulumi.get(self, "dhcp_v6_enabled")

    @dhcp_v6_enabled.setter
    def dhcp_v6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_v6_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Lease")
    def dhcp_v6_lease(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the lease time for DHCPv6 addresses in seconds. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_v6_lease")

    @dhcp_v6_lease.setter
    def dhcp_v6_lease(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dhcp_v6_lease", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Start")
    def dhcp_v6_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_start")

    @dhcp_v6_start.setter
    def dhcp_v6_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_v6_start", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Stop")
    def dhcp_v6_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_stop")

    @dhcp_v6_stop.setter
    def dhcp_v6_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_v6_stop", value)

    @_builtins.property
    @pulumi.getter(name="dhcpdBootEnabled")
    def dhcpd_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        """
        return pulumi.get(self, "dhcpd_boot_enabled")

    @dhcpd_boot_enabled.setter
    def dhcpd_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcpd_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpdBootFilename")
    def dhcpd_boot_filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file to PXE boot from on the dhcpd*boot*server.
        """
        return pulumi.get(self, "dhcpd_boot_filename")

    @dhcpd_boot_filename.setter
    def dhcpd_boot_filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcpd_boot_filename", value)

    @_builtins.property
    @pulumi.getter(name="dhcpdBootServer")
    def dhcpd_boot_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPv4 address of a TFTP server to network boot from.
        """
        return pulumi.get(self, "dhcpd_boot_server")

    @dhcpd_boot_server.setter
    def dhcpd_boot_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcpd_boot_server", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of this network.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="igmpSnooping")
    def igmp_snooping(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether IGMP snooping is enabled or not.
        """
        return pulumi.get(self, "igmp_snooping")

    @igmp_snooping.setter
    def igmp_snooping(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "igmp_snooping", value)

    @_builtins.property
    @pulumi.getter(name="internetAccessEnabled")
    def internet_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this network should be allowed to access the internet or not. Defaults to `true`.
        """
        return pulumi.get(self, "internet_access_enabled")

    @internet_access_enabled.setter
    def internet_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="intraNetworkAccessEnabled")
    def intra_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this network should be allowed to access other local networks or not. Defaults to `true`.
        """
        return pulumi.get(self, "intra_network_access_enabled")

    @intra_network_access_enabled.setter
    def intra_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "intra_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipv6InterfaceType")
    def ipv6_interface_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`. Defaults to `none`.
        """
        return pulumi.get(self, "ipv6_interface_type")

    @ipv6_interface_type.setter
    def ipv6_interface_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_interface_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdInterface")
    def ipv6_pd_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        """
        return pulumi.get(self, "ipv6_pd_interface")

    @ipv6_pd_interface.setter
    def ipv6_pd_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_interface", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdPrefixid")
    def ipv6_pd_prefixid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPv6 Prefix ID.
        """
        return pulumi.get(self, "ipv6_pd_prefixid")

    @ipv6_pd_prefixid.setter
    def ipv6_pd_prefixid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_prefixid", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdStart")
    def ipv6_pd_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_start")

    @ipv6_pd_start.setter
    def ipv6_pd_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_start", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdStop")
    def ipv6_pd_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_stop")

    @ipv6_pd_stop.setter
    def ipv6_pd_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_stop", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaEnable")
    def ipv6_ra_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable router advertisements or not.
        """
        return pulumi.get(self, "ipv6_ra_enable")

    @ipv6_ra_enable.setter
    def ipv6_ra_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_ra_enable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaPreferredLifetime")
    def ipv6_ra_preferred_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime` Defaults to `14400`.
        """
        return pulumi.get(self, "ipv6_ra_preferred_lifetime")

    @ipv6_ra_preferred_lifetime.setter
    def ipv6_ra_preferred_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_ra_preferred_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaPriority")
    def ipv6_ra_priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        """
        return pulumi.get(self, "ipv6_ra_priority")

    @ipv6_ra_priority.setter
    def ipv6_ra_priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_ra_priority", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaValidLifetime")
    def ipv6_ra_valid_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`. Defaults to `86400`.
        """
        return pulumi.get(self, "ipv6_ra_valid_lifetime")

    @ipv6_ra_valid_lifetime.setter
    def ipv6_ra_valid_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_ra_valid_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipv6StaticSubnet")
    def ipv6_static_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the static IPv6 subnet when `ipv6_interface_type` is 'static'.
        """
        return pulumi.get(self, "ipv6_static_subnet")

    @ipv6_static_subnet.setter
    def ipv6_static_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_static_subnet", value)

    @_builtins.property
    @pulumi.getter(name="multicastDns")
    def multicast_dns(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        """
        return pulumi.get(self, "multicast_dns")

    @multicast_dns.setter
    def multicast_dns(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multicast_dns", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkGroup")
    def network_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group of the network. Defaults to `LAN`.
        """
        return pulumi.get(self, "network_group")

    @network_group.setter
    def network_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_group", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the network with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet of the network. Must be a valid CIDR address.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VLAN ID of the network.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="wanDhcpV6PdSize")
    def wan_dhcp_v6_pd_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IPv6 prefix size to request from ISP. Must be between 48 and 64.
        """
        return pulumi.get(self, "wan_dhcp_v6_pd_size")

    @wan_dhcp_v6_pd_size.setter
    def wan_dhcp_v6_pd_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wan_dhcp_v6_pd_size", value)

    @_builtins.property
    @pulumi.getter(name="wanDns")
    def wan_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        DNS servers IPs of the WAN.
        """
        return pulumi.get(self, "wan_dns")

    @wan_dns.setter
    def wan_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "wan_dns", value)

    @_builtins.property
    @pulumi.getter(name="wanEgressQos")
    def wan_egress_qos(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the WAN egress quality of service. Defaults to `0`.
        """
        return pulumi.get(self, "wan_egress_qos")

    @wan_egress_qos.setter
    def wan_egress_qos(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wan_egress_qos", value)

    @_builtins.property
    @pulumi.getter(name="wanGateway")
    def wan_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway")

    @wan_gateway.setter
    def wan_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_gateway", value)

    @_builtins.property
    @pulumi.getter(name="wanGatewayV6")
    def wan_gateway_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway_v6")

    @wan_gateway_v6.setter
    def wan_gateway_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_gateway_v6", value)

    @_builtins.property
    @pulumi.getter(name="wanIp")
    def wan_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address of the WAN.
        """
        return pulumi.get(self, "wan_ip")

    @wan_ip.setter
    def wan_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_ip", value)

    @_builtins.property
    @pulumi.getter(name="wanIpv6")
    def wan_ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address of the WAN.
        """
        return pulumi.get(self, "wan_ipv6")

    @wan_ipv6.setter
    def wan_ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="wanNetmask")
    def wan_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 netmask of the WAN.
        """
        return pulumi.get(self, "wan_netmask")

    @wan_netmask.setter
    def wan_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_netmask", value)

    @_builtins.property
    @pulumi.getter(name="wanNetworkgroup")
    def wan_networkgroup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        """
        return pulumi.get(self, "wan_networkgroup")

    @wan_networkgroup.setter
    def wan_networkgroup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_networkgroup", value)

    @_builtins.property
    @pulumi.getter(name="wanPrefixlen")
    def wan_prefixlen(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPv6 prefix length of the WAN. Must be between 1 and 128.
        """
        return pulumi.get(self, "wan_prefixlen")

    @wan_prefixlen.setter
    def wan_prefixlen(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wan_prefixlen", value)

    @_builtins.property
    @pulumi.getter(name="wanType")
    def wan_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        """
        return pulumi.get(self, "wan_type")

    @wan_type.setter
    def wan_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_type", value)

    @_builtins.property
    @pulumi.getter(name="wanTypeV6")
    def wan_type_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        """
        return pulumi.get(self, "wan_type_v6")

    @wan_type_v6.setter
    def wan_type_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_type_v6", value)

    @_builtins.property
    @pulumi.getter(name="wanUsername")
    def wan_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV4 WAN username.
        """
        return pulumi.get(self, "wan_username")

    @wan_username.setter
    def wan_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_username", value)

    @_builtins.property
    @pulumi.getter(name="xWanPassword")
    def x_wan_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV4 WAN password.
        """
        return pulumi.get(self, "x_wan_password")

    @x_wan_password.setter
    def x_wan_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_wan_password", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_v6_dns_auto: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_v6_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 igmp_snooping: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 intra_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_start: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_ra_preferred_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_ra_priority: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dhcp_v6_pd_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_gateway_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_prefixlen: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_type: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_type_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_username: Optional[pulumi.Input[_builtins.str]] = None,
                 x_wan_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[_builtins.bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[_builtins.int] dhcp_lease: Specifies the lease time for DHCP addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[_builtins.str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[_builtins.str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_v6_dns: Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_dns_auto: Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_enabled: Enable stateful DHCPv6 for static configuration.
        :param pulumi.Input[_builtins.int] dhcp_v6_lease: Specifies the lease time for DHCPv6 addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] dhcp_v6_start: Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.str] dhcp_v6_stop: End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[_builtins.str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[_builtins.str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of this network.
        :param pulumi.Input[_builtins.bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[_builtins.bool] internet_access_enabled: Specifies whether this network should be allowed to access the internet or not. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] intra_network_access_enabled: Specifies whether this network should be allowed to access other local networks or not. Defaults to `true`.
        :param pulumi.Input[_builtins.str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        :param pulumi.Input[_builtins.str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[_builtins.str] ipv6_pd_start: Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.str] ipv6_pd_stop: End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[_builtins.int] ipv6_ra_preferred_lifetime: Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime` Defaults to `14400`.
        :param pulumi.Input[_builtins.str] ipv6_ra_priority: IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        :param pulumi.Input[_builtins.int] ipv6_ra_valid_lifetime: Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] ipv6_static_subnet: Specifies the static IPv6 subnet when `ipv6_interface_type` is 'static'.
        :param pulumi.Input[_builtins.bool] multicast_dns: Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[_builtins.str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the network with.
        :param pulumi.Input[_builtins.str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[_builtins.int] wan_dhcp_v6_pd_size: Specifies the IPv6 prefix size to request from ISP. Must be between 48 and 64.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[_builtins.int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[_builtins.str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_gateway_v6: The IPv6 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_ipv6: The IPv6 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[_builtins.str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[_builtins.int] wan_prefixlen: The IPv6 prefix length of the WAN. Must be between 1 and 128.
        :param pulumi.Input[_builtins.str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[_builtins.str] wan_type_v6: Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        :param pulumi.Input[_builtins.str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[_builtins.str] x_wan_password: Specifies the IPV4 WAN password.
        """
        if dhcp_dns is not None:
            pulumi.set(__self__, "dhcp_dns", dhcp_dns)
        if dhcp_enabled is not None:
            pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)
        if dhcp_lease is not None:
            pulumi.set(__self__, "dhcp_lease", dhcp_lease)
        if dhcp_relay_enabled is not None:
            pulumi.set(__self__, "dhcp_relay_enabled", dhcp_relay_enabled)
        if dhcp_start is not None:
            pulumi.set(__self__, "dhcp_start", dhcp_start)
        if dhcp_stop is not None:
            pulumi.set(__self__, "dhcp_stop", dhcp_stop)
        if dhcp_v6_dns is not None:
            pulumi.set(__self__, "dhcp_v6_dns", dhcp_v6_dns)
        if dhcp_v6_dns_auto is not None:
            pulumi.set(__self__, "dhcp_v6_dns_auto", dhcp_v6_dns_auto)
        if dhcp_v6_enabled is not None:
            pulumi.set(__self__, "dhcp_v6_enabled", dhcp_v6_enabled)
        if dhcp_v6_lease is not None:
            pulumi.set(__self__, "dhcp_v6_lease", dhcp_v6_lease)
        if dhcp_v6_start is not None:
            pulumi.set(__self__, "dhcp_v6_start", dhcp_v6_start)
        if dhcp_v6_stop is not None:
            pulumi.set(__self__, "dhcp_v6_stop", dhcp_v6_stop)
        if dhcpd_boot_enabled is not None:
            pulumi.set(__self__, "dhcpd_boot_enabled", dhcpd_boot_enabled)
        if dhcpd_boot_filename is not None:
            pulumi.set(__self__, "dhcpd_boot_filename", dhcpd_boot_filename)
        if dhcpd_boot_server is not None:
            pulumi.set(__self__, "dhcpd_boot_server", dhcpd_boot_server)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if igmp_snooping is not None:
            pulumi.set(__self__, "igmp_snooping", igmp_snooping)
        if internet_access_enabled is not None:
            pulumi.set(__self__, "internet_access_enabled", internet_access_enabled)
        if intra_network_access_enabled is not None:
            pulumi.set(__self__, "intra_network_access_enabled", intra_network_access_enabled)
        if ipv6_interface_type is not None:
            pulumi.set(__self__, "ipv6_interface_type", ipv6_interface_type)
        if ipv6_pd_interface is not None:
            pulumi.set(__self__, "ipv6_pd_interface", ipv6_pd_interface)
        if ipv6_pd_prefixid is not None:
            pulumi.set(__self__, "ipv6_pd_prefixid", ipv6_pd_prefixid)
        if ipv6_pd_start is not None:
            pulumi.set(__self__, "ipv6_pd_start", ipv6_pd_start)
        if ipv6_pd_stop is not None:
            pulumi.set(__self__, "ipv6_pd_stop", ipv6_pd_stop)
        if ipv6_ra_enable is not None:
            pulumi.set(__self__, "ipv6_ra_enable", ipv6_ra_enable)
        if ipv6_ra_preferred_lifetime is not None:
            pulumi.set(__self__, "ipv6_ra_preferred_lifetime", ipv6_ra_preferred_lifetime)
        if ipv6_ra_priority is not None:
            pulumi.set(__self__, "ipv6_ra_priority", ipv6_ra_priority)
        if ipv6_ra_valid_lifetime is not None:
            pulumi.set(__self__, "ipv6_ra_valid_lifetime", ipv6_ra_valid_lifetime)
        if ipv6_static_subnet is not None:
            pulumi.set(__self__, "ipv6_static_subnet", ipv6_static_subnet)
        if multicast_dns is not None:
            pulumi.set(__self__, "multicast_dns", multicast_dns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_group is not None:
            pulumi.set(__self__, "network_group", network_group)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wan_dhcp_v6_pd_size is not None:
            pulumi.set(__self__, "wan_dhcp_v6_pd_size", wan_dhcp_v6_pd_size)
        if wan_dns is not None:
            pulumi.set(__self__, "wan_dns", wan_dns)
        if wan_egress_qos is not None:
            pulumi.set(__self__, "wan_egress_qos", wan_egress_qos)
        if wan_gateway is not None:
            pulumi.set(__self__, "wan_gateway", wan_gateway)
        if wan_gateway_v6 is not None:
            pulumi.set(__self__, "wan_gateway_v6", wan_gateway_v6)
        if wan_ip is not None:
            pulumi.set(__self__, "wan_ip", wan_ip)
        if wan_ipv6 is not None:
            pulumi.set(__self__, "wan_ipv6", wan_ipv6)
        if wan_netmask is not None:
            pulumi.set(__self__, "wan_netmask", wan_netmask)
        if wan_networkgroup is not None:
            pulumi.set(__self__, "wan_networkgroup", wan_networkgroup)
        if wan_prefixlen is not None:
            pulumi.set(__self__, "wan_prefixlen", wan_prefixlen)
        if wan_type is not None:
            pulumi.set(__self__, "wan_type", wan_type)
        if wan_type_v6 is not None:
            pulumi.set(__self__, "wan_type_v6", wan_type_v6)
        if wan_username is not None:
            pulumi.set(__self__, "wan_username", wan_username)
        if x_wan_password is not None:
            pulumi.set(__self__, "x_wan_password", x_wan_password)

    @_builtins.property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        """
        return pulumi.get(self, "dhcp_dns")

    @dhcp_dns.setter
    def dhcp_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_dns", value)

    @_builtins.property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether DHCP is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_enabled")

    @dhcp_enabled.setter
    def dhcp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpLease")
    def dhcp_lease(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the lease time for DHCP addresses in seconds. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_lease")

    @dhcp_lease.setter
    def dhcp_lease(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dhcp_lease", value)

    @_builtins.property
    @pulumi.getter(name="dhcpRelayEnabled")
    def dhcp_relay_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether DHCP relay is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_relay_enabled")

    @dhcp_relay_enabled.setter
    def dhcp_relay_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_relay_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpStart")
    def dhcp_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address where the DHCP range of addresses starts.
        """
        return pulumi.get(self, "dhcp_start")

    @dhcp_start.setter
    def dhcp_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_start", value)

    @_builtins.property
    @pulumi.getter(name="dhcpStop")
    def dhcp_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address where the DHCP range of addresses stops.
        """
        return pulumi.get(self, "dhcp_stop")

    @dhcp_stop.setter
    def dhcp_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_stop", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Dns")
    def dhcp_v6_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        """
        return pulumi.get(self, "dhcp_v6_dns")

    @dhcp_v6_dns.setter
    def dhcp_v6_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dhcp_v6_dns", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6DnsAuto")
    def dhcp_v6_dns_auto(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise Defaults to `true`.
        """
        return pulumi.get(self, "dhcp_v6_dns_auto")

    @dhcp_v6_dns_auto.setter
    def dhcp_v6_dns_auto(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_v6_dns_auto", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Enabled")
    def dhcp_v6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable stateful DHCPv6 for static configuration.
        """
        return pulumi.get(self, "dhcp_v6_enabled")

    @dhcp_v6_enabled.setter
    def dhcp_v6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_v6_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Lease")
    def dhcp_v6_lease(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the lease time for DHCPv6 addresses in seconds. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_v6_lease")

    @dhcp_v6_lease.setter
    def dhcp_v6_lease(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dhcp_v6_lease", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Start")
    def dhcp_v6_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_start")

    @dhcp_v6_start.setter
    def dhcp_v6_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_v6_start", value)

    @_builtins.property
    @pulumi.getter(name="dhcpV6Stop")
    def dhcp_v6_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_stop")

    @dhcp_v6_stop.setter
    def dhcp_v6_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcp_v6_stop", value)

    @_builtins.property
    @pulumi.getter(name="dhcpdBootEnabled")
    def dhcpd_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        """
        return pulumi.get(self, "dhcpd_boot_enabled")

    @dhcpd_boot_enabled.setter
    def dhcpd_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcpd_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dhcpdBootFilename")
    def dhcpd_boot_filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file to PXE boot from on the dhcpd*boot*server.
        """
        return pulumi.get(self, "dhcpd_boot_filename")

    @dhcpd_boot_filename.setter
    def dhcpd_boot_filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcpd_boot_filename", value)

    @_builtins.property
    @pulumi.getter(name="dhcpdBootServer")
    def dhcpd_boot_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPv4 address of a TFTP server to network boot from.
        """
        return pulumi.get(self, "dhcpd_boot_server")

    @dhcpd_boot_server.setter
    def dhcpd_boot_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dhcpd_boot_server", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of this network.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="igmpSnooping")
    def igmp_snooping(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether IGMP snooping is enabled or not.
        """
        return pulumi.get(self, "igmp_snooping")

    @igmp_snooping.setter
    def igmp_snooping(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "igmp_snooping", value)

    @_builtins.property
    @pulumi.getter(name="internetAccessEnabled")
    def internet_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this network should be allowed to access the internet or not. Defaults to `true`.
        """
        return pulumi.get(self, "internet_access_enabled")

    @internet_access_enabled.setter
    def internet_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="intraNetworkAccessEnabled")
    def intra_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this network should be allowed to access other local networks or not. Defaults to `true`.
        """
        return pulumi.get(self, "intra_network_access_enabled")

    @intra_network_access_enabled.setter
    def intra_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "intra_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipv6InterfaceType")
    def ipv6_interface_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`. Defaults to `none`.
        """
        return pulumi.get(self, "ipv6_interface_type")

    @ipv6_interface_type.setter
    def ipv6_interface_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_interface_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdInterface")
    def ipv6_pd_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        """
        return pulumi.get(self, "ipv6_pd_interface")

    @ipv6_pd_interface.setter
    def ipv6_pd_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_interface", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdPrefixid")
    def ipv6_pd_prefixid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPv6 Prefix ID.
        """
        return pulumi.get(self, "ipv6_pd_prefixid")

    @ipv6_pd_prefixid.setter
    def ipv6_pd_prefixid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_prefixid", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdStart")
    def ipv6_pd_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_start")

    @ipv6_pd_start.setter
    def ipv6_pd_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_start", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PdStop")
    def ipv6_pd_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_stop")

    @ipv6_pd_stop.setter
    def ipv6_pd_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_pd_stop", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaEnable")
    def ipv6_ra_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable router advertisements or not.
        """
        return pulumi.get(self, "ipv6_ra_enable")

    @ipv6_ra_enable.setter
    def ipv6_ra_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_ra_enable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaPreferredLifetime")
    def ipv6_ra_preferred_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime` Defaults to `14400`.
        """
        return pulumi.get(self, "ipv6_ra_preferred_lifetime")

    @ipv6_ra_preferred_lifetime.setter
    def ipv6_ra_preferred_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_ra_preferred_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaPriority")
    def ipv6_ra_priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        """
        return pulumi.get(self, "ipv6_ra_priority")

    @ipv6_ra_priority.setter
    def ipv6_ra_priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_ra_priority", value)

    @_builtins.property
    @pulumi.getter(name="ipv6RaValidLifetime")
    def ipv6_ra_valid_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`. Defaults to `86400`.
        """
        return pulumi.get(self, "ipv6_ra_valid_lifetime")

    @ipv6_ra_valid_lifetime.setter
    def ipv6_ra_valid_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_ra_valid_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="ipv6StaticSubnet")
    def ipv6_static_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the static IPv6 subnet when `ipv6_interface_type` is 'static'.
        """
        return pulumi.get(self, "ipv6_static_subnet")

    @ipv6_static_subnet.setter
    def ipv6_static_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_static_subnet", value)

    @_builtins.property
    @pulumi.getter(name="multicastDns")
    def multicast_dns(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        """
        return pulumi.get(self, "multicast_dns")

    @multicast_dns.setter
    def multicast_dns(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multicast_dns", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkGroup")
    def network_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group of the network. Defaults to `LAN`.
        """
        return pulumi.get(self, "network_group")

    @network_group.setter
    def network_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_group", value)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the network with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet of the network. Must be a valid CIDR address.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VLAN ID of the network.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="wanDhcpV6PdSize")
    def wan_dhcp_v6_pd_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IPv6 prefix size to request from ISP. Must be between 48 and 64.
        """
        return pulumi.get(self, "wan_dhcp_v6_pd_size")

    @wan_dhcp_v6_pd_size.setter
    def wan_dhcp_v6_pd_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wan_dhcp_v6_pd_size", value)

    @_builtins.property
    @pulumi.getter(name="wanDns")
    def wan_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        DNS servers IPs of the WAN.
        """
        return pulumi.get(self, "wan_dns")

    @wan_dns.setter
    def wan_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "wan_dns", value)

    @_builtins.property
    @pulumi.getter(name="wanEgressQos")
    def wan_egress_qos(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the WAN egress quality of service. Defaults to `0`.
        """
        return pulumi.get(self, "wan_egress_qos")

    @wan_egress_qos.setter
    def wan_egress_qos(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wan_egress_qos", value)

    @_builtins.property
    @pulumi.getter(name="wanGateway")
    def wan_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway")

    @wan_gateway.setter
    def wan_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_gateway", value)

    @_builtins.property
    @pulumi.getter(name="wanGatewayV6")
    def wan_gateway_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway_v6")

    @wan_gateway_v6.setter
    def wan_gateway_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_gateway_v6", value)

    @_builtins.property
    @pulumi.getter(name="wanIp")
    def wan_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address of the WAN.
        """
        return pulumi.get(self, "wan_ip")

    @wan_ip.setter
    def wan_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_ip", value)

    @_builtins.property
    @pulumi.getter(name="wanIpv6")
    def wan_ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address of the WAN.
        """
        return pulumi.get(self, "wan_ipv6")

    @wan_ipv6.setter
    def wan_ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="wanNetmask")
    def wan_netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 netmask of the WAN.
        """
        return pulumi.get(self, "wan_netmask")

    @wan_netmask.setter
    def wan_netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_netmask", value)

    @_builtins.property
    @pulumi.getter(name="wanNetworkgroup")
    def wan_networkgroup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        """
        return pulumi.get(self, "wan_networkgroup")

    @wan_networkgroup.setter
    def wan_networkgroup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_networkgroup", value)

    @_builtins.property
    @pulumi.getter(name="wanPrefixlen")
    def wan_prefixlen(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPv6 prefix length of the WAN. Must be between 1 and 128.
        """
        return pulumi.get(self, "wan_prefixlen")

    @wan_prefixlen.setter
    def wan_prefixlen(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "wan_prefixlen", value)

    @_builtins.property
    @pulumi.getter(name="wanType")
    def wan_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        """
        return pulumi.get(self, "wan_type")

    @wan_type.setter
    def wan_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_type", value)

    @_builtins.property
    @pulumi.getter(name="wanTypeV6")
    def wan_type_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        """
        return pulumi.get(self, "wan_type_v6")

    @wan_type_v6.setter
    def wan_type_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_type_v6", value)

    @_builtins.property
    @pulumi.getter(name="wanUsername")
    def wan_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV4 WAN username.
        """
        return pulumi.get(self, "wan_username")

    @wan_username.setter
    def wan_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wan_username", value)

    @_builtins.property
    @pulumi.getter(name="xWanPassword")
    def x_wan_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IPV4 WAN password.
        """
        return pulumi.get(self, "x_wan_password")

    @x_wan_password.setter
    def x_wan_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "x_wan_password", value)


@pulumi.type_token("unifi:index/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_v6_dns_auto: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_v6_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 igmp_snooping: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 intra_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_start: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_ra_preferred_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_ra_priority: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dhcp_v6_pd_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_gateway_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_prefixlen: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_type: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_type_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_username: Optional[pulumi.Input[_builtins.str]] = None,
                 x_wan_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `Network` manages WAN/LAN/VLAN networks.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        vlan = unifi.Network("vlan",
            name="wifi-vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        wan = unifi.Network("wan",
            name="wan",
            purpose="wan",
            wan_networkgroup="WAN",
            wan_type="pppoe",
            wan_ip="192.168.1.1",
            wan_egress_qos=1,
            wan_username="username",
            x_wan_password="password")
        ```

        ## Import

        import from provider configured site

        ```sh
        $ pulumi import unifi:index/network:Network mynetwork 5dc28e5e9106d105bdc87217
        ```

        import from another site

        ```sh
        $ pulumi import unifi:index/network:Network mynetwork bfa2l6i7:5dc28e5e9106d105bdc87217
        ```

        import network by name

        ```sh
        $ pulumi import unifi:index/network:Network mynetwork name=LAN
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[_builtins.bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[_builtins.int] dhcp_lease: Specifies the lease time for DHCP addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[_builtins.str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[_builtins.str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_v6_dns: Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_dns_auto: Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_enabled: Enable stateful DHCPv6 for static configuration.
        :param pulumi.Input[_builtins.int] dhcp_v6_lease: Specifies the lease time for DHCPv6 addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] dhcp_v6_start: Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.str] dhcp_v6_stop: End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[_builtins.str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[_builtins.str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of this network.
        :param pulumi.Input[_builtins.bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[_builtins.bool] internet_access_enabled: Specifies whether this network should be allowed to access the internet or not. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] intra_network_access_enabled: Specifies whether this network should be allowed to access other local networks or not. Defaults to `true`.
        :param pulumi.Input[_builtins.str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        :param pulumi.Input[_builtins.str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[_builtins.str] ipv6_pd_start: Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.str] ipv6_pd_stop: End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[_builtins.int] ipv6_ra_preferred_lifetime: Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime` Defaults to `14400`.
        :param pulumi.Input[_builtins.str] ipv6_ra_priority: IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        :param pulumi.Input[_builtins.int] ipv6_ra_valid_lifetime: Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] ipv6_static_subnet: Specifies the static IPv6 subnet when `ipv6_interface_type` is 'static'.
        :param pulumi.Input[_builtins.bool] multicast_dns: Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[_builtins.str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the network with.
        :param pulumi.Input[_builtins.str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[_builtins.int] wan_dhcp_v6_pd_size: Specifies the IPv6 prefix size to request from ISP. Must be between 48 and 64.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[_builtins.int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[_builtins.str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_gateway_v6: The IPv6 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_ipv6: The IPv6 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[_builtins.str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[_builtins.int] wan_prefixlen: The IPv6 prefix length of the WAN. Must be between 1 and 128.
        :param pulumi.Input[_builtins.str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[_builtins.str] wan_type_v6: Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        :param pulumi.Input[_builtins.str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[_builtins.str] x_wan_password: Specifies the IPV4 WAN password.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `Network` manages WAN/LAN/VLAN networks.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        vlan = unifi.Network("vlan",
            name="wifi-vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        wan = unifi.Network("wan",
            name="wan",
            purpose="wan",
            wan_networkgroup="WAN",
            wan_type="pppoe",
            wan_ip="192.168.1.1",
            wan_egress_qos=1,
            wan_username="username",
            x_wan_password="password")
        ```

        ## Import

        import from provider configured site

        ```sh
        $ pulumi import unifi:index/network:Network mynetwork 5dc28e5e9106d105bdc87217
        ```

        import from another site

        ```sh
        $ pulumi import unifi:index/network:Network mynetwork bfa2l6i7:5dc28e5e9106d105bdc87217
        ```

        import network by name

        ```sh
        $ pulumi import unifi:index/network:Network mynetwork name=LAN
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dhcp_v6_dns_auto: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcp_v6_lease: Optional[pulumi.Input[_builtins.int]] = None,
                 dhcp_v6_start: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcp_v6_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[_builtins.str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 igmp_snooping: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 intra_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_start: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_pd_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_ra_preferred_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_ra_priority: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ra_valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 multicast_dns: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dhcp_v6_pd_size: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_gateway_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_prefixlen: Optional[pulumi.Input[_builtins.int]] = None,
                 wan_type: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_type_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 wan_username: Optional[pulumi.Input[_builtins.str]] = None,
                 x_wan_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["dhcp_dns"] = dhcp_dns
            __props__.__dict__["dhcp_enabled"] = dhcp_enabled
            __props__.__dict__["dhcp_lease"] = dhcp_lease
            __props__.__dict__["dhcp_relay_enabled"] = dhcp_relay_enabled
            __props__.__dict__["dhcp_start"] = dhcp_start
            __props__.__dict__["dhcp_stop"] = dhcp_stop
            __props__.__dict__["dhcp_v6_dns"] = dhcp_v6_dns
            __props__.__dict__["dhcp_v6_dns_auto"] = dhcp_v6_dns_auto
            __props__.__dict__["dhcp_v6_enabled"] = dhcp_v6_enabled
            __props__.__dict__["dhcp_v6_lease"] = dhcp_v6_lease
            __props__.__dict__["dhcp_v6_start"] = dhcp_v6_start
            __props__.__dict__["dhcp_v6_stop"] = dhcp_v6_stop
            __props__.__dict__["dhcpd_boot_enabled"] = dhcpd_boot_enabled
            __props__.__dict__["dhcpd_boot_filename"] = dhcpd_boot_filename
            __props__.__dict__["dhcpd_boot_server"] = dhcpd_boot_server
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["igmp_snooping"] = igmp_snooping
            __props__.__dict__["internet_access_enabled"] = internet_access_enabled
            __props__.__dict__["intra_network_access_enabled"] = intra_network_access_enabled
            __props__.__dict__["ipv6_interface_type"] = ipv6_interface_type
            __props__.__dict__["ipv6_pd_interface"] = ipv6_pd_interface
            __props__.__dict__["ipv6_pd_prefixid"] = ipv6_pd_prefixid
            __props__.__dict__["ipv6_pd_start"] = ipv6_pd_start
            __props__.__dict__["ipv6_pd_stop"] = ipv6_pd_stop
            __props__.__dict__["ipv6_ra_enable"] = ipv6_ra_enable
            __props__.__dict__["ipv6_ra_preferred_lifetime"] = ipv6_ra_preferred_lifetime
            __props__.__dict__["ipv6_ra_priority"] = ipv6_ra_priority
            __props__.__dict__["ipv6_ra_valid_lifetime"] = ipv6_ra_valid_lifetime
            __props__.__dict__["ipv6_static_subnet"] = ipv6_static_subnet
            __props__.__dict__["multicast_dns"] = multicast_dns
            __props__.__dict__["name"] = name
            __props__.__dict__["network_group"] = network_group
            if purpose is None and not opts.urn:
                raise TypeError("Missing required property 'purpose'")
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["site"] = site
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["wan_dhcp_v6_pd_size"] = wan_dhcp_v6_pd_size
            __props__.__dict__["wan_dns"] = wan_dns
            __props__.__dict__["wan_egress_qos"] = wan_egress_qos
            __props__.__dict__["wan_gateway"] = wan_gateway
            __props__.__dict__["wan_gateway_v6"] = wan_gateway_v6
            __props__.__dict__["wan_ip"] = wan_ip
            __props__.__dict__["wan_ipv6"] = wan_ipv6
            __props__.__dict__["wan_netmask"] = wan_netmask
            __props__.__dict__["wan_networkgroup"] = wan_networkgroup
            __props__.__dict__["wan_prefixlen"] = wan_prefixlen
            __props__.__dict__["wan_type"] = wan_type
            __props__.__dict__["wan_type_v6"] = wan_type_v6
            __props__.__dict__["wan_username"] = wan_username
            __props__.__dict__["x_wan_password"] = x_wan_password
        super(Network, __self__).__init__(
            'unifi:index/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dhcp_lease: Optional[pulumi.Input[_builtins.int]] = None,
            dhcp_relay_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dhcp_start: Optional[pulumi.Input[_builtins.str]] = None,
            dhcp_stop: Optional[pulumi.Input[_builtins.str]] = None,
            dhcp_v6_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dhcp_v6_dns_auto: Optional[pulumi.Input[_builtins.bool]] = None,
            dhcp_v6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dhcp_v6_lease: Optional[pulumi.Input[_builtins.int]] = None,
            dhcp_v6_start: Optional[pulumi.Input[_builtins.str]] = None,
            dhcp_v6_stop: Optional[pulumi.Input[_builtins.str]] = None,
            dhcpd_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            dhcpd_boot_filename: Optional[pulumi.Input[_builtins.str]] = None,
            dhcpd_boot_server: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            igmp_snooping: Optional[pulumi.Input[_builtins.bool]] = None,
            internet_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            intra_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6_interface_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_pd_interface: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_pd_prefixid: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_pd_start: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_pd_stop: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_ra_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6_ra_preferred_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_ra_priority: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_ra_valid_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_static_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            multicast_dns: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_group: Optional[pulumi.Input[_builtins.str]] = None,
            purpose: Optional[pulumi.Input[_builtins.str]] = None,
            site: Optional[pulumi.Input[_builtins.str]] = None,
            subnet: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
            wan_dhcp_v6_pd_size: Optional[pulumi.Input[_builtins.int]] = None,
            wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            wan_egress_qos: Optional[pulumi.Input[_builtins.int]] = None,
            wan_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            wan_gateway_v6: Optional[pulumi.Input[_builtins.str]] = None,
            wan_ip: Optional[pulumi.Input[_builtins.str]] = None,
            wan_ipv6: Optional[pulumi.Input[_builtins.str]] = None,
            wan_netmask: Optional[pulumi.Input[_builtins.str]] = None,
            wan_networkgroup: Optional[pulumi.Input[_builtins.str]] = None,
            wan_prefixlen: Optional[pulumi.Input[_builtins.int]] = None,
            wan_type: Optional[pulumi.Input[_builtins.str]] = None,
            wan_type_v6: Optional[pulumi.Input[_builtins.str]] = None,
            wan_username: Optional[pulumi.Input[_builtins.str]] = None,
            x_wan_password: Optional[pulumi.Input[_builtins.str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[_builtins.bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[_builtins.int] dhcp_lease: Specifies the lease time for DHCP addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[_builtins.str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[_builtins.str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dhcp_v6_dns: Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_dns_auto: Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise Defaults to `true`.
        :param pulumi.Input[_builtins.bool] dhcp_v6_enabled: Enable stateful DHCPv6 for static configuration.
        :param pulumi.Input[_builtins.int] dhcp_v6_lease: Specifies the lease time for DHCPv6 addresses in seconds. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] dhcp_v6_start: Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.str] dhcp_v6_stop: End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        :param pulumi.Input[_builtins.bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[_builtins.str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[_builtins.str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[_builtins.str] domain_name: The domain name of this network.
        :param pulumi.Input[_builtins.bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[_builtins.bool] internet_access_enabled: Specifies whether this network should be allowed to access the internet or not. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] intra_network_access_enabled: Specifies whether this network should be allowed to access other local networks or not. Defaults to `true`.
        :param pulumi.Input[_builtins.str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        :param pulumi.Input[_builtins.str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[_builtins.str] ipv6_pd_start: Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.str] ipv6_pd_stop: End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        :param pulumi.Input[_builtins.bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[_builtins.int] ipv6_ra_preferred_lifetime: Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime` Defaults to `14400`.
        :param pulumi.Input[_builtins.str] ipv6_ra_priority: IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        :param pulumi.Input[_builtins.int] ipv6_ra_valid_lifetime: Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`. Defaults to `86400`.
        :param pulumi.Input[_builtins.str] ipv6_static_subnet: Specifies the static IPv6 subnet when `ipv6_interface_type` is 'static'.
        :param pulumi.Input[_builtins.bool] multicast_dns: Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[_builtins.str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[_builtins.str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the network with.
        :param pulumi.Input[_builtins.str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[_builtins.int] wan_dhcp_v6_pd_size: Specifies the IPv6 prefix size to request from ISP. Must be between 48 and 64.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[_builtins.int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[_builtins.str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_gateway_v6: The IPv6 gateway of the WAN.
        :param pulumi.Input[_builtins.str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_ipv6: The IPv6 address of the WAN.
        :param pulumi.Input[_builtins.str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[_builtins.str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[_builtins.int] wan_prefixlen: The IPv6 prefix length of the WAN. Must be between 1 and 128.
        :param pulumi.Input[_builtins.str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[_builtins.str] wan_type_v6: Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        :param pulumi.Input[_builtins.str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[_builtins.str] x_wan_password: Specifies the IPV4 WAN password.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["dhcp_dns"] = dhcp_dns
        __props__.__dict__["dhcp_enabled"] = dhcp_enabled
        __props__.__dict__["dhcp_lease"] = dhcp_lease
        __props__.__dict__["dhcp_relay_enabled"] = dhcp_relay_enabled
        __props__.__dict__["dhcp_start"] = dhcp_start
        __props__.__dict__["dhcp_stop"] = dhcp_stop
        __props__.__dict__["dhcp_v6_dns"] = dhcp_v6_dns
        __props__.__dict__["dhcp_v6_dns_auto"] = dhcp_v6_dns_auto
        __props__.__dict__["dhcp_v6_enabled"] = dhcp_v6_enabled
        __props__.__dict__["dhcp_v6_lease"] = dhcp_v6_lease
        __props__.__dict__["dhcp_v6_start"] = dhcp_v6_start
        __props__.__dict__["dhcp_v6_stop"] = dhcp_v6_stop
        __props__.__dict__["dhcpd_boot_enabled"] = dhcpd_boot_enabled
        __props__.__dict__["dhcpd_boot_filename"] = dhcpd_boot_filename
        __props__.__dict__["dhcpd_boot_server"] = dhcpd_boot_server
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["igmp_snooping"] = igmp_snooping
        __props__.__dict__["internet_access_enabled"] = internet_access_enabled
        __props__.__dict__["intra_network_access_enabled"] = intra_network_access_enabled
        __props__.__dict__["ipv6_interface_type"] = ipv6_interface_type
        __props__.__dict__["ipv6_pd_interface"] = ipv6_pd_interface
        __props__.__dict__["ipv6_pd_prefixid"] = ipv6_pd_prefixid
        __props__.__dict__["ipv6_pd_start"] = ipv6_pd_start
        __props__.__dict__["ipv6_pd_stop"] = ipv6_pd_stop
        __props__.__dict__["ipv6_ra_enable"] = ipv6_ra_enable
        __props__.__dict__["ipv6_ra_preferred_lifetime"] = ipv6_ra_preferred_lifetime
        __props__.__dict__["ipv6_ra_priority"] = ipv6_ra_priority
        __props__.__dict__["ipv6_ra_valid_lifetime"] = ipv6_ra_valid_lifetime
        __props__.__dict__["ipv6_static_subnet"] = ipv6_static_subnet
        __props__.__dict__["multicast_dns"] = multicast_dns
        __props__.__dict__["name"] = name
        __props__.__dict__["network_group"] = network_group
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["site"] = site
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["wan_dhcp_v6_pd_size"] = wan_dhcp_v6_pd_size
        __props__.__dict__["wan_dns"] = wan_dns
        __props__.__dict__["wan_egress_qos"] = wan_egress_qos
        __props__.__dict__["wan_gateway"] = wan_gateway
        __props__.__dict__["wan_gateway_v6"] = wan_gateway_v6
        __props__.__dict__["wan_ip"] = wan_ip
        __props__.__dict__["wan_ipv6"] = wan_ipv6
        __props__.__dict__["wan_netmask"] = wan_netmask
        __props__.__dict__["wan_networkgroup"] = wan_networkgroup
        __props__.__dict__["wan_prefixlen"] = wan_prefixlen
        __props__.__dict__["wan_type"] = wan_type
        __props__.__dict__["wan_type_v6"] = wan_type_v6
        __props__.__dict__["wan_username"] = wan_username
        __props__.__dict__["x_wan_password"] = x_wan_password
        return Network(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        """
        return pulumi.get(self, "dhcp_dns")

    @_builtins.property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether DHCP is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_enabled")

    @_builtins.property
    @pulumi.getter(name="dhcpLease")
    def dhcp_lease(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the lease time for DHCP addresses in seconds. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_lease")

    @_builtins.property
    @pulumi.getter(name="dhcpRelayEnabled")
    def dhcp_relay_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether DHCP relay is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_relay_enabled")

    @_builtins.property
    @pulumi.getter(name="dhcpStart")
    def dhcp_start(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 address where the DHCP range of addresses starts.
        """
        return pulumi.get(self, "dhcp_start")

    @_builtins.property
    @pulumi.getter(name="dhcpStop")
    def dhcp_stop(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 address where the DHCP range of addresses stops.
        """
        return pulumi.get(self, "dhcp_stop")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Dns")
    def dhcp_v6_dns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the IPv6 addresses for the DNS server to be returned from the DHCP server. Used if `dhcp_v6_dns_auto` is set to `false`.
        """
        return pulumi.get(self, "dhcp_v6_dns")

    @_builtins.property
    @pulumi.getter(name="dhcpV6DnsAuto")
    def dhcp_v6_dns_auto(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies DNS source to propagate. If set `false` the entries in `dhcp_v6_dns` are used, the upstream entries otherwise Defaults to `true`.
        """
        return pulumi.get(self, "dhcp_v6_dns_auto")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Enabled")
    def dhcp_v6_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable stateful DHCPv6 for static configuration.
        """
        return pulumi.get(self, "dhcp_v6_enabled")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Lease")
    def dhcp_v6_lease(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the lease time for DHCPv6 addresses in seconds. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_v6_lease")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Start")
    def dhcp_v6_start(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Start address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_start")

    @_builtins.property
    @pulumi.getter(name="dhcpV6Stop")
    def dhcp_v6_stop(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        End address of the DHCPv6 range. Used in static DHCPv6 configuration.
        """
        return pulumi.get(self, "dhcp_v6_stop")

    @_builtins.property
    @pulumi.getter(name="dhcpdBootEnabled")
    def dhcpd_boot_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        """
        return pulumi.get(self, "dhcpd_boot_enabled")

    @_builtins.property
    @pulumi.getter(name="dhcpdBootFilename")
    def dhcpd_boot_filename(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the file to PXE boot from on the dhcpd*boot*server.
        """
        return pulumi.get(self, "dhcpd_boot_filename")

    @_builtins.property
    @pulumi.getter(name="dhcpdBootServer")
    def dhcpd_boot_server(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the IPv4 address of a TFTP server to network boot from.
        """
        return pulumi.get(self, "dhcpd_boot_server")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain name of this network.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="igmpSnooping")
    def igmp_snooping(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether IGMP snooping is enabled or not.
        """
        return pulumi.get(self, "igmp_snooping")

    @_builtins.property
    @pulumi.getter(name="internetAccessEnabled")
    def internet_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether this network should be allowed to access the internet or not. Defaults to `true`.
        """
        return pulumi.get(self, "internet_access_enabled")

    @_builtins.property
    @pulumi.getter(name="intraNetworkAccessEnabled")
    def intra_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether this network should be allowed to access other local networks or not. Defaults to `true`.
        """
        return pulumi.get(self, "intra_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="ipv6InterfaceType")
    def ipv6_interface_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies which type of IPv6 connection to use. Must be one of either `static`, `pd`, or `none`. Defaults to `none`.
        """
        return pulumi.get(self, "ipv6_interface_type")

    @_builtins.property
    @pulumi.getter(name="ipv6PdInterface")
    def ipv6_pd_interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies which WAN interface to use for IPv6 PD. Must be one of either `wan` or `wan2`.
        """
        return pulumi.get(self, "ipv6_pd_interface")

    @_builtins.property
    @pulumi.getter(name="ipv6PdPrefixid")
    def ipv6_pd_prefixid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the IPv6 Prefix ID.
        """
        return pulumi.get(self, "ipv6_pd_prefixid")

    @_builtins.property
    @pulumi.getter(name="ipv6PdStart")
    def ipv6_pd_start(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Start address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_start")

    @_builtins.property
    @pulumi.getter(name="ipv6PdStop")
    def ipv6_pd_stop(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        End address of the DHCPv6 range. Used if `ipv6_interface_type` is set to `pd`.
        """
        return pulumi.get(self, "ipv6_pd_stop")

    @_builtins.property
    @pulumi.getter(name="ipv6RaEnable")
    def ipv6_ra_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable router advertisements or not.
        """
        return pulumi.get(self, "ipv6_ra_enable")

    @_builtins.property
    @pulumi.getter(name="ipv6RaPreferredLifetime")
    def ipv6_ra_preferred_lifetime(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Lifetime in which the address can be used. Address becomes deprecated afterwards. Must be lower than or equal to `ipv6_ra_valid_lifetime` Defaults to `14400`.
        """
        return pulumi.get(self, "ipv6_ra_preferred_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipv6RaPriority")
    def ipv6_ra_priority(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IPv6 router advertisement priority. Must be one of either `high`, `medium`, or `low`
        """
        return pulumi.get(self, "ipv6_ra_priority")

    @_builtins.property
    @pulumi.getter(name="ipv6RaValidLifetime")
    def ipv6_ra_valid_lifetime(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Total lifetime in which the address can be used. Must be equal to or greater than `ipv6_ra_preferred_lifetime`. Defaults to `86400`.
        """
        return pulumi.get(self, "ipv6_ra_valid_lifetime")

    @_builtins.property
    @pulumi.getter(name="ipv6StaticSubnet")
    def ipv6_static_subnet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the static IPv6 subnet when `ipv6_interface_type` is 'static'.
        """
        return pulumi.get(self, "ipv6_static_subnet")

    @_builtins.property
    @pulumi.getter(name="multicastDns")
    def multicast_dns(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether Multicast DNS (mDNS) is enabled or not on the network (Controller >=v7).
        """
        return pulumi.get(self, "multicast_dns")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkGroup")
    def network_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The group of the network. Defaults to `LAN`.
        """
        return pulumi.get(self, "network_group")

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[_builtins.str]:
        """
        The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        """
        return pulumi.get(self, "purpose")

    @_builtins.property
    @pulumi.getter
    def site(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the site to associate the network with.
        """
        return pulumi.get(self, "site")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subnet of the network. Must be a valid CIDR address.
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The VLAN ID of the network.
        """
        return pulumi.get(self, "vlan_id")

    @_builtins.property
    @pulumi.getter(name="wanDhcpV6PdSize")
    def wan_dhcp_v6_pd_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the IPv6 prefix size to request from ISP. Must be between 48 and 64.
        """
        return pulumi.get(self, "wan_dhcp_v6_pd_size")

    @_builtins.property
    @pulumi.getter(name="wanDns")
    def wan_dns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        DNS servers IPs of the WAN.
        """
        return pulumi.get(self, "wan_dns")

    @_builtins.property
    @pulumi.getter(name="wanEgressQos")
    def wan_egress_qos(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the WAN egress quality of service. Defaults to `0`.
        """
        return pulumi.get(self, "wan_egress_qos")

    @_builtins.property
    @pulumi.getter(name="wanGateway")
    def wan_gateway(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway")

    @_builtins.property
    @pulumi.getter(name="wanGatewayV6")
    def wan_gateway_v6(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv6 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway_v6")

    @_builtins.property
    @pulumi.getter(name="wanIp")
    def wan_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 address of the WAN.
        """
        return pulumi.get(self, "wan_ip")

    @_builtins.property
    @pulumi.getter(name="wanIpv6")
    def wan_ipv6(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv6 address of the WAN.
        """
        return pulumi.get(self, "wan_ipv6")

    @_builtins.property
    @pulumi.getter(name="wanNetmask")
    def wan_netmask(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 netmask of the WAN.
        """
        return pulumi.get(self, "wan_netmask")

    @_builtins.property
    @pulumi.getter(name="wanNetworkgroup")
    def wan_networkgroup(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        """
        return pulumi.get(self, "wan_networkgroup")

    @_builtins.property
    @pulumi.getter(name="wanPrefixlen")
    def wan_prefixlen(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The IPv6 prefix length of the WAN. Must be between 1 and 128.
        """
        return pulumi.get(self, "wan_prefixlen")

    @_builtins.property
    @pulumi.getter(name="wanType")
    def wan_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        """
        return pulumi.get(self, "wan_type")

    @_builtins.property
    @pulumi.getter(name="wanTypeV6")
    def wan_type_v6(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the IPV6 WAN connection type. Must be one of either `disabled`, `static`, or `dhcpv6`.
        """
        return pulumi.get(self, "wan_type_v6")

    @_builtins.property
    @pulumi.getter(name="wanUsername")
    def wan_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the IPV4 WAN username.
        """
        return pulumi.get(self, "wan_username")

    @_builtins.property
    @pulumi.getter(name="xWanPassword")
    def x_wan_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the IPV4 WAN password.
        """
        return pulumi.get(self, "x_wan_password")

