# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'DevicePortOverride',
    'RadiusProfileAcctServer',
    'RadiusProfileAuthServer',
    'WlanSchedule',
]

@pulumi.output_type
class DevicePortOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregateNumPorts":
            suggest = "aggregate_num_ports"
        elif key == "opMode":
            suggest = "op_mode"
        elif key == "portProfileId":
            suggest = "port_profile_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DevicePortOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DevicePortOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DevicePortOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 number: _builtins.int,
                 aggregate_num_ports: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 op_mode: Optional[_builtins.str] = None,
                 port_profile_id: Optional[_builtins.str] = None):
        """
        :param _builtins.int number: Switch port number.
        :param _builtins.int aggregate_num_ports: Number of ports in the aggregate.
        :param _builtins.str name: Human-readable name of the port.
        :param _builtins.str op_mode: Operating mode of the port, valid values are `switch`, `mirror`, and `aggregate`. Defaults to `switch`.
        :param _builtins.str port_profile_id: ID of the Port Profile used on this port.
        """
        pulumi.set(__self__, "number", number)
        if aggregate_num_ports is not None:
            pulumi.set(__self__, "aggregate_num_ports", aggregate_num_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if op_mode is not None:
            pulumi.set(__self__, "op_mode", op_mode)
        if port_profile_id is not None:
            pulumi.set(__self__, "port_profile_id", port_profile_id)

    @_builtins.property
    @pulumi.getter
    def number(self) -> _builtins.int:
        """
        Switch port number.
        """
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter(name="aggregateNumPorts")
    def aggregate_num_ports(self) -> Optional[_builtins.int]:
        """
        Number of ports in the aggregate.
        """
        return pulumi.get(self, "aggregate_num_ports")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Human-readable name of the port.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="opMode")
    def op_mode(self) -> Optional[_builtins.str]:
        """
        Operating mode of the port, valid values are `switch`, `mirror`, and `aggregate`. Defaults to `switch`.
        """
        return pulumi.get(self, "op_mode")

    @_builtins.property
    @pulumi.getter(name="portProfileId")
    def port_profile_id(self) -> Optional[_builtins.str]:
        """
        ID of the Port Profile used on this port.
        """
        return pulumi.get(self, "port_profile_id")


@pulumi.output_type
class RadiusProfileAcctServer(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 xsecret: _builtins.str,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip: IP address of accounting service server.
        :param _builtins.str xsecret: RADIUS secret.
        :param _builtins.int port: Port of accounting service. Defaults to `1813`.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "xsecret", xsecret)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address of accounting service server.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def xsecret(self) -> _builtins.str:
        """
        RADIUS secret.
        """
        return pulumi.get(self, "xsecret")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port of accounting service. Defaults to `1813`.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RadiusProfileAuthServer(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 xsecret: _builtins.str,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip: IP address of authentication service server.
        :param _builtins.str xsecret: RADIUS secret.
        :param _builtins.int port: Port of authentication service. Defaults to `1812`.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "xsecret", xsecret)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address of authentication service server.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def xsecret(self) -> _builtins.str:
        """
        RADIUS secret.
        """
        return pulumi.get(self, "xsecret")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port of authentication service. Defaults to `1812`.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class WlanSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMinute":
            suggest = "start_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WlanSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WlanSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WlanSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 duration: _builtins.int,
                 start_hour: _builtins.int,
                 name: Optional[_builtins.str] = None,
                 start_minute: Optional[_builtins.int] = None):
        """
        :param _builtins.str day_of_week: Day of week for the block. Valid values are `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`.
        :param _builtins.int duration: Length of the block in minutes.
        :param _builtins.int start_hour: Start hour for the block (0-23).
        :param _builtins.str name: Name of the block.
        :param _builtins.int start_minute: Start minute for the block (0-59). Defaults to `0`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_hour", start_hour)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        Day of week for the block. Valid values are `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        """
        Length of the block in minutes.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        Start hour for the block (0-23).
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the block.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[_builtins.int]:
        """
        Start minute for the block (0-59). Defaults to `0`.
        """
        return pulumi.get(self, "start_minute")


