# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ForwardArgs', 'Forward']

@pulumi.input_type
class ForwardArgs:
    def __init__(__self__, *,
                 dst_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fwd_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 fwd_port: Optional[pulumi.Input[_builtins.str]] = None,
                 log: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Forward resource.
        :param pulumi.Input[_builtins.str] dst_port: The destination port for the forwarding.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the port forwarding rule is enabled or not. Defaults to `true`. This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.
        :param pulumi.Input[_builtins.str] fwd_ip: The IPv4 address to forward traffic to.
        :param pulumi.Input[_builtins.str] fwd_port: The port to forward traffic to.
        :param pulumi.Input[_builtins.bool] log: Specifies whether to log forwarded traffic or not. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name of the port forwarding rule.
        :param pulumi.Input[_builtins.str] port_forward_interface: The port forwarding interface. Can be `wan`, `wan2`, or `both`.
        :param pulumi.Input[_builtins.str] protocol: The protocol for the port forwarding rule. Can be `tcp`, `udp`, or `tcp_udp`. Defaults to `tcp_udp`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the port forwarding rule with.
        :param pulumi.Input[_builtins.str] src_ip: The source IPv4 address (or CIDR) of the port forwarding rule. For all traffic, specify `any`. Defaults to `any`.
        """
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if enabled is not None:
            warnings.warn("""This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.""", DeprecationWarning)
            pulumi.log.warn("""enabled is deprecated: This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.""")
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fwd_ip is not None:
            pulumi.set(__self__, "fwd_ip", fwd_ip)
        if fwd_port is not None:
            pulumi.set(__self__, "fwd_port", fwd_port)
        if log is not None:
            pulumi.set(__self__, "log", log)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_forward_interface is not None:
            pulumi.set(__self__, "port_forward_interface", port_forward_interface)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if src_ip is not None:
            pulumi.set(__self__, "src_ip", src_ip)

    @_builtins.property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port for the forwarding.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_port", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.""")
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the port forwarding rule is enabled or not. Defaults to `true`. This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fwdIp")
    def fwd_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address to forward traffic to.
        """
        return pulumi.get(self, "fwd_ip")

    @fwd_ip.setter
    def fwd_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fwd_ip", value)

    @_builtins.property
    @pulumi.getter(name="fwdPort")
    def fwd_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port to forward traffic to.
        """
        return pulumi.get(self, "fwd_port")

    @fwd_port.setter
    def fwd_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fwd_port", value)

    @_builtins.property
    @pulumi.getter
    def log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to log forwarded traffic or not. Defaults to `false`.
        """
        return pulumi.get(self, "log")

    @log.setter
    def log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the port forwarding rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portForwardInterface")
    def port_forward_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port forwarding interface. Can be `wan`, `wan2`, or `both`.
        """
        return pulumi.get(self, "port_forward_interface")

    @port_forward_interface.setter
    def port_forward_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_forward_interface", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol for the port forwarding rule. Can be `tcp`, `udp`, or `tcp_udp`. Defaults to `tcp_udp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the port forwarding rule with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)

    @_builtins.property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source IPv4 address (or CIDR) of the port forwarding rule. For all traffic, specify `any`. Defaults to `any`.
        """
        return pulumi.get(self, "src_ip")

    @src_ip.setter
    def src_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_ip", value)


@pulumi.input_type
class _ForwardState:
    def __init__(__self__, *,
                 dst_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fwd_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 fwd_port: Optional[pulumi.Input[_builtins.str]] = None,
                 log: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ip: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Forward resources.
        :param pulumi.Input[_builtins.str] dst_port: The destination port for the forwarding.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the port forwarding rule is enabled or not. Defaults to `true`. This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.
        :param pulumi.Input[_builtins.str] fwd_ip: The IPv4 address to forward traffic to.
        :param pulumi.Input[_builtins.str] fwd_port: The port to forward traffic to.
        :param pulumi.Input[_builtins.bool] log: Specifies whether to log forwarded traffic or not. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name of the port forwarding rule.
        :param pulumi.Input[_builtins.str] port_forward_interface: The port forwarding interface. Can be `wan`, `wan2`, or `both`.
        :param pulumi.Input[_builtins.str] protocol: The protocol for the port forwarding rule. Can be `tcp`, `udp`, or `tcp_udp`. Defaults to `tcp_udp`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the port forwarding rule with.
        :param pulumi.Input[_builtins.str] src_ip: The source IPv4 address (or CIDR) of the port forwarding rule. For all traffic, specify `any`. Defaults to `any`.
        """
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if enabled is not None:
            warnings.warn("""This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.""", DeprecationWarning)
            pulumi.log.warn("""enabled is deprecated: This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.""")
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fwd_ip is not None:
            pulumi.set(__self__, "fwd_ip", fwd_ip)
        if fwd_port is not None:
            pulumi.set(__self__, "fwd_port", fwd_port)
        if log is not None:
            pulumi.set(__self__, "log", log)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_forward_interface is not None:
            pulumi.set(__self__, "port_forward_interface", port_forward_interface)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if src_ip is not None:
            pulumi.set(__self__, "src_ip", src_ip)

    @_builtins.property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port for the forwarding.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dst_port", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.""")
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the port forwarding rule is enabled or not. Defaults to `true`. This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fwdIp")
    def fwd_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address to forward traffic to.
        """
        return pulumi.get(self, "fwd_ip")

    @fwd_ip.setter
    def fwd_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fwd_ip", value)

    @_builtins.property
    @pulumi.getter(name="fwdPort")
    def fwd_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port to forward traffic to.
        """
        return pulumi.get(self, "fwd_port")

    @fwd_port.setter
    def fwd_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fwd_port", value)

    @_builtins.property
    @pulumi.getter
    def log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to log forwarded traffic or not. Defaults to `false`.
        """
        return pulumi.get(self, "log")

    @log.setter
    def log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the port forwarding rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portForwardInterface")
    def port_forward_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port forwarding interface. Can be `wan`, `wan2`, or `both`.
        """
        return pulumi.get(self, "port_forward_interface")

    @port_forward_interface.setter
    def port_forward_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_forward_interface", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol for the port forwarding rule. Can be `tcp`, `udp`, or `tcp_udp`. Defaults to `tcp_udp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the port forwarding rule with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)

    @_builtins.property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source IPv4 address (or CIDR) of the port forwarding rule. For all traffic, specify `any`. Defaults to `any`.
        """
        return pulumi.get(self, "src_ip")

    @src_ip.setter
    def src_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src_ip", value)


@pulumi.type_token("unifi:port/forward:Forward")
class Forward(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dst_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fwd_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 fwd_port: Optional[pulumi.Input[_builtins.str]] = None,
                 log: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        `port.Forward` manages a port forwarding rule on the gateway.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dst_port: The destination port for the forwarding.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the port forwarding rule is enabled or not. Defaults to `true`. This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.
        :param pulumi.Input[_builtins.str] fwd_ip: The IPv4 address to forward traffic to.
        :param pulumi.Input[_builtins.str] fwd_port: The port to forward traffic to.
        :param pulumi.Input[_builtins.bool] log: Specifies whether to log forwarded traffic or not. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name of the port forwarding rule.
        :param pulumi.Input[_builtins.str] port_forward_interface: The port forwarding interface. Can be `wan`, `wan2`, or `both`.
        :param pulumi.Input[_builtins.str] protocol: The protocol for the port forwarding rule. Can be `tcp`, `udp`, or `tcp_udp`. Defaults to `tcp_udp`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the port forwarding rule with.
        :param pulumi.Input[_builtins.str] src_ip: The source IPv4 address (or CIDR) of the port forwarding rule. For all traffic, specify `any`. Defaults to `any`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ForwardArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `port.Forward` manages a port forwarding rule on the gateway.

        :param str resource_name: The name of the resource.
        :param ForwardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ForwardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dst_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fwd_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 fwd_port: Optional[pulumi.Input[_builtins.str]] = None,
                 log: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 src_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ForwardArgs.__new__(ForwardArgs)

            __props__.__dict__["dst_port"] = dst_port
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["fwd_ip"] = fwd_ip
            __props__.__dict__["fwd_port"] = fwd_port
            __props__.__dict__["log"] = log
            __props__.__dict__["name"] = name
            __props__.__dict__["port_forward_interface"] = port_forward_interface
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["site"] = site
            __props__.__dict__["src_ip"] = src_ip
        super(Forward, __self__).__init__(
            'unifi:port/forward:Forward',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dst_port: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            fwd_ip: Optional[pulumi.Input[_builtins.str]] = None,
            fwd_port: Optional[pulumi.Input[_builtins.str]] = None,
            log: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port_forward_interface: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            site: Optional[pulumi.Input[_builtins.str]] = None,
            src_ip: Optional[pulumi.Input[_builtins.str]] = None) -> 'Forward':
        """
        Get an existing Forward resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dst_port: The destination port for the forwarding.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the port forwarding rule is enabled or not. Defaults to `true`. This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.
        :param pulumi.Input[_builtins.str] fwd_ip: The IPv4 address to forward traffic to.
        :param pulumi.Input[_builtins.str] fwd_port: The port to forward traffic to.
        :param pulumi.Input[_builtins.bool] log: Specifies whether to log forwarded traffic or not. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name of the port forwarding rule.
        :param pulumi.Input[_builtins.str] port_forward_interface: The port forwarding interface. Can be `wan`, `wan2`, or `both`.
        :param pulumi.Input[_builtins.str] protocol: The protocol for the port forwarding rule. Can be `tcp`, `udp`, or `tcp_udp`. Defaults to `tcp_udp`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the port forwarding rule with.
        :param pulumi.Input[_builtins.str] src_ip: The source IPv4 address (or CIDR) of the port forwarding rule. For all traffic, specify `any`. Defaults to `any`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ForwardState.__new__(_ForwardState)

        __props__.__dict__["dst_port"] = dst_port
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fwd_ip"] = fwd_ip
        __props__.__dict__["fwd_port"] = fwd_port
        __props__.__dict__["log"] = log
        __props__.__dict__["name"] = name
        __props__.__dict__["port_forward_interface"] = port_forward_interface
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["site"] = site
        __props__.__dict__["src_ip"] = src_ip
        return Forward(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination port for the forwarding.
        """
        return pulumi.get(self, "dst_port")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.""")
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the port forwarding rule is enabled or not. Defaults to `true`. This will attribute will be removed in a future release. Instead of disabling a port forwarding rule you can remove it from your configuration.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fwdIp")
    def fwd_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 address to forward traffic to.
        """
        return pulumi.get(self, "fwd_ip")

    @_builtins.property
    @pulumi.getter(name="fwdPort")
    def fwd_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port to forward traffic to.
        """
        return pulumi.get(self, "fwd_port")

    @_builtins.property
    @pulumi.getter
    def log(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to log forwarded traffic or not. Defaults to `false`.
        """
        return pulumi.get(self, "log")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the port forwarding rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portForwardInterface")
    def port_forward_interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port forwarding interface. Can be `wan`, `wan2`, or `both`.
        """
        return pulumi.get(self, "port_forward_interface")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol for the port forwarding rule. Can be `tcp`, `udp`, or `tcp_udp`. Defaults to `tcp_udp`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def site(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the site to associate the port forwarding rule with.
        """
        return pulumi.get(self, "site")

    @_builtins.property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source IPv4 address (or CIDR) of the port forwarding rule. For all traffic, specify `any`. Defaults to `any`.
        """
        return pulumi.get(self, "src_ip")

