# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.bool] allow_insecure: Skip verification of TLS certificates of API requests. You may need to set this to `true` if you are using your local
               API without setting up a signed certificate. Can be specified with the `UNIFI_INSECURE` environment variable.
        :param pulumi.Input[_builtins.str] api_url: URL of the controller API. Can be specified with the `UNIFI_API` environment variable. You should **NOT** supply the
               path (`/api`), the SDK will discover the appropriate paths. This is to support UDM Pro style API paths as well as more
               standard controller paths.
        :param pulumi.Input[_builtins.str] password: Password for the user accessing the API. Can be specified with the `UNIFI_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.str] site: The site in the Unifi controller this provider will manage. Can be specified with the `UNIFI_SITE` environment variable.
               Default: `default`
        :param pulumi.Input[_builtins.str] username: Local user name for the Unifi controller API. Can be specified with the `UNIFI_USERNAME` environment variable.
        """
        if allow_insecure is None:
            allow_insecure = _utilities.get_env_bool('UNIFI_INSECURE')
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if api_url is None:
            api_url = _utilities.get_env('UNIFI_API')
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if password is None:
            password = _utilities.get_env('UNIFI_PASSWORD')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if site is None:
            site = _utilities.get_env('UNIFI_SITE')
        if site is not None:
            pulumi.set(__self__, "site", site)
        if username is None:
            username = _utilities.get_env('UNIFI_USERNAME')
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip verification of TLS certificates of API requests. You may need to set this to `true` if you are using your local
        API without setting up a signed certificate. Can be specified with the `UNIFI_INSECURE` environment variable.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_insecure", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the controller API. Can be specified with the `UNIFI_API` environment variable. You should **NOT** supply the
        path (`/api`), the SDK will discover the appropriate paths. This is to support UDM Pro style API paths as well as more
        standard controller paths.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the user accessing the API. Can be specified with the `UNIFI_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The site in the Unifi controller this provider will manage. Can be specified with the `UNIFI_SITE` environment variable.
        Default: `default`
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local user name for the Unifi controller API. Can be specified with the `UNIFI_USERNAME` environment variable.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("pulumi:providers:unifi")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the unifi package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_insecure: Skip verification of TLS certificates of API requests. You may need to set this to `true` if you are using your local
               API without setting up a signed certificate. Can be specified with the `UNIFI_INSECURE` environment variable.
        :param pulumi.Input[_builtins.str] api_url: URL of the controller API. Can be specified with the `UNIFI_API` environment variable. You should **NOT** supply the
               path (`/api`), the SDK will discover the appropriate paths. This is to support UDM Pro style API paths as well as more
               standard controller paths.
        :param pulumi.Input[_builtins.str] password: Password for the user accessing the API. Can be specified with the `UNIFI_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.str] site: The site in the Unifi controller this provider will manage. Can be specified with the `UNIFI_SITE` environment variable.
               Default: `default`
        :param pulumi.Input[_builtins.str] username: Local user name for the Unifi controller API. Can be specified with the `UNIFI_USERNAME` environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the unifi package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if allow_insecure is None:
                allow_insecure = _utilities.get_env_bool('UNIFI_INSECURE')
            __props__.__dict__["allow_insecure"] = pulumi.Output.from_input(allow_insecure).apply(pulumi.runtime.to_json) if allow_insecure is not None else None
            if api_url is None:
                api_url = _utilities.get_env('UNIFI_API')
            __props__.__dict__["api_url"] = api_url
            if password is None:
                password = _utilities.get_env('UNIFI_PASSWORD')
            __props__.__dict__["password"] = password
            if site is None:
                site = _utilities.get_env('UNIFI_SITE')
            __props__.__dict__["site"] = site
            if username is None:
                username = _utilities.get_env('UNIFI_USERNAME')
            __props__.__dict__["username"] = username
        super(Provider, __self__).__init__(
            'unifi',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of the controller API. Can be specified with the `UNIFI_API` environment variable. You should **NOT** supply the
        path (`/api`), the SDK will discover the appropriate paths. This is to support UDM Pro style API paths as well as more
        standard controller paths.
        """
        return pulumi.get(self, "api_url")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for the user accessing the API. Can be specified with the `UNIFI_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def site(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The site in the Unifi controller this provider will manage. Can be specified with the `UNIFI_SITE` environment variable.
        Default: `default`
        """
        return pulumi.get(self, "site")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Local user name for the Unifi controller API. Can be specified with the `UNIFI_USERNAME` environment variable.
        """
        return pulumi.get(self, "username")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:unifi/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

