# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WlanArgs', 'Wlan']

@pulumi.input_type
class WlanArgs:
    def __init__(__self__, *,
                 security: pulumi.Input[_builtins.str],
                 user_group_id: pulumi.Input[_builtins.str],
                 ap_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bss_transition: Optional[pulumi.Input[_builtins.bool]] = None,
                 fast_roaming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_ssid: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_guest: Optional[pulumi.Input[_builtins.bool]] = None,
                 l2_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mac_filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_data_rate2g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_data_rate5g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 multicast_enhance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 no2ghz_oui: Optional[pulumi.Input[_builtins.bool]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 pmf_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_arp: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 uapsd: Optional[pulumi.Input[_builtins.bool]] = None,
                 wlan_band: Optional[pulumi.Input[_builtins.str]] = None,
                 wpa3_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 wpa3_transition: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Wlan resource.
        :param pulumi.Input[_builtins.str] security: The type of WiFi security for this network. Valid values are: `wpapsk`, `wpaeap`, and `open`.
        :param pulumi.Input[_builtins.str] user_group_id: ID of the user group to use for this network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ap_group_ids: IDs of the AP groups to use for this network.
        :param pulumi.Input[_builtins.bool] bss_transition: Improves client transitions between APs when they have a weak signal. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] fast_roaming_enabled: Enables 802.11r fast roaming. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] hide_ssid: Indicates whether or not to hide the SSID from broadcast.
        :param pulumi.Input[_builtins.bool] is_guest: Indicates that this is a guest WLAN and should use guest behaviors.
        :param pulumi.Input[_builtins.bool] l2_isolation: Isolates stations on layer 2 (ethernet) level. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] mac_filter_enabled: Indicates whether or not the MAC filter is turned of for the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mac_filter_lists: List of MAC addresses to filter (only valid if `mac_filter_enabled` is `true`).
        :param pulumi.Input[_builtins.str] mac_filter_policy: MAC address filter policy (only valid if `mac_filter_enabled` is `true`). Defaults to `deny`.
        :param pulumi.Input[_builtins.int] minimum_data_rate2g_kbps: Set minimum data rate control for 2G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `1000`, `2000`, `5500`, `6000`, `9000`, `11000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.int] minimum_data_rate5g_kbps: Set minimum data rate control for 5G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `6000`, `9000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.bool] multicast_enhance: Indicates whether or not Multicast Enhance is turned of for the network.
        :param pulumi.Input[_builtins.str] name: The SSID of the network.
        :param pulumi.Input[_builtins.str] network_id: ID of the network for this SSID
        :param pulumi.Input[_builtins.bool] no2ghz_oui: Connect high performance clients to 5 GHz only. Defaults to `true`.
        :param pulumi.Input[_builtins.str] passphrase: The passphrase for the network, this is only required if `security` is not set to `open`.
        :param pulumi.Input[_builtins.str] pmf_mode: Enable Protected Management Frames. This cannot be disabled if using WPA 3. Valid values are `required`, `optional` and `disabled`. Defaults to `disabled`.
        :param pulumi.Input[_builtins.bool] proxy_arp: Reduces airtime usage by allowing APs to "proxy" common broadcast frames as unicast. Defaults to `false`.
        :param pulumi.Input[_builtins.str] radius_profile_id: ID of the RADIUS profile to use when security `wpaeap`. You can query this via the `RadiusProfile` data source.
        :param pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]] schedules: Start and stop schedules for the WLAN
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the wlan with.
        :param pulumi.Input[_builtins.bool] uapsd: Enable Unscheduled Automatic Power Save Delivery. Defaults to `false`.
        :param pulumi.Input[_builtins.str] wlan_band: Radio band your WiFi network will use. Defaults to `both`.
        :param pulumi.Input[_builtins.bool] wpa3_support: Enable WPA 3 support (security must be `wpapsk` and PMF must be turned on).
        :param pulumi.Input[_builtins.bool] wpa3_transition: Enable WPA 3 and WPA 2 support (security must be `wpapsk` and `wpa3_support` must be true).
        """
        pulumi.set(__self__, "security", security)
        pulumi.set(__self__, "user_group_id", user_group_id)
        if ap_group_ids is not None:
            pulumi.set(__self__, "ap_group_ids", ap_group_ids)
        if bss_transition is not None:
            pulumi.set(__self__, "bss_transition", bss_transition)
        if fast_roaming_enabled is not None:
            pulumi.set(__self__, "fast_roaming_enabled", fast_roaming_enabled)
        if hide_ssid is not None:
            pulumi.set(__self__, "hide_ssid", hide_ssid)
        if is_guest is not None:
            pulumi.set(__self__, "is_guest", is_guest)
        if l2_isolation is not None:
            pulumi.set(__self__, "l2_isolation", l2_isolation)
        if mac_filter_enabled is not None:
            pulumi.set(__self__, "mac_filter_enabled", mac_filter_enabled)
        if mac_filter_lists is not None:
            pulumi.set(__self__, "mac_filter_lists", mac_filter_lists)
        if mac_filter_policy is not None:
            pulumi.set(__self__, "mac_filter_policy", mac_filter_policy)
        if minimum_data_rate2g_kbps is not None:
            pulumi.set(__self__, "minimum_data_rate2g_kbps", minimum_data_rate2g_kbps)
        if minimum_data_rate5g_kbps is not None:
            pulumi.set(__self__, "minimum_data_rate5g_kbps", minimum_data_rate5g_kbps)
        if multicast_enhance is not None:
            pulumi.set(__self__, "multicast_enhance", multicast_enhance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if no2ghz_oui is not None:
            pulumi.set(__self__, "no2ghz_oui", no2ghz_oui)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if pmf_mode is not None:
            pulumi.set(__self__, "pmf_mode", pmf_mode)
        if proxy_arp is not None:
            pulumi.set(__self__, "proxy_arp", proxy_arp)
        if radius_profile_id is not None:
            pulumi.set(__self__, "radius_profile_id", radius_profile_id)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if uapsd is not None:
            pulumi.set(__self__, "uapsd", uapsd)
        if wlan_band is not None:
            pulumi.set(__self__, "wlan_band", wlan_band)
        if wpa3_support is not None:
            pulumi.set(__self__, "wpa3_support", wpa3_support)
        if wpa3_transition is not None:
            pulumi.set(__self__, "wpa3_transition", wpa3_transition)

    @_builtins.property
    @pulumi.getter
    def security(self) -> pulumi.Input[_builtins.str]:
        """
        The type of WiFi security for this network. Valid values are: `wpapsk`, `wpaeap`, and `open`.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the user group to use for this network.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_group_id", value)

    @_builtins.property
    @pulumi.getter(name="apGroupIds")
    def ap_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IDs of the AP groups to use for this network.
        """
        return pulumi.get(self, "ap_group_ids")

    @ap_group_ids.setter
    def ap_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ap_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="bssTransition")
    def bss_transition(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Improves client transitions between APs when they have a weak signal. Defaults to `true`.
        """
        return pulumi.get(self, "bss_transition")

    @bss_transition.setter
    def bss_transition(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bss_transition", value)

    @_builtins.property
    @pulumi.getter(name="fastRoamingEnabled")
    def fast_roaming_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables 802.11r fast roaming. Defaults to `false`.
        """
        return pulumi.get(self, "fast_roaming_enabled")

    @fast_roaming_enabled.setter
    def fast_roaming_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fast_roaming_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hideSsid")
    def hide_ssid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether or not to hide the SSID from broadcast.
        """
        return pulumi.get(self, "hide_ssid")

    @hide_ssid.setter
    def hide_ssid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ssid", value)

    @_builtins.property
    @pulumi.getter(name="isGuest")
    def is_guest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that this is a guest WLAN and should use guest behaviors.
        """
        return pulumi.get(self, "is_guest")

    @is_guest.setter
    def is_guest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_guest", value)

    @_builtins.property
    @pulumi.getter(name="l2Isolation")
    def l2_isolation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Isolates stations on layer 2 (ethernet) level. Defaults to `false`.
        """
        return pulumi.get(self, "l2_isolation")

    @l2_isolation.setter
    def l2_isolation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "l2_isolation", value)

    @_builtins.property
    @pulumi.getter(name="macFilterEnabled")
    def mac_filter_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether or not the MAC filter is turned of for the network.
        """
        return pulumi.get(self, "mac_filter_enabled")

    @mac_filter_enabled.setter
    def mac_filter_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mac_filter_enabled", value)

    @_builtins.property
    @pulumi.getter(name="macFilterLists")
    def mac_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of MAC addresses to filter (only valid if `mac_filter_enabled` is `true`).
        """
        return pulumi.get(self, "mac_filter_lists")

    @mac_filter_lists.setter
    def mac_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mac_filter_lists", value)

    @_builtins.property
    @pulumi.getter(name="macFilterPolicy")
    def mac_filter_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address filter policy (only valid if `mac_filter_enabled` is `true`). Defaults to `deny`.
        """
        return pulumi.get(self, "mac_filter_policy")

    @mac_filter_policy.setter
    def mac_filter_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_filter_policy", value)

    @_builtins.property
    @pulumi.getter(name="minimumDataRate2gKbps")
    def minimum_data_rate2g_kbps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set minimum data rate control for 2G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `1000`, `2000`, `5500`, `6000`, `9000`, `11000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        """
        return pulumi.get(self, "minimum_data_rate2g_kbps")

    @minimum_data_rate2g_kbps.setter
    def minimum_data_rate2g_kbps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_data_rate2g_kbps", value)

    @_builtins.property
    @pulumi.getter(name="minimumDataRate5gKbps")
    def minimum_data_rate5g_kbps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set minimum data rate control for 5G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `6000`, `9000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        """
        return pulumi.get(self, "minimum_data_rate5g_kbps")

    @minimum_data_rate5g_kbps.setter
    def minimum_data_rate5g_kbps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_data_rate5g_kbps", value)

    @_builtins.property
    @pulumi.getter(name="multicastEnhance")
    def multicast_enhance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether or not Multicast Enhance is turned of for the network.
        """
        return pulumi.get(self, "multicast_enhance")

    @multicast_enhance.setter
    def multicast_enhance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multicast_enhance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSID of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the network for this SSID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="no2ghzOui")
    def no2ghz_oui(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Connect high performance clients to 5 GHz only. Defaults to `true`.
        """
        return pulumi.get(self, "no2ghz_oui")

    @no2ghz_oui.setter
    def no2ghz_oui(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no2ghz_oui", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passphrase for the network, this is only required if `security` is not set to `open`.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @_builtins.property
    @pulumi.getter(name="pmfMode")
    def pmf_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable Protected Management Frames. This cannot be disabled if using WPA 3. Valid values are `required`, `optional` and `disabled`. Defaults to `disabled`.
        """
        return pulumi.get(self, "pmf_mode")

    @pmf_mode.setter
    def pmf_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pmf_mode", value)

    @_builtins.property
    @pulumi.getter(name="proxyArp")
    def proxy_arp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Reduces airtime usage by allowing APs to "proxy" common broadcast frames as unicast. Defaults to `false`.
        """
        return pulumi.get(self, "proxy_arp")

    @proxy_arp.setter
    def proxy_arp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxy_arp", value)

    @_builtins.property
    @pulumi.getter(name="radiusProfileId")
    def radius_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the RADIUS profile to use when security `wpaeap`. You can query this via the `RadiusProfile` data source.
        """
        return pulumi.get(self, "radius_profile_id")

    @radius_profile_id.setter
    def radius_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]]]:
        """
        Start and stop schedules for the WLAN
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the wlan with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)

    @_builtins.property
    @pulumi.getter
    def uapsd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Unscheduled Automatic Power Save Delivery. Defaults to `false`.
        """
        return pulumi.get(self, "uapsd")

    @uapsd.setter
    def uapsd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "uapsd", value)

    @_builtins.property
    @pulumi.getter(name="wlanBand")
    def wlan_band(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Radio band your WiFi network will use. Defaults to `both`.
        """
        return pulumi.get(self, "wlan_band")

    @wlan_band.setter
    def wlan_band(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wlan_band", value)

    @_builtins.property
    @pulumi.getter(name="wpa3Support")
    def wpa3_support(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable WPA 3 support (security must be `wpapsk` and PMF must be turned on).
        """
        return pulumi.get(self, "wpa3_support")

    @wpa3_support.setter
    def wpa3_support(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wpa3_support", value)

    @_builtins.property
    @pulumi.getter(name="wpa3Transition")
    def wpa3_transition(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable WPA 3 and WPA 2 support (security must be `wpapsk` and `wpa3_support` must be true).
        """
        return pulumi.get(self, "wpa3_transition")

    @wpa3_transition.setter
    def wpa3_transition(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wpa3_transition", value)


@pulumi.input_type
class _WlanState:
    def __init__(__self__, *,
                 ap_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bss_transition: Optional[pulumi.Input[_builtins.bool]] = None,
                 fast_roaming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_ssid: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_guest: Optional[pulumi.Input[_builtins.bool]] = None,
                 l2_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mac_filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_data_rate2g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_data_rate5g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 multicast_enhance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 no2ghz_oui: Optional[pulumi.Input[_builtins.bool]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 pmf_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_arp: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 uapsd: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wlan_band: Optional[pulumi.Input[_builtins.str]] = None,
                 wpa3_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 wpa3_transition: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Wlan resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ap_group_ids: IDs of the AP groups to use for this network.
        :param pulumi.Input[_builtins.bool] bss_transition: Improves client transitions between APs when they have a weak signal. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] fast_roaming_enabled: Enables 802.11r fast roaming. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] hide_ssid: Indicates whether or not to hide the SSID from broadcast.
        :param pulumi.Input[_builtins.bool] is_guest: Indicates that this is a guest WLAN and should use guest behaviors.
        :param pulumi.Input[_builtins.bool] l2_isolation: Isolates stations on layer 2 (ethernet) level. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] mac_filter_enabled: Indicates whether or not the MAC filter is turned of for the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mac_filter_lists: List of MAC addresses to filter (only valid if `mac_filter_enabled` is `true`).
        :param pulumi.Input[_builtins.str] mac_filter_policy: MAC address filter policy (only valid if `mac_filter_enabled` is `true`). Defaults to `deny`.
        :param pulumi.Input[_builtins.int] minimum_data_rate2g_kbps: Set minimum data rate control for 2G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `1000`, `2000`, `5500`, `6000`, `9000`, `11000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.int] minimum_data_rate5g_kbps: Set minimum data rate control for 5G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `6000`, `9000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.bool] multicast_enhance: Indicates whether or not Multicast Enhance is turned of for the network.
        :param pulumi.Input[_builtins.str] name: The SSID of the network.
        :param pulumi.Input[_builtins.str] network_id: ID of the network for this SSID
        :param pulumi.Input[_builtins.bool] no2ghz_oui: Connect high performance clients to 5 GHz only. Defaults to `true`.
        :param pulumi.Input[_builtins.str] passphrase: The passphrase for the network, this is only required if `security` is not set to `open`.
        :param pulumi.Input[_builtins.str] pmf_mode: Enable Protected Management Frames. This cannot be disabled if using WPA 3. Valid values are `required`, `optional` and `disabled`. Defaults to `disabled`.
        :param pulumi.Input[_builtins.bool] proxy_arp: Reduces airtime usage by allowing APs to "proxy" common broadcast frames as unicast. Defaults to `false`.
        :param pulumi.Input[_builtins.str] radius_profile_id: ID of the RADIUS profile to use when security `wpaeap`. You can query this via the `RadiusProfile` data source.
        :param pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]] schedules: Start and stop schedules for the WLAN
        :param pulumi.Input[_builtins.str] security: The type of WiFi security for this network. Valid values are: `wpapsk`, `wpaeap`, and `open`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the wlan with.
        :param pulumi.Input[_builtins.bool] uapsd: Enable Unscheduled Automatic Power Save Delivery. Defaults to `false`.
        :param pulumi.Input[_builtins.str] user_group_id: ID of the user group to use for this network.
        :param pulumi.Input[_builtins.str] wlan_band: Radio band your WiFi network will use. Defaults to `both`.
        :param pulumi.Input[_builtins.bool] wpa3_support: Enable WPA 3 support (security must be `wpapsk` and PMF must be turned on).
        :param pulumi.Input[_builtins.bool] wpa3_transition: Enable WPA 3 and WPA 2 support (security must be `wpapsk` and `wpa3_support` must be true).
        """
        if ap_group_ids is not None:
            pulumi.set(__self__, "ap_group_ids", ap_group_ids)
        if bss_transition is not None:
            pulumi.set(__self__, "bss_transition", bss_transition)
        if fast_roaming_enabled is not None:
            pulumi.set(__self__, "fast_roaming_enabled", fast_roaming_enabled)
        if hide_ssid is not None:
            pulumi.set(__self__, "hide_ssid", hide_ssid)
        if is_guest is not None:
            pulumi.set(__self__, "is_guest", is_guest)
        if l2_isolation is not None:
            pulumi.set(__self__, "l2_isolation", l2_isolation)
        if mac_filter_enabled is not None:
            pulumi.set(__self__, "mac_filter_enabled", mac_filter_enabled)
        if mac_filter_lists is not None:
            pulumi.set(__self__, "mac_filter_lists", mac_filter_lists)
        if mac_filter_policy is not None:
            pulumi.set(__self__, "mac_filter_policy", mac_filter_policy)
        if minimum_data_rate2g_kbps is not None:
            pulumi.set(__self__, "minimum_data_rate2g_kbps", minimum_data_rate2g_kbps)
        if minimum_data_rate5g_kbps is not None:
            pulumi.set(__self__, "minimum_data_rate5g_kbps", minimum_data_rate5g_kbps)
        if multicast_enhance is not None:
            pulumi.set(__self__, "multicast_enhance", multicast_enhance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if no2ghz_oui is not None:
            pulumi.set(__self__, "no2ghz_oui", no2ghz_oui)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if pmf_mode is not None:
            pulumi.set(__self__, "pmf_mode", pmf_mode)
        if proxy_arp is not None:
            pulumi.set(__self__, "proxy_arp", proxy_arp)
        if radius_profile_id is not None:
            pulumi.set(__self__, "radius_profile_id", radius_profile_id)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if uapsd is not None:
            pulumi.set(__self__, "uapsd", uapsd)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)
        if wlan_band is not None:
            pulumi.set(__self__, "wlan_band", wlan_band)
        if wpa3_support is not None:
            pulumi.set(__self__, "wpa3_support", wpa3_support)
        if wpa3_transition is not None:
            pulumi.set(__self__, "wpa3_transition", wpa3_transition)

    @_builtins.property
    @pulumi.getter(name="apGroupIds")
    def ap_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IDs of the AP groups to use for this network.
        """
        return pulumi.get(self, "ap_group_ids")

    @ap_group_ids.setter
    def ap_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ap_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="bssTransition")
    def bss_transition(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Improves client transitions between APs when they have a weak signal. Defaults to `true`.
        """
        return pulumi.get(self, "bss_transition")

    @bss_transition.setter
    def bss_transition(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bss_transition", value)

    @_builtins.property
    @pulumi.getter(name="fastRoamingEnabled")
    def fast_roaming_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables 802.11r fast roaming. Defaults to `false`.
        """
        return pulumi.get(self, "fast_roaming_enabled")

    @fast_roaming_enabled.setter
    def fast_roaming_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fast_roaming_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hideSsid")
    def hide_ssid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether or not to hide the SSID from broadcast.
        """
        return pulumi.get(self, "hide_ssid")

    @hide_ssid.setter
    def hide_ssid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ssid", value)

    @_builtins.property
    @pulumi.getter(name="isGuest")
    def is_guest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that this is a guest WLAN and should use guest behaviors.
        """
        return pulumi.get(self, "is_guest")

    @is_guest.setter
    def is_guest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_guest", value)

    @_builtins.property
    @pulumi.getter(name="l2Isolation")
    def l2_isolation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Isolates stations on layer 2 (ethernet) level. Defaults to `false`.
        """
        return pulumi.get(self, "l2_isolation")

    @l2_isolation.setter
    def l2_isolation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "l2_isolation", value)

    @_builtins.property
    @pulumi.getter(name="macFilterEnabled")
    def mac_filter_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether or not the MAC filter is turned of for the network.
        """
        return pulumi.get(self, "mac_filter_enabled")

    @mac_filter_enabled.setter
    def mac_filter_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mac_filter_enabled", value)

    @_builtins.property
    @pulumi.getter(name="macFilterLists")
    def mac_filter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of MAC addresses to filter (only valid if `mac_filter_enabled` is `true`).
        """
        return pulumi.get(self, "mac_filter_lists")

    @mac_filter_lists.setter
    def mac_filter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mac_filter_lists", value)

    @_builtins.property
    @pulumi.getter(name="macFilterPolicy")
    def mac_filter_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address filter policy (only valid if `mac_filter_enabled` is `true`). Defaults to `deny`.
        """
        return pulumi.get(self, "mac_filter_policy")

    @mac_filter_policy.setter
    def mac_filter_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_filter_policy", value)

    @_builtins.property
    @pulumi.getter(name="minimumDataRate2gKbps")
    def minimum_data_rate2g_kbps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set minimum data rate control for 2G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `1000`, `2000`, `5500`, `6000`, `9000`, `11000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        """
        return pulumi.get(self, "minimum_data_rate2g_kbps")

    @minimum_data_rate2g_kbps.setter
    def minimum_data_rate2g_kbps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_data_rate2g_kbps", value)

    @_builtins.property
    @pulumi.getter(name="minimumDataRate5gKbps")
    def minimum_data_rate5g_kbps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set minimum data rate control for 5G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `6000`, `9000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        """
        return pulumi.get(self, "minimum_data_rate5g_kbps")

    @minimum_data_rate5g_kbps.setter
    def minimum_data_rate5g_kbps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_data_rate5g_kbps", value)

    @_builtins.property
    @pulumi.getter(name="multicastEnhance")
    def multicast_enhance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether or not Multicast Enhance is turned of for the network.
        """
        return pulumi.get(self, "multicast_enhance")

    @multicast_enhance.setter
    def multicast_enhance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multicast_enhance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSID of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the network for this SSID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="no2ghzOui")
    def no2ghz_oui(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Connect high performance clients to 5 GHz only. Defaults to `true`.
        """
        return pulumi.get(self, "no2ghz_oui")

    @no2ghz_oui.setter
    def no2ghz_oui(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no2ghz_oui", value)

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passphrase for the network, this is only required if `security` is not set to `open`.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passphrase", value)

    @_builtins.property
    @pulumi.getter(name="pmfMode")
    def pmf_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable Protected Management Frames. This cannot be disabled if using WPA 3. Valid values are `required`, `optional` and `disabled`. Defaults to `disabled`.
        """
        return pulumi.get(self, "pmf_mode")

    @pmf_mode.setter
    def pmf_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pmf_mode", value)

    @_builtins.property
    @pulumi.getter(name="proxyArp")
    def proxy_arp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Reduces airtime usage by allowing APs to "proxy" common broadcast frames as unicast. Defaults to `false`.
        """
        return pulumi.get(self, "proxy_arp")

    @proxy_arp.setter
    def proxy_arp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxy_arp", value)

    @_builtins.property
    @pulumi.getter(name="radiusProfileId")
    def radius_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the RADIUS profile to use when security `wpaeap`. You can query this via the `RadiusProfile` data source.
        """
        return pulumi.get(self, "radius_profile_id")

    @radius_profile_id.setter
    def radius_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]]]:
        """
        Start and stop schedules for the WLAN
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WlanScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of WiFi security for this network. Valid values are: `wpapsk`, `wpaeap`, and `open`.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site to associate the wlan with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site", value)

    @_builtins.property
    @pulumi.getter
    def uapsd(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable Unscheduled Automatic Power Save Delivery. Defaults to `false`.
        """
        return pulumi.get(self, "uapsd")

    @uapsd.setter
    def uapsd(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "uapsd", value)

    @_builtins.property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user group to use for this network.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_group_id", value)

    @_builtins.property
    @pulumi.getter(name="wlanBand")
    def wlan_band(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Radio band your WiFi network will use. Defaults to `both`.
        """
        return pulumi.get(self, "wlan_band")

    @wlan_band.setter
    def wlan_band(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wlan_band", value)

    @_builtins.property
    @pulumi.getter(name="wpa3Support")
    def wpa3_support(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable WPA 3 support (security must be `wpapsk` and PMF must be turned on).
        """
        return pulumi.get(self, "wpa3_support")

    @wpa3_support.setter
    def wpa3_support(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wpa3_support", value)

    @_builtins.property
    @pulumi.getter(name="wpa3Transition")
    def wpa3_transition(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable WPA 3 and WPA 2 support (security must be `wpapsk` and `wpa3_support` must be true).
        """
        return pulumi.get(self, "wpa3_transition")

    @wpa3_transition.setter
    def wpa3_transition(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wpa3_transition", value)


@pulumi.type_token("unifi:index/wlan:Wlan")
class Wlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ap_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bss_transition: Optional[pulumi.Input[_builtins.bool]] = None,
                 fast_roaming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_ssid: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_guest: Optional[pulumi.Input[_builtins.bool]] = None,
                 l2_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mac_filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_data_rate2g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_data_rate5g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 multicast_enhance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 no2ghz_oui: Optional[pulumi.Input[_builtins.bool]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 pmf_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_arp: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WlanScheduleArgs', 'WlanScheduleArgsDict']]]]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 uapsd: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wlan_band: Optional[pulumi.Input[_builtins.str]] = None,
                 wpa3_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 wpa3_transition: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        `Wlan` manages a WiFi network / SSID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_unifi as unifi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        default = unifi.get_ap_group()
        default_get_group = unifi.iam.get_group()
        vlan = unifi.Network("vlan",
            name="wifi-vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        wifi = unifi.Wlan("wifi",
            name="myssid",
            passphrase="12345678",
            security="wpapsk",
            wpa3_support=True,
            wpa3_transition=True,
            pmf_mode="optional",
            network_id=vlan.id,
            ap_group_ids=[default.id],
            user_group_id=default_get_group.id)
        ```

        ## Import

        import from provider configured site

        ```sh
        $ pulumi import unifi:index/wlan:Wlan mywlan 5dc28e5e9106d105bdc87217
        ```

        import from another site

        ```sh
        $ pulumi import unifi:index/wlan:Wlan mywlan bfa2l6i7:5dc28e5e9106d105bdc87217
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ap_group_ids: IDs of the AP groups to use for this network.
        :param pulumi.Input[_builtins.bool] bss_transition: Improves client transitions between APs when they have a weak signal. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] fast_roaming_enabled: Enables 802.11r fast roaming. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] hide_ssid: Indicates whether or not to hide the SSID from broadcast.
        :param pulumi.Input[_builtins.bool] is_guest: Indicates that this is a guest WLAN and should use guest behaviors.
        :param pulumi.Input[_builtins.bool] l2_isolation: Isolates stations on layer 2 (ethernet) level. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] mac_filter_enabled: Indicates whether or not the MAC filter is turned of for the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mac_filter_lists: List of MAC addresses to filter (only valid if `mac_filter_enabled` is `true`).
        :param pulumi.Input[_builtins.str] mac_filter_policy: MAC address filter policy (only valid if `mac_filter_enabled` is `true`). Defaults to `deny`.
        :param pulumi.Input[_builtins.int] minimum_data_rate2g_kbps: Set minimum data rate control for 2G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `1000`, `2000`, `5500`, `6000`, `9000`, `11000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.int] minimum_data_rate5g_kbps: Set minimum data rate control for 5G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `6000`, `9000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.bool] multicast_enhance: Indicates whether or not Multicast Enhance is turned of for the network.
        :param pulumi.Input[_builtins.str] name: The SSID of the network.
        :param pulumi.Input[_builtins.str] network_id: ID of the network for this SSID
        :param pulumi.Input[_builtins.bool] no2ghz_oui: Connect high performance clients to 5 GHz only. Defaults to `true`.
        :param pulumi.Input[_builtins.str] passphrase: The passphrase for the network, this is only required if `security` is not set to `open`.
        :param pulumi.Input[_builtins.str] pmf_mode: Enable Protected Management Frames. This cannot be disabled if using WPA 3. Valid values are `required`, `optional` and `disabled`. Defaults to `disabled`.
        :param pulumi.Input[_builtins.bool] proxy_arp: Reduces airtime usage by allowing APs to "proxy" common broadcast frames as unicast. Defaults to `false`.
        :param pulumi.Input[_builtins.str] radius_profile_id: ID of the RADIUS profile to use when security `wpaeap`. You can query this via the `RadiusProfile` data source.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WlanScheduleArgs', 'WlanScheduleArgsDict']]]] schedules: Start and stop schedules for the WLAN
        :param pulumi.Input[_builtins.str] security: The type of WiFi security for this network. Valid values are: `wpapsk`, `wpaeap`, and `open`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the wlan with.
        :param pulumi.Input[_builtins.bool] uapsd: Enable Unscheduled Automatic Power Save Delivery. Defaults to `false`.
        :param pulumi.Input[_builtins.str] user_group_id: ID of the user group to use for this network.
        :param pulumi.Input[_builtins.str] wlan_band: Radio band your WiFi network will use. Defaults to `both`.
        :param pulumi.Input[_builtins.bool] wpa3_support: Enable WPA 3 support (security must be `wpapsk` and PMF must be turned on).
        :param pulumi.Input[_builtins.bool] wpa3_transition: Enable WPA 3 and WPA 2 support (security must be `wpapsk` and `wpa3_support` must be true).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `Wlan` manages a WiFi network / SSID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_unifi as unifi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        default = unifi.get_ap_group()
        default_get_group = unifi.iam.get_group()
        vlan = unifi.Network("vlan",
            name="wifi-vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        wifi = unifi.Wlan("wifi",
            name="myssid",
            passphrase="12345678",
            security="wpapsk",
            wpa3_support=True,
            wpa3_transition=True,
            pmf_mode="optional",
            network_id=vlan.id,
            ap_group_ids=[default.id],
            user_group_id=default_get_group.id)
        ```

        ## Import

        import from provider configured site

        ```sh
        $ pulumi import unifi:index/wlan:Wlan mywlan 5dc28e5e9106d105bdc87217
        ```

        import from another site

        ```sh
        $ pulumi import unifi:index/wlan:Wlan mywlan bfa2l6i7:5dc28e5e9106d105bdc87217
        ```

        :param str resource_name: The name of the resource.
        :param WlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ap_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bss_transition: Optional[pulumi.Input[_builtins.bool]] = None,
                 fast_roaming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_ssid: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_guest: Optional[pulumi.Input[_builtins.bool]] = None,
                 l2_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mac_filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_data_rate2g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_data_rate5g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
                 multicast_enhance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 no2ghz_oui: Optional[pulumi.Input[_builtins.bool]] = None,
                 passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 pmf_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_arp: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WlanScheduleArgs', 'WlanScheduleArgsDict']]]]] = None,
                 security: Optional[pulumi.Input[_builtins.str]] = None,
                 site: Optional[pulumi.Input[_builtins.str]] = None,
                 uapsd: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wlan_band: Optional[pulumi.Input[_builtins.str]] = None,
                 wpa3_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 wpa3_transition: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WlanArgs.__new__(WlanArgs)

            __props__.__dict__["ap_group_ids"] = ap_group_ids
            __props__.__dict__["bss_transition"] = bss_transition
            __props__.__dict__["fast_roaming_enabled"] = fast_roaming_enabled
            __props__.__dict__["hide_ssid"] = hide_ssid
            __props__.__dict__["is_guest"] = is_guest
            __props__.__dict__["l2_isolation"] = l2_isolation
            __props__.__dict__["mac_filter_enabled"] = mac_filter_enabled
            __props__.__dict__["mac_filter_lists"] = mac_filter_lists
            __props__.__dict__["mac_filter_policy"] = mac_filter_policy
            __props__.__dict__["minimum_data_rate2g_kbps"] = minimum_data_rate2g_kbps
            __props__.__dict__["minimum_data_rate5g_kbps"] = minimum_data_rate5g_kbps
            __props__.__dict__["multicast_enhance"] = multicast_enhance
            __props__.__dict__["name"] = name
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["no2ghz_oui"] = no2ghz_oui
            __props__.__dict__["passphrase"] = None if passphrase is None else pulumi.Output.secret(passphrase)
            __props__.__dict__["pmf_mode"] = pmf_mode
            __props__.__dict__["proxy_arp"] = proxy_arp
            __props__.__dict__["radius_profile_id"] = radius_profile_id
            __props__.__dict__["schedules"] = schedules
            if security is None and not opts.urn:
                raise TypeError("Missing required property 'security'")
            __props__.__dict__["security"] = security
            __props__.__dict__["site"] = site
            __props__.__dict__["uapsd"] = uapsd
            if user_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_group_id'")
            __props__.__dict__["user_group_id"] = user_group_id
            __props__.__dict__["wlan_band"] = wlan_band
            __props__.__dict__["wpa3_support"] = wpa3_support
            __props__.__dict__["wpa3_transition"] = wpa3_transition
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["passphrase"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Wlan, __self__).__init__(
            'unifi:index/wlan:Wlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ap_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bss_transition: Optional[pulumi.Input[_builtins.bool]] = None,
            fast_roaming_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            hide_ssid: Optional[pulumi.Input[_builtins.bool]] = None,
            is_guest: Optional[pulumi.Input[_builtins.bool]] = None,
            l2_isolation: Optional[pulumi.Input[_builtins.bool]] = None,
            mac_filter_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            mac_filter_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mac_filter_policy: Optional[pulumi.Input[_builtins.str]] = None,
            minimum_data_rate2g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
            minimum_data_rate5g_kbps: Optional[pulumi.Input[_builtins.int]] = None,
            multicast_enhance: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            no2ghz_oui: Optional[pulumi.Input[_builtins.bool]] = None,
            passphrase: Optional[pulumi.Input[_builtins.str]] = None,
            pmf_mode: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_arp: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WlanScheduleArgs', 'WlanScheduleArgsDict']]]]] = None,
            security: Optional[pulumi.Input[_builtins.str]] = None,
            site: Optional[pulumi.Input[_builtins.str]] = None,
            uapsd: Optional[pulumi.Input[_builtins.bool]] = None,
            user_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            wlan_band: Optional[pulumi.Input[_builtins.str]] = None,
            wpa3_support: Optional[pulumi.Input[_builtins.bool]] = None,
            wpa3_transition: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Wlan':
        """
        Get an existing Wlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ap_group_ids: IDs of the AP groups to use for this network.
        :param pulumi.Input[_builtins.bool] bss_transition: Improves client transitions between APs when they have a weak signal. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] fast_roaming_enabled: Enables 802.11r fast roaming. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] hide_ssid: Indicates whether or not to hide the SSID from broadcast.
        :param pulumi.Input[_builtins.bool] is_guest: Indicates that this is a guest WLAN and should use guest behaviors.
        :param pulumi.Input[_builtins.bool] l2_isolation: Isolates stations on layer 2 (ethernet) level. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] mac_filter_enabled: Indicates whether or not the MAC filter is turned of for the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mac_filter_lists: List of MAC addresses to filter (only valid if `mac_filter_enabled` is `true`).
        :param pulumi.Input[_builtins.str] mac_filter_policy: MAC address filter policy (only valid if `mac_filter_enabled` is `true`). Defaults to `deny`.
        :param pulumi.Input[_builtins.int] minimum_data_rate2g_kbps: Set minimum data rate control for 2G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `1000`, `2000`, `5500`, `6000`, `9000`, `11000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.int] minimum_data_rate5g_kbps: Set minimum data rate control for 5G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `6000`, `9000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        :param pulumi.Input[_builtins.bool] multicast_enhance: Indicates whether or not Multicast Enhance is turned of for the network.
        :param pulumi.Input[_builtins.str] name: The SSID of the network.
        :param pulumi.Input[_builtins.str] network_id: ID of the network for this SSID
        :param pulumi.Input[_builtins.bool] no2ghz_oui: Connect high performance clients to 5 GHz only. Defaults to `true`.
        :param pulumi.Input[_builtins.str] passphrase: The passphrase for the network, this is only required if `security` is not set to `open`.
        :param pulumi.Input[_builtins.str] pmf_mode: Enable Protected Management Frames. This cannot be disabled if using WPA 3. Valid values are `required`, `optional` and `disabled`. Defaults to `disabled`.
        :param pulumi.Input[_builtins.bool] proxy_arp: Reduces airtime usage by allowing APs to "proxy" common broadcast frames as unicast. Defaults to `false`.
        :param pulumi.Input[_builtins.str] radius_profile_id: ID of the RADIUS profile to use when security `wpaeap`. You can query this via the `RadiusProfile` data source.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WlanScheduleArgs', 'WlanScheduleArgsDict']]]] schedules: Start and stop schedules for the WLAN
        :param pulumi.Input[_builtins.str] security: The type of WiFi security for this network. Valid values are: `wpapsk`, `wpaeap`, and `open`.
        :param pulumi.Input[_builtins.str] site: The name of the site to associate the wlan with.
        :param pulumi.Input[_builtins.bool] uapsd: Enable Unscheduled Automatic Power Save Delivery. Defaults to `false`.
        :param pulumi.Input[_builtins.str] user_group_id: ID of the user group to use for this network.
        :param pulumi.Input[_builtins.str] wlan_band: Radio band your WiFi network will use. Defaults to `both`.
        :param pulumi.Input[_builtins.bool] wpa3_support: Enable WPA 3 support (security must be `wpapsk` and PMF must be turned on).
        :param pulumi.Input[_builtins.bool] wpa3_transition: Enable WPA 3 and WPA 2 support (security must be `wpapsk` and `wpa3_support` must be true).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WlanState.__new__(_WlanState)

        __props__.__dict__["ap_group_ids"] = ap_group_ids
        __props__.__dict__["bss_transition"] = bss_transition
        __props__.__dict__["fast_roaming_enabled"] = fast_roaming_enabled
        __props__.__dict__["hide_ssid"] = hide_ssid
        __props__.__dict__["is_guest"] = is_guest
        __props__.__dict__["l2_isolation"] = l2_isolation
        __props__.__dict__["mac_filter_enabled"] = mac_filter_enabled
        __props__.__dict__["mac_filter_lists"] = mac_filter_lists
        __props__.__dict__["mac_filter_policy"] = mac_filter_policy
        __props__.__dict__["minimum_data_rate2g_kbps"] = minimum_data_rate2g_kbps
        __props__.__dict__["minimum_data_rate5g_kbps"] = minimum_data_rate5g_kbps
        __props__.__dict__["multicast_enhance"] = multicast_enhance
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["no2ghz_oui"] = no2ghz_oui
        __props__.__dict__["passphrase"] = passphrase
        __props__.__dict__["pmf_mode"] = pmf_mode
        __props__.__dict__["proxy_arp"] = proxy_arp
        __props__.__dict__["radius_profile_id"] = radius_profile_id
        __props__.__dict__["schedules"] = schedules
        __props__.__dict__["security"] = security
        __props__.__dict__["site"] = site
        __props__.__dict__["uapsd"] = uapsd
        __props__.__dict__["user_group_id"] = user_group_id
        __props__.__dict__["wlan_band"] = wlan_band
        __props__.__dict__["wpa3_support"] = wpa3_support
        __props__.__dict__["wpa3_transition"] = wpa3_transition
        return Wlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apGroupIds")
    def ap_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        IDs of the AP groups to use for this network.
        """
        return pulumi.get(self, "ap_group_ids")

    @_builtins.property
    @pulumi.getter(name="bssTransition")
    def bss_transition(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Improves client transitions between APs when they have a weak signal. Defaults to `true`.
        """
        return pulumi.get(self, "bss_transition")

    @_builtins.property
    @pulumi.getter(name="fastRoamingEnabled")
    def fast_roaming_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables 802.11r fast roaming. Defaults to `false`.
        """
        return pulumi.get(self, "fast_roaming_enabled")

    @_builtins.property
    @pulumi.getter(name="hideSsid")
    def hide_ssid(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether or not to hide the SSID from broadcast.
        """
        return pulumi.get(self, "hide_ssid")

    @_builtins.property
    @pulumi.getter(name="isGuest")
    def is_guest(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates that this is a guest WLAN and should use guest behaviors.
        """
        return pulumi.get(self, "is_guest")

    @_builtins.property
    @pulumi.getter(name="l2Isolation")
    def l2_isolation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Isolates stations on layer 2 (ethernet) level. Defaults to `false`.
        """
        return pulumi.get(self, "l2_isolation")

    @_builtins.property
    @pulumi.getter(name="macFilterEnabled")
    def mac_filter_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether or not the MAC filter is turned of for the network.
        """
        return pulumi.get(self, "mac_filter_enabled")

    @_builtins.property
    @pulumi.getter(name="macFilterLists")
    def mac_filter_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of MAC addresses to filter (only valid if `mac_filter_enabled` is `true`).
        """
        return pulumi.get(self, "mac_filter_lists")

    @_builtins.property
    @pulumi.getter(name="macFilterPolicy")
    def mac_filter_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        MAC address filter policy (only valid if `mac_filter_enabled` is `true`). Defaults to `deny`.
        """
        return pulumi.get(self, "mac_filter_policy")

    @_builtins.property
    @pulumi.getter(name="minimumDataRate2gKbps")
    def minimum_data_rate2g_kbps(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set minimum data rate control for 2G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `1000`, `2000`, `5500`, `6000`, `9000`, `11000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        """
        return pulumi.get(self, "minimum_data_rate2g_kbps")

    @_builtins.property
    @pulumi.getter(name="minimumDataRate5gKbps")
    def minimum_data_rate5g_kbps(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set minimum data rate control for 5G devices, in Kbps. Use `0` to disable minimum data rates. Valid values are: `6000`, `9000`, `12000`, `18000`, `24000`, `36000`, `48000`,  and `54000`.
        """
        return pulumi.get(self, "minimum_data_rate5g_kbps")

    @_builtins.property
    @pulumi.getter(name="multicastEnhance")
    def multicast_enhance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether or not Multicast Enhance is turned of for the network.
        """
        return pulumi.get(self, "multicast_enhance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The SSID of the network.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the network for this SSID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="no2ghzOui")
    def no2ghz_oui(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Connect high performance clients to 5 GHz only. Defaults to `true`.
        """
        return pulumi.get(self, "no2ghz_oui")

    @_builtins.property
    @pulumi.getter
    def passphrase(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The passphrase for the network, this is only required if `security` is not set to `open`.
        """
        return pulumi.get(self, "passphrase")

    @_builtins.property
    @pulumi.getter(name="pmfMode")
    def pmf_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable Protected Management Frames. This cannot be disabled if using WPA 3. Valid values are `required`, `optional` and `disabled`. Defaults to `disabled`.
        """
        return pulumi.get(self, "pmf_mode")

    @_builtins.property
    @pulumi.getter(name="proxyArp")
    def proxy_arp(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Reduces airtime usage by allowing APs to "proxy" common broadcast frames as unicast. Defaults to `false`.
        """
        return pulumi.get(self, "proxy_arp")

    @_builtins.property
    @pulumi.getter(name="radiusProfileId")
    def radius_profile_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the RADIUS profile to use when security `wpaeap`. You can query this via the `RadiusProfile` data source.
        """
        return pulumi.get(self, "radius_profile_id")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> pulumi.Output[Optional[Sequence['outputs.WlanSchedule']]]:
        """
        Start and stop schedules for the WLAN
        """
        return pulumi.get(self, "schedules")

    @_builtins.property
    @pulumi.getter
    def security(self) -> pulumi.Output[_builtins.str]:
        """
        The type of WiFi security for this network. Valid values are: `wpapsk`, `wpaeap`, and `open`.
        """
        return pulumi.get(self, "security")

    @_builtins.property
    @pulumi.getter
    def site(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the site to associate the wlan with.
        """
        return pulumi.get(self, "site")

    @_builtins.property
    @pulumi.getter
    def uapsd(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable Unscheduled Automatic Power Save Delivery. Defaults to `false`.
        """
        return pulumi.get(self, "uapsd")

    @_builtins.property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the user group to use for this network.
        """
        return pulumi.get(self, "user_group_id")

    @_builtins.property
    @pulumi.getter(name="wlanBand")
    def wlan_band(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Radio band your WiFi network will use. Defaults to `both`.
        """
        return pulumi.get(self, "wlan_band")

    @_builtins.property
    @pulumi.getter(name="wpa3Support")
    def wpa3_support(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable WPA 3 support (security must be `wpapsk` and PMF must be turned on).
        """
        return pulumi.get(self, "wpa3_support")

    @_builtins.property
    @pulumi.getter(name="wpa3Transition")
    def wpa3_transition(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable WPA 3 and WPA 2 support (security must be `wpapsk` and `wpa3_support` must be true).
        """
        return pulumi.get(self, "wpa3_transition")

