import os
from pathlib import Path
from typing import Dict, Any

from checkov.common.bridgecrew.platform_integration import BcPlatformIntegration
from checkov.common.bridgecrew.vulnerability_scanning.integrations.twistcli import TwistcliIntegration
from checkov.common.util.str_utils import removeprefix


class PackageScanningIntegration(TwistcliIntegration):
    def create_report(
        self,
        twistcli_scan_result: Dict[str, Any],
        bc_platform_integration: BcPlatformIntegration,
        file_path: Path,
        **kwargs: Any,
    ) -> Dict[str, Any]:
        payload = {
            "packageName": str(file_path.name),
            "packageFilePath": removeprefix(str(file_path), os.getenv("BC_ROOT_DIR", "")),
            "type": "Package",
            "sourceId": bc_platform_integration.repo_id,
            "branch": bc_platform_integration.repo_branch,
            "sourceType": bc_platform_integration.bc_source.name,
            "vulnerabilities": self.get_vulnerabilities_for_report(twistcli_scan_result),
            "packages": self.get_packages_for_report(twistcli_scan_result),
        }
        if bc_platform_integration.cicd_details:
            payload["cicdDetails"] = bc_platform_integration.cicd_details
        return payload


package_scanning_integration = PackageScanningIntegration()
