import pytest
from io import StringIO
from ansiblemetrics.playbook.num_unique_names import NumUniqueNames

#script_unique_names
script_0 = '---\n- name: logic and comparison\n\thosts: localhost\n\tgather_facts: false\n\tvars:\n\tnum1: 10\n\tnum3: 10\n\ttasks:\n\t- name: logic and comparison\n\t\tdebug:\n\t\t\tmsg: "Can you read me?"\n\t\twhen: num1 >= num3 and num1 is even and num2 is not defined\n\t- name: logic and comparison\n\t\tdebug:\n\t\t\tmsg: "Can you read me again?"\n\t\twhen: num3 >= num1'
script_2 = '- become: false\n\tgather_facts: false\n\thosts: testhost\n\tname: Test vars_prompt confirm\n\ttasks:\n\t- assert:\n\t\t\tthat:\n\t\t\t- input == \'confirm me\'\n\t\tname: null\n\t- debug:\n\t\t\tvar: input\n\tvars_prompt:\n\t- confirm: true\n\t\tname: input'
script_3 = '---\n- name: demo the logic\n\thosts: localhost\n\tgather_facts: false\n\tvars:\n\tnum1: 10\n\tnum3: 10\n\ttasks:\n\t- name: logic and comparison 1\n\t\tdebug:\n\t\t\tmsg: "Can you read me?"\n\t\twhen: num1 >= num3 and num1 is even and num2 is not defined\n\t- name: logic and comparison 2\n\t\tdebug:\n\t\t\tmsg: "Can you read me again?"\n\t\twhen: num3 >= num1'
script_5 = '- hosts: all\n\ttasks:\n\t- delegate_to: localhost\n\t\tname: Retrieve the Root Storage Volume Template\n\t\toneview_storage_volume_template_facts:\n\t\t\tconfig: \'{{ config }}\'\n\t\t\tparams:\n\t\t\t\tcount: 1\n\t\t\t\tfilter: isRoot=\'True\'\n\t\t\t\tsort: name:descending\n\t\t\t\tstart: 0\n\t- set_fact: svt_root_uri="{{ storage_volume_templates[0][\'uri\'] }}"\n\t- delegate_to: localhost\n\t\tname: Create a Storage Volume Template\n\t\toneview_storage_volume_template:\n\t\t\tconfig: \'{{ config }}\'\n\t\t\tdata:\n\t\t\t\tdescription: \'\'\n\t\t\t\tname: \'{{ storage_vol_templ_name }}\'\n\t\t\t\tproperties:\n\t\t\t\t\tdescription:\n\t\t\t\t\t\tdefault: \'\'\n\t\t\t\t\t\tdescription: A description for the volume\n\t\t\t\t\t\tmaxLength: 2000\n\t\t\t\t\t\tmeta:\n\t\t\t\t\t\t\tlocked: false\n\t\t\t\t\t\tminLength: 0\n\t\t\t\t\t\ttitle: Description\n\t\t\t\t\t\ttype: string\n\t\t\t\t\tisShareable:\n\t\t\t\t\t\tdefault: false\n\t\t\t\t\t\tdescription: The shareability of the volume\n\t\t\t\t\t\tmeta:\n\t\t\t\t\t\t\tlocked: false\n\t\t\t\t\t\ttitle: Is Shareable\n\t\t\t\t\t\ttype: boolean\n\t\t\t\t\tname:\n\t\t\t\t\t\tdescription: A volume name between 1 and 100 characters\n\t\t\t\t\t\tmaxLength: 100\n\t\t\t\t\t\tmeta:\n\t\t\t\t\t\t\tlocked: false\n\t\t\t\t\t\tminLength: 1\n\t\t\t\t\t\trequired: true\n\t\t\t\t\t\ttitle: Volume name\n\t\t\t\t\t\ttype: string\n\t\t\t\t\tprovisioningType:\n\t\t\t\t\t\tdefault: Full\n\t\t\t\t\t\tdescription: The provisioning type for the volume\n\t\t\t\t\t\tenum:\n\t\t\t\t\t\t- Thin\n\t\t\t\t\t\t- Full\n\t\t\t\t\t\t- Thin Deduplication\n\t\t\t\t\t\tmeta:\n\t\t\t\t\t\t\tcreateOnly: true\n\t\t\t\t\t\t\tlocked: true\n\t\t\t\t\t\ttitle: Provisioning Type\n\t\t\t\t\t\ttype: string\n\t\t\t\t\tsize:\n\t\t\t\t\t\tdefault: 1073741824\n\t\t\t\t\t\tdescription: The capacity of the volume in bytes\n\t\t\t\t\t\tmaximum: 17592186044416\n\t\t\t\t\t\tmeta:\n\t\t\t\t\t\t\tlocked: false\n\t\t\t\t\t\t\tsemanticType: capacity\n\t\t\t\t\t\tminimum: 268435456\n\t\t\t\t\t\trequired: true\n\t\t\t\t\t\ttitle: Capacity\n\t\t\t\t\t\ttype: integer\n\t\t\t\t\tsnapshotPool:\n\t\t\t\t\t\tdefault: \'{{ storage_pool_uri }}\'\n\t\t\t\t\t\tdescription: A URI reference to the common provisioning group used to\n\t\t\t\t\t\t\tcreate snapshots\n\t\t\t\t\t\tformat: x-uri-reference\n\t\t\t\t\t\tmeta:\n\t\t\t\t\t\t\tlocked: true\n\t\t\t\t\t\t\tsemanticType: device-snapshot-storage-pool\n\t\t\t\t\t\ttitle: Snapshot Pool\n\t\t\t\t\t\ttype: string\n\t\t\t\t\tstoragePool:\n\t\t\t\t\t\tdefault: \'{{ storage_pool_uri }}\'\n\t\t\t\t\t\tdescription: A common provisioning group URI reference\n\t\t\t\t\t\tformat: x-uri-reference\n\t\t\t\t\t\tmeta:\n\t\t\t\t\t\t\tcreateOnly: true\n\t\t\t\t\t\t\tlocked: false\n\t\t\t\t\t\t\tsemanticType: device-storage-pool\n\t\t\t\t\t\trequired: true\n\t\t\t\t\t\ttitle: Storage Pool\n\t\t\t\t\t\ttype: string\n\t\t\t\trootTemplateUri: \'{{ svt_root_uri }}\'\n\t\t\tstate: present\n\t- delegate_to: localhost\n\t\tname: Update a Storage Volume Template provisioning type\n\t\toneview_storage_volume_template:\n\t\t\tconfig: \'{{ config }}\'\n\t\t\tdata:\n\t\t\t\tname: \'{{ storage_vol_templ_name }}\'\n\t\t\t\tproperties:\n\t\t\t\t\tprovisioningType:\n\t\t\t\t\t\tdefault: Thin\n\t\t\t\trootTemplateUri: \'{{ svt_root_uri }}\'\n\t\t\tstate: present\n\t- delegate_to: localhost\n\t\tname: Does not update when Storage Volume Template already as expected\n\t\toneview_storage_volume_template:\n\t\t\tconfig: \'{{ config }}\'\n\t\t\tdata:\n\t\t\t\tname: \'{{ storage_vol_templ_name }}\'\n\t\t\t\tproperties:\n\t\t\t\t\tprovisioningType:\n\t\t\t\t\t\tdefault: Thin\n\t\t\t\trootTemplateUri: \'{{ svt_root_uri }}\'\n\t\t\tstate: present\n\t- delegate_to: localhost\n\t\tname: Delete the Storage Volume Template\n\t\toneview_storage_volume_template:\n\t\t\tconfig: \'{{ config }}\'\n\t\t\tdata:\n\t\t\t\tname: \'{{storage_vol_templ_name}}\'\n\t\t\tstate: absent\n\tvars:\n\t\tconfig: \'{{ playbook_dir }}/oneview_config.json\'\n\t\tstorage_pool_uri: /rest/storage-pools/6BC7B518-BFB8-41A0-B173-A7C801352530\n\t\tstorage_vol_templ_name: svt1\n'

TEST_DATA = [
    (script_0, 0),
    (script_2, 2),
    (script_3, 3),
    (script_5, 5)
]

@pytest.mark.parametrize('script, expected', TEST_DATA)
def test(script, expected):
    script = StringIO(script.expandtabs(2))
    count = NumUniqueNames(script).count()
    script.close()
    assert count == expected