# Generated by Django 5.2.8 on 2025-11-23 07:25

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('name_ascii', models.CharField(max_length=100, verbose_name='ASCII Name')),
                ('geoname_id', models.IntegerField(unique=True, verbose_name='Geoname ID')),
                ('continent', models.CharField(max_length=50, verbose_name='Continent')),
                ('code2', models.CharField(max_length=2, unique=True, verbose_name='ISO Alpha-2 Code')),
                ('code3', models.CharField(max_length=3, unique=True, verbose_name='ISO Alpha-3 Code')),
                ('postal_code_format', models.CharField(blank=True, max_length=100, null=True, verbose_name='Postal Code Format')),
                ('postal_code_regex', models.CharField(blank=True, max_length=255, null=True, verbose_name='Postal Code Regex')),
                ('flag_png', models.URLField(blank=True, max_length=500, null=True, verbose_name='Flag PNG URL')),
                ('flag_svg', models.URLField(blank=True, max_length=500, null=True, verbose_name='Flag PNG URL')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
            ],
            options={
                'verbose_name': 'Country',
                'verbose_name_plural': 'Countries',
            },
        ),
        migrations.CreateModel(
            name='CallingCode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=20, verbose_name='Code')),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='calling_codes', to='geobank.country', verbose_name='Country')),
            ],
            options={
                'verbose_name': 'Calling Code',
                'verbose_name_plural': 'Calling Codes',
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('name_ascii', models.CharField(max_length=100, verbose_name='ASCII Name')),
                ('geoname_id', models.IntegerField(unique=True, verbose_name='Geoname ID')),
                ('code', models.CharField(max_length=10, verbose_name='Code')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='regions', to='geobank.country', verbose_name='Country')),
            ],
            options={
                'verbose_name': 'Region',
                'verbose_name_plural': 'Regions',
                'unique_together': {('country', 'code')},
            },
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('name_ascii', models.CharField(max_length=100, verbose_name='ASCII Name')),
                ('geoname_id', models.IntegerField(unique=True, verbose_name='Geoname ID')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cities', to='geobank.country', verbose_name='Country')),
                ('region', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='cities', to='geobank.region', verbose_name='Region')),
            ],
            options={
                'verbose_name': 'City',
                'verbose_name_plural': 'Cities',
            },
        ),
    ]
