# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1beta.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from datetime import datetime
from typing import Any, Dict, List, Optional, Tuple, Union

from pydantic import (
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
    validate_call,
)
from stackit.core.configuration import Configuration
from typing_extensions import Annotated

from stackit.cdn.api_client import ApiClient, RequestSerialized
from stackit.cdn.api_response import ApiResponse
from stackit.cdn.models.create_distribution_payload import CreateDistributionPayload
from stackit.cdn.models.create_distribution_response import CreateDistributionResponse
from stackit.cdn.models.delete_custom_domain_response import DeleteCustomDomainResponse
from stackit.cdn.models.delete_distribution_response import DeleteDistributionResponse
from stackit.cdn.models.find_cache_paths_response import FindCachePathsResponse
from stackit.cdn.models.get_cache_info_response import GetCacheInfoResponse
from stackit.cdn.models.get_custom_domain_response import GetCustomDomainResponse
from stackit.cdn.models.get_distribution_response import GetDistributionResponse
from stackit.cdn.models.get_logs_response import GetLogsResponse
from stackit.cdn.models.get_statistics_response import GetStatisticsResponse
from stackit.cdn.models.list_distributions_response import ListDistributionsResponse
from stackit.cdn.models.patch_distribution_payload import PatchDistributionPayload
from stackit.cdn.models.patch_distribution_response import PatchDistributionResponse
from stackit.cdn.models.purge_cache_payload import PurgeCachePayload
from stackit.cdn.models.put_custom_domain_payload import PutCustomDomainPayload
from stackit.cdn.models.put_custom_domain_response import PutCustomDomainResponse
from stackit.cdn.rest import RESTResponseType


class DefaultApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, configuration: Configuration = None) -> None:
        if configuration is None:
            configuration = Configuration()
        self.configuration = configuration
        self.api_client = ApiClient(self.configuration)

    @validate_call
    def create_distribution(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        create_distribution_payload: CreateDistributionPayload,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDistributionResponse:
        """Create new distribution

        CreateDistribution will create a new CDN distribution

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param create_distribution_payload: (required)
        :type create_distribution_payload: CreateDistributionPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_distribution_serialize(
            project_id=project_id,
            create_distribution_payload=create_distribution_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CreateDistributionResponse",
            "400": "GenericJSONResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_distribution_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        create_distribution_payload: CreateDistributionPayload,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDistributionResponse]:
        """Create new distribution

        CreateDistribution will create a new CDN distribution

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param create_distribution_payload: (required)
        :type create_distribution_payload: CreateDistributionPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_distribution_serialize(
            project_id=project_id,
            create_distribution_payload=create_distribution_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CreateDistributionResponse",
            "400": "GenericJSONResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_distribution_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        create_distribution_payload: CreateDistributionPayload,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create new distribution

        CreateDistribution will create a new CDN distribution

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param create_distribution_payload: (required)
        :type create_distribution_payload: CreateDistributionPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_distribution_serialize(
            project_id=project_id,
            create_distribution_payload=create_distribution_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CreateDistributionResponse",
            "400": "GenericJSONResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_distribution_serialize(
        self,
        project_id,
        create_distribution_payload,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_distribution_payload is not None:
            _body_params = create_distribution_payload

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/v1beta/projects/{projectId}/distributions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_custom_domain(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        intent_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteCustomDomainResponse:
        """Delete a custom domain

        Removes a custom domain

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param intent_id:
        :type intent_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            intent_id=intent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "DeleteCustomDomainResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_custom_domain_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        intent_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteCustomDomainResponse]:
        """Delete a custom domain

        Removes a custom domain

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param intent_id:
        :type intent_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            intent_id=intent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "DeleteCustomDomainResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_custom_domain_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        intent_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a custom domain

        Removes a custom domain

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param intent_id:
        :type intent_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            intent_id=intent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "DeleteCustomDomainResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _delete_custom_domain_serialize(
        self,
        project_id,
        distribution_id,
        domain,
        intent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        if domain is not None:
            _path_params["domain"] = domain
        # process the query parameters
        if intent_id is not None:

            _query_params.append(("intentId", intent_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/customDomains/{domain}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_distribution(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        intent_id: Annotated[
            Optional[StrictStr],
            Field(
                description="While optional, it is greatly encouraged to provide an `intentId`.  This is used to deduplicate requests.   If multiple DELETE-Requests with the same `intentId` are received, all but the first request are dropped. "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteDistributionResponse:
        """Delete distribution

        DeleteDistribution accepts a project- and distribution-ID and will delete a distribution.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param intent_id: While optional, it is greatly encouraged to provide an `intentId`.  This is used to deduplicate requests.   If multiple DELETE-Requests with the same `intentId` are received, all but the first request are dropped.
        :type intent_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            intent_id=intent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "DeleteDistributionResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_distribution_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        intent_id: Annotated[
            Optional[StrictStr],
            Field(
                description="While optional, it is greatly encouraged to provide an `intentId`.  This is used to deduplicate requests.   If multiple DELETE-Requests with the same `intentId` are received, all but the first request are dropped. "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteDistributionResponse]:
        """Delete distribution

        DeleteDistribution accepts a project- and distribution-ID and will delete a distribution.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param intent_id: While optional, it is greatly encouraged to provide an `intentId`.  This is used to deduplicate requests.   If multiple DELETE-Requests with the same `intentId` are received, all but the first request are dropped.
        :type intent_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            intent_id=intent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "DeleteDistributionResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_distribution_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        intent_id: Annotated[
            Optional[StrictStr],
            Field(
                description="While optional, it is greatly encouraged to provide an `intentId`.  This is used to deduplicate requests.   If multiple DELETE-Requests with the same `intentId` are received, all but the first request are dropped. "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete distribution

        DeleteDistribution accepts a project- and distribution-ID and will delete a distribution.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param intent_id: While optional, it is greatly encouraged to provide an `intentId`.  This is used to deduplicate requests.   If multiple DELETE-Requests with the same `intentId` are received, all but the first request are dropped.
        :type intent_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            intent_id=intent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "DeleteDistributionResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _delete_distribution_serialize(
        self,
        project_id,
        distribution_id,
        intent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        if intent_id is not None:

            _query_params.append(("intentId", intent_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def find_cache_paths(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        path: Annotated[StrictStr, Field(description="A substring of the search query. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FindCachePathsResponse:
        """Return Paths that were purged

        This returns paths that are present in the cache purging history.  Only substrings of the provided input are returned.  The response is sorted in descending order by the most recent purge.  So, assuming you have have the following purged for a distribution - `/test/1` at `2025-01-01` - `/test/2` at `2025-01-02` - `/someOtherPath/1` at `2025-01-03` - `/test/1` at `2025-01-04` - `/test/3` at `2025-01-05`, this would return the following paths, in the following order, assuming `/te` was the search parameter: - `/test/3` - `/test/1` - `/test/2`

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param path: A substring of the search query.  (required)
        :type path: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._find_cache_paths_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            path=path,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FindCachePathsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def find_cache_paths_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        path: Annotated[StrictStr, Field(description="A substring of the search query. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FindCachePathsResponse]:
        """Return Paths that were purged

        This returns paths that are present in the cache purging history.  Only substrings of the provided input are returned.  The response is sorted in descending order by the most recent purge.  So, assuming you have have the following purged for a distribution - `/test/1` at `2025-01-01` - `/test/2` at `2025-01-02` - `/someOtherPath/1` at `2025-01-03` - `/test/1` at `2025-01-04` - `/test/3` at `2025-01-05`, this would return the following paths, in the following order, assuming `/te` was the search parameter: - `/test/3` - `/test/1` - `/test/2`

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param path: A substring of the search query.  (required)
        :type path: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._find_cache_paths_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            path=path,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FindCachePathsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def find_cache_paths_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        path: Annotated[StrictStr, Field(description="A substring of the search query. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Return Paths that were purged

        This returns paths that are present in the cache purging history.  Only substrings of the provided input are returned.  The response is sorted in descending order by the most recent purge.  So, assuming you have have the following purged for a distribution - `/test/1` at `2025-01-01` - `/test/2` at `2025-01-02` - `/someOtherPath/1` at `2025-01-03` - `/test/1` at `2025-01-04` - `/test/3` at `2025-01-05`, this would return the following paths, in the following order, assuming `/te` was the search parameter: - `/test/3` - `/test/1` - `/test/2`

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param path: A substring of the search query.  (required)
        :type path: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._find_cache_paths_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            path=path,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FindCachePathsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _find_cache_paths_serialize(
        self,
        project_id,
        distribution_id,
        path,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        if path is not None:

            _query_params.append(("path", path))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/cache/paths",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_cache_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        purge_path: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCacheInfoResponse:
        """Get Infos about the Caching State

        Return caching info metadata, which contains the last cache purging time and a history of the most recent *full* purges.  If (and only if) you provide the path query parameter, the history will also contain granular cache purges.  The request will not fail if no data about a path is found.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param purge_path:
        :type purge_path: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_cache_info_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            purge_path=purge_path,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetCacheInfoResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_cache_info_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        purge_path: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCacheInfoResponse]:
        """Get Infos about the Caching State

        Return caching info metadata, which contains the last cache purging time and a history of the most recent *full* purges.  If (and only if) you provide the path query parameter, the history will also contain granular cache purges.  The request will not fail if no data about a path is found.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param purge_path:
        :type purge_path: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_cache_info_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            purge_path=purge_path,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetCacheInfoResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_cache_info_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        purge_path: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Infos about the Caching State

        Return caching info metadata, which contains the last cache purging time and a history of the most recent *full* purges.  If (and only if) you provide the path query parameter, the history will also contain granular cache purges.  The request will not fail if no data about a path is found.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param purge_path:
        :type purge_path: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_cache_info_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            purge_path=purge_path,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetCacheInfoResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_cache_info_serialize(
        self,
        project_id,
        distribution_id,
        purge_path,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        if purge_path is not None:

            _query_params.append(("purgePath", purge_path))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/cache",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_custom_domain(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCustomDomainResponse:
        """Retrieve a specific custom domain

        Returns a 200 and the custom domain if this custom domain was associated to this distribution, else 404

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetCustomDomainResponse",
            "401": "str",
            "404": "GenericJSONResponse",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_custom_domain_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCustomDomainResponse]:
        """Retrieve a specific custom domain

        Returns a 200 and the custom domain if this custom domain was associated to this distribution, else 404

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetCustomDomainResponse",
            "401": "str",
            "404": "GenericJSONResponse",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_custom_domain_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a specific custom domain

        Returns a 200 and the custom domain if this custom domain was associated to this distribution, else 404

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetCustomDomainResponse",
            "401": "str",
            "404": "GenericJSONResponse",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_custom_domain_serialize(
        self,
        project_id,
        distribution_id,
        domain,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        if domain is not None:
            _path_params["domain"] = domain
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/customDomains/{domain}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_distribution(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetDistributionResponse:
        """Get distribution by ID

        This returns a specific distribution by its ID. If no distribution with the given ID exists the endpoint returns 404. Trying to get a deleted distributions also return 404.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetDistributionResponse",
            "401": "str",
            "404": "GenericJSONResponse",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_distribution_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetDistributionResponse]:
        """Get distribution by ID

        This returns a specific distribution by its ID. If no distribution with the given ID exists the endpoint returns 404. Trying to get a deleted distributions also return 404.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetDistributionResponse",
            "401": "str",
            "404": "GenericJSONResponse",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_distribution_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get distribution by ID

        This returns a specific distribution by its ID. If no distribution with the given ID exists the endpoint returns 404. Trying to get a deleted distributions also return 404.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetDistributionResponse",
            "401": "str",
            "404": "GenericJSONResponse",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_distribution_serialize(
        self,
        project_id,
        distribution_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_logs(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: Annotated[StrictStr, Field(description="Your CDN distribution ID")],
        var_from: Annotated[
            Optional[datetime], Field(description="the start of the time range for which logs should be returned")
        ] = None,
        to: Annotated[
            Optional[datetime],
            Field(
                description='the end of the time range for which logs should be returned. If not specified,  "now" is used. '
            ),
        ] = None,
        page_size: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(
                description="Quantifies how many log entries should be returned on this  page. Must be a natural number between 1 and 1000 (inclusive) "
            ),
        ] = None,
        page_identifier: Annotated[
            Optional[StrictStr],
            Field(
                description='Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get "pushed" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API. '
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="The following sort options exist. We default to `timestamp` - `timestamp` - Sort by log message time stamp. "
            ),
        ] = None,
        sort_order: Optional[StrictStr] = None,
        data_center_region: Annotated[
            Optional[StrictStr],
            Field(
                description="Filters by the CDN data center region that served the request. Can be combined with other filters "
            ),
        ] = None,
        request_country_code: Annotated[
            Optional[StrictStr],
            Field(
                description="Filters by the originating country of the user request. Can be combined with other filters "
            ),
        ] = None,
        status_code: Annotated[
            Optional[StrictInt],
            Field(
                description="Filters by the HTTP status code returned to the client. Can be combined with other filters "
            ),
        ] = None,
        cache_hit: Annotated[
            Optional[StrictBool],
            Field(
                description="Filters based on whether the request was served from the CDN cache. Can be combined with other filters "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetLogsResponse:
        """Retrieve distribution logs


        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: Your CDN distribution ID (required)
        :type distribution_id: str
        :param var_from: the start of the time range for which logs should be returned
        :type var_from: datetime
        :param to: the end of the time range for which logs should be returned. If not specified,  \"now\" is used.
        :type to: datetime
        :param page_size: Quantifies how many log entries should be returned on this  page. Must be a natural number between 1 and 1000 (inclusive)
        :type page_size: int
        :param page_identifier: Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get \"pushed\" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API.
        :type page_identifier: str
        :param sort_by: The following sort options exist. We default to `timestamp` - `timestamp` - Sort by log message time stamp.
        :type sort_by: str
        :param sort_order:
        :type sort_order: str
        :param data_center_region: Filters by the CDN data center region that served the request. Can be combined with other filters
        :type data_center_region: str
        :param request_country_code: Filters by the originating country of the user request. Can be combined with other filters
        :type request_country_code: str
        :param status_code: Filters by the HTTP status code returned to the client. Can be combined with other filters
        :type status_code: int
        :param cache_hit: Filters based on whether the request was served from the CDN cache. Can be combined with other filters
        :type cache_hit: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_logs_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            var_from=var_from,
            to=to,
            page_size=page_size,
            page_identifier=page_identifier,
            sort_by=sort_by,
            sort_order=sort_order,
            data_center_region=data_center_region,
            request_country_code=request_country_code,
            status_code=status_code,
            cache_hit=cache_hit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetLogsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_logs_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: Annotated[StrictStr, Field(description="Your CDN distribution ID")],
        var_from: Annotated[
            Optional[datetime], Field(description="the start of the time range for which logs should be returned")
        ] = None,
        to: Annotated[
            Optional[datetime],
            Field(
                description='the end of the time range for which logs should be returned. If not specified,  "now" is used. '
            ),
        ] = None,
        page_size: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(
                description="Quantifies how many log entries should be returned on this  page. Must be a natural number between 1 and 1000 (inclusive) "
            ),
        ] = None,
        page_identifier: Annotated[
            Optional[StrictStr],
            Field(
                description='Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get "pushed" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API. '
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="The following sort options exist. We default to `timestamp` - `timestamp` - Sort by log message time stamp. "
            ),
        ] = None,
        sort_order: Optional[StrictStr] = None,
        data_center_region: Annotated[
            Optional[StrictStr],
            Field(
                description="Filters by the CDN data center region that served the request. Can be combined with other filters "
            ),
        ] = None,
        request_country_code: Annotated[
            Optional[StrictStr],
            Field(
                description="Filters by the originating country of the user request. Can be combined with other filters "
            ),
        ] = None,
        status_code: Annotated[
            Optional[StrictInt],
            Field(
                description="Filters by the HTTP status code returned to the client. Can be combined with other filters "
            ),
        ] = None,
        cache_hit: Annotated[
            Optional[StrictBool],
            Field(
                description="Filters based on whether the request was served from the CDN cache. Can be combined with other filters "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetLogsResponse]:
        """Retrieve distribution logs


        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: Your CDN distribution ID (required)
        :type distribution_id: str
        :param var_from: the start of the time range for which logs should be returned
        :type var_from: datetime
        :param to: the end of the time range for which logs should be returned. If not specified,  \"now\" is used.
        :type to: datetime
        :param page_size: Quantifies how many log entries should be returned on this  page. Must be a natural number between 1 and 1000 (inclusive)
        :type page_size: int
        :param page_identifier: Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get \"pushed\" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API.
        :type page_identifier: str
        :param sort_by: The following sort options exist. We default to `timestamp` - `timestamp` - Sort by log message time stamp.
        :type sort_by: str
        :param sort_order:
        :type sort_order: str
        :param data_center_region: Filters by the CDN data center region that served the request. Can be combined with other filters
        :type data_center_region: str
        :param request_country_code: Filters by the originating country of the user request. Can be combined with other filters
        :type request_country_code: str
        :param status_code: Filters by the HTTP status code returned to the client. Can be combined with other filters
        :type status_code: int
        :param cache_hit: Filters based on whether the request was served from the CDN cache. Can be combined with other filters
        :type cache_hit: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_logs_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            var_from=var_from,
            to=to,
            page_size=page_size,
            page_identifier=page_identifier,
            sort_by=sort_by,
            sort_order=sort_order,
            data_center_region=data_center_region,
            request_country_code=request_country_code,
            status_code=status_code,
            cache_hit=cache_hit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetLogsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_logs_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: Annotated[StrictStr, Field(description="Your CDN distribution ID")],
        var_from: Annotated[
            Optional[datetime], Field(description="the start of the time range for which logs should be returned")
        ] = None,
        to: Annotated[
            Optional[datetime],
            Field(
                description='the end of the time range for which logs should be returned. If not specified,  "now" is used. '
            ),
        ] = None,
        page_size: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(
                description="Quantifies how many log entries should be returned on this  page. Must be a natural number between 1 and 1000 (inclusive) "
            ),
        ] = None,
        page_identifier: Annotated[
            Optional[StrictStr],
            Field(
                description='Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get "pushed" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API. '
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="The following sort options exist. We default to `timestamp` - `timestamp` - Sort by log message time stamp. "
            ),
        ] = None,
        sort_order: Optional[StrictStr] = None,
        data_center_region: Annotated[
            Optional[StrictStr],
            Field(
                description="Filters by the CDN data center region that served the request. Can be combined with other filters "
            ),
        ] = None,
        request_country_code: Annotated[
            Optional[StrictStr],
            Field(
                description="Filters by the originating country of the user request. Can be combined with other filters "
            ),
        ] = None,
        status_code: Annotated[
            Optional[StrictInt],
            Field(
                description="Filters by the HTTP status code returned to the client. Can be combined with other filters "
            ),
        ] = None,
        cache_hit: Annotated[
            Optional[StrictBool],
            Field(
                description="Filters based on whether the request was served from the CDN cache. Can be combined with other filters "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve distribution logs


        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: Your CDN distribution ID (required)
        :type distribution_id: str
        :param var_from: the start of the time range for which logs should be returned
        :type var_from: datetime
        :param to: the end of the time range for which logs should be returned. If not specified,  \"now\" is used.
        :type to: datetime
        :param page_size: Quantifies how many log entries should be returned on this  page. Must be a natural number between 1 and 1000 (inclusive)
        :type page_size: int
        :param page_identifier: Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get \"pushed\" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API.
        :type page_identifier: str
        :param sort_by: The following sort options exist. We default to `timestamp` - `timestamp` - Sort by log message time stamp.
        :type sort_by: str
        :param sort_order:
        :type sort_order: str
        :param data_center_region: Filters by the CDN data center region that served the request. Can be combined with other filters
        :type data_center_region: str
        :param request_country_code: Filters by the originating country of the user request. Can be combined with other filters
        :type request_country_code: str
        :param status_code: Filters by the HTTP status code returned to the client. Can be combined with other filters
        :type status_code: int
        :param cache_hit: Filters based on whether the request was served from the CDN cache. Can be combined with other filters
        :type cache_hit: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_logs_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            var_from=var_from,
            to=to,
            page_size=page_size,
            page_identifier=page_identifier,
            sort_by=sort_by,
            sort_order=sort_order,
            data_center_region=data_center_region,
            request_country_code=request_country_code,
            status_code=status_code,
            cache_hit=cache_hit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetLogsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_logs_serialize(
        self,
        project_id,
        distribution_id,
        var_from,
        to,
        page_size,
        page_identifier,
        sort_by,
        sort_order,
        data_center_region,
        request_country_code,
        status_code,
        cache_hit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, datetime):
                _query_params.append(("from", var_from.strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(("from", var_from))

        if to is not None:
            if isinstance(to, datetime):
                _query_params.append(("to", to.strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(("to", to))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if page_identifier is not None:

            _query_params.append(("pageIdentifier", page_identifier))

        if sort_by is not None:

            _query_params.append(("sortBy", sort_by))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order))

        if data_center_region is not None:

            _query_params.append(("dataCenterRegion", data_center_region))

        if request_country_code is not None:

            _query_params.append(("requestCountryCode", request_country_code))

        if status_code is not None:

            _query_params.append(("statusCode", status_code))

        if cache_hit is not None:

            _query_params.append(("cacheHit", cache_hit))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/logs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_statistics(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        var_from: Annotated[
            datetime, Field(description="the start of the time range for which statistics should be returned")
        ],
        to: Annotated[
            Optional[datetime],
            Field(
                description="the end of the time range for which statistics should be returned. If not specified,  the end of the current time interval is used, e.g. next day for daily,  next month for monthly, and so on. "
            ),
        ] = None,
        interval: Annotated[
            Optional[StrictStr],
            Field(
                description="Over which interval should statistics be aggregated?  defaults to hourly resolution  **NOTE**: Intervals are grouped in buckets that start and end based on a day in UTC+0 time. So for the `daily` interval, the group starts (inclusive) and ends (exclusive) at `00:00Z` "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetStatisticsResponse:
        """Retrieve the statistics of a distribution

        Returns the statistics of the distribution in the given time range. The response is a list of statistics records. Each record aggregates the statistics for its time interval. In case no statistics for a time interval exist, no record is returned. The time range for which statistics should be returned can be configured using query parameters.  Timestamps are assumed to be UTC. This is especially important for the \"buckets\" when you, for example, return daily information. A day always starts and ends at 00:00Z.  **Important Note:** Lower bounds are inclusive, upper bounds are exclusive. If you, for example, want a daily grouped which starts on the 1st Jan and also contains the full 10th Jan day, you would define `2025-01-01T00:00:00Z` as the lower and `2025-01-11T00:00:00Z` as the upper bound.  The upper bound is optional. If you omit it, the API will use the start of the next interval as the upper bound.   Example: if `interval` is `hourly`, `from` would default to the start of the next hour, if it's `daily`, `from` would default to the start of the next day, etc.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param var_from: the start of the time range for which statistics should be returned (required)
        :type var_from: datetime
        :param to: the end of the time range for which statistics should be returned. If not specified,  the end of the current time interval is used, e.g. next day for daily,  next month for monthly, and so on.
        :type to: datetime
        :param interval: Over which interval should statistics be aggregated?  defaults to hourly resolution  **NOTE**: Intervals are grouped in buckets that start and end based on a day in UTC+0 time. So for the `daily` interval, the group starts (inclusive) and ends (exclusive) at `00:00Z`
        :type interval: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_statistics_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            var_from=var_from,
            to=to,
            interval=interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetStatisticsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_statistics_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        var_from: Annotated[
            datetime, Field(description="the start of the time range for which statistics should be returned")
        ],
        to: Annotated[
            Optional[datetime],
            Field(
                description="the end of the time range for which statistics should be returned. If not specified,  the end of the current time interval is used, e.g. next day for daily,  next month for monthly, and so on. "
            ),
        ] = None,
        interval: Annotated[
            Optional[StrictStr],
            Field(
                description="Over which interval should statistics be aggregated?  defaults to hourly resolution  **NOTE**: Intervals are grouped in buckets that start and end based on a day in UTC+0 time. So for the `daily` interval, the group starts (inclusive) and ends (exclusive) at `00:00Z` "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetStatisticsResponse]:
        """Retrieve the statistics of a distribution

        Returns the statistics of the distribution in the given time range. The response is a list of statistics records. Each record aggregates the statistics for its time interval. In case no statistics for a time interval exist, no record is returned. The time range for which statistics should be returned can be configured using query parameters.  Timestamps are assumed to be UTC. This is especially important for the \"buckets\" when you, for example, return daily information. A day always starts and ends at 00:00Z.  **Important Note:** Lower bounds are inclusive, upper bounds are exclusive. If you, for example, want a daily grouped which starts on the 1st Jan and also contains the full 10th Jan day, you would define `2025-01-01T00:00:00Z` as the lower and `2025-01-11T00:00:00Z` as the upper bound.  The upper bound is optional. If you omit it, the API will use the start of the next interval as the upper bound.   Example: if `interval` is `hourly`, `from` would default to the start of the next hour, if it's `daily`, `from` would default to the start of the next day, etc.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param var_from: the start of the time range for which statistics should be returned (required)
        :type var_from: datetime
        :param to: the end of the time range for which statistics should be returned. If not specified,  the end of the current time interval is used, e.g. next day for daily,  next month for monthly, and so on.
        :type to: datetime
        :param interval: Over which interval should statistics be aggregated?  defaults to hourly resolution  **NOTE**: Intervals are grouped in buckets that start and end based on a day in UTC+0 time. So for the `daily` interval, the group starts (inclusive) and ends (exclusive) at `00:00Z`
        :type interval: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_statistics_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            var_from=var_from,
            to=to,
            interval=interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetStatisticsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_statistics_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        var_from: Annotated[
            datetime, Field(description="the start of the time range for which statistics should be returned")
        ],
        to: Annotated[
            Optional[datetime],
            Field(
                description="the end of the time range for which statistics should be returned. If not specified,  the end of the current time interval is used, e.g. next day for daily,  next month for monthly, and so on. "
            ),
        ] = None,
        interval: Annotated[
            Optional[StrictStr],
            Field(
                description="Over which interval should statistics be aggregated?  defaults to hourly resolution  **NOTE**: Intervals are grouped in buckets that start and end based on a day in UTC+0 time. So for the `daily` interval, the group starts (inclusive) and ends (exclusive) at `00:00Z` "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve the statistics of a distribution

        Returns the statistics of the distribution in the given time range. The response is a list of statistics records. Each record aggregates the statistics for its time interval. In case no statistics for a time interval exist, no record is returned. The time range for which statistics should be returned can be configured using query parameters.  Timestamps are assumed to be UTC. This is especially important for the \"buckets\" when you, for example, return daily information. A day always starts and ends at 00:00Z.  **Important Note:** Lower bounds are inclusive, upper bounds are exclusive. If you, for example, want a daily grouped which starts on the 1st Jan and also contains the full 10th Jan day, you would define `2025-01-01T00:00:00Z` as the lower and `2025-01-11T00:00:00Z` as the upper bound.  The upper bound is optional. If you omit it, the API will use the start of the next interval as the upper bound.   Example: if `interval` is `hourly`, `from` would default to the start of the next hour, if it's `daily`, `from` would default to the start of the next day, etc.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param var_from: the start of the time range for which statistics should be returned (required)
        :type var_from: datetime
        :param to: the end of the time range for which statistics should be returned. If not specified,  the end of the current time interval is used, e.g. next day for daily,  next month for monthly, and so on.
        :type to: datetime
        :param interval: Over which interval should statistics be aggregated?  defaults to hourly resolution  **NOTE**: Intervals are grouped in buckets that start and end based on a day in UTC+0 time. So for the `daily` interval, the group starts (inclusive) and ends (exclusive) at `00:00Z`
        :type interval: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_statistics_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            var_from=var_from,
            to=to,
            interval=interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetStatisticsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_statistics_serialize(
        self,
        project_id,
        distribution_id,
        var_from,
        to,
        interval,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        if var_from is not None:
            if isinstance(var_from, datetime):
                _query_params.append(("from", var_from.strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(("from", var_from))

        if to is not None:
            if isinstance(to, datetime):
                _query_params.append(("to", to.strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(("to", to))

        if interval is not None:

            _query_params.append(("interval", interval))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/statistics",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_distributions(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        page_size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(
                description="Quantifies how many distributions should be returned on this  page. Must be a natural number between 1 and 100 (inclusive) "
            ),
        ] = None,
        page_identifier: Annotated[
            Optional[StrictStr],
            Field(
                description='Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get "pushed" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API. '
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="The following sort options exist. We default to `createdAt` - `id` - Sort by distribution ID using String comparison - `updatedAt` - Sort by when the distribution configuration was last modified,    for example by changing the regions or response headers - `createdAt` - Sort by when the distribution was initially created. - `originUrl` - Sort by originURL using String comparison - `status` - Sort by distribution status, using String comparison - `originUrlRelated` - The origin URL is segmented and reversed before sorting. E.g. `www.example.com` is converted to `com.example.www` for sorting. This way, distributions pointing to the same domain trees are grouped next to each other. "
            ),
        ] = None,
        sort_order: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListDistributionsResponse:
        """List all distributions belonging to a specific project

        ListDistributions returns a list of all CDN distributions associated with  a given project, ordered by their distribution ID.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param page_size: Quantifies how many distributions should be returned on this  page. Must be a natural number between 1 and 100 (inclusive)
        :type page_size: int
        :param page_identifier: Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get \"pushed\" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API.
        :type page_identifier: str
        :param sort_by: The following sort options exist. We default to `createdAt` - `id` - Sort by distribution ID using String comparison - `updatedAt` - Sort by when the distribution configuration was last modified,    for example by changing the regions or response headers - `createdAt` - Sort by when the distribution was initially created. - `originUrl` - Sort by originURL using String comparison - `status` - Sort by distribution status, using String comparison - `originUrlRelated` - The origin URL is segmented and reversed before sorting. E.g. `www.example.com` is converted to `com.example.www` for sorting. This way, distributions pointing to the same domain trees are grouped next to each other.
        :type sort_by: str
        :param sort_order:
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_distributions_serialize(
            project_id=project_id,
            page_size=page_size,
            page_identifier=page_identifier,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListDistributionsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_distributions_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        page_size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(
                description="Quantifies how many distributions should be returned on this  page. Must be a natural number between 1 and 100 (inclusive) "
            ),
        ] = None,
        page_identifier: Annotated[
            Optional[StrictStr],
            Field(
                description='Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get "pushed" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API. '
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="The following sort options exist. We default to `createdAt` - `id` - Sort by distribution ID using String comparison - `updatedAt` - Sort by when the distribution configuration was last modified,    for example by changing the regions or response headers - `createdAt` - Sort by when the distribution was initially created. - `originUrl` - Sort by originURL using String comparison - `status` - Sort by distribution status, using String comparison - `originUrlRelated` - The origin URL is segmented and reversed before sorting. E.g. `www.example.com` is converted to `com.example.www` for sorting. This way, distributions pointing to the same domain trees are grouped next to each other. "
            ),
        ] = None,
        sort_order: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListDistributionsResponse]:
        """List all distributions belonging to a specific project

        ListDistributions returns a list of all CDN distributions associated with  a given project, ordered by their distribution ID.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param page_size: Quantifies how many distributions should be returned on this  page. Must be a natural number between 1 and 100 (inclusive)
        :type page_size: int
        :param page_identifier: Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get \"pushed\" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API.
        :type page_identifier: str
        :param sort_by: The following sort options exist. We default to `createdAt` - `id` - Sort by distribution ID using String comparison - `updatedAt` - Sort by when the distribution configuration was last modified,    for example by changing the regions or response headers - `createdAt` - Sort by when the distribution was initially created. - `originUrl` - Sort by originURL using String comparison - `status` - Sort by distribution status, using String comparison - `originUrlRelated` - The origin URL is segmented and reversed before sorting. E.g. `www.example.com` is converted to `com.example.www` for sorting. This way, distributions pointing to the same domain trees are grouped next to each other.
        :type sort_by: str
        :param sort_order:
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_distributions_serialize(
            project_id=project_id,
            page_size=page_size,
            page_identifier=page_identifier,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListDistributionsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_distributions_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        page_size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(
                description="Quantifies how many distributions should be returned on this  page. Must be a natural number between 1 and 100 (inclusive) "
            ),
        ] = None,
        page_identifier: Annotated[
            Optional[StrictStr],
            Field(
                description='Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get "pushed" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API. '
            ),
        ] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="The following sort options exist. We default to `createdAt` - `id` - Sort by distribution ID using String comparison - `updatedAt` - Sort by when the distribution configuration was last modified,    for example by changing the regions or response headers - `createdAt` - Sort by when the distribution was initially created. - `originUrl` - Sort by originURL using String comparison - `status` - Sort by distribution status, using String comparison - `originUrlRelated` - The origin URL is segmented and reversed before sorting. E.g. `www.example.com` is converted to `com.example.www` for sorting. This way, distributions pointing to the same domain trees are grouped next to each other. "
            ),
        ] = None,
        sort_order: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List all distributions belonging to a specific project

        ListDistributions returns a list of all CDN distributions associated with  a given project, ordered by their distribution ID.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param page_size: Quantifies how many distributions should be returned on this  page. Must be a natural number between 1 and 100 (inclusive)
        :type page_size: int
        :param page_identifier: Identifier is returned by the previous response and is used to request the next page.  As the `pageIdentifier` encodes an element, inserts during pagination will *not* shift the result. So a scenario like:   - Start listing first page - Insert new element - Start listing second page will *never* result in an element from the first page to get \"pushed\" to the second page, like it could  occur with basic limit + offset pagination.  The identifier should be treated as an opaque string and never modified. Only pass values returned by the API.
        :type page_identifier: str
        :param sort_by: The following sort options exist. We default to `createdAt` - `id` - Sort by distribution ID using String comparison - `updatedAt` - Sort by when the distribution configuration was last modified,    for example by changing the regions or response headers - `createdAt` - Sort by when the distribution was initially created. - `originUrl` - Sort by originURL using String comparison - `status` - Sort by distribution status, using String comparison - `originUrlRelated` - The origin URL is segmented and reversed before sorting. E.g. `www.example.com` is converted to `com.example.www` for sorting. This way, distributions pointing to the same domain trees are grouped next to each other.
        :type sort_by: str
        :param sort_order:
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_distributions_serialize(
            project_id=project_id,
            page_size=page_size,
            page_identifier=page_identifier,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListDistributionsResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_distributions_serialize(
        self,
        project_id,
        page_size,
        page_identifier,
        sort_by,
        sort_order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        # process the query parameters
        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if page_identifier is not None:

            _query_params.append(("pageIdentifier", page_identifier))

        if sort_by is not None:

            _query_params.append(("sortBy", sort_by))

        if sort_order is not None:

            _query_params.append(("sortOrder", sort_order))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/v1beta/projects/{projectId}/distributions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def patch_distribution(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        patch_distribution_payload: Optional[PatchDistributionPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PatchDistributionResponse:
        """Update existing distribution

        Modify a CDN distribution with a partial update. Only the fields specified in the request will be modified.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param patch_distribution_payload:
        :type patch_distribution_payload: PatchDistributionPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._patch_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            patch_distribution_payload=patch_distribution_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PatchDistributionResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def patch_distribution_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        patch_distribution_payload: Optional[PatchDistributionPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PatchDistributionResponse]:
        """Update existing distribution

        Modify a CDN distribution with a partial update. Only the fields specified in the request will be modified.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param patch_distribution_payload:
        :type patch_distribution_payload: PatchDistributionPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._patch_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            patch_distribution_payload=patch_distribution_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PatchDistributionResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def patch_distribution_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        patch_distribution_payload: Optional[PatchDistributionPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update existing distribution

        Modify a CDN distribution with a partial update. Only the fields specified in the request will be modified.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param patch_distribution_payload:
        :type patch_distribution_payload: PatchDistributionPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._patch_distribution_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            patch_distribution_payload=patch_distribution_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PatchDistributionResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _patch_distribution_serialize(
        self,
        project_id,
        distribution_id,
        patch_distribution_payload,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patch_distribution_payload is not None:
            _body_params = patch_distribution_payload

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def purge_cache(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        purge_cache_payload: Optional[PurgeCachePayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Clear distribution cache

        Clear the cache for this distribution.  All content, regardless of its staleness, will get refetched from the host.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param purge_cache_payload:
        :type purge_cache_payload: PurgeCachePayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._purge_cache_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            purge_cache_payload=purge_cache_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "object",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def purge_cache_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        purge_cache_payload: Optional[PurgeCachePayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Clear distribution cache

        Clear the cache for this distribution.  All content, regardless of its staleness, will get refetched from the host.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param purge_cache_payload:
        :type purge_cache_payload: PurgeCachePayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._purge_cache_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            purge_cache_payload=purge_cache_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "object",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def purge_cache_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        purge_cache_payload: Optional[PurgeCachePayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Clear distribution cache

        Clear the cache for this distribution.  All content, regardless of its staleness, will get refetched from the host.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param purge_cache_payload:
        :type purge_cache_payload: PurgeCachePayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._purge_cache_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            purge_cache_payload=purge_cache_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "object",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _purge_cache_serialize(
        self,
        project_id,
        distribution_id,
        purge_cache_payload,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if purge_cache_payload is not None:
            _body_params = purge_cache_payload

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/cache/purge",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def put_custom_domain(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        put_custom_domain_payload: Optional[PutCustomDomainPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PutCustomDomainResponse:
        """Create or update a custom domain

        Creates a new custom domain. If it already exists, this will overwrite the previous custom domain's properties.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param put_custom_domain_payload:
        :type put_custom_domain_payload: PutCustomDomainPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._put_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            put_custom_domain_payload=put_custom_domain_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PutCustomDomainResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def put_custom_domain_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        put_custom_domain_payload: Optional[PutCustomDomainPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PutCustomDomainResponse]:
        """Create or update a custom domain

        Creates a new custom domain. If it already exists, this will overwrite the previous custom domain's properties.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param put_custom_domain_payload:
        :type put_custom_domain_payload: PutCustomDomainPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._put_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            put_custom_domain_payload=put_custom_domain_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PutCustomDomainResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def put_custom_domain_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="Your STACKIT Project ID")],
        distribution_id: StrictStr,
        domain: Annotated[str, Field(strict=True, max_length=72)],
        put_custom_domain_payload: Optional[PutCustomDomainPayload] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create or update a custom domain

        Creates a new custom domain. If it already exists, this will overwrite the previous custom domain's properties.

        :param project_id: Your STACKIT Project ID (required)
        :type project_id: str
        :param distribution_id: (required)
        :type distribution_id: str
        :param domain: (required)
        :type domain: str
        :param put_custom_domain_payload:
        :type put_custom_domain_payload: PutCustomDomainPayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._put_custom_domain_serialize(
            project_id=project_id,
            distribution_id=distribution_id,
            domain=domain,
            put_custom_domain_payload=put_custom_domain_payload,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "PutCustomDomainResponse",
            "401": "str",
            "422": "GenericJSONResponse",
            "500": "GenericJSONResponse",
        }
        response_data = self.api_client.call_api(*_param, _request_timeout=_request_timeout)
        return response_data.response

    def _put_custom_domain_serialize(
        self,
        project_id,
        distribution_id,
        domain,
        put_custom_domain_payload,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params["projectId"] = project_id
        if distribution_id is not None:
            _path_params["distributionId"] = distribution_id
        if domain is not None:
            _path_params["domain"] = domain
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if put_custom_domain_payload is not None:
            _body_params = put_custom_domain_payload

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(["application/json", "text/plain"])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(["application/json"])
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/v1beta/projects/{projectId}/distributions/{distributionId}/customDomains/{domain}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
