# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1beta.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing_extensions import Annotated, Self


class DistributionLogsRecord(BaseModel):
    """
    DistributionLogsRecord
    """  # noqa: E501

    cache_hit: StrictBool = Field(alias="cacheHit")
    data_center_region: StrictStr = Field(alias="dataCenterRegion")
    distribution_id: StrictStr = Field(alias="distributionID")
    host: StrictStr
    path: StrictStr
    request_country_code: Annotated[str, Field(min_length=2, strict=True, max_length=2)] = Field(
        description="ISO 3166-1 A2 compliant country code", alias="requestCountryCode"
    )
    size: Annotated[int, Field(strict=True, ge=0)]
    status_code: StrictInt = Field(alias="statusCode")
    timestamp: datetime
    __properties: ClassVar[List[str]] = [
        "cacheHit",
        "dataCenterRegion",
        "distributionID",
        "host",
        "path",
        "requestCountryCode",
        "size",
        "statusCode",
        "timestamp",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DistributionLogsRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DistributionLogsRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "cacheHit": obj.get("cacheHit"),
                "dataCenterRegion": obj.get("dataCenterRegion"),
                "distributionID": obj.get("distributionID"),
                "host": obj.get("host"),
                "path": obj.get("path"),
                "requestCountryCode": obj.get("requestCountryCode"),
                "size": obj.get("size"),
                "statusCode": obj.get("statusCode"),
                "timestamp": obj.get("timestamp"),
            }
        )
        return _obj
