# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1beta.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated, Self


class StatusError(BaseModel):
    """
    StatusError
    """  # noqa: E501

    de: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="A german translation string corresponding to the error key. Note that we do not guarantee german translations are present.",
    )
    en: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="An english translation string corresponding to the error key. An english translation key is always present."
    )
    key: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="An enum value that describes a Status Error."
    )
    __properties: ClassVar[List[str]] = ["de", "en", "key"]

    @field_validator("key")
    def key_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(
            ["UNKNOWN", "CUSTOM_DOMAIN_CNAME_MISSING", "CUSTOM_DOMAIN_ALREADY_IN_USE", "PUBLIC_BETA_QUOTA_REACHED"]
        ):
            raise ValueError(
                "must be one of enum values ('UNKNOWN', 'CUSTOM_DOMAIN_CNAME_MISSING', 'CUSTOM_DOMAIN_ALREADY_IN_USE', 'PUBLIC_BETA_QUOTA_REACHED')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StatusError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StatusError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({"de": obj.get("de"), "en": obj.get("en"), "key": obj.get("key")})
        return _obj
