# mypy-boto3-sagemaker<a id="mypy-boto3-sagemaker"></a>

[![PyPI - mypy-boto3-sagemaker](https://img.shields.io/pypi/v/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-sagemaker?color=blue)](https://pypistats.org/packages/mypy-boto3-sagemaker)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SageMaker 1.17.71](https://boto3.amazonaws.com/v1/documentation/api/1.17.71/reference/services/sagemaker.html#SageMaker)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.12.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-sagemaker docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sagemaker/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-sagemaker](#mypy-boto3-sagemaker)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `SageMaker` service.

```bash
python -m pip install boto3-stubs[sagemaker]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[sagemaker]` in your environment:
  `python -m pip install 'boto3-stubs[sagemaker]'`

Both type checking and auto-complete should work for `SageMaker` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[sagemaker]` in your environment:
  `python -m pip install 'boto3-stubs[sagemaker]'`

Both type checking and auto-complete should work for `SageMaker` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[sagemaker]` in your environment:
  `python -m pip install 'boto3-stubs[sagemaker]'`
- Run `mypy` as usual

Type checking should work for `SageMaker` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[sagemaker]` in your environment:
  `python -m pip install 'boto3-stubs[sagemaker]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SageMaker` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`SageMakerClient` provides annotations for `boto3.client("sagemaker")`.

```python
import boto3

from mypy_boto3_sagemaker import SageMakerClient

client: SageMakerClient = boto3.client("sagemaker")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SageMakerClient = session.client("sagemaker")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_sagemaker.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_sagemaker import SageMakerClient
from mypy_boto3_sagemaker.paginator import (
    ListActionsPaginator,
    ListAlgorithmsPaginator,
    ListAppImageConfigsPaginator,
    ListAppsPaginator,
    ListArtifactsPaginator,
    ListAssociationsPaginator,
    ListAutoMLJobsPaginator,
    ListCandidatesForAutoMLJobPaginator,
    ListCodeRepositoriesPaginator,
    ListCompilationJobsPaginator,
    ListContextsPaginator,
    ListDataQualityJobDefinitionsPaginator,
    ListDeviceFleetsPaginator,
    ListDevicesPaginator,
    ListDomainsPaginator,
    ListEdgePackagingJobsPaginator,
    ListEndpointConfigsPaginator,
    ListEndpointsPaginator,
    ListExperimentsPaginator,
    ListFeatureGroupsPaginator,
    ListFlowDefinitionsPaginator,
    ListHumanTaskUisPaginator,
    ListHyperParameterTuningJobsPaginator,
    ListImageVersionsPaginator,
    ListImagesPaginator,
    ListLabelingJobsPaginator,
    ListLabelingJobsForWorkteamPaginator,
    ListModelBiasJobDefinitionsPaginator,
    ListModelExplainabilityJobDefinitionsPaginator,
    ListModelPackageGroupsPaginator,
    ListModelPackagesPaginator,
    ListModelQualityJobDefinitionsPaginator,
    ListModelsPaginator,
    ListMonitoringExecutionsPaginator,
    ListMonitoringSchedulesPaginator,
    ListNotebookInstanceLifecycleConfigsPaginator,
    ListNotebookInstancesPaginator,
    ListPipelineExecutionStepsPaginator,
    ListPipelineExecutionsPaginator,
    ListPipelineParametersForExecutionPaginator,
    ListPipelinesPaginator,
    ListProcessingJobsPaginator,
    ListSubscribedWorkteamsPaginator,
    ListTagsPaginator,
    ListTrainingJobsPaginator,
    ListTrainingJobsForHyperParameterTuningJobPaginator,
    ListTransformJobsPaginator,
    ListTrialComponentsPaginator,
    ListTrialsPaginator,
    ListUserProfilesPaginator,
    ListWorkforcesPaginator,
    ListWorkteamsPaginator,
    SearchPaginator,
)

client: SageMakerClient = boto3.client("sagemaker")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_actions_paginator: ListActionsPaginator = client.get_paginator("list_actions")
list_algorithms_paginator: ListAlgorithmsPaginator = client.get_paginator("list_algorithms")
list_app_image_configs_paginator: ListAppImageConfigsPaginator = client.get_paginator("list_app_image_configs")
list_apps_paginator: ListAppsPaginator = client.get_paginator("list_apps")
list_artifacts_paginator: ListArtifactsPaginator = client.get_paginator("list_artifacts")
list_associations_paginator: ListAssociationsPaginator = client.get_paginator("list_associations")
list_auto_ml_jobs_paginator: ListAutoMLJobsPaginator = client.get_paginator("list_auto_ml_jobs")
list_candidates_for_auto_ml_job_paginator: ListCandidatesForAutoMLJobPaginator = client.get_paginator("list_candidates_for_auto_ml_job")
list_code_repositories_paginator: ListCodeRepositoriesPaginator = client.get_paginator("list_code_repositories")
list_compilation_jobs_paginator: ListCompilationJobsPaginator = client.get_paginator("list_compilation_jobs")
list_contexts_paginator: ListContextsPaginator = client.get_paginator("list_contexts")
list_data_quality_job_definitions_paginator: ListDataQualityJobDefinitionsPaginator = client.get_paginator("list_data_quality_job_definitions")
list_device_fleets_paginator: ListDeviceFleetsPaginator = client.get_paginator("list_device_fleets")
list_devices_paginator: ListDevicesPaginator = client.get_paginator("list_devices")
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_edge_packaging_jobs_paginator: ListEdgePackagingJobsPaginator = client.get_paginator("list_edge_packaging_jobs")
list_endpoint_configs_paginator: ListEndpointConfigsPaginator = client.get_paginator("list_endpoint_configs")
list_endpoints_paginator: ListEndpointsPaginator = client.get_paginator("list_endpoints")
list_experiments_paginator: ListExperimentsPaginator = client.get_paginator("list_experiments")
list_feature_groups_paginator: ListFeatureGroupsPaginator = client.get_paginator("list_feature_groups")
list_flow_definitions_paginator: ListFlowDefinitionsPaginator = client.get_paginator("list_flow_definitions")
list_human_task_uis_paginator: ListHumanTaskUisPaginator = client.get_paginator("list_human_task_uis")
list_hyper_parameter_tuning_jobs_paginator: ListHyperParameterTuningJobsPaginator = client.get_paginator("list_hyper_parameter_tuning_jobs")
list_image_versions_paginator: ListImageVersionsPaginator = client.get_paginator("list_image_versions")
list_images_paginator: ListImagesPaginator = client.get_paginator("list_images")
list_labeling_jobs_paginator: ListLabelingJobsPaginator = client.get_paginator("list_labeling_jobs")
list_labeling_jobs_for_workteam_paginator: ListLabelingJobsForWorkteamPaginator = client.get_paginator("list_labeling_jobs_for_workteam")
list_model_bias_job_definitions_paginator: ListModelBiasJobDefinitionsPaginator = client.get_paginator("list_model_bias_job_definitions")
list_model_explainability_job_definitions_paginator: ListModelExplainabilityJobDefinitionsPaginator = client.get_paginator("list_model_explainability_job_definitions")
list_model_package_groups_paginator: ListModelPackageGroupsPaginator = client.get_paginator("list_model_package_groups")
list_model_packages_paginator: ListModelPackagesPaginator = client.get_paginator("list_model_packages")
list_model_quality_job_definitions_paginator: ListModelQualityJobDefinitionsPaginator = client.get_paginator("list_model_quality_job_definitions")
list_models_paginator: ListModelsPaginator = client.get_paginator("list_models")
list_monitoring_executions_paginator: ListMonitoringExecutionsPaginator = client.get_paginator("list_monitoring_executions")
list_monitoring_schedules_paginator: ListMonitoringSchedulesPaginator = client.get_paginator("list_monitoring_schedules")
list_notebook_instance_lifecycle_configs_paginator: ListNotebookInstanceLifecycleConfigsPaginator = client.get_paginator("list_notebook_instance_lifecycle_configs")
list_notebook_instances_paginator: ListNotebookInstancesPaginator = client.get_paginator("list_notebook_instances")
list_pipeline_execution_steps_paginator: ListPipelineExecutionStepsPaginator = client.get_paginator("list_pipeline_execution_steps")
list_pipeline_executions_paginator: ListPipelineExecutionsPaginator = client.get_paginator("list_pipeline_executions")
list_pipeline_parameters_for_execution_paginator: ListPipelineParametersForExecutionPaginator = client.get_paginator("list_pipeline_parameters_for_execution")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
list_processing_jobs_paginator: ListProcessingJobsPaginator = client.get_paginator("list_processing_jobs")
list_subscribed_workteams_paginator: ListSubscribedWorkteamsPaginator = client.get_paginator("list_subscribed_workteams")
list_tags_paginator: ListTagsPaginator = client.get_paginator("list_tags")
list_training_jobs_paginator: ListTrainingJobsPaginator = client.get_paginator("list_training_jobs")
list_training_jobs_for_hyper_parameter_tuning_job_paginator: ListTrainingJobsForHyperParameterTuningJobPaginator = client.get_paginator("list_training_jobs_for_hyper_parameter_tuning_job")
list_transform_jobs_paginator: ListTransformJobsPaginator = client.get_paginator("list_transform_jobs")
list_trial_components_paginator: ListTrialComponentsPaginator = client.get_paginator("list_trial_components")
list_trials_paginator: ListTrialsPaginator = client.get_paginator("list_trials")
list_user_profiles_paginator: ListUserProfilesPaginator = client.get_paginator("list_user_profiles")
list_workforces_paginator: ListWorkforcesPaginator = client.get_paginator("list_workforces")
list_workteams_paginator: ListWorkteamsPaginator = client.get_paginator("list_workteams")
search_paginator: SearchPaginator = client.get_paginator("search")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_sagemaker.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_sagemaker import SageMakerClient
from mypy_boto3_sagemaker.waiter import (
    EndpointDeletedWaiter,
    EndpointInServiceWaiter,
    NotebookInstanceDeletedWaiter,
    NotebookInstanceInServiceWaiter,
    NotebookInstanceStoppedWaiter,
    ProcessingJobCompletedOrStoppedWaiter,
    TrainingJobCompletedOrStoppedWaiter,
    TransformJobCompletedOrStoppedWaiter,
)

client: SageMakerClient = boto3.client("sagemaker")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
endpoint_deleted_waiter: EndpointDeletedWaiter = client.get_waiter("endpoint_deleted")
endpoint_in_service_waiter: EndpointInServiceWaiter = client.get_waiter("endpoint_in_service")
notebook_instance_deleted_waiter: NotebookInstanceDeletedWaiter = client.get_waiter("notebook_instance_deleted")
notebook_instance_in_service_waiter: NotebookInstanceInServiceWaiter = client.get_waiter("notebook_instance_in_service")
notebook_instance_stopped_waiter: NotebookInstanceStoppedWaiter = client.get_waiter("notebook_instance_stopped")
processing_job_completed_or_stopped_waiter: ProcessingJobCompletedOrStoppedWaiter = client.get_waiter("processing_job_completed_or_stopped")
training_job_completed_or_stopped_waiter: TrainingJobCompletedOrStoppedWaiter = client.get_waiter("training_job_completed_or_stopped")
transform_job_completed_or_stopped_waiter: TransformJobCompletedOrStoppedWaiter = client.get_waiter("transform_job_completed_or_stopped")
```

### Literals<a id="literals"></a>

`mypy_boto3_sagemaker.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_sagemaker.literals import (
    ActionStatus,
    AlgorithmSortBy,
    AlgorithmStatus,
    AppImageConfigSortKey,
    AppInstanceType,
    AppNetworkAccessType,
    AppSortKey,
    AppStatus,
    AppType,
    ArtifactSourceIdType,
    AssemblyType,
    AssociationEdgeType,
    AthenaResultCompressionType,
    AthenaResultFormat,
    AuthMode,
    AutoMLJobObjectiveType,
    AutoMLJobSecondaryStatus,
    AutoMLJobStatus,
    AutoMLMetricEnum,
    AutoMLS3DataType,
    AutoMLSortBy,
    AutoMLSortOrder,
    AwsManagedHumanLoopRequestSource,
    BatchStrategy,
    BooleanOperator,
    CandidateSortBy,
    CandidateStatus,
    CandidateStepType,
    CapacitySizeType,
    CaptureMode,
    CaptureStatus,
    CodeRepositorySortBy,
    CodeRepositorySortOrder,
    CompilationJobStatus,
    CompressionType,
    ConditionOutcome,
    ContainerMode,
    ContentClassifier,
    DataDistributionType,
    DetailedAlgorithmStatus,
    DetailedModelPackageStatus,
    DirectInternetAccess,
    DomainStatus,
    EdgePackagingJobStatus,
    EndpointConfigSortKey,
    EndpointDeletedWaiterName,
    EndpointInServiceWaiterName,
    EndpointSortKey,
    EndpointStatus,
    ExecutionStatus,
    FeatureGroupSortBy,
    FeatureGroupSortOrder,
    FeatureGroupStatus,
    FeatureType,
    FileSystemAccessMode,
    FileSystemType,
    FlowDefinitionStatus,
    Framework,
    HumanTaskUiStatus,
    HyperParameterScalingType,
    HyperParameterTuningJobObjectiveType,
    HyperParameterTuningJobSortByOptions,
    HyperParameterTuningJobStatus,
    HyperParameterTuningJobStrategyType,
    HyperParameterTuningJobWarmStartType,
    ImageSortBy,
    ImageSortOrder,
    ImageStatus,
    ImageVersionSortBy,
    ImageVersionSortOrder,
    ImageVersionStatus,
    InferenceExecutionMode,
    InputMode,
    InstanceType,
    JoinSource,
    LabelingJobStatus,
    ListActionsPaginatorName,
    ListAlgorithmsPaginatorName,
    ListAppImageConfigsPaginatorName,
    ListAppsPaginatorName,
    ListArtifactsPaginatorName,
    ListAssociationsPaginatorName,
    ListAutoMLJobsPaginatorName,
    ListCandidatesForAutoMLJobPaginatorName,
    ListCodeRepositoriesPaginatorName,
    ListCompilationJobsPaginatorName,
    ListCompilationJobsSortBy,
    ListContextsPaginatorName,
    ListDataQualityJobDefinitionsPaginatorName,
    ListDeviceFleetsPaginatorName,
    ListDeviceFleetsSortBy,
    ListDevicesPaginatorName,
    ListDomainsPaginatorName,
    ListEdgePackagingJobsPaginatorName,
    ListEdgePackagingJobsSortBy,
    ListEndpointConfigsPaginatorName,
    ListEndpointsPaginatorName,
    ListExperimentsPaginatorName,
    ListFeatureGroupsPaginatorName,
    ListFlowDefinitionsPaginatorName,
    ListHumanTaskUisPaginatorName,
    ListHyperParameterTuningJobsPaginatorName,
    ListImageVersionsPaginatorName,
    ListImagesPaginatorName,
    ListLabelingJobsForWorkteamPaginatorName,
    ListLabelingJobsForWorkteamSortByOptions,
    ListLabelingJobsPaginatorName,
    ListModelBiasJobDefinitionsPaginatorName,
    ListModelExplainabilityJobDefinitionsPaginatorName,
    ListModelPackageGroupsPaginatorName,
    ListModelPackagesPaginatorName,
    ListModelQualityJobDefinitionsPaginatorName,
    ListModelsPaginatorName,
    ListMonitoringExecutionsPaginatorName,
    ListMonitoringSchedulesPaginatorName,
    ListNotebookInstanceLifecycleConfigsPaginatorName,
    ListNotebookInstancesPaginatorName,
    ListPipelineExecutionStepsPaginatorName,
    ListPipelineExecutionsPaginatorName,
    ListPipelineParametersForExecutionPaginatorName,
    ListPipelinesPaginatorName,
    ListProcessingJobsPaginatorName,
    ListSubscribedWorkteamsPaginatorName,
    ListTagsPaginatorName,
    ListTrainingJobsForHyperParameterTuningJobPaginatorName,
    ListTrainingJobsPaginatorName,
    ListTransformJobsPaginatorName,
    ListTrialComponentsPaginatorName,
    ListTrialsPaginatorName,
    ListUserProfilesPaginatorName,
    ListWorkforcesPaginatorName,
    ListWorkforcesSortByOptions,
    ListWorkteamsPaginatorName,
    ListWorkteamsSortByOptions,
    ModelApprovalStatus,
    ModelCacheSetting,
    ModelPackageGroupSortBy,
    ModelPackageGroupStatus,
    ModelPackageSortBy,
    ModelPackageStatus,
    ModelPackageType,
    ModelSortKey,
    MonitoringExecutionSortKey,
    MonitoringJobDefinitionSortKey,
    MonitoringProblemType,
    MonitoringScheduleSortKey,
    MonitoringType,
    NotebookInstanceAcceleratorType,
    NotebookInstanceDeletedWaiterName,
    NotebookInstanceInServiceWaiterName,
    NotebookInstanceLifecycleConfigSortKey,
    NotebookInstanceLifecycleConfigSortOrder,
    NotebookInstanceSortKey,
    NotebookInstanceSortOrder,
    NotebookInstanceStatus,
    NotebookInstanceStoppedWaiterName,
    NotebookOutputOption,
    ObjectiveStatus,
    OfflineStoreStatusValue,
    Operator,
    OrderKey,
    ParameterType,
    PipelineExecutionStatus,
    PipelineStatus,
    ProblemType,
    ProcessingInstanceType,
    ProcessingJobCompletedOrStoppedWaiterName,
    ProcessingJobStatus,
    ProcessingS3CompressionType,
    ProcessingS3DataDistributionType,
    ProcessingS3DataType,
    ProcessingS3InputMode,
    ProcessingS3UploadMode,
    ProductionVariantAcceleratorType,
    ProductionVariantInstanceType,
    ProfilingStatus,
    ProjectSortBy,
    ProjectSortOrder,
    ProjectStatus,
    RecordWrapper,
    RedshiftResultCompressionType,
    RedshiftResultFormat,
    RepositoryAccessMode,
    ResourceType,
    RetentionType,
    RootAccess,
    RuleEvaluationStatus,
    S3DataDistribution,
    S3DataType,
    SagemakerServicecatalogStatus,
    ScheduleStatus,
    SearchPaginatorName,
    SearchSortOrder,
    SecondaryStatus,
    SortActionsBy,
    SortArtifactsBy,
    SortAssociationsBy,
    SortBy,
    SortContextsBy,
    SortExperimentsBy,
    SortOrder,
    SortPipelineExecutionsBy,
    SortPipelinesBy,
    SortTrialComponentsBy,
    SortTrialsBy,
    SplitType,
    StepStatus,
    TargetDevice,
    TargetPlatformAccelerator,
    TargetPlatformArch,
    TargetPlatformOs,
    TrafficRoutingConfigType,
    TrainingInputMode,
    TrainingInstanceType,
    TrainingJobCompletedOrStoppedWaiterName,
    TrainingJobEarlyStoppingType,
    TrainingJobSortByOptions,
    TrainingJobStatus,
    TransformInstanceType,
    TransformJobCompletedOrStoppedWaiterName,
    TransformJobStatus,
    TrialComponentPrimaryStatus,
    UserProfileSortKey,
    UserProfileStatus,
    VariantPropertyType,
)

def check_value(value: ActionStatus) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_sagemaker.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_sagemaker.type_defs import (
    ActionSourceTypeDef,
    ActionSummaryTypeDef,
    AddAssociationResponseTypeDef,
    AddTagsOutputTypeDef,
    AgentVersionTypeDef,
    AlarmTypeDef,
    AlgorithmSpecificationTypeDef,
    AlgorithmStatusDetailsTypeDef,
    AlgorithmStatusItemTypeDef,
    AlgorithmSummaryTypeDef,
    AlgorithmValidationProfileTypeDef,
    AlgorithmValidationSpecificationTypeDef,
    AnnotationConsolidationConfigTypeDef,
    AppDetailsTypeDef,
    AppImageConfigDetailsTypeDef,
    AppSpecificationTypeDef,
    ArtifactSourceTypeDef,
    ArtifactSourceTypeTypeDef,
    ArtifactSummaryTypeDef,
    AssociateTrialComponentResponseTypeDef,
    AssociationSummaryTypeDef,
    AthenaDatasetDefinitionTypeDef,
    AutoMLCandidateStepTypeDef,
    AutoMLCandidateTypeDef,
    AutoMLChannelTypeDef,
    AutoMLContainerDefinitionTypeDef,
    AutoMLDataSourceTypeDef,
    AutoMLJobArtifactsTypeDef,
    AutoMLJobCompletionCriteriaTypeDef,
    AutoMLJobConfigTypeDef,
    AutoMLJobObjectiveTypeDef,
    AutoMLJobSummaryTypeDef,
    AutoMLOutputDataConfigTypeDef,
    AutoMLPartialFailureReasonTypeDef,
    AutoMLS3DataSourceTypeDef,
    AutoMLSecurityConfigTypeDef,
    AutoRollbackConfigTypeDef,
    BiasTypeDef,
    BlueGreenUpdatePolicyTypeDef,
    CacheHitResultTypeDef,
    CandidateArtifactLocationsTypeDef,
    CandidatePropertiesTypeDef,
    CapacitySizeTypeDef,
    CaptureContentTypeHeaderTypeDef,
    CaptureOptionTypeDef,
    CategoricalParameterRangeSpecificationTypeDef,
    CategoricalParameterRangeTypeDef,
    ChannelSpecificationTypeDef,
    ChannelTypeDef,
    CheckpointConfigTypeDef,
    CodeRepositorySummaryTypeDef,
    CognitoConfigTypeDef,
    CognitoMemberDefinitionTypeDef,
    CollectionConfigurationTypeDef,
    CompilationJobSummaryTypeDef,
    ConditionStepMetadataTypeDef,
    ContainerDefinitionTypeDef,
    ContextSourceTypeDef,
    ContextSummaryTypeDef,
    ContinuousParameterRangeSpecificationTypeDef,
    ContinuousParameterRangeTypeDef,
    CreateActionResponseTypeDef,
    CreateAlgorithmOutputTypeDef,
    CreateAppImageConfigResponseTypeDef,
    CreateAppResponseTypeDef,
    CreateArtifactResponseTypeDef,
    CreateAutoMLJobResponseTypeDef,
    CreateCodeRepositoryOutputTypeDef,
    CreateCompilationJobResponseTypeDef,
    CreateContextResponseTypeDef,
    CreateDataQualityJobDefinitionResponseTypeDef,
    CreateDomainResponseTypeDef,
    CreateEndpointConfigOutputTypeDef,
    CreateEndpointOutputTypeDef,
    CreateExperimentResponseTypeDef,
    CreateFeatureGroupResponseTypeDef,
    CreateFlowDefinitionResponseTypeDef,
    CreateHumanTaskUiResponseTypeDef,
    CreateHyperParameterTuningJobResponseTypeDef,
    CreateImageResponseTypeDef,
    CreateImageVersionResponseTypeDef,
    CreateLabelingJobResponseTypeDef,
    CreateModelBiasJobDefinitionResponseTypeDef,
    CreateModelExplainabilityJobDefinitionResponseTypeDef,
    CreateModelOutputTypeDef,
    CreateModelPackageGroupOutputTypeDef,
    CreateModelPackageOutputTypeDef,
    CreateModelQualityJobDefinitionResponseTypeDef,
    CreateMonitoringScheduleResponseTypeDef,
    CreateNotebookInstanceLifecycleConfigOutputTypeDef,
    CreateNotebookInstanceOutputTypeDef,
    CreatePipelineResponseTypeDef,
    CreatePresignedDomainUrlResponseTypeDef,
    CreatePresignedNotebookInstanceUrlOutputTypeDef,
    CreateProcessingJobResponseTypeDef,
    CreateProjectOutputTypeDef,
    CreateTrainingJobResponseTypeDef,
    CreateTransformJobResponseTypeDef,
    CreateTrialComponentResponseTypeDef,
    CreateTrialResponseTypeDef,
    CreateUserProfileResponseTypeDef,
    CreateWorkforceResponseTypeDef,
    CreateWorkteamResponseTypeDef,
    CustomImageTypeDef,
    DataCaptureConfigSummaryTypeDef,
    DataCaptureConfigTypeDef,
    DataCatalogConfigTypeDef,
    DataProcessingTypeDef,
    DataQualityAppSpecificationTypeDef,
    DataQualityBaselineConfigTypeDef,
    DataQualityJobInputTypeDef,
    DataSourceTypeDef,
    DatasetDefinitionTypeDef,
    DebugHookConfigTypeDef,
    DebugRuleConfigurationTypeDef,
    DebugRuleEvaluationStatusTypeDef,
    DeleteActionResponseTypeDef,
    DeleteArtifactResponseTypeDef,
    DeleteAssociationResponseTypeDef,
    DeleteContextResponseTypeDef,
    DeleteExperimentResponseTypeDef,
    DeletePipelineResponseTypeDef,
    DeleteTrialComponentResponseTypeDef,
    DeleteTrialResponseTypeDef,
    DeleteWorkteamResponseTypeDef,
    DeployedImageTypeDef,
    DeploymentConfigTypeDef,
    DescribeActionResponseTypeDef,
    DescribeAlgorithmOutputTypeDef,
    DescribeAppImageConfigResponseTypeDef,
    DescribeAppResponseTypeDef,
    DescribeArtifactResponseTypeDef,
    DescribeAutoMLJobResponseTypeDef,
    DescribeCodeRepositoryOutputTypeDef,
    DescribeCompilationJobResponseTypeDef,
    DescribeContextResponseTypeDef,
    DescribeDataQualityJobDefinitionResponseTypeDef,
    DescribeDeviceFleetResponseTypeDef,
    DescribeDeviceResponseTypeDef,
    DescribeDomainResponseTypeDef,
    DescribeEdgePackagingJobResponseTypeDef,
    DescribeEndpointConfigOutputTypeDef,
    DescribeEndpointOutputTypeDef,
    DescribeExperimentResponseTypeDef,
    DescribeFeatureGroupResponseTypeDef,
    DescribeFlowDefinitionResponseTypeDef,
    DescribeHumanTaskUiResponseTypeDef,
    DescribeHyperParameterTuningJobResponseTypeDef,
    DescribeImageResponseTypeDef,
    DescribeImageVersionResponseTypeDef,
    DescribeLabelingJobResponseTypeDef,
    DescribeModelBiasJobDefinitionResponseTypeDef,
    DescribeModelExplainabilityJobDefinitionResponseTypeDef,
    DescribeModelOutputTypeDef,
    DescribeModelPackageGroupOutputTypeDef,
    DescribeModelPackageOutputTypeDef,
    DescribeModelQualityJobDefinitionResponseTypeDef,
    DescribeMonitoringScheduleResponseTypeDef,
    DescribeNotebookInstanceLifecycleConfigOutputTypeDef,
    DescribeNotebookInstanceOutputTypeDef,
    DescribePipelineDefinitionForExecutionResponseTypeDef,
    DescribePipelineExecutionResponseTypeDef,
    DescribePipelineResponseTypeDef,
    DescribeProcessingJobResponseTypeDef,
    DescribeProjectOutputTypeDef,
    DescribeSubscribedWorkteamResponseTypeDef,
    DescribeTrainingJobResponseTypeDef,
    DescribeTransformJobResponseTypeDef,
    DescribeTrialComponentResponseTypeDef,
    DescribeTrialResponseTypeDef,
    DescribeUserProfileResponseTypeDef,
    DescribeWorkforceResponseTypeDef,
    DescribeWorkteamResponseTypeDef,
    DesiredWeightAndCapacityTypeDef,
    DeviceFleetSummaryTypeDef,
    DeviceStatsTypeDef,
    DeviceSummaryTypeDef,
    DeviceTypeDef,
    DisassociateTrialComponentResponseTypeDef,
    DomainDetailsTypeDef,
    EdgeModelStatTypeDef,
    EdgeModelSummaryTypeDef,
    EdgeModelTypeDef,
    EdgeOutputConfigTypeDef,
    EdgePackagingJobSummaryTypeDef,
    EndpointConfigSummaryTypeDef,
    EndpointInputTypeDef,
    EndpointSummaryTypeDef,
    EndpointTypeDef,
    ExperimentConfigTypeDef,
    ExperimentSourceTypeDef,
    ExperimentSummaryTypeDef,
    ExperimentTypeDef,
    ExplainabilityTypeDef,
    FeatureDefinitionTypeDef,
    FeatureGroupSummaryTypeDef,
    FeatureGroupTypeDef,
    FileSystemConfigTypeDef,
    FileSystemDataSourceTypeDef,
    FilterTypeDef,
    FinalAutoMLJobObjectiveMetricTypeDef,
    FinalHyperParameterTuningJobObjectiveMetricTypeDef,
    FlowDefinitionOutputConfigTypeDef,
    FlowDefinitionSummaryTypeDef,
    GetDeviceFleetReportResponseTypeDef,
    GetModelPackageGroupPolicyOutputTypeDef,
    GetSagemakerServicecatalogPortfolioStatusOutputTypeDef,
    GetSearchSuggestionsResponseTypeDef,
    GitConfigForUpdateTypeDef,
    GitConfigTypeDef,
    HumanLoopActivationConditionsConfigTypeDef,
    HumanLoopActivationConfigTypeDef,
    HumanLoopConfigTypeDef,
    HumanLoopRequestSourceTypeDef,
    HumanTaskConfigTypeDef,
    HumanTaskUiSummaryTypeDef,
    HyperParameterAlgorithmSpecificationTypeDef,
    HyperParameterSpecificationTypeDef,
    HyperParameterTrainingJobDefinitionTypeDef,
    HyperParameterTrainingJobSummaryTypeDef,
    HyperParameterTuningJobConfigTypeDef,
    HyperParameterTuningJobObjectiveTypeDef,
    HyperParameterTuningJobSummaryTypeDef,
    HyperParameterTuningJobWarmStartConfigTypeDef,
    ImageConfigTypeDef,
    ImageTypeDef,
    ImageVersionTypeDef,
    InferenceExecutionConfigTypeDef,
    InferenceSpecificationTypeDef,
    InputConfigTypeDef,
    IntegerParameterRangeSpecificationTypeDef,
    IntegerParameterRangeTypeDef,
    JupyterServerAppSettingsTypeDef,
    KernelGatewayAppSettingsTypeDef,
    KernelGatewayImageConfigTypeDef,
    KernelSpecTypeDef,
    LabelCountersForWorkteamTypeDef,
    LabelCountersTypeDef,
    LabelingJobAlgorithmsConfigTypeDef,
    LabelingJobDataAttributesTypeDef,
    LabelingJobDataSourceTypeDef,
    LabelingJobForWorkteamSummaryTypeDef,
    LabelingJobInputConfigTypeDef,
    LabelingJobOutputConfigTypeDef,
    LabelingJobOutputTypeDef,
    LabelingJobResourceConfigTypeDef,
    LabelingJobS3DataSourceTypeDef,
    LabelingJobSnsDataSourceTypeDef,
    LabelingJobStoppingConditionsTypeDef,
    LabelingJobSummaryTypeDef,
    ListActionsResponseTypeDef,
    ListAlgorithmsOutputTypeDef,
    ListAppImageConfigsResponseTypeDef,
    ListAppsResponseTypeDef,
    ListArtifactsResponseTypeDef,
    ListAssociationsResponseTypeDef,
    ListAutoMLJobsResponseTypeDef,
    ListCandidatesForAutoMLJobResponseTypeDef,
    ListCodeRepositoriesOutputTypeDef,
    ListCompilationJobsResponseTypeDef,
    ListContextsResponseTypeDef,
    ListDataQualityJobDefinitionsResponseTypeDef,
    ListDeviceFleetsResponseTypeDef,
    ListDevicesResponseTypeDef,
    ListDomainsResponseTypeDef,
    ListEdgePackagingJobsResponseTypeDef,
    ListEndpointConfigsOutputTypeDef,
    ListEndpointsOutputTypeDef,
    ListExperimentsResponseTypeDef,
    ListFeatureGroupsResponseTypeDef,
    ListFlowDefinitionsResponseTypeDef,
    ListHumanTaskUisResponseTypeDef,
    ListHyperParameterTuningJobsResponseTypeDef,
    ListImageVersionsResponseTypeDef,
    ListImagesResponseTypeDef,
    ListLabelingJobsForWorkteamResponseTypeDef,
    ListLabelingJobsResponseTypeDef,
    ListModelBiasJobDefinitionsResponseTypeDef,
    ListModelExplainabilityJobDefinitionsResponseTypeDef,
    ListModelPackageGroupsOutputTypeDef,
    ListModelPackagesOutputTypeDef,
    ListModelQualityJobDefinitionsResponseTypeDef,
    ListModelsOutputTypeDef,
    ListMonitoringExecutionsResponseTypeDef,
    ListMonitoringSchedulesResponseTypeDef,
    ListNotebookInstanceLifecycleConfigsOutputTypeDef,
    ListNotebookInstancesOutputTypeDef,
    ListPipelineExecutionStepsResponseTypeDef,
    ListPipelineExecutionsResponseTypeDef,
    ListPipelineParametersForExecutionResponseTypeDef,
    ListPipelinesResponseTypeDef,
    ListProcessingJobsResponseTypeDef,
    ListProjectsOutputTypeDef,
    ListSubscribedWorkteamsResponseTypeDef,
    ListTagsOutputTypeDef,
    ListTrainingJobsForHyperParameterTuningJobResponseTypeDef,
    ListTrainingJobsResponseTypeDef,
    ListTransformJobsResponseTypeDef,
    ListTrialComponentsResponseTypeDef,
    ListTrialsResponseTypeDef,
    ListUserProfilesResponseTypeDef,
    ListWorkforcesResponseTypeDef,
    ListWorkteamsResponseTypeDef,
    MemberDefinitionTypeDef,
    MetadataPropertiesTypeDef,
    MetricDataTypeDef,
    MetricDefinitionTypeDef,
    MetricsSourceTypeDef,
    ModelArtifactsTypeDef,
    ModelBiasAppSpecificationTypeDef,
    ModelBiasBaselineConfigTypeDef,
    ModelBiasJobInputTypeDef,
    ModelClientConfigTypeDef,
    ModelDataQualityTypeDef,
    ModelDeployConfigTypeDef,
    ModelDeployResultTypeDef,
    ModelDigestsTypeDef,
    ModelExplainabilityAppSpecificationTypeDef,
    ModelExplainabilityBaselineConfigTypeDef,
    ModelExplainabilityJobInputTypeDef,
    ModelMetricsTypeDef,
    ModelPackageContainerDefinitionTypeDef,
    ModelPackageGroupSummaryTypeDef,
    ModelPackageGroupTypeDef,
    ModelPackageStatusDetailsTypeDef,
    ModelPackageStatusItemTypeDef,
    ModelPackageSummaryTypeDef,
    ModelPackageTypeDef,
    ModelPackageValidationProfileTypeDef,
    ModelPackageValidationSpecificationTypeDef,
    ModelQualityAppSpecificationTypeDef,
    ModelQualityBaselineConfigTypeDef,
    ModelQualityJobInputTypeDef,
    ModelQualityTypeDef,
    ModelStepMetadataTypeDef,
    ModelSummaryTypeDef,
    MonitoringAppSpecificationTypeDef,
    MonitoringBaselineConfigTypeDef,
    MonitoringClusterConfigTypeDef,
    MonitoringConstraintsResourceTypeDef,
    MonitoringExecutionSummaryTypeDef,
    MonitoringGroundTruthS3InputTypeDef,
    MonitoringInputTypeDef,
    MonitoringJobDefinitionSummaryTypeDef,
    MonitoringJobDefinitionTypeDef,
    MonitoringNetworkConfigTypeDef,
    MonitoringOutputConfigTypeDef,
    MonitoringOutputTypeDef,
    MonitoringResourcesTypeDef,
    MonitoringS3OutputTypeDef,
    MonitoringScheduleConfigTypeDef,
    MonitoringScheduleSummaryTypeDef,
    MonitoringScheduleTypeDef,
    MonitoringStatisticsResourceTypeDef,
    MonitoringStoppingConditionTypeDef,
    MultiModelConfigTypeDef,
    NestedFiltersTypeDef,
    NetworkConfigTypeDef,
    NotebookInstanceLifecycleConfigSummaryTypeDef,
    NotebookInstanceLifecycleHookTypeDef,
    NotebookInstanceSummaryTypeDef,
    NotificationConfigurationTypeDef,
    ObjectiveStatusCountersTypeDef,
    OfflineStoreConfigTypeDef,
    OfflineStoreStatusTypeDef,
    OidcConfigForResponseTypeDef,
    OidcConfigTypeDef,
    OidcMemberDefinitionTypeDef,
    OnlineStoreConfigTypeDef,
    OnlineStoreSecurityConfigTypeDef,
    OutputConfigTypeDef,
    OutputDataConfigTypeDef,
    PaginatorConfigTypeDef,
    ParameterRangeTypeDef,
    ParameterRangesTypeDef,
    ParameterTypeDef,
    ParentHyperParameterTuningJobTypeDef,
    ParentTypeDef,
    PipelineExecutionStepMetadataTypeDef,
    PipelineExecutionStepTypeDef,
    PipelineExecutionSummaryTypeDef,
    PipelineExecutionTypeDef,
    PipelineSummaryTypeDef,
    PipelineTypeDef,
    ProcessingClusterConfigTypeDef,
    ProcessingFeatureStoreOutputTypeDef,
    ProcessingInputTypeDef,
    ProcessingJobStepMetadataTypeDef,
    ProcessingJobSummaryTypeDef,
    ProcessingJobTypeDef,
    ProcessingOutputConfigTypeDef,
    ProcessingOutputTypeDef,
    ProcessingResourcesTypeDef,
    ProcessingS3InputTypeDef,
    ProcessingS3OutputTypeDef,
    ProcessingStoppingConditionTypeDef,
    ProductionVariantCoreDumpConfigTypeDef,
    ProductionVariantSummaryTypeDef,
    ProductionVariantTypeDef,
    ProfilerConfigForUpdateTypeDef,
    ProfilerConfigTypeDef,
    ProfilerRuleConfigurationTypeDef,
    ProfilerRuleEvaluationStatusTypeDef,
    ProjectSummaryTypeDef,
    PropertyNameQueryTypeDef,
    PropertyNameSuggestionTypeDef,
    ProvisioningParameterTypeDef,
    PublicWorkforceTaskPriceTypeDef,
    PutModelPackageGroupPolicyOutputTypeDef,
    RedshiftDatasetDefinitionTypeDef,
    RegisterModelStepMetadataTypeDef,
    RenderUiTemplateResponseTypeDef,
    RenderableTaskTypeDef,
    RenderingErrorTypeDef,
    RepositoryAuthConfigTypeDef,
    ResolvedAttributesTypeDef,
    ResourceConfigTypeDef,
    ResourceLimitsTypeDef,
    ResourceSpecTypeDef,
    ResponseMetadataTypeDef,
    RetentionPolicyTypeDef,
    RetryStrategyTypeDef,
    S3DataSourceTypeDef,
    S3StorageConfigTypeDef,
    ScheduleConfigTypeDef,
    SearchExpressionTypeDef,
    SearchRecordTypeDef,
    SearchResponseTypeDef,
    SecondaryStatusTransitionTypeDef,
    ServiceCatalogProvisionedProductDetailsTypeDef,
    ServiceCatalogProvisioningDetailsTypeDef,
    SharingSettingsTypeDef,
    ShuffleConfigTypeDef,
    SourceAlgorithmSpecificationTypeDef,
    SourceAlgorithmTypeDef,
    SourceIpConfigTypeDef,
    StartPipelineExecutionResponseTypeDef,
    StopPipelineExecutionResponseTypeDef,
    StoppingConditionTypeDef,
    SubscribedWorkteamTypeDef,
    SuggestionQueryTypeDef,
    TagTypeDef,
    TargetPlatformTypeDef,
    TensorBoardAppSettingsTypeDef,
    TensorBoardOutputConfigTypeDef,
    TrafficRoutingConfigTypeDef,
    TrainingJobDefinitionTypeDef,
    TrainingJobStatusCountersTypeDef,
    TrainingJobStepMetadataTypeDef,
    TrainingJobSummaryTypeDef,
    TrainingJobTypeDef,
    TrainingSpecificationTypeDef,
    TransformDataSourceTypeDef,
    TransformInputTypeDef,
    TransformJobDefinitionTypeDef,
    TransformJobStepMetadataTypeDef,
    TransformJobSummaryTypeDef,
    TransformJobTypeDef,
    TransformOutputTypeDef,
    TransformResourcesTypeDef,
    TransformS3DataSourceTypeDef,
    TrialComponentArtifactTypeDef,
    TrialComponentMetricSummaryTypeDef,
    TrialComponentParameterValueTypeDef,
    TrialComponentSimpleSummaryTypeDef,
    TrialComponentSourceDetailTypeDef,
    TrialComponentSourceTypeDef,
    TrialComponentStatusTypeDef,
    TrialComponentSummaryTypeDef,
    TrialComponentTypeDef,
    TrialSourceTypeDef,
    TrialSummaryTypeDef,
    TrialTypeDef,
    TuningJobCompletionCriteriaTypeDef,
    USDTypeDef,
    UiConfigTypeDef,
    UiTemplateInfoTypeDef,
    UiTemplateTypeDef,
    UpdateActionResponseTypeDef,
    UpdateAppImageConfigResponseTypeDef,
    UpdateArtifactResponseTypeDef,
    UpdateCodeRepositoryOutputTypeDef,
    UpdateContextResponseTypeDef,
    UpdateDomainResponseTypeDef,
    UpdateEndpointOutputTypeDef,
    UpdateEndpointWeightsAndCapacitiesOutputTypeDef,
    UpdateExperimentResponseTypeDef,
    UpdateImageResponseTypeDef,
    UpdateModelPackageOutputTypeDef,
    UpdateMonitoringScheduleResponseTypeDef,
    UpdatePipelineExecutionResponseTypeDef,
    UpdatePipelineResponseTypeDef,
    UpdateTrainingJobResponseTypeDef,
    UpdateTrialComponentResponseTypeDef,
    UpdateTrialResponseTypeDef,
    UpdateUserProfileResponseTypeDef,
    UpdateWorkforceResponseTypeDef,
    UpdateWorkteamResponseTypeDef,
    UserContextTypeDef,
    UserProfileDetailsTypeDef,
    UserSettingsTypeDef,
    VariantPropertyTypeDef,
    VpcConfigTypeDef,
    WaiterConfigTypeDef,
    WorkforceTypeDef,
    WorkteamTypeDef,
)

def get_structure() -> ActionSourceTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-sagemaker` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-sagemaker docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_sagemaker/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
