<p align="center">
  <img src="https://raw.githubusercontent.com/KissmeBro/engine-python/refs/heads/main/logo.png" alt="Engine Logo" width="180" />
</p>

# 🚀 engine-python  
> A modern, intelligent, asynchronous search engine library for Python  

---

## ⭐ Overview  
Engine is a modern asynchronous Python library designed to deliver fast and intelligent search capabilities.  
Built with `asyncio` and `aiohttp`, it provides scalable and efficient search operations  
that easily integrate into your applications and services.

---

## 🔥 Features  
- ⚡ Fully asynchronous using asyncio and aiohttp  
- 🧩 Modular and extensible architecture  
- 🛠️ Easy to integrate and use  
- 🚀 Optimized for speed and concurrency  
- 🧠 Designed for intelligent search algorithms and data retrieval  

---

## 👨‍💻 Who is it for?  
Ideal for developers needing a lightweight, performant search engine library  
to build custom search tools, crawlers, or data indexing systems.

---

## 📚 Examples  
- [example_one.py](https://github.com/KissmeBro/engine-python/blob/main/examples/example_one.py)  
- [example_two.py](https://github.com/KissmeBro/engine-python/blob/main/examples/example_two.py)  

---

## 🔐 Getting API Key & CSE ID  
- Get your [API Key](https://developers.google.com/custom-search/v1/introduction)  
- Get your [CSE ID](https://programmablesearchengine.google.com/controlpanel/create)  

---

## 🔎 Custom Search  
- Website: `https://cse.google.com/cse?cx=CSE_ID`  
- Official docs: [Google Custom Search API](https://developers.google.com/custom-search/v1/reference/rest/v1/cse/list?apix=true)  

---

## 📦 Installation  
```bash
pip install engine-python