#!/usr/bin/env python

from setuptools import setup

import pony_rest

author = "lwzm"

with open("README.md") as f:
    long_description = f.read()

setup(
    name="pony-rest",
    version=pony_rest.__version__,
    description="Restful API generated by ponyorm and tornado",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author=author,
    author_email="{}@qq.com".format(author),
    keywords="rest restful pony tornado http api".split(),
    url="https://github.com/lwzm/pony-rest",
    py_modules=["pony_rest"],
    classifiers=[
        "Environment :: Console",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: Implementation :: CPython",
        "Programming Language :: Python :: Implementation :: PyPy",
        "Topic :: Software Development :: Build Tools",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "License :: OSI Approved :: MIT License",
    ],
)
