# caldavctl

[![PyPI - Version](https://img.shields.io/pypi/v/caldavctl.svg)](https://pypi.org/project/caldavctl)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/caldavctl.svg)](https://pypi.org/project/caldavctl)

-----

## Table of Contents

- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [License](#license)

⚠️WARNING ⚠️

This software is alpha quality, use at your own risk.

## Installation

To install:

    pipx install caldavctl

### Completion

Optionally enable completion:

* bash, add this to `~/.bashrc`:

    ```
    eval "$(_CALDAVCTL_COMPLETE=bash_source caldavctl)"
    ```

* zsh, add this to `~/.zshrc`:

    ```
    eval "$(_CALDAVCTL_COMPLETE=zsh_source caldavctl)"
    ```

* fish, add this to `~/.config/fish/completions/foo-bar.fish`:

    ```
    _CALDAVCTL_COMPLETE=fish_source caldavctl | source
    ```

## Configuration

`caldavctl` is configured in `$HOME/.config/caldavctl/config.toml`:

```toml
[server.server_01_nickname]
username="your user"
password="your pass"
url="https://oneserver.org/cal"

[server.server_02_nickname]
username="your user"
password="your pass"
url="https://anotherserver.org/cal"

[default]
server="server_01_nickname"
calendar="Default"
timezone="Asia/Tokyo"
```

Make sure to make this file readable only by the user owner of the file:

```bash
$ chmod go-rwx $HOME/.config/caldavctl/config.toml
```

## Usage

`caldavctl` uses sub commands to expose its functionality:

```bash
$ caldavctl --help
Usage: caldavctl [OPTIONS] COMMAND [ARGS]...

  caldavctl - command line CalDAV client

Options:
  -c, --config TEXT  Configuration file
  --name TEXT        Server nickname
  --username TEXT    Username on the CalDAV server
  --passwd TEXT      Password on the CalDAV server
  --url TEXT         Calendar CalDAV url
  --timezone TEXT    Your time zone
  --server TEXT      Default server (use nickname)
  --calendar TEXT    Default calendar id
  --help             Show this message and exit.

Commands:
  br        Backup or restore a calendar
  calendar  Commands that deal with the calendars on the server
  event     Event management
  ics       iCalendar file operations
  journal   Journal management
  todo      Todo management
```
Notes:

* The options to the main command override the configuration file;
* By default the configuration file is `$HOME/.config/caldavctl/config.toml`;
* Currently the `journal` sub-command is only a place holder;

To get help about a sub-command do:

```bash
$ caldavctl <sub-command> --help
```

For example:

```bash
$ caldavctl event --help
Usage: caldavctl event [OPTIONS] COMMAND [ARGS]...

  Event management

Options:
  --help  Show this message and exit.

Commands:
  create  Create new event
  delete  Delete an event on the server
  list    List events from the server list.
```

This holds true for sub-sub-commands:

```bash
$ caldavctl todo list --help
Usage: caldavctl todo list [OPTIONS]

  List todos from the default server and default calendar

Options:
  -d, --description  Show the event's description.
  -a, --all          Show all todos, including completed todos.
  --help             Show this message and exit.
```

### The create event command

The `create event` command uses a simple `key: value` format to define the elements of an event. If the `--edit` option is used without specifying a file, an example file is opened on your `$EDITOR`:

```
# Mandatory
DTSTART: 2025-02-02 09:00
DTEND: 2025-02-02 09:45

# Recommended
SUMMARY:

# Optional
LOCATION:
CATEGORIES:
TIMEZONE:
PRIORITY: 5
ALARM: P0D
DESCRIPTION: [[ ]]

# NOTES:
#
#   * Date and time:
#       * The dates must be in iso format, for instance: 2024-12-29 13:45;
#       * The timezone used is the one defined by default or the one defined in
#         the "TIMEZONE" key;
#   * Categories: the categories are a comma separated list;
#   * Priority: 1 - highest priority, 9 - lowest priority
#   * Description: The description can be multi line, just make sure it's
#     delimited by [[ ]].
#   * Alarms:
#       * By default an alarm is defined the moment the event begins;
#       * The alarms are defined using:
#           ALARM: <trigger> [<description>]
#       * The trigger is defined according to:
#           https://datatracker.ietf.org/doc/html/rfc5545#autoid-38
#       * For example, to trigger an alarm 30 minutes before the event start, use:
#           ALARM: -PT30M
#       * The alarm description is optional
```
The start and end dates are, by default the next day from 9 to 9:45.

## License

`caldavctl` is distributed under the terms of the [GPL-3.0-or-later](https://spdx.org/licenses/GPL-3.0-or-later.html) license.
