import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthnMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/authn_mapping#id AuthnMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identity provider key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/authn_mapping#key AuthnMapping#key}
    */
    readonly key: string;
    /**
    * The ID of a role to attach to all users with the corresponding key and value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/authn_mapping#role AuthnMapping#role}
    */
    readonly role: string;
    /**
    * Identity provider value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/authn_mapping#value AuthnMapping#value}
    */
    readonly value: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/datadog/r/authn_mapping datadog_authn_mapping}
*/
export declare class AuthnMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "datadog_authn_mapping";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/authn_mapping datadog_authn_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthnMappingConfig
    */
    constructor(scope: Construct, id: string, config: AuthnMappingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
